/*  Queue.h
 
   QueueMaster v1.5 -- Queue's program execution for long jobs
   Copyright (C) 1997  John Gruenenfelder
   Compiled:  Tuesday, July 15, 1997
 
   WWW:       http://www.primenet.com/~andman
              http://www.primenet.com/~andman/QueueMaster.html
   Email:     andman@primenet.com   OR  johng@aquarius.as.arizona.edu
   Mail:      John Gruenenfelder
              2001 Calle Mesa Del Oso
              Tucson, AZ 85748
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

------------------------------------------------------------------------------
------------------------------------------------------------------------------
*/

#ifndef QUEUE_H
#define QUEUE_H

#include <string.h>
#include <stdlib.h>

//Shtupid different defines from different compilers...
#if defined unix
	#define UNIX
#elif defined __MSDOS__
	#define MSDOS
#endif

//My compiler at home didn't have unistd.h.
//This may be true for most DOS compilers.
#if defined UNIX
	#include <unistd.h>
#elif defined MSDOS
	#include <dir.h>
#endif

#define TRUE  1
#define FALSE 0

extern int TEST,VERBOSE,CSH;

class ImageFile {
	char *File,*Method,*Path,*OrigLine;
public:
	ImageFile(char *F,char *M,char *P,char *O) {
		File=new char[50];
		Method=new char[200];
		OrigLine=new char[100];
		Path=new char[100];
		strcpy(File,F);
		strcpy(Method,M);
		strcpy(Path,P);
		strcpy(OrigLine,O); }
	~ImageFile() {
		delete OrigLine;
		delete File;
		delete Method;
		delete Path; }
	inline char * FileName(void) {
		return File; }
	inline char * PathName(void) {
		return Path; }
	inline char * MethodName(void) {
		return Method; }
	inline char * Vader(void) {
		return OrigLine; }
	int Execute(void) {
		int x,y=0,Dumlen;
		char *Command=new char[1000],CurDir[100];

		getcwd(CurDir,100);
		chdir(Path);
		if (VERBOSE)
			cout << "Path: " << Path << endl;
		Dumlen=strlen(Method);
		for (x=0;x<Dumlen;x++,y++) {
			if ((Method[x]=='$')&&(Method[x+1]=='1')) {
				strcpy(&Command[y],File);
				y=strlen(Command)-1;
				x++; }
			else {
				Command[y]=Method[x];
				Command[y+1]=0; } }
		if (VERBOSE)
			cout << "Command: " << Command << endl;
		if (!TEST) {
			#if defined UNIX
				if (CSH) {
					char *Dum=new char[1010];
					strcpy(Dum,"csh -f -c '");
					strcat(Dum,Command);
					strcat(Dum,"'");
					x=system(Dum);
					delete Dum; }
				else
					x=system(Command);
			#else
				x=system(Command);
			#endif
		}
		if ((!TEST)&&(VERBOSE))
			cout << "system() returned: " << x << endl;
		chdir(CurDir);
		delete Command;
		return x; }
};


//-------------------------------------------
//-------     Template for a queue    -------
//-------------------------------------------
template<class Kool> class Queue {
	struct Link {
		Link *Next;
		Kool *QueueObj;
		Link(Kool *Q) : QueueObj(Q),Next(0) { }
	};
	Link *Start;
public:
	Queue(void) : Start(0) { }
	~Queue() {
		Link *Dead;
		while (Start) {
			Dead=Start;
			Start=Start->Next;
			delete Dead;
		} }
	int Add(Kool *K) {
		Link *Temp;
		if (Start==0) {
			if ((Start=new Link(K))==0)
				return FALSE;
			Start->Next=0; }
		else if (Start->Next==0) {
			if ((Start->Next=new Link(K))==0)
				return FALSE;
			Start->Next->Next=0; }
		else {
			Temp=Start;
			while (Temp->Next!=0)
				Temp=Temp->Next;
			if ((Temp->Next=new Link(K))==0)
				return FALSE;
			Temp->Next->Next=0; }
		return TRUE; }
	inline Kool * Upchuck(void) {
		Kool *DUM;
		Link *Die;
		if (Start==0)
			return 0;
		DUM=Start->QueueObj;
		Die=Start;
		Start=Start->Next;
		delete Die;
		return DUM; }
};

#endif  // QUEUE_H
