/*  Queue.C

   QueueMaster v1.5 -- Queue's program execution for long jobs
   Copyright (C) 1997  John Gruenenfelder
   Compiled:  Tuesday, July 15, 1997

   WWW:	      http://www.primenet.com/~andman
	      http://www.primenet.com/~andman/QueueMaster.html
   Email:     andman@primenet.com   OR  johng@aquarius.as.arizona.edu
   Mail:      John Gruenenfelder
	      2001 Calle Mesa Del Oso
	      Tucson, AZ 85748
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
------------------------------------------------------------------------------
------------------------------------------------------------------------------
*/


#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include <ctype.h>
#include "Queue.h"

//Size of '\n'.   2 chars in DOS, 1 in UNIX
#if defined UNIX
	#define NLSize 1
#elif defined MSDOS
	#define NLSize 2
#endif

//Turn off dum warnings about functions not being expanded inline
#pragma warn -inl

#define TRUE  1
#define FALSE 0

struct Method {
	int Num;
	Method *Next;
	char *TheMethod;
};

int UpdateQF(char *,int);
int ReadQueue(void);
void SpewHelp(void);
int AllSpace(char *);
char *RemLSpace(char *);
void FreeMemory(void);
Method * FindNode(int);
int AddNode(int, char *);
void DeleteLList(void);
int CharInStr(char, const char *);

const char *QMVersion="1.5";
const char *DateCompiled="Tuesday, July 15, 1997";
const char *Author="John Gruenenfelder";

Queue<ImageFile> AndMan;
char	*QFName=0;
Method	*Start;
int	NumMethods=0;
int	TEST=FALSE,VERBOSE=TRUE,PROGRESSIVE=FALSE,CSH=FALSE,SEQUENTIAL=FALSE,ALLSTOP=FALSE;

int main(int argc,char *argv[]) {
	ImageFile *Gorpon;
	int	x,TheForce;

	if (argc==1) {
		SpewHelp();
		return 1; }

	for (x=1;x<argc;x++) {
		if (argv[x][0]=='-') {
			switch (toupper(argv[x][1])) {
				case 'T': TEST=TRUE;		break;
				case 'Q': VERBOSE=FALSE;	break;
				case 'P': PROGRESSIVE=TRUE;
					  SEQUENTIAL=FALSE;	break;
				case 'C': CSH=TRUE;		break;
				case 'S': SEQUENTIAL=TRUE;
					  PROGRESSIVE=FALSE;	break;
				case 'H':
				case '?': SpewHelp();		break;
				default:  cerr << "Error: unknown switch:\n\t" << argv[x] << endl;
			}
		} else {
			QFName=argv[x];
		}
	}

	if (QFName==0) {
		cerr << "Error: input filename not specified." << endl;
		return 2; }

	TheForce=ReadQueue();
	if (ALLSTOP) {
		cout << "QueueMaster has read STOP in the queuefile and has stopped processing." << endl;
		FreeMemory();
		return 0; }
	while (TheForce) {
		Gorpon=AndMan.Upchuck();
		while (Gorpon) {
			x=Gorpon->Execute();
			if (!TEST)
				if (!UpdateQF(Gorpon->Vader(),x)) {
					cerr << "Error: Unable to update queuefile." << endl;
					delete Gorpon;
					FreeMemory();
					return 3; }
			delete Gorpon;
			Gorpon=AndMan.Upchuck(); }
		if (!TEST) {
			TheForce=ReadQueue();
			if (ALLSTOP) {
				cout << "QueueMaster has read STOP in the queuefile and has stopped processing." << endl;
				FreeMemory();
				return 0; } }
		else
			TheForce=FALSE; }

	FreeMemory();
	return 0;
}

void SpewHelp(void) {
	cout << "\n\t\tQueueMaster v" << QMVersion << "\n\t\tby " << Author << "\n" \
	"\t\tandman@primenet.com\n\thttp://www.primenet.com/~andman/QueueMaster.html\n" \
	"\n\tQueue queuefile [-Q] [-T] [-C] [-P | -S]\n" \
	"where queuefile is the name of the queue to be processed.\n" \
	"-Q is quiet mode and supresses most output except errors\n" \
	"-T does a TEST of the queuefile without executing it\n" \
	"-P allows progressive methods.  If a file uses method 1 and completes and\n" \
	"   method 2 exists, QueueMaster will add a line to the end of the queue\n" \
	"   with the filename running method 2.  It will continue like this until\n" \
	"   there are no more methods.  Methods MUST be consecutive for this to work,\n" \
	"   but are not required to start at any particular number.\n" \
	"-C use C shell instead of Bourne shell for executing commands.  Only\n" \
	"   applicable in UNIX.  Switch ignored if in DOS.\n" \
	"-S uses Sequential mode.  Like Progressive mode except only one command is\n" \
	"   read per pass and all methods are done.  Then next file is read, etc.\n" \
	"   Cannot be used with Progressive mode.  Last switch of the two takes\n" \
	"   precedence (i.e. Will shut the other off).\n" \
	"STOP  put this at the top of the queuefile and the next time the queuefile\n" \
	"      is read the program will quit without losing any data." << endl;
}


int UpdateQF(char *Jabba,int Yoda) {
	const char *Nums="0123456789";
	char BobaFett[200],*NewLine,TempStr[20];
	int z=TRUE,x=0,y;

	if (VERBOSE)
		cout << "Updating Queuefile..."  << endl;
	if ((!PROGRESSIVE)&&(!SEQUENTIAL)) {
		fstream QF(QFName,ios::in|ios::out);
		if (!QF)
			return FALSE;
		while ((z)&&(QF.getline(BobaFett,200))) {
			if (strcmp(BobaFett,Jabba)==0) {
				z=FALSE;
				QF.seekp(-strlen(BobaFett)-NLSize,ios::cur);
				if (Yoda!=-1)
					QF.put('X'); 
				else
					QF.put('F');
			}
		}
	} else { {	//  Extra brackets to scope QF and Dum
		ifstream QF(QFName);
		if (!QF)
			return FALSE;
		ofstream Dum("AbCxYz");
		if (!Dum)
			return FALSE;
		while (QF.getline(BobaFett,200)) {
			Dum << BobaFett << '\n';
			if ((strcmp(BobaFett,Jabba)==0)&&(z)) {
				z=FALSE;
				Dum.seekp(-strlen(BobaFett)-NLSize,ios::cur);
				if (Yoda!=-1)
					Dum.put('X'); 
				else
					Dum.put('F');
				NewLine=RemLSpace(Jabba);
				if (PROGRESSIVE)
					Dum << &BobaFett[1] << "  --  Progressive method " << NewLine[0] << '\n';
				else
					Dum << &BobaFett[1] << "  --  Sequential method " << NewLine[0] << '\n';
				Dum.seekp(0,ios::end);
				x=1;
				while (CharInStr(NewLine[x],Nums)) {
					x++;
				}
				strncpy(TempStr,NewLine,x);
				TempStr[x]='\0';
				y=atoi(TempStr);
				if (FindNode(y+1)) {
					NewLine+=x;
					Dum << y+1 << NewLine << '\n';
				}
			}
		} }
		ofstream QF(QFName);
		if (!QF)
			return FALSE;
		ifstream Dum("AbCxYz");
		if (!Dum)
			return FALSE;
		while (Dum.getline(BobaFett,200))
			QF << BobaFett << '\n';
		unlink("AbCxYz");
	}
	return TRUE;
}

int ReadQueue(void) {
	const char *Nums="0123456789";
	char Line[200],*NewLine,CurPath[100];
	char TempStr[20];
	int x,y,RetVal=FALSE,NoMore=FALSE;
	Method *Vader;

	if (VERBOSE)
		cout << "Reading Queue..." << endl;
	ifstream QueueFile(QFName);
	if (!QueueFile) {
		cerr << "\nError: could not open " << QFName << " to read as input for QueueMaster." << endl;
		return FALSE; }

	FreeMemory();
	CurPath[0]='.';
	CurPath[1]=0;

	while (QueueFile.getline(Line,200)) {
		NewLine=RemLSpace(Line);
		if ((NewLine[0]!=0)&&(NewLine[0]!='#')&&(NewLine[0]!='F')&&(NewLine[0]!='X')) {
			if ((strstr(NewLine,"STOP")==NewLine)||(strstr(NewLine,"stop")==NewLine))
				ALLSTOP=TRUE;
			else if (toupper(NewLine[0])=='D') {
				if (CharInStr(NewLine[1],Nums)) {
					x=2;
					while (CharInStr(NewLine[x],Nums)) {
						x++;
					}
					x--;
					strncpy(TempStr,&NewLine[1],x);
					TempStr[x]='\0';
					y=atoi(TempStr);
					if (FindNode(y)==NULL) {
						AddNode(y,&NewLine[x+2]);
					} else {
						cerr << "Error: method " << y << " has already been defined." << endl;
					}
				} else {
					strcpy(CurPath,&NewLine[1]);
				}
			}
			else if (toupper(NewLine[0])=='O') {
				switch (NewLine[1]) {
					case 'Q': VERBOSE=FALSE;	break;
					case 'P': PROGRESSIVE=TRUE;
						  SEQUENTIAL=FALSE;	break;
					case 'S': SEQUENTIAL=TRUE;
						  PROGRESSIVE=FALSE;	break;
					case 'C': CSH=TRUE;		break;
					default:  cerr << "Error: Invalid Option in queuefile:\n--> " << Line << endl;
				}
			}
			else if (CharInStr(NewLine[0],Nums)) {
				x=1;
				while (CharInStr(NewLine[x],Nums)) {
					x++;
				}
				strncpy(TempStr,NewLine,x);
				TempStr[x]='\0';
				y=atoi(TempStr);
				if (FindNode(y)==NULL) {
					cerr << "Error: method " << y << " has not been defined and is referenced in line:\n--> " << Line << endl;
				} else {
					RetVal=TRUE;
					if (!NoMore) {
						Vader=FindNode(y);
						AndMan.Add(new ImageFile(&NewLine[x+1],Vader->TheMethod,CurPath,Line));
					}
					if (SEQUENTIAL)
						NoMore=TRUE;
				}
			}
			else if (!AllSpace(Line))
					cerr << "Error: could not process line:\n--> " << Line << endl; } }
	return RetVal;
}

int AllSpace(char *Spacey) {
	int x=0;
	while ((Spacey[x]==' ')||(Spacey[x++]=='\t'));
	if (Spacey[x-1]==0)
		return TRUE;
	return FALSE;
}

char *RemLSpace(char *DarkHelmet) {
	int x=0;
	while ((DarkHelmet[x]==' ')||(DarkHelmet[x]=='\t')) {
		x++;
	}
	return &DarkHelmet[x];
}

void FreeMemory(void) {
	ImageFile *Gorpon;
	int x;

	DeleteLList();
	Gorpon=AndMan.Upchuck();
	while (Gorpon) {
		delete Gorpon;
		Gorpon=AndMan.Upchuck(); }
}

Method * FindNode(int Dum) {
	Method *Temp=Start;

	if (Temp==NULL)
		return NULL;
	while ((Temp->Num!=Dum)&&(Temp->Next!=NULL)) {
		Temp=Temp->Next;
	}
	if (Temp->Num==Dum)
		return Temp;
	else
		return NULL;
}

int AddNode(int Dum, char *Meth) {
	Method *Temp=Start;

	if (Temp==NULL) {
		if ((Temp=(Method *)malloc(sizeof(Method)))==NULL)
			return FALSE;
		Start=Temp;
	} else {
		while (Temp->Next!=NULL) {
			Temp=Temp->Next;
		}
		if ((Temp->Next=(Method *)malloc(sizeof(Method)))==NULL)
			return FALSE;
		Temp=Temp->Next;
	}
	Temp->Next=NULL;
	Temp->Num=Dum;
	Temp->TheMethod=strdup(Meth);
	return TRUE;
}

void DeleteLList(void) {
	Method *Temp;

	while (Start!=NULL) {
		Temp=Start;
		free(Start->TheMethod);
		Start=Start->Next;
		free(Temp);
	}
}

int CharInStr(char AChar, const char *AStr) {
	int x=0;

	while (AStr[x]!='\0') {
		if (AChar==AStr[x])
			return TRUE;
		x++;
	}
	return FALSE;
}
