
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>

#define COMMENT '#'
#define MAXCOL  7

float p[MAXCOL][10];
int max,delta;
float diff;
char comment;
/* ---------------------------------------------------------------- */
void help()
{
printf("Usage: smooth -c#m#n#\n");
printf("smooths a column in a table by taking the average\n");
printf("       -A : prints command-line preceeded by '%c' to stdout\n",comment);
printf("       -c : column to smooth. (default: don't smooth)\n");
printf("       -d : add delta\n");
printf("       -n : number of items to average (default: 5)\n");
printf("       -m : factor to multiply with (default 1)\n");
printf("Copyright Hans Paijmans 1995\n");
exit(1);
} 
/* ---------------------------------------------------------------- */

void error_exit(char *s,char *ss)
{
printf("Error: %s %s\n",s,ss);
help();
exit(1);
} 
/* ---------------------------------------------------------------- */
float average(int x,int m)
{
float sum;
int y;
sum=0;

for (y=0;y<max;y++) sum+=p[x][y];

return m*(sum / max);
}
/* ---------------------------------------------------------------- */
main(int argc,char **argv)
{
char s[500],*ss,o;
char a[MAXCOL][500];
int x,y,n,column,mult,cols,delta_column;
float f;
extern int optind;
extern char *optarg;

comment=COMMENT;
delta=0;
diff=0;
column=-1;max=5;mult=1;
while ((o=getopt(argc,argv,"Ac:dm:n:h"))!=-1)
     switch (o)
       {
       case 'A': printf("%c",comment);
                 for (n=0;n<argc;n++) printf("%s ",argv[n]);
                 printf("\n");
                 break;
 
       case 'c': column=atoi(optarg)-1;break;
       case 'd': delta=1;delta_column=atoi(optarg);break;
       case 'h': help();break;
       case 'm': mult=atoi(optarg);break;
       case 'n': max=atoi(optarg);break;
       }

memset(a,0,20*50*sizeof(char));
memset(p,0,20*10*sizeof(float));
for (x=0;x<20;x++) for (y=0;y<10;y++) p[x][y]=0;

if (!max) max=5;
if (!mult) mult=1;
if (!delta_column) delta_column=column;

printf("column %d\ndelta  %d\nmax    %d\nmult   %d\n",column,delta,max,mult);

do
   {
   do
     {
     gets(s);
     if (s[0]==comment) printf("%s\n",s);
        else 
          {
          cols=0;
          ss=strtok(s,"\t ");strcpy(a[cols],ss);
          while (ss) { strcpy(a[cols++],ss);ss=strtok(NULL,"\t ");}
          }
     }
   while (((s[0]==comment) || (strlen(s)<3)) && (!feof(stdin)));

if (column>=0)
   {
     for (x=max;x>0;x--) p[column][x]=p[column][x-1];
     p[column][0]=atof(a[column]);

     f=average(column,mult);
     /*     sprintf(a[column],"%2.3f",f); */
   }

   for (x=0;x<cols;x++) printf(" %s",a[x]);
printf(" %2.3f ",f);
   if (delta) printf(" %2.2f",f-diff);
   diff=f;
   printf("\n");

   }
while (!feof(stdin));
exit(0);
}












