
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>

#define COMMENT '#'


float p[7][10];
int max,delta;
float diff;
char comment;
/* ---------------------------------------------------------------- */
void help()
{
printf("Usage: smooth -c#m#n#\n");
printf("smooths a column in a table by taking the average\n");
printf("       -A : prints command-line preceeded by '%c' to stdout\n",comment);
printf("       -c : column to smooth\n");
printf("       -d : add delta\n");
printf("       -n : number of items to average (default: 5)\n");
printf("       -m : factor to multiply with\n");
printf("Copyright Hans Paijmans 1995\n");
exit(1);
} 
/* ---------------------------------------------------------------- */

void error_exit(char *s,char *ss)
{
printf("Error: %s %s\n",s,ss);
help();
exit(1);
} 
/* ---------------------------------------------------------------- */
float average(int x,int m)
{
float sum;
int y;
sum=0;

for (y=0;y<max;y++) sum+=p[x][y];

return m*(sum / max);
}
/* ---------------------------------------------------------------- */
main(int argc,char **argv)
{
char s[100],*ss,o;
char a[7][100];
int x,y,n,column,mult;
float f;
extern int optind;
extern char *optarg;

comment=COMMENT;
delta=0;
diff=0;
column=10;max=0;mult=1;
while ((o=getopt(argc,argv,"Ac:dm:n:h"))!=-1)
     switch (o)
       {
       case 'A': printf("%c",comment);
                 for (n=0;n<argc;n++) printf("%s ",argv[n]);
                 printf("\n");
                 break;
 
       case 'c': column=atoi(optarg)-1;break;
       case 'd': delta=1;break;
       case 'h': help();break;
       case 'm': mult=atoi(optarg);break;
       case 'n': max=atoi(optarg);break;
       }

if (max==0) max=5;
if (mult==0) mult=1;

memset(a,0,7*100*sizeof(char));
memset(p,0,7*10*sizeof(float));

do
   {
   do
     {
     gets(s);
     if (s[0]=='#') printf("%s\n",s);
     }
   while (((s[0]=='#') || (strlen(s)<3)) && (!feof(stdin)));

   sscanf(s,"%s %s %s %s %s %s\n",&a[0],&a[1],&a[2],&a[3],&a[4],&a[5]);

   for (x=max;x>0;x--) p[column][x]=p[column][x-1];
   p[column][0]=atof(a[column]);
   f=average(column,mult);
   sprintf(a[column],"%2.4f",f);
   printf(" %s %s %s %s %s %s",a[0],a[1],a[2],a[3],a[4],a[5]);
   if (delta) printf(" %2.2f",f-diff);
   diff=f;
   printf("\n");

   }
while (!feof(stdin));
exit(0);
}












