
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <math.h>

#define MAX_VAR 10000

float **var;
int aantal_vars;
/* ---------------------------------------------------------------- */
void help()
{
printf("Usage: pearson -c#m#n#\n");
printf("computes pearson's coeff. in a table\n");
printf("Copyright Hans Paijmans 1995\n");
exit(1);
}
/* ---------------------------------------------------------------- */
float average(float *fl,int num)
{
float som;
int x;

som=0;
for (x=0;x<num;x++) som+=fl[x];
return som/num;
}
/* ---------------------------------------------------------------- */
float sum(float *fl,int num)
{ 
float som;
int x;

som=0;
for (x=0;x<num;x++) som+=fl[x];
return som;
}
/* ---------------------------------------------------------------- */
float variance(float *fl,int num)
{
float som,avg;
int x,N_min_1;

avg=average(fl,num);
N_min_1=num-1;
som=0;
for (x=0;x<num;x++) som+=((fl[x]-avg)*(fl[x]-avg)) / N_min_1;
return som;
}
/* ---------------------------------------------------------------- */
float std_dev(float *fl,int num)
{
return sqrt(variance(fl,num));
}
/* ---------------------------------------------------------------- */
float pearsons_R(float *fl1, float *fl2, int num)
{
float som,avg1,avg2,sd1,sd2;
int x;

som=0;
avg1=average(fl1,num);
avg2=average(fl2,num);
sd1=std_dev(fl1,num);
sd2=std_dev(fl2,num);
for (x=0;x<num;x++) som+=((fl1[x]-avg1)*(fl2[x]-avg2));
return (som/((num-1)*sd1*sd2));
}
/* ---------------------------------------------------------------- */
float student(float r, int num)
{
return (
            r * (float)sqrt( 
                     (2*num-2)/(1-(float)(r*r))
                    )
       );
}
/* ---------------------------------------------------------------- */
main(int argc,char **argv)
{
char o;
int x,y;
float r,t;

while ((o=getopt(argc,argv,"h"))!=-1)
     switch (o)
       {
       case 'h': help();break;
       }

aantal_vars=0;
var=(float**)malloc(4*sizeof(var));
for (x=0;x<4;x++) var[x]=(float*)malloc(MAX_VAR*sizeof(float));



do
   {
   scanf("%f %f %f\n",&var[0][aantal_vars],&var[1][aantal_vars],&var[2][aantal_vars]);
   aantal_vars++;
   }
while (!feof(stdin));

printf("kwak\n");


for (x=0;x<aantal_vars;x++)   printf("%f %f\n",var[0][x],var[1][x]);

printf("N        :%d\nAverage  : %f\n",aantal_vars,average(var[0],aantal_vars));
printf("variance :%f\n",variance(var[0],aantal_vars));
printf("Std-dev  :%f\n",std_dev(var[0],aantal_vars));

for (x=0;x<3;x++) 
    {
    for (y=0;y<3;y++) 
           {
           r=pearsons_R(var[x],var[y],aantal_vars);
           t=student(r,aantal_vars);
           printf("\t%f - %f",r,t);
           
           }
    printf("\n");
    }
exit(0);

}









