
/*
ptldiff copyright (c) 2009-always Jan Panteltje

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


/* compile with gcc -Wall -o ptldiff ptldiff.c */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
 

void usage()
{
fprintf(stderr, "\nptldiff-0.1\n\
Usage: ptldiff URL1 URL2 [verbose]\n\
verbose  displays wget outputs such as progress bars.\n\
Examples:\n\
ptldiff ftp://sunsite.unc.edu/pub/linux/system/news/readers/NewsFleX-1.5.7.3.tgz http://panteltje.com/panteltje/newsflex/NewsFleX-1.5.7.3.tgz\n\
ptldiff file:/home/me/something.txt ftp://somewhere/somedir/something.txt\n\
ptldiff http://panteltje.com/index.html \"10.0.0.152:82/index.html --user=guest --password=none\"\n\
Note: ptldiff requires wget and cat installed.\n\
");

exit(1);
}


int main(int argc, char**argv)
{
int a, b;
FILE *pptr1, *pptr2;
char temp[65535];
char temp2[40];
int verbose = 0;

long bytecount;


if( (argc != 3) && (argc != 4) ) usage();

if(argc == 4)
	{
	if(strcmp(argv[3], "verbose") == 0) verbose = 1;  
	}


if(verbose)
	{
	temp2[0] = 0;
	}
else
	{
	sprintf(temp2, "2> /dev/zero");
	}

if(argv[0][0] == '/') usage();
if(argv[1][0] == '/') usage();


if(strncmp(argv[1], "file:", 5) == 0)
	{
	// cat /home/ftp/m101.tif
	sprintf(temp, "cat %s %s", argv[1] + 5, temp2);  	
	}
else
	{
	//wget -O- 10.0.0.152:82/index.html
	sprintf(temp, "wget -O- %s %s", argv[1], temp2);
	}

pptr1 = popen(temp, "r");
	


if(strncmp(argv[2], "file:", 5) == 0)
	{
	// cat /home/ftp/m101.tif
	sprintf(temp, "cat %s %s", argv[2] + 5, temp2);  	
	}
else
	{
	//wget -O- 10.0.0.152:82/index.html
	sprintf(temp, "wget -O- %s %s", argv[2], temp2);
	}

pptr2 = popen(temp, "r");


bytecount = 0;
while(1)
	{
	a = fgetc(pptr1);
	b = fgetc(pptr2);

	if(a != b)
		{
		fprintf(stderr, "%s: files differ at bytecount %ld.\n", argv[0], bytecount);
		
		exit(1);
		}

	bytecount++;

	if( (a == EOF) || (b == EOF) ) break;
	}


fprintf(stderr, "%s: files are identical.\n", argv[0]);

exit(0);
} /* end function main */





