/*
Copyright (c) 2000 David A. Caswell

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include <stdio.h>

struct conversion_data {
  float T;
  float R;
};

struct conversion_data cdata[] = {
  {-50.0, 320.2e3},
  {-45.0, 247.5e3},
  {-40.0, 188.4e3},
  {-35.0, 144.0e3},
  {-30.0, 111.3e3},
  {-25.0, 86.39e3},
  {-20.0, 67.74e3},
  {-15.0, 53.39e3},
  {-10.0, 42.45e3},
  {-5.0, 33.89e3},
  {0.0, 27.28e3},
  {5.0, 22.05e3},
  {10.0, 17.96e3},
  {15.0, 14.65e3},
  {20.0, 12.09e3},
  {25.0, 10.0e3},
  {30.0, 8.313e3},
  {35.0, 6.941e3},
  {40.0, 5.826e3},
  {45.0, 4.912e3},
  {50.0, 4.161e3},
  {55.0, 3.537e3},
  {60.0, 3.021e3},
  {65.0, 2.589e3},
  {70.0, 2.229e3},
  {75.0, 1.924e3},
  {80.0, 1.669e3},
  {85.0, 1.451e3},
  {90.0, 1.366e3},
  {95.0, 1.108e3},
  {100.0, 0.9375e3},
  {105.0, 0.8575e3},
  {110.0, 0.7579e3},
  {0.0, 0.0},
};

double convert( double R )
{
  int i;
  i=0;
  while(1){
    if(cdata[i].R==0.0 && cdata[i].T==0.0) break;
    if(R >= cdata[i].R){
      if(i==0) return -1000.0;
      return cdata[i-1].T + 
	((cdata[i].T-cdata[i-1].T)/(cdata[i].R-cdata[i-1].R)) * 
	(R - cdata[i-1].R);
    }
    i++;
  }
return -1000.0;
}



main()
{
  float R;
  float T;
  char input[255];

  while(fgets(input, sizeof(input)-1, stdin)>0){
    sscanf(input, "%g,\n", &R);
    printf("%g, %s", convert(R)*9.0/5.0+32.0, input);
  }
  
}
