//-----------------------------------------------------------------------//
//                                                                       //
//   Project Media Group                  Helpdesk Registration System   //
//                                                                       //
//-----------------------------------------------------------------------//
//                                                                       //
//   Filename:  login.cc               Date created:       14-04-99      //
//   Version:   1.6                    Last modification:  27-04-99      //
//   Author:    A. Edens                                                 //
//              G. Versluis                                              //
//                                                                       //
//   Purpose:   Security and registering users in HRS                    //
//   Inputs:    Login, Password, IP addr.                                //
//   Output:    Mainmenu if password is correct                          //
//                                                                       //
//-----------------------------------------------------------------------//
//                                                                       //
//  This program is free software; you can redistribute it and/or modify //
//  it under the terms of the GNU General Public License as published by //
//  the Free Software Foundation; either version 2 of the License, or    //
//  (at your option) any later version.                                  //
//                                                                       //
//  This program is distributed in the hope that it will be useful,      //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of       //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        //
//  GNU General Public License for more details.                         //
//                                                                       //
//  You should have received a copy of the GNU General Public License    //
//  along with this program; if not, write to the Free Software          //
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            //
//                                                                       //
//-----------------------------------------------------------------------//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <crypt.h>
#include <mysql/mysql.h>
#include <hrslib.cc>
// #include "egg.cc"


void printerror(void)
{
	printf("Content-type: text/html\n\n");
	printf("<html>
<head>
<title>Fout bij aanmelden</title>
</head>
\n");
	
printf("<body background=\"/images/background.jpg\" bgproperties=\"fixed\">
\n");
	printf("<table border=\"0\" width=\"100%%\" bgcolor=\"#C0C0C0\" cellspacing=\"0\" cellpadding=\"3\">
");
	printf("<tr>
<td width=\"7%%\" rowspan=\"2\" bgcolor=\"#000080\"><img src=\"/images/weblogo_small.gif\"></td>");
	printf("<td width=\"82%%\" bgcolor=\"#000080\"><p align=\"center\"><font face=\"Arial\" color=\"#FFFFFF\"><big>Helpdesk
 Registration System</big></font></td>
");
	printf("<td width=\"11%%\">&nbsp;</td>
</tr>
");
	printf("<tr>
<td width=\"82%%\"><strong>Fout bij aanmelden</strong></td>
<td width=\"11%%\">&nbsp;</td>
</tr>
</table>
");
	printf("<br>Controleer uw gebruikersnaam en wachtwoord en probeer opnieuw aan te melden.<P>\n");
	printf("<a HREF=\"/\">Klik hier voor het aanmeldscherm</a>");
	printhtml("tail.html","");

}



int main(void)
{
    char *dbgid = new char[2];	// GroupID

    char *dbname = new char[16];	// Username

    char *dbpasswd = new char[20];	// Password in database

    char *encryptpasswd = new char[20];		// Encrypted password

    char *username = new char[16];	// Username (typed in at login prompt)

    char *userpasswd = new char[20];	// Password (idem)

    if (!init())
	return 1;

    username = getenv("WWW_username");
    userpasswd = getenv("WWW_password");
/*
    if (!strcmp(username, "Tux") && !strcmp(userpasswd, "Tux"))
    {
      egg();
    } else { 
*/
    if (findname(dbgid, username, dbpasswd)) {
/*	printf("Content-type: text/html\n\n");
	printf("<HTML><HEAD>\n");
	printf("<TITLE>Helpdesk Registration System</TITLE>\n");
	printf("</HEAD>\n");
	printf("<body background=\"/images/webpage-backpattern.jpg\" bgproperties=\"fixed\">\n");
	printf("<H1>Fout bij aanmelding</H1>\n");
	printf("Controleer uw gebruikersnaam en wachtwoord en probeer opnieuw aan te melden.<P>\n");
	printf("<HR><ADDRESS>Helpdesk Registration System - (c)1999 Project Media Group</ADDRESS>\n");
	printf("</BODY></HTML>\n");
*/
	printerror();
	return 0;
    } else {
	encryptpasswd = crypt(userpasswd, dbpasswd);
	if (!strcmp(dbpasswd, encryptpasswd)) {
	    setip(username);
	    if (strcmp(dbgid, "0"))
		printhtml("main-admins.html", "-");
	    if (!strcmp(dbgid, "0"))
		printhtml("main-users.html", "-");
	} else {
/*	    printf("Content-type: text/html\n\n");
	    printf("<HTML><HEAD>");
	    printf("<TITLE>Helpdesk Registration System</TITLE>");
	    printf("</HEAD>");
	    printf("<body background=\"/images/webpage-backpattern.jpg\" bgproperties=\"fixed\">");
	    printf("<H1>Fout bij aanmelding</H1>");
	    printf("Controleer uw gebruikersnaam en wachtwoord en probeer opnieuw aan te melden.<P>");
	    printf("<HR><ADDRESS>Helpdesk Registration System - (c)1999 Project Media Group</ADDRESS>");
	    printf("</BODY></HTML>");
*/
	    printerror();
	}
    }
    mysql_close(&mysql);
    return 0;
    
}
