//-----------------------------------------------------------------------//
//                                                                       //
//   Project Media Group                  Helpdesk Registration System   //
//                                                                       //
//-----------------------------------------------------------------------//
//                                                                       //
//   Filename: addusr.cc               Date created:      20-05-99       //
//   Version:  1.0                     Last modification: 24-05-99       //
//   Author:   A. Edens                                                  //
//             G. Versluis                                               //
//                                                                       //
//   Purpose: Creates a new user record based on input data              //
//   inputs:  name, fullname, group, password (twice)                    //
//   outputs: confirmation                                               //
//                                                                       //
//-----------------------------------------------------------------------//
//                                                                       //
//  This program is free software; you can redistribute it and/or modify //
//  it under the terms of the GNU General Public License as published by //
//  the Free Software Foundation; either version 2 of the License, or    //
//  (at your option) any later version.                                  // 
//                                                                       //
//  This program is distributed in the hope that it will be useful,      //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of       //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        //
//  GNU General Public License for more details.                         //
//                                                                       //
//  You should have received a copy of the GNU General Public License    //
//  along with this program; if not, write to the Free Software          //
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            //
//                                                                       //
//-----------------------------------------------------------------------//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <crypt.h>
#include <mysql/mysql.h>
#include <hrslib.cc>


int main(void)
{
    char *query = new char[1500];
    char *slt = new char[5];
    char *dbuid = new char[5];
    char *dbgid = new char[5];
    char *dbnaam = new char[11];
    char *dbpasswd = new char[16];
    char *dbpasswd2 = new char[16];
    char *dbfullname = new char[26];
    char *uid = new char[5];

    if (!init())
	return 1;
    if (!checkadmin(uid)) {
	return 1;
    } else {
	dbgid = getenv("WWW_gid");
	dbnaam = getenv("WWW_username");
	dbfullname = getenv("WWW_fullname");
	dbpasswd = getenv("WWW_Pwd");
	dbpasswd2 = getenv("WWW_PwdConfirm");
	if (!strcmp(dbpasswd, dbpasswd2)) {
	    salt(slt);
	    dbpasswd = crypt(dbpasswd2, slt);
	    strcpy(query, "INSERT INTO gebruikers VALUES (LAST_INSERT_ID(),\"");
	    strcat(query, dbgid);
	    strcat(query, "\",\"");
	    strcat(query, dbnaam);
	    strcat(query, "\",\"");
	    strcat(query, dbpasswd);
	    strcat(query, "\",\"");
	    strcat(query, dbfullname);
	    strcat(query, "\",\"\")");
	    mysql_query(&mysql, query);

	    printf("Content-type: text/html\n\n");
	    
		printf("<HTML><HEAD>\n");
	    
		printf("<TITLE>Helpdesk Registration System</TITLE>\n");
	    printf("<meta http-equiv=\"refresh\" content=\"10; URL=/main-admins.html\">\n");
	    
		printf("</HEAD><BODY background=\"/images/background.jpg\" bgproperties=\"fixed\">\n");
	    
		printf("<H1>Gebruiker is toegevoegd</H1><BR>\n");
	    printf("De gebruiker '%s' is toegevoegd aan het systeem.<br>\n", dbnaam);
	    printf("Als u niet binnen 10 seconden het hoofdmenu ziet, klik dan <a href=\"/main-admins.html\">hier</a><br>\n");
	    printf("<hr><address>Helpdesk Registration System - (c)1999 Project Media Group</Address>\n");
	    printf("</BODY></HTML>\n");
	} else {
	    printf("Content-type: text/plain\n\nError...\nPassword confirmation incorrect\n");
	}
    }
}
