//-----------------------------------------------------------------------//
//                                                                       //
//   Project Media Group                  Helpdesk Registration System   //
//                                                                       //
//-----------------------------------------------------------------------//
//                                                                       //
//   Filename:  hrslib.cc              Date created:       13-04-99      //
//   Version:   2.6                    Last modification:  24-05-99      //
//   Author:    Versluis G.                                              //
//              Edens A.                                                 //
//                                                                       //
//   Purpose:   General HRS functions                                    //
//   Inputs:    Function depended                                        //
//   Output:    Function depended                                        //
//                                                                       //
//-----------------------------------------------------------------------//
//                                                                       //
//  This program is free software; you can redistribute it and/or modify //
//  it under the terms of the GNU General Public License as published by //
//  the Free Software Foundation; either version 2 of the License, or    //
//  (at your option) any later version.                                  // 
//                                                                       //
//  This program is distributed in the hope that it will be useful,      //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of       //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        //
//  GNU General Public License for more details.                         //
//                                                                       //
//  You should have received a copy of the GNU General Public License    //
//  along with this program; if not, write to the Free Software          //
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            //
//                                                                       //
//-----------------------------------------------------------------------//
#include <string.h>   // str2int
#include <stdio.h>    // printf fopen, fclose etc.
#include <stdlib.h>
#include <errno.h>
#include <crypt.h>
#include <sys/time.h>
#include <mysql/mysql.h>

static MYSQL mysql;
static MYSQL_RES result;
static MYSQL_ROW datarow;

/*

printhtml(filename, text)               print HTML with replacement to stdout
printfile(filename)                     print HTML-tail to stdout
getdate                                 get date from unix machine
gettime                                 get time from unix machine

checkusr(user)                          check if user exists
clearip(ip)                             clear ip in database
checkpasswd(user,password) <- clearip   check password is correct

mkusr                                   make user record in database
rmusr                                   remove user record from database
chusr                                   change user record in database
lsusr                                   list all users
lsactive                                list all active users

mkincident                              create incident
rmincident                              remove incident (admin)
chincident                              change incident
lsincident                              list incidents based on query
closeincident                           move incident to history db
incident2problem                        move incident to problem db
report                                  report statistics

getpage                                 link to another webpage
str2int                                 convert string to integer

*/
int printhtml(char *,char *);

MYSQL_RES doquery(char *query)
{
  mysql_query(&mysql, query);
  return(*mysql_store_result(&mysql));
}

int init(void)
{
  char *mysqlhost = "localhost";
  char *mysqluser =  "root";
  char *mysqlpasswd = "";
  char *database = "hrs";

	if (!(mysql_connect(&mysql, mysqlhost, mysqluser, mysqlpasswd)))
	{
		printhtml("error.html", mysql_error(&mysql));
		return 0;
	} else {
		mysql_select_db(&mysql, database);
		return -1;
	}
}

void salt(char *s)
{
	unsigned char itoa64[] = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
	unsigned long v;
	int n=2;
	timeval tv;
	gettimeofday(&tv,(struct timezone *) 0);
	v = tv.tv_usec;
	while (--n >= 0) {
		*s++ = itoa64[v&0x3f];
		v >>= 6;
	}
}


int findname(char *gid, char *name, char *passwd)
{
	char *query=new char[1500];
	int rows;
        strcpy(query, "SELECT gid,naam,passwd FROM gebruikers WHERE naam = \"");
        strcat(query, name);
        strcat(query, "\"");
	result = doquery(query);
	rows = mysql_num_rows(&result);
	if (rows!=1) {
	    return -1;
	} else {
	    datarow = mysql_fetch_row(&result);
	    strcpy(gid,datarow[0]);
	    strcpy(name,datarow[1]);
	    strcpy(passwd,datarow[2]);
	    return 0;
	}
}

int checklogon(char *naam)
{
	char *query=new char[1500];
	char *ip=getenv("REMOTE_ADDR");
	int rows;
        strcpy(query, "SELECT naam,ipaddress FROM gebruikers WHERE ipaddress = \"");
        strcat(query, ip);
        strcat(query, "\"");
	result = doquery(query);
	rows = mysql_num_rows(&result);
	if (rows!=1) {
	    printhtml("error.html","U bent niet aangemeld<br>Klik <a href=\"/index.html\">hier</a> om aan te melden<br>");
	    return 0;
	} else {
	    datarow = mysql_fetch_row(&result);
	    strcpy(naam,datarow[0]);
	    return -1;
	}
}


int checkadmin(char *uid)
// returns -1 if user is not logged on or not an admin...
{
	char *query=new char[1500];
	char *ip=getenv("REMOTE_ADDR");
	int rows;
        strcpy(query, "SELECT uid,ipaddress,gid FROM gebruikers WHERE ipaddress = \"");
        strcat(query, ip);
        strcat(query, "\"");
	result = doquery(query);
	rows = mysql_num_rows(&result);
	if (rows!=1) {
	    printf("Content-type: text/html\n\n");
	    printf("<HTML><HEAD>\n");
	    printf("<TITLE>Helpdesk Registration System</TITLE>\n");
	    printf("<meta http-equiv=\"refresh\" content=\"10; URL=/index.html\">\n");
	    printf("</HEAD><BODY background=\"/images/background.jpg\" bgproperties=\"fixed\">\n");
	    printf("<H1>Niet Aangemeld</H1><BR>\n");
	    printf("U bent niet aangemeld bij HRS.<br>\n");
	    printf("Als u niet binnen 10 seconden het aanmeldscherm ziet, klik dan <a href=\"/index.html\">hier</a><br>\n");
	    printf("<hr><address>Helpdesk Registration System - (c)1999 Project Media Group</Address>\n");
	    printf("</BODY></HTML>\n");
	    return 0;
	} else {
	    datarow = mysql_fetch_row(&result);
	    if(!strcmp(datarow[2],"0"))
	    {
		printf("Content-type: text/html\n\n");
		printf("<HTML><HEAD>\n");
		printf("<TITLE>Helpdesk Registration System</TITLE>\n");
		printf("</HEAD><BODY background=\"/images/background.jpg\" bgproperties=\"fixed\">\n");
		printf("<H1>Niet voldoende rechten</H1><BR>\n");
		printf("U heeft niet voldoende rechten om deze functie uit te voeren.<br>\n");
		printf("Neem a.u.b contact op met een beheerder of uw afdelinghoofd<br>\n");
		printf("<hr><address>Helpdesk Registration System - (c)1999 Project Media Group</Address>\n");
		printf("</BODY></HTML>\n");
		return 0;
	    } else {
	    	strcpy(uid,datarow[0]);
		return -1;
	    }
	}
}

int clearip(char *ip)
{
  char *query=new char[1500];
  strcpy(query, "UPDATE gebruikers SET ipaddress=\"\" WHERE ipaddress= \"");
  strcat(query, ip);
  strcat(query, "\"");
  mysql_query(&mysql, query);
}

int setip(char *name)
{
	char *query=new char[1500];
	char *ip=getenv("REMOTE_ADDR");

	clearip(ip);
        strcpy(query, "UPDATE gebruikers SET ipaddress= \"");
        strcat(query, ip);
        strcat(query, "\" where naam= \"");
        strcat(query, name);
	strcat(query, "\"\0");
	mysql_query(&mysql, query);
}


int printhtml(char *filename, char *text)
{
  char c;
  FILE *fpointer;
  fpointer = fopen(filename, "r");
  if (!fpointer) return -1;
  c=fgetc(fpointer);
  while (!feof(fpointer))
  {
    if (c=='\\')
    {
      c=fgetc(fpointer);
      if (c=='t') printf("%s", text);       
      else putc('\\', stdout);
    }
    else putc(c, stdout);
    c=fgetc(fpointer);
  }
  
  fclose(fpointer);
  return 0;
}

int printfile(char *filename)
{
  char c;
  FILE *fpointer;
  fpointer = fopen(filename, "r");
  if (!fpointer) {
    printf("Content-type: text/plain\n\n");
    perror("hrslib.cc");
    return -1;
  }  
  printf("Content-type: text/html\n\n");    
  c=fgetc(fpointer);
  while (!feof(fpointer))
  {
    putc(c, stdout);
    c=fgetc(fpointer);
  }
  fclose(fpointer);
  return 0;
}

int getdate(char date[10])
{
  char i;
  FILE *fpointer;
  fpointer = fopen("/proc/rtc", "r");
  if (!fpointer) return -1;
  fseek(fpointer, 31, SEEK_SET);
  for (i=0; i<10; i++)
  {
    date[i]=fgetc(fpointer);
  }
  date[i]='\0';
  fclose(fpointer);
  return 0;
}

int gettime(char time[5])
{
  char i;
  FILE *fpointer;
  fpointer = fopen("/proc/rtc", "r");
  if (!fpointer) return -1;
  fseek(fpointer, 11, SEEK_SET);
  for (i=0; i<5; i++)
  {
    time[i]=fgetc(fpointer);
  }
  time[i]='\0';
  fclose(fpointer);
  return 0;
}

int closeincident(char *incidentnr)
{
  MYSQL_RES result;
  char *query=new char[1500];
  char *afboekdatum=new char[11];
  strcpy(query, "select * from incidenten where incidentnr=");
  strcat(query, incidentnr);
  result=doquery(query);
  if (mysql_num_rows(&result)==0) return -1;
  datarow = mysql_fetch_row(&result);
  strcpy(query, "insert into history values (");
  strcat(query, datarow[0]);
  strcat(query, ",\"" );
  strcat(query, datarow[1]);
  strcat(query, "\",\"" );
  strcat(query, datarow[2]);
  strcat(query, "\",\"" );
  strcat(query, datarow[3]);
  strcat(query, "\",\"" );
  strcat(query, datarow[4]);
  strcat(query, "\"," );
  strcat(query, datarow[5]);
  strcat(query, "," );
  strcat(query, datarow[6]);
  strcat(query, ",\"" );
  strcat(query, datarow[7]);
  strcat(query, "\",\"" );
  strcat(query, datarow[8]);
  strcat(query, "\",\"" );
  strcat(query, datarow[9]);
  strcat(query, "\",\"" );
  strcat(query, datarow[10]);
  strcat(query, "\",\"" );
  strcat(query, datarow[11]);
  strcat(query, "\",\"" );
  strcat(query, datarow[12]);
  strcat(query, "\",\"" );
  strcat(query, datarow[13]);
  strcat(query, "\",\"" );

  getdate(afboekdatum);
  strcat(query, afboekdatum);
  strcat(query, "\")" );
  mysql_query(&mysql, query);

  strcpy(query, "delete from incidenten where incidentnr=");
  strcat(query, incidentnr);
  mysql_query(&mysql, query);
  return(0);
}

int incident2problem(char *incidentnr)
{
  char *query=new char[1500];
  char *afboekdatum=new char[11];
  strcpy(query, "select * from incidenten where incidentnr=");
  strcat(query, incidentnr);
  result=doquery(query);
  if (mysql_num_rows(&result)==0) return -1;
  datarow = mysql_fetch_row(&result);
  strcpy(query, "insert into problem values (\"");
  strcat(query, datarow[0]);  // incidentnr. (int[11])
  strcat(query, ",\"" );
  strcat(query, datarow[1]);  // Aanmelder (varchar[15])
  strcat(query, "\",\"" );
  strcat(query, datarow[2]);  // Klant (varchar[25])
  strcat(query, "\",\"" );
  strcat(query, datarow[3]);  // Toestelnr (varchar[15])
  strcat(query, "\",\"" );
  strcat(query, datarow[4]);  // Kamernr (varchar[10])
  strcat(query, "\"," );
  strcat(query, datarow[5]);  // Eigenaar (int[11])
  strcat(query, "," );
  strcat(query, datarow[6]);  // Prioriteit (int[11])
  strcat(query, ",\"" );
  strcat(query, datarow[7]);  // Categorie (varchar[20])
  strcat(query, "\",\"" );
  strcat(query, datarow[8]);  // Software (varchar[20])
  strcat(query, "\",\"" );
  strcat(query, datarow[9]);  // Omschrijving (varchar[255])
  strcat(query, "\",\"" );
  strcat(query, datarow[10]);  // Status (varchar[255])
  strcat(query, "\",\"" );
  strcat(query, datarow[11]);  // Oplossing (varchar[255])
  strcat(query, "\",\"" );
  strcat(query, datarow[12]);  // Opgelost (char[1])
  strcat(query, "\",\"" );
  strcat(query, datarow[13]);  // Inboekdatum (varchar[10])
  strcat(query, "\",\"" );
  getdate(afboekdatum);
  strcat(query, afboekdatum);  // Afboekdatum (varchar[10])
  strcat(query, "\")" );
  mysql_query(&mysql, query);

  strcpy(query, "delete from incidenten where incidentnr=");
  strcat(query, incidentnr);
  mysql_query(&mysql, query);
  return(0);
}


int str2int(char *line)
{
  int i,number=0;
  for (i=0; i<strlen(line); i++)
  {
    number=number*10;
    number=number+line[i]-48;
  }
  return(number);
}


void getpage(char *page)
{
  printf("Content-type: text/html\n\n");
  printf("<HTML><HEAD>");
  printf("<meta http-equiv=\"refresh\" content=\"0; URL=%s\">",page);
  printf("</HEAD></HTML>");
}

