
//-----------------------------------------------------------------------//
//                                                                       //
//   Project Media Group                  Helpdesk Registration System   //
//                                                                       //
//-----------------------------------------------------------------------//
//                                                                       //
//   Filename:  report.cc              Date created:       24-05-99      //
//   Version:   2.7                    Last modification:  01-06-99      //
//   Author:    Versluis G.                                              //
//              Edens A.                                                 //
//                                                                       //
//   Purpose:   Create report                                            //
//   Inputs:    Date                                                     //
//   Output:    Report                                                   //
//                                                                       //
//-----------------------------------------------------------------------//
//                                                                       //
//  This program is free software; you can redistribute it and/or modify //
//  it under the terms of the GNU General Public License as published by //
//  the Free Software Foundation; either version 2 of the License, or    //
//  (at your option) any later version.                                  //
//                                                                       //
//  This program is distributed in the hope that it will be useful,      //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of       //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        //
//  GNU General Public License for more details.                         //
//                                                                       //
//  You should have received a copy of the GNU General Public License    //
//  along with this program; if not, write to the Free Software          //
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            //
//                                                                       //
//-----------------------------------------------------------------------//
#include <stdio.h>		// printf fopen, fclose etc.
#include <stdlib.h>
#include <errno.h>
#include <mysql/mysql.h>
#include <hrslib.cc>

void printreport(void)
//  prints standard report for function 'report'
{
    printf("<table bgcolor=\"#C0C0C0\" width=100%%>\n");
    printf("<tr><td width=25%%>Incidentnr:<td width=75%%>%s</tr>\n", datarow[0]);
    printf("<tr><td width=25%%>Categorie:<td width=75%%>%s</tr>\n", datarow[1]);
    printf("<tr><td width=25%%>Software:<td width=75%%>%s</tr>\n", datarow[2]);
    printf("<tr><td width=25%%>Omschrijving:<td width=75%%>%s</tr>\n", datarow[3]);
    printf("<tr><td width=25%%>Status:<td width=75%%>%s</tr>\n", datarow[4]);
    printf("<tr><td width=25%%>Oplossing:<td width=75%%>%s</tr>\n", datarow[5]);
    printf("<tr><td width=25%%>Inboekdatum:<td width=75%%>%s</tr>\n", datarow[6]);
    printf("<tr><td width=25%%>Laatste wijziging:<td width=75%%>%s</tr>\n", datarow[7]);
    printf("<tr><td colspan=2><hr size=6 width=100%%></td></tr>\n");
    printf("</table>");
}

int report(char date1[10], char date2[10])
//  report statistics
{


    // open db
    char *query = new char[1500];

    if (!strcmp(getenv("WWW_incidenten"), "j")) {
	strcpy(query, "SELECT incidentnr, categorie, software, omschrijving, status, oplossing, inboekdatum, afboekdatum FROM incidenten WHERE inboekdatum>=\"");
	strcat(query, date1);
	strcat(query, "\" AND inboekdatum<=\"");
	strcat(query, date2);
	strcat(query, "\" AND afgemeld=\"n\"");
	result = doquery(query);
	printf("<br><table width=100%% bgcolor=\"#C0C0C0\">");
	printf("<tr><td bgcolor=\"#000080\"><font color=\"#FFFFFF\"><strong>Aantal openstaande incidenten gevonden: %d</td></tr>\n", mysql_num_rows(&result));
	printf("<tr><td>&nbsp;</tr>");
	printf("</table>");
	while (datarow = mysql_fetch_row(&result))
	    printreport();

    }
    if (!strcmp(getenv("WWW_history"), "j")) {
	strcpy(query, "select Incidentnr, Categorie, Software, Omschrijving, Status, Oplossing, Inboekdatum, Afboekdatum from incidenten where Inboekdatum>=\"");
	strcat(query, date1);
	strcat(query, "\" AND inboekdatum<=\"");
	strcat(query, date2);
	strcat(query, "\" AND afgemeld=\"j\"");
	result = doquery(query);

	printf("<br><table width=100%% bgcolor=\"#C0C0C0\">");
	printf("<tr><td bgcolor=\"#000080\"><font color=\"#FFFFFF\"><strong>Aantal afgesloten incidenten gevonden: %d</tr>", mysql_num_rows(&result));
	printf("<tr><td>&nbsp;</tr>");
	printf("</table>");
	while (datarow = mysql_fetch_row(&result))
	    printreport();
    }
    if (!strcmp(getenv("WWW_problemen"), "j")) {
	strcpy(query, "select Incidentnr, Categorie, Software, Omschrijving, Status, Oplossing, Inboekdatum, Afboekdatum from problemen where Inboekdatum>=\"");
	strcat(query, date1);
	strcat(query, "\" AND inboekdatum<=\"");
	strcat(query, date2);
	strcat(query, "\"");

	result = doquery(query);

	printf("<br><table width=100%% bgcolor=\"#C0C0C0\">");
	printf("<tr><td bgcolor=\"#000080\"><font color=\"#FFFFFF\"><strong>Aantal problemen gevonden: %d</tr>", mysql_num_rows(&result));
	printf("<tr><td>&nbsp;</tr>");
	printf("</table>");
	while (datarow = mysql_fetch_row(&result))
	    printreport();
    }
    // close db
}


int main(void)
{
    char *username = new char[16];

    if (!init()) {
	return 1;
    } else {
	char *error = new char[100];
	if (!checklogon(username)) {
	    return 1;
	} else {
	    char *beginperiode = new char[11];
	    beginperiode = getenv("WWW_beginperiode");
	    char *eindperiode = new char[11];
	    eindperiode = getenv("WWW_eindperiode");

	    if ((!strcmp(beginperiode, "")) || (!strcmp(eindperiode, ""))) {
		error = ("Periode was niet ingevuld.\0");
		printhtml("./error.html", error);
	    } else {
		char *header = new char[100];
		strcpy(header, "Rapport");
		printhtml("./header.html", header);
		report(beginperiode, eindperiode);
		printhtml("./tail.html", "");
		mysql_close(&mysql);
	    }
	}
	mysql_close(&mysql);
	return 0;
    }
}
