//-----------------------------------------------------------------------//
//                                                                       //
//   Project Media Group                  Helpdesk Registration System   //
//                                                                       //
//-----------------------------------------------------------------------//
//                                                                       //
//   Filename:  mkincident.cc          Date created:       24-04-99      //
//   Version:   2.7                    Last modification:  01-06-99      //
//   Author:    Versluis G.                                              //
//              Edens A.                                                 //
//                                                                       //
//   Purpose:   Create incident in database                              //
//   Inputs:    Incidentdata                                             //
//   Output:    Incidentdata is written in database                      //
//                                                                       //
//-----------------------------------------------------------------------//
//                                                                       //
//  This program is free software; you can redistribute it and/or modify //
//  it under the terms of the GNU General Public License as published by //
//  the Free Software Foundation; either version 2 of the License, or    //
//  (at your option) any later version.                                  //
//                                                                       //
//  This program is distributed in the hope that it will be useful,      //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of       //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        //
//  GNU General Public License for more details.                         //
//                                                                       //
//  You should have received a copy of the GNU General Public License    //
//  along with this program; if not, write to the Free Software          //
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            //
//                                                                       //
//-----------------------------------------------------------------------//
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <mysql/mysql.h>
#include <hrslib.cc>

int mkincident(char *aanmelder)
{
    char *query = new char[1500];
    char *klant = new char[26];
    char *toestelnr = new char[16];
    char *kamernr = new char[11];
    char *eigenaar = new char[12];
    char *prioriteit = new char[12];
    char *categorie = new char[21];
    char *software = new char[21];
    char *omschrijving = new char[256];
    char *status = new char[256];
    char *oplossing = new char[256];
    char *opgelost = new char[2];
    char *afgemeld = new char[2];
    char *inboekdatum = new char[11];
    char *afboekdatum = new char[11];

    klant = getenv("WWW_klant");
    if (!strcmp(klant, ""))
	return -1;
    toestelnr = getenv("WWW_toestelnr");
    if (!strcmp(toestelnr, ""))
	return -1;
    kamernr = getenv("WWW_kamernr");
    if (!strcmp(kamernr, ""))
	return -1;
    eigenaar = getenv("WWW_eigenaar");
    if (!strcmp(eigenaar, ""))
	return -1;
    prioriteit = getenv("WWW_prioriteit");
    if (!strcmp(prioriteit, ""))
	return -1;
    categorie = getenv("WWW_categorie");
    if (!strcmp(categorie, ""))
	return -1;
    software = getenv("WWW_software");
    if (!strcmp(software, ""))
	return -1;
    omschrijving = getenv("WWW_omschrijving");
    if (!strcmp(omschrijving, ""))
	return -1;
    status = getenv("WWW_status");
    if (!strcmp(status, ""))
	strcpy(status, "\0");
    oplossing = getenv("WWW_oplossing");
    if (!strcmp(oplossing, ""))
	strcpy(oplossing, "\0");
    opgelost = getenv("WWW_opgelost");
    afgemeld = getenv("WWW_afgemeld");

    getdate(inboekdatum);
    getdate(afboekdatum);

    strcpy(query, "INSERT INTO incidenten VALUES (LAST_INSERT_ID(),\"");	// incidentnr+1;

    strcat(query, aanmelder);	// Aanmelder (varchar[15])

    strcat(query, "\",\"");
    strcat(query, klant);	// Klant (varchar[25])

    strcat(query, "\",\"");
    strcat(query, toestelnr);	// Toestelnr (varchar[15])

    strcat(query, "\",\"");
    strcat(query, kamernr);	// Kamernr (varchar[10])

    strcat(query, "\",");
    strcat(query, eigenaar);	// Eigenaar (int[11])

    strcat(query, ",");
    strcat(query, prioriteit);	// Prioriteit (int[11])

    strcat(query, ",\"");
    strcat(query, categorie);	// Categorie (varchar[20])

    strcat(query, "\",\"");
    strcat(query, software);	// Software (varchar[20])

    strcat(query, "\",\"");
    strcat(query, omschrijving);	// Omschrijving (varchar[255])

    strcat(query, "\",\"");
    strcat(query, status);	// Status (varchar[255])

    strcat(query, "\",\"");
    strcat(query, oplossing);	// Oplossing (varchar[255])

    strcat(query, "\",\"");
    strcat(query, opgelost);	// Opgelost (char[1])

    strcat(query, "\",\"");
    strcat(query, afgemeld);	// Afgemeld (char[1])

    strcat(query, "\",\"");
    strcat(query, inboekdatum);	// Inboekdatum (varchar[10])

    strcat(query, "\",\"");
    strcat(query, afboekdatum);	// Afboekdatum (varchar[10])

    strcat(query, "\")");
    mysql_query(&mysql, query);
    return (0);
}
//---------------------------------------------------------------------//

int main(void)
{
    char *aanmelder = new char[16];
    if (!init())
	return -1;
    if (!checklogon(aanmelder)) {
	return -1;
    } else {
	if (mkincident(aanmelder)) {
	    char *error = new char[100];
	    error = ("Niet alle benodigde gegevens zijn ingevuld.\0");
	    printhtml("error.html", error);
	    mysql_close(&mysql);
	    return -1;
	}
    }
    mysql_close(&mysql);
    printhtml("./main-admins.html", "");
    return 0;
}
