
//-----------------------------------------------------------------------//
//                                                                       //
//   Project Media Group                  Helpdesk Registration System   //
//                                                                       //
//-----------------------------------------------------------------------//
//                                                                       //
//   Filename:  lstincident.cc         Date created:       24-05-99      //
//   Version:   2.5                    Last modification:  24-05-99      //
//   Author:    Versluis G.                                              //
//              Edens A.                                                 //
//                                                                       //
//   Purpose:   List incidents                                           //
//   Inputs:    Incidentdata that is filled in                           //
//   Output:    List of incidents that match the query                   //
//                                                                       //
//-----------------------------------------------------------------------//
//                                                                       //
//  This program is free software; you can redistribute it and/or modify //
//  it under the terms of the GNU General Public License as published by //
//  the Free Software Foundation; either version 2 of the License, or    //
//  (at your option) any later version.                                  //
//                                                                       //
//  This program is distributed in the hope that it will be useful,      //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of       //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        //
//  GNU General Public License for more details.                         //
//                                                                       //
//  You should have received a copy of the GNU General Public License    //
//  along with this program; if not, write to the Free Software          //
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            //
//                                                                       //
//-----------------------------------------------------------------------//
#include <stdio.h>		// printf fopen, fclose etc.
#include <stdlib.h>
#include <errno.h>
#include <crypt.h>
#include <mysql/mysql.h>
#include <hrslib.cc>

//static MYSQL mysql;
//static MYSQL_RES result;
//static MYSQL_ROW datarow;


int lsincident(void)
//  list incidents based on query
{
    char *query = new char[15000];

    char *incidentnr = new char[12];
    char *aanmelder = new char[16];
    char *klant = new char[26];
    char *toestelnr = new char[16];
    char *kamernr = new char[11];
    char *eigenaar = new char[12];
    char *prioriteit = new char[12];
    char *categorie = new char[21];
    char *software = new char[21];
    char *omschrijving = new char[256];
    char *afgemeld = new char[2];
    char *opgelost = new char[2];
    char *inboekdatum = new char[11];
    char *afboekdatum = new char[11];

    incidentnr = getenv("WWW_incidentnr");
    aanmelder = getenv("WWW_aanmelder");
    klant = getenv("WWW_klant");
    toestelnr = getenv("WWW_toestelnr");
    kamernr = getenv("WWW_kamernr");
    eigenaar = getenv("WWW_eigenaar");
    prioriteit = getenv("WWW_prioriteit");
    categorie = getenv("WWW_categorie");
    software = getenv("WWW_software");
    omschrijving = getenv("WWW_omschrijving");
    afgemeld = getenv("WWW_afgemeld");
    opgelost = getenv("WWW_opgelost");
    inboekdatum = getenv("WWW_inboekdatum");
    afboekdatum = getenv("WWW_afboekdatum");

    strcpy(query, "SELECT incidentnr, opgelost, afgemeld, prioriteit, inboekdatum, klant, eigenaar, categorie, omschrijving FROM incidenten WHERE incidentnr>=0");

    if (strcmp(incidentnr, "")) {
	strcat(query, " AND incidentnr=");
	strcat(query, incidentnr);
    }
    if (strcmp(aanmelder, "")) {
	strcat(query, " AND aanmelder=\"");
	strcat(query, aanmelder);
	strcat(query, "\"");
    }
    if (strcmp(klant, "")) {
	strcat(query, " AND klant=\"");
	strcat(query, klant);
	strcat(query, "\"");
    }
    if (strcmp(toestelnr, "")) {
	strcat(query, " AND toestelnr=\"");
	strcat(query, toestelnr);
	strcat(query, "\"");
    }
    if (strcmp(kamernr, "")) {
	strcat(query, " AND kamernr=\"");
	strcat(query, kamernr);
	strcat(query, "\"");
    }
    if (strcmp(eigenaar, "")) {
	strcat(query, " AND eigenaar=");
	strcat(query, eigenaar);
    }
    if (prioriteit) {
	strcat(query, " AND prioriteit=");
	strcat(query, prioriteit);
    }
    if (strcmp(categorie, "")) {
	strcat(query, " AND categorie=\"");
	strcat(query, categorie);
	strcat(query, "\"");
    }
    if (strcmp(software, "")) {
	strcat(query, " AND software=\"");
	strcat(query, software);
	strcat(query, "\"");
    }
    if (strcmp(omschrijving, "")) {
	strcat(query, " AND omschrijving=\"");
	strcat(query, omschrijving);
	strcat(query, "\"");
    }
    if (opgelost) {
	strcat(query, " AND opgelost=\"");
	strcat(query, opgelost);
	strcat(query, "\"");
    }
    if (afgemeld) {
	strcat(query, " AND afgemeld=\"");
	strcat(query, afgemeld);
	strcat(query, "\"");
    }
    if (strcmp(inboekdatum, "")) {
	strcat(query, " AND inboekdatum=\"");
	strcat(query, inboekdatum);
	strcat(query, "\"");
    }
    if (strcmp(afboekdatum, "")) {
	strcat(query, " AND afboekdatum=\"");
	strcat(query, afboekdatum);
	strcat(query, "\"");
    }
    char *header = new char[100];
    header = "Lijst incidenten\0";
    printhtml("header.html", header);

    result = doquery(query);
    printf("Aantal incidenten gevonden: %d<br>\n<br>\n<br>\n", mysql_num_rows(&result));
    printf("<form method=POST action=\"/cgi-bin/uncgi/getincident.cgi\">");
    printf("<table bgcolor=\"#C0C0C0\" border=0 cellspacing=0 cellpadding=5>\n");
    printf("<tr bgcolor=\"000080\"><td><strong><font color=\"#FFFFFF\">Openen<td><strong><font color=\"#FFFFFF\">incidentnr<td><strong><font color=\"#FFFFFF\">opgelost<td><strong><font color=\"#FFFFFF\">afgemeld<td><strong><font color=\"#FFFFFF\">prioriteit<td><strong><font color=\"#FFFFFF\">inboekdatum<td><strong><font color=\"#FFFFFF\">klant<td><strong><font color=\"#FFFFFF\">eigenaar<td><strong><font color=\"#FFFFFF\">categorie<td><strong><font color=\"#FFFFFF\">omschrijving</strong></tr>");
    while (datarow = mysql_fetch_row(&result)) {
	printf("<tr valign=top><td><input type=\"radio\" value=\"%s\" name=\"incidentnr\"><td>%s<td>%s<td>%s<td>%s<td>%s<td>%s<td>%s<td>%s<td>%s</tr>\n", datarow[0], datarow[0], datarow[1], datarow[2], datarow[3], datarow[4], datarow[5], datarow[6], datarow[7], datarow[8]);
    }
    printf("<tr><td colspan=10><input type=submit name=\"functie\" value=\"Wijzigen\"><input type=submit name=\"functie\" value=\"Verwijderen\"></tr>");
    printf("</table></form>\n");
    printhtml("tail.html", "");
    return (0);
}


int main(void)
{
    if (!init())
	return -1;

    char *username = new char[16];
    if (checklogon(username)) {
	if (lsincident()) {
	    char *error = new char[100];
	    error = ("Niet alle benodigde gegevens zijn ingevuld.\0");
	    printhtml("error.html", error);
	}
    }
    mysql_close(&mysql);
    return 0;
}
