
//-----------------------------------------------------------------------//
//                                                                       //
//   Project Media Group                  Helpdesk Registration System   //
//                                                                       //
//-----------------------------------------------------------------------//
//                                                                       //
//   Filename:  getincident.cc         Date created:       24-05-99      //
//   Version:   2.7                    Last modification:  07-06-99      //
//   Author:    Versluis G.                                              //
//              Edens A.                                                 //
//                                                                       //
//   Purpose:   Get incident from database                               //
//   Inputs:    Incidentnr                                               //
//   Output:    Incidentdata                                             //
//                                                                       //
//-----------------------------------------------------------------------//
//                                                                       //
//  This program is free software; you can redistribute it and/or modify //
//  it under the terms of the GNU General Public License as published by //
//  the Free Software Foundation; either version 2 of the License, or    //
//  (at your option) any later version.                                  //
//                                                                       //
//  This program is distributed in the hope that it will be useful,      //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of       //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        //
//  GNU General Public License for more details.                         //
//                                                                       //
//  You should have received a copy of the GNU General Public License    //
//  along with this program; if not, write to the Free Software          //
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            //
//                                                                       //
//-----------------------------------------------------------------------//
#include <stdio.h>		// printf fopen, fclose etc.
#include <stdlib.h>
#include <errno.h>
#include <mysql/mysql.h>
#include <hrslib.cc>


int getincident(char *incidentnr)
{
    char *query = new char[1500];

    strcpy(query, "SELECT incidentnr, aanmelder, klant, toestelnr, kamernr, eigenaar, prioriteit, categorie, software, omschrijving, status, oplossing, opgelost, inboekdatum, afboekdatum FROM incidenten WHERE incidentnr=");
    strcat(query, incidentnr);
    result = doquery(query);
    datarow = mysql_fetch_row(&result);

    printf("<form method=POST action=\"/cgi-bin/uncgi/chincident.cgi\"><table width=100%% bgcolor=\"C0C0C0\" border=0 cellspacing=0 cellpadding=5>\n");
    printf("<tr><td width=\"15%%\" valign=\"top\" nowrap checked=\"false\"><strong>Incidentnummer</strong></td>
<td width=\"35%\"><input type=hidden name=\"incidentnr\" value=\"%s\">%s</td>
", datarow[0], datarow[0]);
    printf("<td width=\"15%%\" valign=\"top\" nowrap><strong>Eigenaar incident</strong></td><td width=\"35%%\">%s</td>
</tr>
", datarow[5]);
    printf("<tr>
<td width=\"15%%\" valign=\"top\" nowrap><strong>Klant</strong></td><td width=\"35%%\"><input type=\"text\" name=\"klant\" size=\"20\" value=\"%s\"></td>
", datarow[2]);
    printf("<td width=\"15%%\" valign=\"top\" nowrap><strong>Prioriteit</strong></td><td width=\"35%%\"><input type=\"radio\" value=\"1\" name=\"prioriteit\">Hoog&nbsp; <input type=\"radio\" name=\"prioriteit\" value=\"2\" checked>Normaal&nbsp; <input type=\"radio\"
 name=\"prioriteit\" value=\"3\">Laag</td>
</tr>");
    printf("<tr><td width=\"15%\" valign=\"top\" nowrap><strong>Toestelnummer</strong></td>
<td width=\"35%%\"><input type=\"text\" name=\"toestelnr\" value=\"%s\"size=\"20\"></td>
", datarow[3]);
    printf("<td width=\"15%%\" valign=\"top\" nowrap><strong>Opgelost</strong></td>
<td width=\"35%%\"><input type=\"radio\" name=\"opgelost\" value=\"j\">Ja <input type=\"radio\"
 name=\"opgelost\" value=\"n\" checked>Nee</td></tr>
");
    printf("<tr>
<td width=\"15%%\" valign=\"top\" nowrap><strong>Kamernummer</strong></td>
<td width=\"35%%\"><input type=\"text\" name=\"kamernr\" size=\"20\" value=\"%s\"></td>
", datarow[4]);
    printf("<td width=\"15%%\" valign=\"top\" nowrap><strong>Afgemeld</strong></td>
<td width=\"35%%\"><input type=\"radio\" name=\"afgemeld\" value=\"j\">Ja <input type=\"radio\"
 name=\"afgemeld\" value=\"n\" checked>Nee</td>
</tr>
");
    printf("<tr><td width=\"15%%\" valign=\"top\" nowrap><strong>Categorie</strong></td><td width=\"35%%\"><select name=\"categorie\" size=\"1\">
<option value=\"%s\">%s</option><option value=\"Overig\"></option><option value=\"Software\">Software</option>
<option value=\"Hardware\">Hardware</option>
<option value=\"Netwerk\">Netwerk</option>
<option value=\"Overig\">Overig</option></select></td>
", datarow[7], datarow[7]);
    printf("<td width=\"15%%\" valign=\"top\" nowrap><strong>Inboekdatum</strong></td>
<td width=\"35%%\">%s</td>
</tr>
", datarow[13]);
    printf("<tr><td width=\"15%%\" valign=\"top\" nowrap><strong>Software</strong></td>
<td width=\"35%%\"><input type=\"text\" name=\"software\" size=\"20\" value=\"%s\"></td>
", datarow[8]);
    printf("<td width=\"15%%\" valign=\"top\" nowrap><strong>Laatste wijziging</strong></td>
<td width=\"35%\">%s</td>
</tr>
", datarow[14]);
    printf("<tr>
<td width=\"15%%\" valign=\"top\" nowrap><strong>Omschrijving</strong></td>
<td width=\"100%%\" colspan=\"3\"><textarea rows=\"4\" name=\"omschrijving\" cols=\"63\">%s</textarea></td>
</tr>
", datarow[9]);
    printf("<tr>
<td width=\"15%%\" valign=\"top\" nowrap><strong>Status</strong></td>
<td width=\"100%%\" colspan=\"3\"><textarea rows=\"4\" name=\"status\" cols=\"63\">%s</textarea></td>
</tr>
", datarow[10]);
    printf("<tr>
<td width=\"15%%\" valign=\"top\" nowrap><strong>Omschrijving</strong></td>
<td width=\"100%%\" colspan=\"3\"><textarea rows=\"4\" name=\"oplossing\" cols=\"63\">%s</textarea></td>
</tr>
", datarow[11]);
    printf("<tr><td colspan=4><input type=submit name=\"bOK\" value=\"Opslaan\"><input type=reset value=\"Herstel\">");
    printf("</table></form>");
}

void rmincident(char *incidentnr)
{
    char *query = new char[1500];
    strcpy(query, "DELETE FROM incidenten WHERE incidentnr=");
    strcat(query, incidentnr);
    mysql_query(&mysql, query);
    strcpy(query, "delete from problemen where incidentnr=");
    strcat(query, incidentnr);
    mysql_query(&mysql, query);
}


int main(void)
{
    char *username = new char[16];
    char *functie = new char[10];
    if (!init())
	return 1;
    char *error = new char[100];
    functie = getenv("WWW_functie");
    if (!strcmp(functie, "Wijzigen")) {
	if (!checklogon(username)) {
	    return 1;
	} else {
	    char *incidentnr = new char[12];
	    incidentnr = getenv("WWW_incidentnr");
	    if (!incidentnr) {
		error = ("Incidentnr. is onbekend.\0");
		printhtml("error.html", error);
	    } else {
		char *header = new char[100];
		printhtml("header.html", "Wijzigen incident");
		getincident(incidentnr);
		printhtml("tail.html", "");
		mysql_close(&mysql);
	    }
	    mysql_close(&mysql);
	    return 0;
	}
    } else {
	if (!checkadmin(username)) {
	    return -1;
	} else {
	    char *incidentnr = new char[12];
	    incidentnr = getenv("WWW_incidentnr");
	    rmincident(incidentnr);
	    printhtml("header.html", "Incident verwijderd");
	    printf("Het incident is verwijderd");
	    printhtml("tail.html", "");
	}
    }

}
