/*
e2s copyright (c) 2009-always Jan Panteltje

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "e2s.h"



int get_time(char *tmp)
{
time_t now;
struct tm *log_time;

if(! tmp) return 0;

now = time(0);

if(use_universal_time_flag)
	{
	log_time = gmtime(&now);
	}
else
	{
	log_time = localtime(&now);
	}

strftime(tmp, 511, "%a, %d %b %Y %H:%M:%S", log_time);

return 1;
} /* end function get_time */



int make_socket(unsigned short int port, int *sock)
{
struct sockaddr_in name;
     
/* Create the TCP socket. */
*sock = socket(PF_INET, SOCK_STREAM, 0);
if(*sock < 0)
	{
	fprintf(stderr, "e2s: make_socket(): sock() failed for port %d because ", port);
	perror ("");
	
	return 0;
	}
     
/* Give the socket a name. */
name.sin_family = AF_INET;
name.sin_port = htons (port);
name.sin_addr.s_addr = htonl (INADDR_ANY);
if(bind(*sock, (struct sockaddr *) &name, sizeof (name)) < 0)
	{
	fprintf(stderr, "e2s: make_socket(): bind() failed for port %d socket %d because ", port, *sock); 
	perror ("");

	return 0;
	}

return 1;
} /* end function make_socket */



void *internet_routine(int serial_fd)
{
int a, b, i, j;
int sock;
int current_sock = -1; // -Wall
fd_set active_fd_set, read_fd_set;
struct sockaddr_in clientname;
size_t size;
int new;
int bytes_read;
char inbuffer[INTERNET_BUFFER_SIZE];
int total_frames_send;
time_t start_time, elapsed_time;
float frames_per_second;
unsigned long total_bytes_send;
int clients;
struct timeval timeout;
int message_number;
int said_no_clients_flag;
int confirm_msg_send_flag;
char temp[INTERNET_BUFFER_SIZE];

if(debug_flag)
	{
	fprintf(stderr, "e2s: internet_routine(): arg serial_fd=%d, using internet_port=%d\n", serial_fd, internet_port);
	}

/* Create the socket and set it up to accept connections. */
if(! make_socket(internet_port, &sock) )
	{
	return 0;
	}

if (listen (sock, MAX_LISTEN_QUEUE) < 0)
	{
	fprintf(stderr, "e2s: internet_routine(): listen() failed for socket %d because \n", sock);
	perror ("");
	return 0;
	}
     
/* Initialize the set of active sockets. */
FD_ZERO (&active_fd_set);
FD_SET (sock, &active_fd_set);

/* listen to user for commands */
//FD_SET(fileno(stdin), &active_fd_set);     

/* listen to serial port */
FD_SET(serial_fd, &active_fd_set);     

/* report */
get_time(temp);
fprintf(stderr, "e2s: %s listening for connections on port %d.\n", temp, internet_port);

/* test for connections and user action */
message_number = 0;
confirm_msg_send_flag = 0;
said_no_clients_flag = 0;
start_time = time(0);
elapsed_time = 0;
total_frames_send = 0;
total_bytes_send = 0;
clients = 0;
frames_per_second = 0;
/* set for empty transmit text */
while (1)
	{
	/* Block until input arrives on one or more active sockets. */
	read_fd_set = active_fd_set;

	timeout.tv_sec = 1;
	timeout.tv_usec = 0;
	a = select (FD_SETSIZE, &read_fd_set, NULL, NULL, &timeout);
	if(a < 0)
		{
		perror ("select");
		return 0;
		}
	if(a == 0)/* timeout */     
		{
		/* fprintf(stderr, "e2s: internet_routine(): server timeout\n");	*/
		/* basically we could return here and / or do something else */
		if(clients == 0)
			{
			if(! said_no_clients_flag)
				{
				get_time(temp);
				fprintf(stderr, "e2s: %s no clients.\n", temp);
				said_no_clients_flag = 1;
				}
			}
		else
			{
			said_no_clients_flag = 0;
			}
		continue;
		}

	/* Service all the sockets with input pending. */
	for (i = 0; i < FD_SETSIZE; ++i)
		{
		if (FD_ISSET (i, &read_fd_set) )
			{
			if(i == serial_fd)
				{
				a = read (i, temp, INTERNET_BUFFER_SIZE);
				if(a == -1)
					{
					fprintf(stderr, "e2s: internet_routine(): read() failed for serial_fd %d, because ", serial_fd);
					perror("");
								
					if(errno == EAGAIN) continue;
					if(errno == EINTR) continue;
					
					return 0;						
					}

				if(debug_flag)
					{
					fprintf(stderr, "e2s: internet_routine(): read from serial device %d bytes, temp=\n", a);
					for(j = 0; j < a; j++)
						{
						fprintf(stderr, "%02x %c\n", temp[j] & 0xff, temp[j] & 0xff);
						}
					}
					
				/* send to socket */
				if(current_sock != -1)
					{
//					int sendto (int SOCKET, void *BUFFER. size_t SIZE, int FLAGS, struct sockaddr *ADDR, socklen_t LENGTH)
					b = sendto(current_sock, temp, a, 0, (struct sockaddr *)&clientname, sizeof(struct sockaddr) );
					if(b == -1)
						{
						fprintf(stderr, "e2s: internet_routine(): sendto(): failed for socket %d, because ", current_sock);
						perror("");
								
						if(errno == EAGAIN) continue;
						if(errno == EINTR) continue;
					
						return 0;						
						}

					if(b != a)
						{
						fprintf(stderr, "e2s: internet_routine(): sendto() could only write %d of %d bytes to socket %d\n", b, a, current_sock);
						}
					} /* end if current_sock != -1 */

				continue;
 				}/* end if something on serial_fd */

			if (i == sock) /* Connection request on original socket. */
				{
				size = sizeof (clientname);
				new = accept (sock, (struct sockaddr *) &clientname, &size);
				if (new < 0)
					{
					fprintf(stderr, "e2s: internet_routine(): accept() failed because "); 
					perror ("accept");

					return 0;
					}

				/* report connect */
				get_time(temp);
				fprintf (stderr, "e2s: %s connect from host %s.\n", temp, inet_ntoa (clientname.sin_addr) ); /* this gives incorrect port why?	ntohs (clientname.sin_port)); */

				FD_SET (new, &active_fd_set);

				/* one client more */
				clients++;
				}
			else /* Data arriving on an already-connected socket. */
				{
				current_sock = i;
				errno = 0;
				bytes_read = read (i, inbuffer, INTERNET_BUFFER_SIZE);
				if(bytes_read < 0) /* read error */
					{
					perror ("read");
					if(errno == EAGAIN) continue;
					if(errno == EINTR) continue;

					/* drop this connection */
					FD_CLR (i, &active_fd_set);

					close(i);

					/* one client less */
					if(clients > 0) clients--;

					/* prevent trying to write to a no longer valid socket */
					current_sock = -1;
				
					/* try next socket */
					continue;
					return 0;
					}
				else if (bytes_read == 0) /* EOF */
					{
					FD_CLR (i, &active_fd_set);

					close (i);

					/* one client less */
					if(clients > 0) clients--;

					/* prevent trying to write to a no longer valid socket */
					current_sock = -1;
				
					/* try next socket */
					continue;
					}

				if(debug_flag)
					{
					fprintf(stderr, "e2s: internet_routine(): read from socket %d bytes, inbuffer=\n", bytes_read);
					for(j = 0; j < bytes_read; j++)
						{
						fprintf(stderr, "%02x %c\n", inbuffer[j] & 0xff, inbuffer[j] & 0xff);
						}
					}

				/* send to serial port */

//				ssize_t write(int fd, const void *buf, size_t count);
				b = write(serial_fd, inbuffer, bytes_read);
				if(b == -1)
					{
					fprintf(stderr, "e2s: internet_routine(): write() to serial_fd %d failed because ", serial_fd);
					perror("");
					
					if(errno == EAGAIN) continue;
					if(errno == EINTR) continue;

					return 0;
					}

				if(b != bytes_read)
					{
					fprintf(stderr, "e2s: internet_routine(): could only write %d bytes of %d to serial_fd %d\n", b, bytes_read, serial_fd);
					}

				}/* end if existing connection */
			}/* end if FD_ISSET */
		}/* end for server all connections */
	}/* end while wait for select */

/* never here */
return 0;
} /* end function internet_routine */


