#include "deftags.h"

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>

char FGETC(FILE *f);
int  FEOF(FILE *f);

static int MAXL_CPRINTF=0;
int GENFINDINFO=0;

void trim(char *s) {
int i,n,k;
  for(i=strlen(s)-1;i>0 && s[i]==' ';i--) { s[i]='\0'; }
  for(i=0,n=strlen(s);i<n && s[i]==' ';i++);
  for(k=i,i=0;k<=n;k++,i++) { s[i]=s[k]; }
}

void strup(char *s) {
  while(s[0]!='\0') { s[0]=toupper(s[0]);s+=1; }
}

char read_tag(char *tag_def,FILE *F,char plus,char colon,char seg_end,char lit,int uc,int at,int atm);

/* directories to include */

#include "881.c"
#include "902.c"
#include "911.c"
#include "912.c"
#include "921.c"
#include "932.c"
#include "D.93A.c"
#include "S.93A.c"
#include "D.94A.c"
#include "D.94B.c"
#include "D.95A.c"
#include "D.95B.c"
#include "D.96A.c"
#include "D.96B.c"
#include "I.96B.c"
#include "D.97A.c"
#include "I.97A.c" 
#include "D.97B.c"
#include "I.97B.c"
#include "D.98A.c"
#include "I.98A.c"
#include "D.98B.c"
#include "I.98B.c"
#include "D.99A.c"
#include "I.99A.c"

#define D000    -2
#define D881    -1
#define D902    0
#define D911	1
#define D912	2
#define D921	3
#define D932	4
#define DD_93A	5
#define DD_94A	6
#define DD_94B	7
#define DD_95A	8
#define DD_95B	9
#define DD_96A	10
#define DD_96B	11
#define DD_97A	12
#define DD_97B	13
#define DD_98A	14
#define DD_98B	15
#define DD_99A	16
#define DD_99B	17

void dirinfo(void)
{
  fprintf(stderr,"<enter> to continue...");
  getchar();
  fprintf(stderr,"supported directories:\n");
  fprintf(stderr,"%-8s",info881());
  fprintf(stderr,"%-8s\n",info902());
  fprintf(stderr,"%-8s",info911());
  fprintf(stderr,"%-8s",info912());
  fprintf(stderr,"%-8s",info921());
  fprintf(stderr,"%-8s",info932());
  fprintf(stderr,"%-8s",infoD_93A());
  fprintf(stderr,"%-8s\n",infoS_93A());
  fprintf(stderr,"%-8s",infoD_94A());
  fprintf(stderr,"%-8s",infoD_94B());
  fprintf(stderr,"%-8s",infoD_95A());
  fprintf(stderr,"%-8s",infoD_95B());
  fprintf(stderr,"%-8s",infoD_96A());
  fprintf(stderr,"%-8s",infoD_96B());
  fprintf(stderr,"%-8s\n",infoI_96B());
  fprintf(stderr,"%-8s",infoD_97A());
  fprintf(stderr,"%-8s",infoI_97A());
  fprintf(stderr,"%-8s",infoD_97B());
  fprintf(stderr,"%-8s\n",infoI_97B());
  fprintf(stderr,"%-8s",infoD_98A());
  fprintf(stderr,"%-8s",infoI_98A());
  fprintf(stderr,"%-8s",infoD_98B());
  fprintf(stderr,"%-8s\n",infoI_98B());
  fprintf(stderr,"%-8s",infoD_99A());
  fprintf(stderr,"%-8s",infoI_99A());
  fprintf(stderr,"\n");
}

static char DIREC[25],PREVDIREC[25],MSTYPEVER[25],PREVMSTYPEVER[25]; 
static int  _DIREC;
static int  MESSNO=0,LINENO=1;
static int  inUNH=0; 


void findDirec(char *direc)
{
       if (strcmp(direc,"882")==0) { _DIREC=D881; }
  else if (strcmp(direc,"902")==0) { _DIREC=D902; }
  else if (strcmp(direc,"911")==0) { _DIREC=D911; }
  else if (strcmp(direc,"912")==0) { _DIREC=D912; }
  else if (strcmp(direc,"921")==0) { _DIREC=D921; }
  else if (strcmp(direc,"932")==0) { _DIREC=D932; }
  else if (strcmp(direc,"93A")==0) { _DIREC=DD_93A; }
  else if (strcmp(direc,"94A")==0) { _DIREC=DD_94A; }
  else if (strcmp(direc,"94B")==0) { _DIREC=DD_94B; }
  else if (strcmp(direc,"95A")==0) { _DIREC=DD_95A; }
  else if (strcmp(direc,"95B")==0) { _DIREC=DD_95B; }
  else if (strcmp(direc,"96A")==0) { _DIREC=DD_96A; }
  else if (strcmp(direc,"96B")==0) { _DIREC=DD_96B; }
  else if (strcmp(direc,"97A")==0) { _DIREC=DD_97A; }
  else if (strcmp(direc,"97B")==0) { _DIREC=DD_97B; }
  else if (strcmp(direc,"98A")==0) { _DIREC=DD_98A; }
  else if (strcmp(direc,"98B")==0) { _DIREC=DD_98B; }
  else if (strcmp(direc,"99A")==0) { _DIREC=DD_99A; }
  else { _DIREC=D000; 
    fprintf(stderr,"Warning: I don't know of directory '%s'\n",direc); 
  }
}

int findTheDIREC(char *direc)
{
char Direc[25];
  strncpy(Direc,direc,24);
  Direc[24]='\0';
  trim(Direc);
  strup(Direc);

       if (strcmp(Direc,info881())==0) { strcpy(DIREC,"881"); }
  else if (strcmp(Direc,info902())==0) { strcpy(DIREC,"902"); }
  else if (strcmp(Direc,info911())==0) { strcpy(DIREC,"911"); }
  else if (strcmp(Direc,info912())==0) { strcpy(DIREC,"912"); }
  else if (strcmp(Direc,info921())==0) { strcpy(DIREC,"921"); }
  else if (strcmp(Direc,info932())==0) { strcpy(DIREC,"932"); }
  else if (strcmp(Direc,infoD_93A())==0) { strcpy(DIREC,"93A"); }
  else if (strcmp(Direc,infoS_93A())==0) { strcpy(MSTYPEVER,"S");
					   strcpy(DIREC,"93A"); 
					 }
  else if (strcmp(Direc,infoD_94A())==0) { strcpy(DIREC,"94A"); }
  else if (strcmp(Direc,infoD_94B())==0) { strcpy(DIREC,"94B"); }
  else if (strcmp(Direc,infoD_95A())==0) { strcpy(DIREC,"95A"); }
  else if (strcmp(Direc,infoD_95B())==0) { strcpy(DIREC,"95B"); }
  else if (strcmp(Direc,infoD_96A())==0) { strcpy(DIREC,"96A"); }
  else if (strcmp(Direc,infoD_96B())==0) { strcpy(DIREC,"96B"); }
  else if (strcmp(Direc,infoD_97A())==0) { strcpy(DIREC,"97A"); }
  else if (strcmp(Direc,infoD_97B())==0) { strcpy(DIREC,"97B"); }
  else if (strcmp(Direc,infoD_98A())==0) { strcpy(DIREC,"98A"); }
  else if (strcmp(Direc,infoD_98B())==0) { strcpy(DIREC,"98B"); }
  else if (strcmp(Direc,infoD_99A())==0) { strcpy(DIREC,"99A"); }
  else {
    if (Direc[0]=='I') {
     Direc[0]='D';
     fprintf(stderr,"You specified an interactive directory to be used\n"
	     "Use the -I option to make use of interactive directories\n"
	     "For now I'll assume '%s' and try again\n",Direc);
     return findTheDIREC(Direc);
    }
    else {
      return 0;
    }
  }

  findDirec(DIREC);

return 1;
}

/* and handle them in read_tag */

static int INTERACTIVE;

#define ITAGF(c,dc1,dc2,ic1,ic2)  \
 case c: if (INTERACTIVE) { \
	  dirfound=dc1(TAG,tag,F,plus,colon,seg_end,lit,uc,at,atm); \
         } \
	 else { \
	  dirfound=0; \
         } \
	 if (!dirfound) { \
	  dirfound=dc2(TAG,tag,F,plus,colon,seg_end,lit,uc,at,atm); \
	 } \
	 if (!dirfound) { int D=_DIREC; \
	   _DIREC-=1; \
	  if (GENFINDINFO) fprintf(stderr,"'%s' not found in %s, searching %s\n", \
			 tag,ic1(),ic2()); \
	   ifthenelse(tag,F,plus,colon,seg_end,lit,uc,at,atm); \
	   _DIREC=D; \
	   return; \
	 } \
    break;

void ifthenelse(char *tag,FILE *F,char plus,char colon,char seg_end,char lit,int uc,int at,int atm)
{ register unsigned short t1,t2,t3;
  int      dirfound;
  t1=toupper(tag[0]);t2=toupper(tag[1]);t3=toupper(tag[2]);
 if (t1>='A' && t1<='Z' && t2>='A' && t2<='Z' && t3>='A' && t3<='Z') {
 register unsigned short TAG;
  TAG=t1-'A'+((((t3-'A')<<5)+t2-'A')<<5);

  /* Code for directory selection */

  switch(_DIREC) {
    case D881: dirfound=dir881(TAG,tag,F,plus,colon,seg_end,lit,uc,at,atm);
    break;
    case D902: dirfound=dir902(TAG,tag,F,plus,colon,seg_end,lit,uc,at,atm);
	       if (!dirfound) { int D=_DIREC;
		  _DIREC-=1;
		  if (GENFINDINFO) fprintf(stderr,"'%s' not found in %s, searching %s\n",
				 tag,info902(),info881());
		  ifthenelse(tag,F,plus,colon,seg_end,lit,uc,at,atm);
		  _DIREC=D;
		  return;
	       }
    break;
    case D911: dirfound=dir911(TAG,tag,F,plus,colon,seg_end,lit,uc,at,atm);
	       if (!dirfound) { int D=_DIREC;
		  _DIREC-=1;
		  if (GENFINDINFO) fprintf(stderr,"'%s' not found in %s, searching %s\n",
				 tag,info911(),info902());
		  ifthenelse(tag,F,plus,colon,seg_end,lit,uc,at,atm);
		  _DIREC=D;
		  return;
	       }
    break;
    case D912: dirfound=dir912(TAG,tag,F,plus,colon,seg_end,lit,uc,at,atm);
	       if (!dirfound) { int D=_DIREC;
		  _DIREC-=1;
		  if (GENFINDINFO) fprintf(stderr,"'%s' not found in %s, searching %s\n",
				 tag,info912(),info911());
		  ifthenelse(tag,F,plus,colon,seg_end,lit,uc,at,atm);
		  _DIREC=D;
		  return;
	       }
    break;
    case D921: dirfound=dir921(TAG,tag,F,plus,colon,seg_end,lit,uc,at,atm);
	       if (!dirfound) { int D=_DIREC;
		  _DIREC-=1;
		  if (GENFINDINFO) fprintf(stderr,"'%s' not found in %s, searching %s\n",
				 tag,info921(),info912());
		  ifthenelse(tag,F,plus,colon,seg_end,lit,uc,at,atm);
		  _DIREC=D;
		  return;
	       }
    break;
    case D932: dirfound=dir932(TAG,tag,F,plus,colon,seg_end,lit,uc,at,atm);
	       if (!dirfound) { int D=_DIREC;
		  _DIREC-=1;
		  if (GENFINDINFO) fprintf(stderr,"'%s' not found in %s, searching %s\n",
				 tag,info932(),info921());
		  ifthenelse(tag,F,plus,colon,seg_end,lit,uc,at,atm);
		  _DIREC=D;
		  return;
	       }
    break;
    case DD_93A: if (strcmp(MSTYPEVER,"S")==0) {
                  dirfound=dirS_93A(TAG,tag,F,plus,colon,seg_end,lit,uc,at,atm);
                 } else {
                  dirfound=dirD_93A(TAG,tag,F,plus,colon,seg_end,lit,uc,at,atm);
                 }
	         if (!dirfound) { int D=_DIREC;
		    _DIREC-=1;
		    if (GENFINDINFO) fprintf(stderr,"'%s' not found in %s, searching %s\n",
				   tag,infoD_93A(),info932());
		    ifthenelse(tag,F,plus,colon,seg_end,lit,uc,at,atm);
		    _DIREC=D;
		    return;
	         }
    break;
    case DD_94A: dirfound=dirD_94A(TAG,tag,F,plus,colon,seg_end,lit,uc,at,atm);
	         if (!dirfound) { int D=_DIREC;
		    _DIREC-=1;
		    if (GENFINDINFO) fprintf(stderr,"'%s' not found in %s, searching %s\n",
				   tag,infoD_94A(),infoD_93A());
		    ifthenelse(tag,F,plus,colon,seg_end,lit,uc,at,atm);
		    _DIREC=D;
		    return;
	         }
    break;
    case DD_94B: dirfound=dirD_94B(TAG,tag,F,plus,colon,seg_end,lit,uc,at,atm);
	         if (!dirfound) { int D=_DIREC;
		    _DIREC-=1;
		    if (GENFINDINFO) fprintf(stderr,"'%s' not found in %s, searching %s\n",
				   tag,infoD_94B(),infoD_94A());
		    ifthenelse(tag,F,plus,colon,seg_end,lit,uc,at,atm);
		    _DIREC=D;
		    return;
	         }
    break;
    case DD_95A: dirfound=dirD_95A(TAG,tag,F,plus,colon,seg_end,lit,uc,at,atm);
	         if (!dirfound) { int D=_DIREC;
		    _DIREC-=1;
		    if (GENFINDINFO) fprintf(stderr,"'%s' not found in %s, searching %s\n",
				   tag,infoD_95A(),infoD_94B());
		    ifthenelse(tag,F,plus,colon,seg_end,lit,uc,at,atm);
		    _DIREC=D;
		    return;
	         }
    break;
    case DD_95B: dirfound=dirD_95B(TAG,tag,F,plus,colon,seg_end,lit,uc,at,atm);
	         if (!dirfound) { int D=_DIREC;
		    _DIREC-=1;
		    if (GENFINDINFO) fprintf(stderr,"'%s' not found in %s, searching %s\n",
				   tag,infoD_95B(),infoD_95A());
		    ifthenelse(tag,F,plus,colon,seg_end,lit,uc,at,atm);
		    _DIREC=D;
		    return;
	         }
    break;
    case DD_96A: dirfound=dirD_96A(TAG,tag,F,plus,colon,seg_end,lit,uc,at,atm);
	         if (!dirfound) { int D=_DIREC;
		    _DIREC-=1;
		    if (GENFINDINFO) fprintf(stderr,"'%s' not found in %s, searching %s\n",
				   tag,infoD_96A(),infoD_95B());
		    ifthenelse(tag,F,plus,colon,seg_end,lit,uc,at,atm);
		    _DIREC=D;
		    return;
	         }
    break;
    ITAGF(DD_96B,dirI_96B,dirD_96B,infoD_96B,infoD_96A)
    ITAGF(DD_97A,dirI_97A,dirD_97A,infoD_97A,infoD_96B)
    ITAGF(DD_97B,dirI_97B,dirD_97B,infoD_97B,infoD_97A)
    ITAGF(DD_98A,dirI_98A,dirD_98A,infoD_98A,infoD_97B)
    ITAGF(DD_98B,dirI_98B,dirD_98B,infoD_98B,infoD_98A)
    ITAGF(DD_99A,dirI_99A,dirD_99A,infoD_99A,infoD_98B)
    default:	dirfound=-1;
    break;
  }

  if (!dirfound || dirfound==-1) {
    if (!dirfound && 
	strncmp(tag,"UC",2)!=0 &&
	strncmp(tag,"US",2)!=0 &&
	strncmp(tag,"UN",2)!=0) {
          if (GENFINDINFO) fprintf(stderr,"Warning: tag %s not found in directory %s at line %d (using default)\n",tag,DIREC,LINENO);
    }

  switch(TAG) {
  case 17504 :
    tag[2]=read_tag(TAG_ADR,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 17600 :
    tag[2]=read_tag(TAG_AGR,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 19744 :
    tag[2]=read_tag(TAG_AJT,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 2400 :
    tag[2]=read_tag(TAG_ALC,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 8544 :
    tag[2]=read_tag(TAG_ALI,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 17888 :
    tag[2]=read_tag(TAG_APR,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 3616 :
    tag[2]=read_tag(TAG_ARD,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 17952 :
    tag[2]=read_tag(TAG_ARR,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 8768 :
    tag[2]=read_tag(TAG_ASI,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 20064 :
    tag[2]=read_tag(TAG_ATT,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 20096 :
    tag[2]=read_tag(TAG_AUT,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 12481 :
    tag[2]=read_tag(TAG_BGM,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 8449 :
    tag[2]=read_tag(TAG_BII,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 19073 :
    tag[2]=read_tag(TAG_BUS,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 21506 :
    tag[2]=read_tag(TAG_CAV,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 3138 :
    tag[2]=read_tag(TAG_CCD,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 8258 :
    tag[2]=read_tag(TAG_CCI,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 18530 :
    tag[2]=read_tag(TAG_CDS,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 21602 :
    tag[2]=read_tag(TAG_CDV,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 3202 :
    tag[2]=read_tag(TAG_CED,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 15746 :
    tag[2]=read_tag(TAG_CMP,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 8610 :
    tag[2]=read_tag(TAG_CNI,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 19874 :
    tag[2]=read_tag(TAG_CNT,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 3522 :
    tag[2]=read_tag(TAG_COD,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 12738 :
    tag[2]=read_tag(TAG_COM,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 19906 :
    tag[2]=read_tag(TAG_COT,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 8674 :
    tag[2]=read_tag(TAG_CPI,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 18914 :
    tag[2]=read_tag(TAG_CPS,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 20034 :
    tag[2]=read_tag(TAG_CST,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 610 :
    tag[2]=read_tag(TAG_CTA,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 24194 :
    tag[2]=read_tag(TAG_CUX,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 12291 :
    tag[2]=read_tag(TAG_DAM,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 18627 :
    tag[2]=read_tag(TAG_DGS,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 8451 :
    tag[2]=read_tag(TAG_DII,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 12547 :
    tag[2]=read_tag(TAG_DIM,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 8547 :
    tag[2]=read_tag(TAG_DLI,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 12643 :
    tag[2]=read_tag(TAG_DLM,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 18819 :
    tag[2]=read_tag(TAG_DMS,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 2499 :
    tag[2]=read_tag(TAG_DOC,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 8771 :
    tag[2]=read_tag(TAG_DSI,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 12899 :
    tag[2]=read_tag(TAG_DTM,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 8356 :
    tag[2]=read_tag(TAG_EFI,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 12644 :
    tag[2]=read_tag(TAG_ELM,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 20836 :
    tag[2]=read_tag(TAG_ELU,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 15748 :
    tag[2]=read_tag(TAG_EMP,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 516 :
    tag[2]=read_tag(TAG_EQA,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 3588 :
    tag[2]=read_tag(TAG_EQD,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 13828 :
    tag[2]=read_tag(TAG_EQN,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 2596 :
    tag[2]=read_tag(TAG_ERC,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 15908 :
    tag[2]=read_tag(TAG_ERP,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 69 :
    tag[2]=read_tag(TAG_FCA,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 8453 :
    tag[2]=read_tag(TAG_FII,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 18853 :
    tag[2]=read_tag(TAG_FNS,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 19877 :
    tag[2]=read_tag(TAG_FNT,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 24165 :
    tag[2]=read_tag(TAG_FTX,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 18534 :
    tag[2]=read_tag(TAG_GDS,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 3334 :
    tag[2]=read_tag(TAG_GID,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 13574 :
    tag[2]=read_tag(TAG_GIN,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 17670 :
    tag[2]=read_tag(TAG_GIR,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 18694 :
    tag[2]=read_tag(TAG_GIS,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 17862 :
    tag[2]=read_tag(TAG_GOR,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 21030 :
    tag[2]=read_tag(TAG_GRU,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 13319 :
    tag[2]=read_tag(TAG_HAN,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 3144 :
    tag[2]=read_tag(TAG_ICD,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 4200 :
    tag[2]=read_tag(TAG_IDE,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 2280 :
    tag[2]=read_tag(TAG_IHC,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 3464 :
    tag[2]=read_tag(TAG_IMD,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 3496 :
    tag[2]=read_tag(TAG_IND,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 15784 :
    tag[2]=read_tag(TAG_INP,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 21928 :
    tag[2]=read_tag(TAG_INV,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 16936 :
    tag[2]=read_tag(TAG_IRQ,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 13323 :
    tag[2]=read_tag(TAG_LAN,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 13579 :
    tag[2]=read_tag(TAG_LIN,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 2507 :
    tag[2]=read_tag(TAG_LOC,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 140 :
    tag[2]=read_tag(TAG_MEA,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 12428 :
    tag[2]=read_tag(TAG_MEM,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 18764 :
    tag[2]=read_tag(TAG_MKS,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 460 :
    tag[2]=read_tag(TAG_MOA,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 6732 :
    tag[2]=read_tag(TAG_MSG,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 3085 :
    tag[2]=read_tag(TAG_NAD,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 19469 :
    tag[2]=read_tag(TAG_NAT,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 2063 :
    tag[2]=read_tag(TAG_PAC,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 8207 :
    tag[2]=read_tag(TAG_PAI,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 19471 :
    tag[2]=read_tag(TAG_PAT,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 3151 :
    tag[2]=read_tag(TAG_PCD,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 8271 :
    tag[2]=read_tag(TAG_PCI,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 8303 :
    tag[2]=read_tag(TAG_PDI,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 8399 :
    tag[2]=read_tag(TAG_PGI,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 271 :
    tag[2]=read_tag(TAG_PIA,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 19727 :
    tag[2]=read_tag(TAG_PIT,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 431 :
    tag[2]=read_tag(TAG_PNA,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 2607 :
    tag[2]=read_tag(TAG_PRC,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 8751 :
    tag[2]=read_tag(TAG_PRI,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 3663 :
    tag[2]=read_tag(TAG_PSD,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 25199 :
    tag[2]=read_tag(TAG_PTY,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 25200 :
    tag[2]=read_tag(TAG_QTY,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 18096 :
    tag[2]=read_tag(TAG_QVR,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 18513 :
    tag[2]=read_tag(TAG_RCS,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 11409 :
    tag[2]=read_tag(TAG_REL,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 5297 :
    tag[2]=read_tag(TAG_RFF,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 6577 :
    tag[2]=read_tag(TAG_RNG,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 4721 :
    tag[2]=read_tag(TAG_RTE,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 11282 :
    tag[2]=read_tag(TAG_SAL,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 2130 :
    tag[2]=read_tag(TAG_SCC,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 3154 :
    tag[2]=read_tag(TAG_SCD,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 6290 :
    tag[2]=read_tag(TAG_SEG,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 11410 :
    tag[2]=read_tag(TAG_SEL,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 16530 :
    tag[2]=read_tag(TAG_SEQ,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 8370 :
    tag[2]=read_tag(TAG_SFI,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 15570 :
    tag[2]=read_tag(TAG_SGP,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 20690 :
    tag[2]=read_tag(TAG_SGU,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 18930 :
    tag[2]=read_tag(TAG_SPS,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 626 :
    tag[2]=read_tag(TAG_STA,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 2674 :
    tag[2]=read_tag(TAG_STC,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 6770 :
    tag[2]=read_tag(TAG_STG,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 19058 :
    tag[2]=read_tag(TAG_STS,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 23571 :
    tag[2]=read_tag(TAG_TAX,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 2803 :
    tag[2]=read_tag(TAG_TXC,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 2131 :
    tag[2]=read_tag(TAG_TCC,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 19571 :
    tag[2]=read_tag(TAG_TDT,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 12435 :
    tag[2]=read_tag(TAG_TEM,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 3475 :
    tag[2]=read_tag(TAG_TMD,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 15763 :
    tag[2]=read_tag(TAG_TMP,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 3539 :
    tag[2]=read_tag(TAG_TOD,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 11763 :
    tag[2]=read_tag(TAG_TPL,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 18003 :
    tag[2]=read_tag(TAG_TSR,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 20211 :
    tag[2]=read_tag(TAG_TXT,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 1460 :
    tag[2]=read_tag(TAG_UNB,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 4532 :
    tag[2]=read_tag(TAG_UNE,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 6580 :
    tag[2]=read_tag(TAG_UNG,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 7604 :
    /* UNH : reset DIREC variable! */
    /* fprintf(stderr,"IN UNH!\n"); */
    tag[2]=read_tag(TAG_UNH,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 18868 :
    tag[2]=read_tag(TAG_UNS,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 19892 :
    tag[2]=read_tag(TAG_UNT,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 26036 :
    tag[2]=read_tag(TAG_UNZ,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 596 :
    tag[2]=read_tag(TAG_USA,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 1620 :
    tag[2]=read_tag(TAG_USB,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 2644 :
    tag[2]=read_tag(TAG_USC,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 7764 :
    tag[2]=read_tag(TAG_USH,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 18004 :
    tag[2]=read_tag(TAG_USR,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 20052 :
    tag[2]=read_tag(TAG_UST,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 24148 :
    tag[2]=read_tag(TAG_USX,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 25172 :
    tag[2]=read_tag(TAG_USY,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 8276 :
    tag[2]=read_tag(TAG_UCI,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 12372 :
    tag[2]=read_tag(TAG_UCM,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 3156 :
    tag[2]=read_tag(TAG_UCD,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 23636 :
    tag[2]=read_tag(TAG_UCX,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
  case 17492 :
    tag[2]=read_tag(TAG_UCR,F,plus,colon,seg_end,lit,uc,at,atm);tag[0]=0;tag[1]=0;
    break;
   default:
     fprintf(stderr,"Can't uncompress/compress tag '%s' (line %d), tag is unknown to me\n",tag,LINENO); 
     break;
  }  /* SWITCH */ 
  } /* if !dirfound */
 } /* IF */
}

#include <stdio.h>
#include <stdlib.h>

void cprintf(char plus,char colon,char endseg,char *format,...);
void CPUT(char c);
void CPUTS(char *s);
void CFLUSH(void);

#define MAXFBUF 16384

double cntnum;
int    DOCNTNUM,INCNTNUM;

char read_tag(char *tag_def,FILE *F,char plus,char colon,char seg_end,char lit,int uc,int at,int atm);

int force=(1==0),REMOVE_COMMENTS,NONEWLINE=0;
char UNCOMPRESSED_ZERO=' ';

int cmd(int c)
{
  if (!c) { return (1==1); }
  else {
    fprintf(stderr,"You can only specify 1 command at a time\n");
    exit(1);
  }
}

void notabba(int at, int m,int num,int f)
{
  if (at || m || num || f) {
    fprintf(stderr,
	    "You cannot use options -@, -M, -num and -f with -ab and -ba\n");
    exit(1);
  }
}

void AB(FILE *in,
        char  plusA,char  colonA,char  seg_endA,char  litA,
        char  plusB,char  colonB,char  seg_endB,char  litB
        )
{
char c;
char *UNB="UNB+UNOA";
int  i;

  i=0;
  c=FGETC(in);
  if (REMOVE_COMMENTS) {
    while (c==';') {
      if (c==';') { while(c!='\n') { c=FGETC(in); } }
      c=FGETC(in); 
    }
  }

  while(!FEOF(in)) {

    if (REMOVE_COMMENTS) {
      if (c=='\n') { CPUT(c); }
      while(c=='\n' && !FEOF(in)) {
        c=FGETC(in);
        if (c==';') { while(c!='\n') { c=FGETC(in); } }
      }
      if (FEOF(in)) { return; } 
    }

    if (UNB[i]==c) { i+=1; }
    else { i=0; }

    if (UNB[i]=='\0') { CPUT('B'); }
    else if (c==plusA) { CPUT(plusB); }
    else if (c==colonA) { CPUT(colonB); }
    else if (c==seg_endA) { CPUT(seg_endB); }
    else if (c==litA) { int n=NONEWLINE;NONEWLINE=0;CPUT(FGETC(in));NONEWLINE=n; }
    else { CPUT(c); }
    c=FGETC(in);
  }
}

void BA(FILE *in, 
        char plusA,char colonA,char seg_endA,char litA,
        char plusB,char colonB,char seg_endB,char litB
        )
{
char c;
char *UNB="UNB+UNOB";
int  i;

  c=FGETC(in);

  if (REMOVE_COMMENTS) {
    while (c==';') {
      if (c==';') { while(c!='\n') { c=FGETC(in); } }
      c=FGETC(in); 
    }
  }

  i=0; 

  while(!FEOF(in)) {

    if (REMOVE_COMMENTS) {
      if (c=='\n') { CPUT(c); }
      while(c=='\n' && !FEOF(in)) {
        c=FGETC(in);
        if (c==';') { while(c!='\n') { c=FGETC(in); } }
      }
      if (FEOF(in)) { return; } 
    }

    if (UNB[i]==c || (UNB[i]=='+' && c==plusB)) { i+=1; }
    else { i=0; }

    if (UNB[i]=='\0') { CPUT('A'); }
    else if (c==plusA) { CPUT(litA);CPUT(plusA); }
    else if (c==colonA) { CPUT(litA);CPUT(colonA); }
    else if (c==seg_endA) { CPUT(litA);CPUT(seg_endA); }
    else if (c==litA) { CPUT(litA);CPUT(litA); } 
    else if (c==plusB) { CPUT(plusA); }
    else if (c==colonB) { CPUT(colonA); }
    else if (c==seg_endB) { CPUT(seg_endA); }
    else { CPUT(c); }

    c=FGETC(in);
  }
}

int main(int argc,char *argv[])
{
char plus='+',colon=':',seg_end='\'',lit='?';
char plusB=29,colonB=31,seg_endB=28,litB=0;
char tag[4]={0,0,0,0};
int  uc=(1==0),i,at=(1==0),atm=(1==0),command=(1==0),error=(1==0),ab=(1==0),ba=(1==0);
FILE *F;
char *filein=NULL, *fileout=NULL;
char *inbuf,*outbuf;

  DOCNTNUM=(1==0);
  strcpy(DIREC,""); 
  strcpy(PREVDIREC,DIREC);
  strcpy(MSTYPEVER,"");
  strcpy(PREVMSTYPEVER,"");
  REMOVE_COMMENTS=0;
  INTERACTIVE=0;

  if (argc==1) { 
    fprintf(stderr,"\nconvedi 11.2 (c) (GPL) nov. 1997, jun. 1999 H.N.M. Dijkema\n"
		   "compiled version: %s\n\n"
		   "Converts EDIfact levelA/B to uncompressed and vise-versa\n\n"
		   "\n"
		   "<enter> to continue...",COMPILEDVER
            );
	    getchar();

    fprintf(stderr,"\n"
		   "usage: convedi [ -ab -ba -au -bu -ua -ub ] [options] <file in> <file out>\n"
		   "      -au   - compressed level a to uncompressed\n"
		   "      -bu   - compressed level b to uncompressed\n"
		   "      -ua   - uncompressed level a to compressed\n"
		   "      -ub   - uncompressed level b to compressed\n"
		   "      -ab   - compressed level a to compressed level b\n" 
		   "      -ba   - compressed level b to compressed level a\n"
                   "\n"
            );
	    getchar();
     fprintf(stderr,"\n" 
                   "  options\n"
		   "      -R    - remove Comments (applies to -ab/-ba only)\n"
		   "      -I    - use interactive directory, if segment definition exists\n"
		   "             in that directory\n"
		   "      -D <d>- default to directory d\n"
		   "      -f    - fill empty fields with a small value\n"
		   "      -@    - add '@' at the end of a segment\n"
		   "      -0    - use '0' instead of ' ' to fill empty\n"
		   "              numeric fields in uncompressed format\n"
		   "      -M    - add '^M' at the and of a segment (UNIX to MSDOS)\n"
                   "              use this option if you don't use ASCII FTP\n"
		   "      -num  - fill the CNT NUM segment of a message with the\n"
		   "      -n    - no newline after segment separator\n"
                   "              count of all numbers in the message (UNH-UNT)\n"
		   "      -w    - Generate info about finding tags\n"
		   "      -     - use stdin/stdout for <file in>/<file out>\n"
		   "\n"
            );
            dirinfo();
     exit(0);
  }

  for(i=1;argv[i]!=NULL;i++) {
    if (strcmp(argv[i],"-c")==0) {int t1,t2,t3;
       t1=argv[i+1][0]-'A';
       t2=argv[i+1][1]-'A';
       t3=argv[i+1][2]-'A';
       printf("%s=%d\n",argv[i+1],(((t3*32)+t2)*32)+t1);
       exit(0);
    }
    else if (strcmp(argv[i],"-au")==0) { command=cmd(command); }
    else if (strcmp(argv[i],"-bu")==0) { command=cmd(command);plus=29;colon=31;seg_end=28;lit=0; }
    else if (strcmp(argv[i],"-ua")==0) { command=cmd(command);uc=(1==1); }
    else if (strcmp(argv[i],"-ub")==0) { command=cmd(command);uc=(1==1);plus=29;colon=31;seg_end=28;lit=0; }
    else if (strcmp(argv[i],"-ab")==0) { command=cmd(command);ab=(1==1); }
    else if (strcmp(argv[i],"-ba")==0) { command=cmd(command);ba=(1==1); }
    else if (strcmp(argv[i],"-n")==0)  { NONEWLINE=1; }
    else if (strcmp(argv[i],"-w")==0)  { GENFINDINFO=1; }
    else if (strcmp(argv[i],"-R")==0)  { REMOVE_COMMENTS=1; }
    else if (strcmp(argv[i],"-I")==0)  { INTERACTIVE=1; }
    else if (strcmp(argv[i],"-D")==0)  { if (argv[i+1]==NULL) {
					    fprintf(stderr,"usage: -D<d>\n");
					    exit(1);
					 } else {
					   if (!findTheDIREC(argv[i+1])) {
					    fprintf(stderr,"directory %s not supported\n",argv[i+1]);
					    exit(1);
					   }
					   i+=1;
                                         }
                                       }
    else if (strcmp(argv[i],"-@")==0)  { at=(1==1); }
    else if (strcmp(argv[i],"-M")==0)  { atm=(1==1); }
    else if (strcmp(argv[i],"-f")==0)  { force=(1==1); }
    else if (strcmp(argv[i],"-0")==0)  { UNCOMPRESSED_ZERO='0'; }
    else if (strcmp(argv[i],"-num")==0) { DOCNTNUM=(1==1); }
    else {
      filein=fileout;
      fileout=argv[i];
    }
  }

  if (ab || ba) { notabba(at,atm,DOCNTNUM,force); }

  if (filein==NULL || fileout==NULL) { 
    fprintf(stderr,"please give an input and an output file\n"); 
    error=(1==1);
  }
  else {FILE *O;
    if (strcmp(fileout,"-")==0) { O=stdout; }
    else { O=freopen(fileout,"wt",stdout); }
    if (strcmp(filein,"-")==0) { F=stdin; }
    else { F=fopen(filein,"rb"); }
    if (F==NULL) { fprintf(stderr,"Couldn't open input file '%s'\n",filein);error=(1==1);  }
    if (O==NULL) { fprintf(stderr,"Couldn't open output file '%s'\n",fileout);error=(1==1);  }
  }
  if (!command) {
    fprintf(stderr,"please issue a command (-ab, -ba, -au, -bu, -ua or -ub)\n");
    error=(1==1);
  }
  if (error) { exit(1); }

  if (ab) { fprintf(stderr,"level A to level B, "); }
  else if (ba) { fprintf(stderr,"level B to level A, "); }
  else if (plus=='+') { fprintf(stderr,"level A - "); }
  else { fprintf(stderr,"level B - "); }

  fprintf(stderr,"%s to %s ",filein,fileout); 
  if (!ab && !ba) {
    if (!uc) { fprintf(stderr," - compressed to uncompressed"); }
    else { fprintf(stderr," - uncompressed to compressed"); }
  }

  if (at) { fprintf(stderr," -@"); }
  if (atm) { fprintf(stderr," -M"); }
  if (DOCNTNUM) { fprintf(stderr," -num"); }
  if (UNCOMPRESSED_ZERO=='0') { fprintf(stderr," -0"); }
  if (REMOVE_COMMENTS) { fprintf(stderr," -R"); }

  fprintf(stderr,"\n\n"); 

  /* set buffers if we can */

  outbuf=(char *) malloc(MAXFBUF);
  if (outbuf!=NULL) { setvbuf(stdout,outbuf,_IOFBF,MAXFBUF); }
  inbuf=(char *) malloc(MAXFBUF);
  if (inbuf!=NULL) { setvbuf(F,inbuf,_IOFBF,MAXFBUF); }

  if (!ab && !ba) {
    tag[2]=FGETC(F);
    while (!FEOF(F)) {
      if (tag[2]==';') { while(tag[2]!='\n' && !FEOF(F)) { tag[2]=FGETC(F); } }
      ifthenelse(tag,F,plus,colon,seg_end,lit,uc,at,atm);
      tag[0]=tag[1];tag[1]=tag[2];tag[2]=FGETC(F);
    }
    if (uc) {
      cprintf(plus,colon,seg_end,NULL);
    }
    /*fprintf(stderr,"max output bufferspace used: %d bytes\n",MAXL_CPRINTF);*/
  } 
  else if (ab) { AB(F,plus,colon,seg_end,lit,plusB,colonB,seg_endB,litB); }
  else if (ba) { BA(F,plus,colon,seg_end,lit,plusB,colonB,seg_endB,litB); }
  else {
     fprintf(stderr,"Strange, I can't do anything\n"); 
  }

  CFLUSH();

return 0;
}

#define MAX_LEN 16386	/* The maximum FIELD length supported, i.e. 
			   a data element.
			*/
char field[MAX_LEN];

void  read_plus(char *tagdef,FILE *f,char plus,char colon,char endseg,char lit,char c);
char *read_colon(char *tagdef,FILE *f,char plus,char colon,char endseg,char lit,char *c);
char read_tag_cu(char *Tagdef,FILE *f,char plus,char colon,char endseg,char lit,int at,int atm);
char to_compr(char *tagdef,FILE *f,char plus,char colon,char endseg,char lit,int at,int atm);
void prtCntNum(char *buffer);

char read_tag(char *Tagdef,FILE *f,char plus,char colon,char endseg,char lit,int uc,int at,int atm)
{
char r;
  if (strncmp(Tagdef,"UNH",3)==0) { 
    cntnum=0.0; 
    strcpy(PREVDIREC,DIREC); 
    strcpy(PREVMSTYPEVER,MSTYPEVER);
    strcpy(DIREC,""); 
    strcpy(MSTYPEVER,""); 
    MESSNO+=1;
    inUNH=1;
  }
  if (strncmp(Tagdef,"CNT",3)==0) { INCNTNUM=(1==1); } else { INCNTNUM=(1==0); }
  /*fprintf(stderr,"%s\n",Tagdef);*/
  if (uc) { 
    r=to_compr(Tagdef,f,plus,colon,endseg,lit,at,atm);
  }
  else {
    r=read_tag_cu(Tagdef,f,plus,colon,endseg,lit,at,atm);
  }
  if (inUNH) { inUNH=0; }
return r;
}

static int cu_fieldno;

char read_tag_cu(char *Tagdef,FILE *f,char plus,char colon,char endseg,char lit,int at,int atm)
{
int i;
char *tagdef=Tagdef;
char tag[4],c;


  cu_fieldno=0;

  /*for(i=0;Tagdef[i]!='\0';i++) { tagdef[i]=Tagdef[i]; }
  tagdef[i]='\0';*/
  /*strcpy(tagdef,Tagdef);*/

  strncpy(tag,tagdef,3);
  tag[3]='\0';
  for(i=0;tagdef[i]!='+';i++);
  /*tagdef[i]='\0';*/

  CPUTS(tag);  

    c=FGETC(f);
    read_plus(tagdef+i+1,f,plus,colon,endseg,lit,c);
    c=FGETC(f);

  if (at) { CPUT('@'); } 
  if (atm) { CPUT(13); }
  CPUT('\n'); 

return c;
}

void read_plus(char *s,FILE *f,char plus,char colon,char endseg,char lit,char c)
{

  while (s[0]!='\'') { /*WHILE0*/
    /*printf("%s\n",s); */
    if (s[0]=='+') { char type;int num;   /* IF0 */
      s+=1;
      type=s[0];
      num=atoi(&s[1]); 
      while (s[0]!='\'' && s[0]!='+' && s[0]!=':') { s+=1; }

      {
	field[0]='\0';
	if (c==plus) {int k=0;

	  c=FGETC(f);
	  while (c!=plus && c!=colon && c!=endseg) { 
	    if (c==lit) { c=FGETC(f); }
	    field[k]=c;k+=1;field[k]='\0';
	    c=FGETC(f);
	  }

	  if (type=='A' || type=='a') {
	    if (force && strlen(field)==0) { strcpy(field,"-");k=1; }
	    CPUTS(field);
	    if (k<num) { int i; for(i=k;i<num;i++) { CPUT(' '); } }
          }
	  else {

            cntnum+=atof(field);

	    if (field[0]=='-') { 
	      CPUT('-');
	      if (k<num) { int i;for(i=k;i<num;i++) { CPUT('0'); } } 
	      CPUTS(field+1); 
	    }
	    else {
	      if (field[0]=='\0') { /* leeg veld */
		if (force) { strcpy(field,"1"); k=1; }
		if (k<num) { int i;for(i=k;i<num;i++) { CPUT(UNCOMPRESSED_ZERO); } }
	      }
	      else {
	        if (k<num) { int i;for(i=k;i<num;i++) { CPUT('0'); } } 
	      }
	      CPUTS(field); 
	    }
          }
	} else { int i;
	  if (force) { 
	     if (type=='A' || type=='a') { 
	       CPUT('-'); 
	       for(i=1;i<num;i++) { CPUT(' '); }
	     } else { 
		for(i=1;i<num;i++) { CPUT('0'); }
		printf("1"); 

                cntnum+=1.0;

	     } 
          }
	  else {
	    if (type=='N' || type=='n') {
	      for(i=0;i<num;i++) { CPUT(UNCOMPRESSED_ZERO); }
	    }
	    else {
	      for(i=0;i<num;i++) { CPUT(' '); } 
            }
          }
	}

	cu_fieldno+=1;

	if (s[0]==':') { s=read_colon(s,f,plus,colon,endseg,lit,&c); }

      }
    }
    else if (s[0]==':') { fprintf(stderr,"Can't have a colon here (line %d)!\n",LINENO); exit(1);  } 
    else {
      while(s[0]!='+' && s[0]!=':' && s[0]!='\'') { s+=1; } 
    } /* IF0 */
  } /* WHILE0 */
}

char *read_colon(char *s,FILE *f,char plus,char colon,char endseg,char lit,char *pre)
{
char c;
  c=*pre;
  while (s[0]!='+' && s[0]!='\'') { 
    if (s[0]==':') { char type;int num;
      s+=1;
      type=s[0];
      num=atoi(&s[1]);
      while (s[0]!='\'' && s[0]!='+' && s[0]!=':') { s+=1; }

      {
	field[0]='\0';
	if (c==colon) {int k=0;

	  c=FGETC(f);
	  while (c!=plus && c!=colon && c!=endseg) { 
	    if (c==lit) { c=FGETC(f); }
	    field[k]=c;k+=1;field[k]='\0';
	    c=FGETC(f);
	  }

	  if (type=='A' || type=='a') {
	    if (force && strlen(field)==0) { strcpy(field,"-");k=1; }
	    CPUTS(field);
	    if (k<num) { int i; for(i=k;i<num;i++) { CPUT(' '); } }
          }
	  else {
            if (DOCNTNUM && INCNTNUM) { prtCntNum(field);k=strlen(field); }
	    if (field[0]=='-') { 
	      cntnum+=atof(field);
	      CPUT('-');
	      if (k<num) { int i;for(i=k;i<num;i++) { CPUT('0'); } } 
	      CPUTS(field+1); 
	    }
	    else {
	      if (field[0]=='\0') { /* leeg veld */
		if (force) { strcpy(field,"1"); k=1;cntnum+=1.0; }
		if (k<num) { int i;for(i=k;i<num;i++) { CPUT(UNCOMPRESSED_ZERO); }}
	      }
	      else {
                cntnum+=atof(field);
	        if (k<num) { int i;for(i=k;i<num;i++) { CPUT('0'); } } 
	      }
	      CPUTS(field); 
	    }
          }
	} else { int i,k;
	  if (force) { 
	     if (type=='A' || type=='a') { 
	       CPUT('-'); 
	       for(i=1;i<num;i++) { CPUT(' '); }
	     } else { 
                if (DOCNTNUM && INCNTNUM) { 
                  prtCntNum(field);k=strlen(field); 
	          if (field[0]=='-') { 
	            cntnum+=atof(field);
	            CPUT('-');
	            if (k<num) { int i;for(i=k;i<num;i++) { CPUT('0'); } } 
	            CPUTS(field+1); 
	          }
	          else {
                    cntnum+=atof(field);
	            if (k<num) { int i;for(i=k;i<num;i++) { CPUT('0'); } } 
	            CPUTS(field); 
	          }
                }
                else {
		  for(i=1;i<num;i++) { CPUT('0'); }
		  CPUT('1'); 
		  cntnum+=1.0;
                }
	     } 
	  }
	  else {
            if (DOCNTNUM && (type=='N' || type=='n') && INCNTNUM) { 
              prtCntNum(field);k=strlen(field);
	      if (field[0]=='-') { 
	        cntnum+=atof(field);
	        CPUT('-');
	        if (k<num) { int i;for(i=k;i<num;i++) { CPUT('0'); } } 
	        CPUTS(field+1); 
	      }
	      else {
                cntnum+=atof(field);
	        if (k<num) { int i;for(i=k;i<num;i++) { CPUT('0'); } } 
	        CPUTS(field); 
	      }
            }
            else {
	      if (type=='N' || type=='n') {
	        for(i=0;i<num;i++) { CPUT(UNCOMPRESSED_ZERO); }
	      }
	      else {
	        for(i=0;i<num;i++) { CPUT(' '); } 
              }
            }
          }
	}
      }
      cu_fieldno+=1;
      /*if (inUNH) {
	fprintf(stderr,"inUNH field = %s\n",field);
      }*/
      if (inUNH) {
       if (cu_fieldno==3) {
	 strcpy(MSTYPEVER,field);
	 trim(MSTYPEVER);
	 strup(MSTYPEVER);
	 if (strcmp(MSTYPEVER,PREVMSTYPEVER)!=0) {
	   fprintf(stderr,"New directory (UNH.0052) '%s' detected (message %d, line %d)\n",
			   MSTYPEVER,MESSNO,LINENO);
         }
       }
       else if (cu_fieldno==4) {
	 strcpy(DIREC,field);
	 trim(DIREC);
	 strup(DIREC);
	 if (strcmp(DIREC,PREVDIREC)!=0) {
	   fprintf(stderr,"New directory (UNH.0054) '%s' detected (message %d, line %d)\n",
			   DIREC,MESSNO,LINENO);
           findDirec(DIREC);
         }
       }
      }
    }
    else {
      while(s[0]!='+' && s[0]!=':' && s[0]!='\'') { s+=1; }
    }
  }
  pre[0]=c;

return s;
}


void prt_field(char *s,char type,int len,char plus,char colon,char segend,char lit);

char to_compr(char *tagdef,FILE *f,char plus,char colon,char endseg,char lit,int at,int atm)
{
char *s;
int k=0,len,doCntNum=(1==0),chkCntNum=(strncmp("CNT",tagdef,3)==0);
int fieldno;
  /*fprintf(stderr,"OK!\n");*/

  prt_field(tagdef,'A',3,plus,colon,endseg,lit); 
  fieldno=0;

  k=0;
  len=0;
  s=tagdef+4;
  while (s[0]!='\'') {char type;int n;

    n=atoi(&s[2]);
    k=0;

    /*fgets(field,n,f);
    len=strlen(field);
    if (field[len-1]=='\n') { LINENO+=1;len-=1; }*/
    for(k=0;k<n && (field[k]=FGETC(f))!='\n';k++);
    len=k;
    k=0;

    type=s[1];

    if (s[0]=='+') { cprintf(plus,colon,endseg,"%c",plus); }
    else if (s[0]==':') { cprintf(plus,colon,endseg,"%c",colon); }

    if (doCntNum) {char q[100];
      prtCntNum(q);
      prt_field(q,type,strlen(q),plus,colon,endseg,lit);
      doCntNum=(1==0);
    }
    else {
      prt_field(&field[k],type,len-k,plus,colon,endseg,lit);
    }

    fieldno+=1;
    if (inUNH) {
      if (fieldno==3) {
        strncpy(MSTYPEVER,&field[k],len-k);
	MSTYPEVER[len-k]='\0';
	trim(MSTYPEVER);
	strup(MSTYPEVER);
	if (strcmp(MSTYPEVER,PREVMSTYPEVER)!=0) {
	   fprintf(stderr,"New directory (UNH.0052) '%s' detected (message %d, line %d)\n",
			  MSTYPEVER,MESSNO,LINENO);
        }
      }
      else if (fieldno==4) {
        strncpy(DIREC,&field[k],len-k);
	DIREC[len-k]='\0';
        trim(DIREC); 
        strup(DIREC); 
        if (strcmp(DIREC,PREVDIREC)!=0) {
	  fprintf(stderr,"New directory (UNH.0054) '%s' detected (message %d, line %d)\n",
	                  DIREC,MESSNO,LINENO);
           findDirec(DIREC);
        }
      }
    }

    if (chkCntNum) {
      if (strncmp(&field[k],"NUM",3)==0 && DOCNTNUM) { doCntNum=(1==1); }
    }
    k+=n;
    s+=1;while (s[0]!='+' && s[0]!=':' && s[0]!='\'') { s+=1; }
  }
  /*fprintf(stderr,"En nu?\n");*/
  cprintf(plus,colon,endseg,"%c",endseg); 
  /*fprintf(stderr,"En nu (2)?\n");*/
  if (at) { cprintf(plus,colon,endseg,"@"); } 
  if (atm) { cprintf(plus,colon,endseg,"%c",13); } 
  cprintf(plus,colon,endseg,"\n"); 

return FGETC(f);
}

void prt_field(char *s,char type,int len,char plus,char colon,char segend,char lit)
{
int i,k,zero=(1==0);
  if (type=='A' || type=='a') { 
    for(;len>0 && s[len-1]==' ';len--); 
    k=0;
  }
  else if (type=='N') {int min=(1==0);
    k=0;

    cntnum+=atof(s);

    if (s[0]=='-') { min=(1==1); }
    for(;k<len && (s[k]=='0' || s[k]=='-' || s[k]==' ');k++) { if (s[k]=='0') { zero=(1==1); }  s[k]=' '; }
    if (k==len && zero) { 
      k-=1; 
      s[k]='0';
    }
    else if (k>0 && min) {
      s[k-1]='-'; 
      k-=1;
    }
  }
  else if (type=='n') {
    cntnum+=atof(s);
    k=0;
  }

  if (force && (len==0 || len==k)) {
    if (type=='A' || type=='a') { s[0]='-';len=1; }
    else if (type=='N') { k-=1;s[k]='1';cntnum+=atof(s); }
    else if (type=='n') { int i;
             k=0;
             for(i=0;i<len-1;i++) { s[i]='0'; }
             s[i]=1;
             cntnum+=atof(s);
    }
  }

  for(i=k;i<len;i++) { 
    if (s[i]==plus) { cprintf(plus,colon,segend,"%c%c",lit,plus); }
    else if (s[i]==colon) { cprintf(plus,colon,segend,"%c%c",lit,colon); }
    else if (s[i]==segend) { cprintf(plus,colon,segend,"%c%c",lit,segend); }
    else { cprintf(plus,colon,segend,"%c",s[i]); } 
  }
}


void prtCntNum(char *buffer)
{
int i;
  sprintf(buffer,"%.18lf",cntnum);
  for(i=strlen(buffer)-1;i>=0 && buffer[i]=='0';i--) { buffer[i]='\0'; }
  if (i>=0 && buffer[i]=='.') { buffer[i]='\0'; }
  /*fprintf(stderr,"%s\n",buffer);*/
}


#define MAX_SEG_LEN   16384	/* max 16Kb. The segment
				   will be printed right away,
				   but for each plus, the
				   empty colons from the
				   previous field will be deleted
				   and for each segment end,
				   all plusses will be deleted.
				   We need some space for this.
				*/
#define MAX_FIELD_LEN MAX_LEN   /* this is for a field only */

void cprintf(char plus,char colon,char endseg,char *format,...)
{
static char *buffer=NULL,*tmp_buf=NULL;
static int  L=0;
va_list args;

   if (tmp_buf==NULL) {
     tmp_buf=(char *) malloc(MAX_FIELD_LEN);
     buffer=(char *) malloc(MAX_SEG_LEN);
     if (buffer==NULL || tmp_buf==NULL) { fprintf(stderr,"Out of memory\n");exit(1); }
     strcpy(buffer,"");
   }

   if (format==NULL) {  /* last cprint, empty the rest of the buffer (no endseg found) */
     cprintf(plus,colon,endseg,"");
     CPUTS(buffer);
     /*fprintf(stderr,"%s",buffer);*/
     L=0;
     buffer[L]='\0';
   }
   else {int newL;
     va_start(args,format);
     vsprintf(tmp_buf,format,args);
     va_end(args);

     newL=L+strlen(tmp_buf);
     if (newL>MAXL_CPRINTF) {
       MAXL_CPRINTF=newL;
       if (MAXL_CPRINTF>MAX_SEG_LEN) {
	 fprintf(stderr,"Out of bufferspace while printing segment at line %d\n",LINENO);
	 exit(1);
       }
     }
     
     strcat(&buffer[L],tmp_buf);
     L=newL;

     {
      register int i,k,l;


	/* assume there will never be a plus or a colon after an endseg
	   before we clean up */

        for(i=L-1;i>=0 && buffer[i]!=endseg && 
			  buffer[i]!=plus && buffer[i]!=colon;i--);

	/*if (strcmp(tmp_buf,"'")==0) {
	  fprintf(stderr,"' detected, i=%d",i);
	}*/

	/* When an endseg is found, clean up the buffer */

        if (i!=-1 && buffer[i]==endseg) {
/*          fprintf(stderr,"HE!%s\n",buffer);*/
          k=i+1;
          l=i;
          for(i-=1;i>=0 && (buffer[i]==colon || buffer[i]==plus);i--) {
/*            fprintf(stderr,"%2d%c",i,buffer[i]);*/
            buffer[i]=buffer[l];
            l-=1;
          }
          l+=1;
/*          fprintf(stderr,"\nHE2 %d %d!\n",l,i);*/
/*          fprintf(stderr,"HE1!\n");*/
          while(i>=0) {
            if (buffer[i]==colon && buffer[i+1]==plus) {
              memmove(&buffer[i],&buffer[i+1],l-i);
              l-=1;
            }
            i-=1;
          }
/*          fprintf(stderr,"\nHE2 %d %d!\n",l,i);*/
          for(i=0;i<l;i++) { CPUT(buffer[i]);/*fprintf(stderr,"%c",buffer[i]);*/ }
/*          fprintf(stderr,"HE3!\n");*/
          memmove(buffer,&buffer[k],L-k);
/*          fprintf(stderr,"HE4!\n");*/
          L-=k;
          buffer[L]='\0';
        }
	else {static int BEGINALFA=0;

	 /* search for the first plus from the back and remove the colons */
	 /* Assume there are only colons and endsegs at the end of the
	    buffer */

	 for(i=L-1;i>=0 && (buffer[i]==colon || buffer[i]==endseg);i--);

	 /* if a plus is found, remove the trailing colons from the right */
          
	 /*fprintf(stderr,"%s\n",buffer);*/
         if (i!=-1 && buffer[i]==plus) {
	   for(l=i,i-=1;buffer[i]==colon;i--);
	   i+=1;
	   if (l!=i) {
	     memmove(&buffer[i],&buffer[l],L-l+1);
	     L-=(l-i);
	   }
	   if (buffer[L]!='\0') { fprintf(stderr,"Error!\n"); exit(1); }
	 }

	 /* otherwise, print the buffer, untill the last colon, 
	    plus or endseg */

	 /*fprintf(stderr,"%s\n",buffer);*/
	 if (L>0) {char c;
	   for(i=BEGINALFA;i<L && (buffer[i]==plus || buffer[i]==colon);i++);
	   BEGINALFA=i;
	   for(;i<L && buffer[i]!=plus && buffer[i]!=colon && buffer[i]!=endseg;i++);
	   i-=1;
	   /*for(i=L-1;i>=0 && 
		     (buffer[i]==plus || buffer[i]==colon || buffer[i]==endseg)
                    ;i--);*/
           /*fprintf(stderr,"%s %d %d\n",buffer,BEGINALFA,i); */
           if (i>=BEGINALFA) {
	     BEGINALFA=0;
             c=buffer[i+1];buffer[i+1]='\0';
	     CPUTS(buffer);
	     /*fprintf(stderr,"%s\n",buffer);*/
	     /*fprintf(stderr,"%d %d\n",i,L);*/
	     buffer[i+1]=c;
	     i+=1;
             memmove(buffer,buffer+i,L-i+1);
	     L=L-i;
	     /*fprintf(stderr,"%d %d\n",i,L);*/
	     /*buffer[L]='\0';*/
	     if (buffer[L]!='\0') { fprintf(stderr,"Error2!\n"); exit(1); }
           }
         }
       }
     }
   }
}


/* BEWARE! Only 1 file is expected to be there to read! */

#define BUF_LEN 16384

char FBUF[BUF_LEN];
int BUFLEN=0,INBUF=0;

char FGETC(FILE *f)
{
char c;
  if (INBUF==BUFLEN) { 
    BUFLEN=read(fileno(f),FBUF,BUF_LEN); 
    INBUF=0;
    if (BUFLEN==0) { return 26; }	/* ^Z == eof */
  }
/*return FBUF[INBUF++]; */
  if ((c=FBUF[INBUF++])=='\n') { LINENO+=1; }
return c;
}

int FEOF(FILE *f)
{
  return BUFLEN==0;
}

static char CBUF[BUF_LEN];
static int  CLEN=0;

void CPUT(char c)
{
  if (NONEWLINE && (c=='\n' || c==13)) {
    /* empty */
  } else {
    if (CLEN>=BUF_LEN-1) {
      CFLUSH();
    }
    CBUF[CLEN++]=c;
  }
}

void CPUTS(char *s)
{
  while(s[0]!='\0') { CPUT(s[0]);s+=1; }
}

void CFLUSH(void)
{
  CBUF[CLEN]='\0';
  printf("%s",CBUF); 
  CLEN=0; 
}



