/*
col_pic copyright (c) 2009-always Jan Panteltje

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#include "forms.h"
#include "col_pic.h"

FD_col_pic *fdui;


FILE *filefd;

int readline(FILE *file, char *contents)
{
int a, c, i;

if(debug_flag)
	{
	fprintf (stderr, "readline(): arg file=%lu\n", (long)file);
	}

for(i = 0; i < READSIZE - 1; i++)
	{
	while(1)
		{
		c = getc(file);
		a = ferror(file);
		if(a)
			{
			perror("readline():");
			continue;
			}
		break;
		}
	if(feof(file) )
		{
		fclose(file);
		contents[i] = 0;/* EOF marker */
		return(EOF);
		}
	if(c == '\n')
		{
		contents[i] = 0;/* string termination */
		return 1;/* end of line */
		} 
	contents[i] = c;
	}
/*
mmm since we are here, the line must be quite long, possibly something
is wrong.
Since I do not always check for a return 0 in the use uf this function,
just to be safe, gona force a string termination.
This prevents stack overflow, and variables getting overwritten.
*/
contents[i] = 0;/* force string termination */
/*fclose(file);*/
if(debug_flag)
	{
	fprintf(stderr,\
	"readline(): line to long, returning 0 contents=%s\n", contents);
	}
return 0;
} /* end function readline */


int integer_to_fontsize(int fontsize)
{
int size;

size = 0; /* only for clean compilation with -Wall */

/* tiny snall normal medium large huge */
if(fontsize == 0) size = FL_TINY_SIZE;
if(fontsize == 1) size = FL_SMALL_SIZE;
if(fontsize == 2) size = FL_NORMAL_SIZE;
if(fontsize == 3) size = FL_MEDIUM_SIZE;
if(fontsize == 4) size = FL_LARGE_SIZE;
if(fontsize == 5) size = FL_HUGE_SIZE;

return size;
} /* end function integer to fontsize */


int ogettime(
char *weekday,
char *month,
int *monthday,
int *hour,
int *minute,
int *second,
int *year
)
{
time_t now;
char *datestring;

time(&now); /* sets unsigned long int I to seconds since start 1970 */
datestring = ctime(&now); /* char * converts now to character string date and time */

sscanf(datestring, "%s %s %d %d:%d:%d %d",\
weekday,month,monthday,hour,minute,second,year); /* no &, already pointers */

return 1;
} /* end function ogettime */



int reverse_gamma(int value, int *result, double coefficient)
{
double dmax;
double dval;
double dresult;

if(debug_flag)
	{
	fprintf(stderr, "reverse_gamma(): arg value=%d result=%p coefficient=%.2f using gamma_off_flag=%d\n", value, result, coefficient, gamma_off_flag);
	}

if(! result) return 0;
if(value < 0) return 0;
if(value > 255) return 0;
if(coefficient < 0) return 0;

if(gamma_off_flag)
	{
	/* change nothing */
	*result = value;
	
	return 1;
	}

dmax = pow(255.0, coefficient);
if(debug_flag)
	{
	fprintf(stderr, "dmax=%.2f\n", dmax);
	}

dval = pow((double)value, coefficient);

if(debug_flag)
	{
	fprintf(stderr, "dval=%.2f\n", dval);
	}

dresult = (dval * 255.0) / dmax;

if(debug_flag)
	{
	fprintf(stderr, "dresult=%.2f\n", dresult);
	}

*result = (int)dresult;

if(debug_flag)
	{
	fprintf(stderr, "*result=%d\n", *result);
	}

return 1;
} /* end function reverse_gamma */



int set_dial_color(double degrees, double saturation, double brightness)
{
int y, u, v;
int cy, cr, cg, cb;
double du, dv;
int red, green, blue;
double dred, dgreen, dblue;

if(debug_flag)
	{
	fprintf(stdout,\
	"set_dial_color(): arg degrees=%.2f saturation=%.2f brightness=%.2f\n", degrees, saturation, brightness);
	}

saturation /= 100.0;
brightness /= 100.0;

du = sin(degrees * M_PI / 180.0);
dv = cos(degrees * M_PI / 180.0);

u = du * 255.0 * saturation;
v = dv * 255.0 * saturation;

/* yuv to rgb */

/* From wikipedia http://en.wikipedia.org/wiki/YUV 
The ITU-R version of the formulae are different:

Y = 0.299 * R + 0.587 * G + 0.114 *  B + 0
Cb = -0.169 * R - 0.331 * G - 0.499 * B + 128
Cr = 0.499 * R - 0.418 * G - 0.0813 * B + 128
            
R = clip(Y + 1.402 * (Cr - 128))
G = clip(Y - 0.344 * (Cb - 128) - 0.714 * (Cr - 128))
B = clip(Y + 1.772 * (Cb - 128)) 
*/

/* lot of white */
y = 200;
cy = y - 16;
cy  *= 76310;

cr = 104635 * v;
cg = -25690 * u + -53294 * v;
cb = 132278 * u;

red = LIMIT(cr + cy);
green = LIMIT(cg + cy);
blue =  LIMIT(cb + cy);

dred = (double)red * brightness;
dgreen = (double)green * brightness;
dblue = (double)blue * brightness;

selected_red = (int)dred;
selected_green = (int)dgreen;
selected_blue = (int)dblue;

if(debug_flag)
	{
	fprintf(stdout, "set_dial_color(): red=%d green=%d blue=%d\n", red, green, blue);
	}

fl_mapcolor(FL_FREE_COL1 + 24, selected_red, selected_green, selected_blue);

fl_set_object_color(\
	fdui -> color_circle_dial, FL_FREE_COL1 + 24, FL_FREE_COL1 + 24);

fl_redraw_object(fdui -> color_circle_dial);

return 1;
} /* end function set_template_dial_color */



int send_selected_color_saturation_brightness()
{
char temp[80];
int reverse_gamma_red, reverse_gamma_green, reverse_gamma_blue;

if(debug_flag)
	{
	fprintf(stderr, "send_selected_color_saturation(): arg none, using selected_color=%.2f, selected_saturation=%.2f\n", selected_color, selected_saturation); 
	}

//int reverse_gamma(int value, int *result, double coefficient)
reverse_gamma(selected_red, &reverse_gamma_red, gamma_correction);
reverse_gamma(selected_green, &reverse_gamma_green, gamma_correction);
reverse_gamma(selected_blue, &reverse_gamma_blue, gamma_correction);

if(port)	// send as UDP to internet address and port as specified on comand line.
	{
	fprintf(pnetcat, "R%d\nG%d\nB%d\n", reverse_gamma_red, reverse_gamma_green, reverse_gamma_blue);

	fflush(pnetcat);
	}	
else
	{
	sprintf(temp, "R%d%cG%d%cB%d%c", reverse_gamma_red, 10, reverse_gamma_green, 10, reverse_gamma_blue, 10);
	send_command(temp);
	}

sprintf(temp, "sending red=%d green=%d blue=%d", reverse_gamma_red, reverse_gamma_green, reverse_gamma_blue);
fl_set_object_label(fdui -> status_box, temp);

return 1;
}


