
/*
col_pic copyright (c) 2005 Jan Panteltje

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#include "forms.h"
#include "col_pic.h"

extern FD_col_pic *fdui;

int save_setting(char *type, char *string)
{
char pathfilename[READSIZE];
FILE *setting_file;

/* combine with home directory */
sprintf(pathfilename, "%s/.col_pic/setup/%s", home_dir, type);
setting_file = fopen(pathfilename, "w");
if(! setting_file)
	{
	fl_show_alert("Cannot open file for write:", pathfilename, "", 0);
	if(debug_flag)
		{
		fprintf(stderr, "\nCannot open setting file %s for write\n",\
		pathfilename);
		}
	return(0);
	}

fprintf(setting_file, "%s", string);
fclose(setting_file);
return(1);	
}/* end function save_setting */


char *load_setting(char *type)
{
int a;
char temp[4096];
char pathfilename[READSIZE];
FILE *setting_file;

/* combine with home directory */
sprintf(pathfilename, "%s/.col_pic/setup/%s", home_dir, type);

setting_file = fopen(pathfilename, "r");
if(! setting_file)
	{
/*
	fl_show_alert(\
	"Cannot open file for read:", pathfilename, "using defaults", 0);
*/

	if(debug_flag)
		{
		fprintf(stderr, "\nCannot open setting file %s for read\n",\
		pathfilename);
		}

	return 0;
	}

a = readline(setting_file, temp);/* closes file if EOF */	
if(a != EOF) fclose(setting_file);

return( (char *) strsave(temp) );
}/* end function load_setting */


#ifdef VARIABLE_FONTSIZES
int save_fontsizes()
{
char temp[READSIZE];
//sprintf(temp, "%d", main_form_fontsize);

return 1;
);

if(! save_setting("fontsizes", temp) ) return(0);

return 1;
}/* end function save_fontsizes */


int load_fontsizes()
{
char *data_read;
 
data_read = (char *) load_setting("fontsizes");
if(! data_read) return(0);

//sscanf(data_read, "%d", &main_form_fontsize);

free(data_read);

//fl_set_browser_fontsize(fdui -> col_pic, main_form_fontsize);

return 1;
}/* end function load_fontsizes */

#endif // VARIABLE_FONTSIZES


int save_settings()
{
char temp[1024];

if(debug_flag)
	{
	fprintf(stderr, "save_settings(): arg none\n");
	}

sprintf(temp, "%.2f %.2f %.2f %d %d %d",\
selected_color,\
selected_saturation,\
selected_brightness,\
selected_browser_topline,\
selected_browser_line,\
gamma_off_flag\
);

save_setting("settings", temp);

return 1;
} /* end function save_settings */


int load_settings()
{
int a;
char *ptr;
char temp[80];

if(debug_flag)
	{
	fprintf(stderr, "load_settings(): arg none\n");
	}

ptr = (char *) load_setting("settings");
if( ! ptr)
	{
	/* report about usings defaults in load settings() */
	return 0;
	}

a = sscanf(ptr, "%lf %lf %lf %d %d %d",\
&selected_color,\
&selected_saturation,\
&selected_brightness,\
&selected_browser_topline,\
&selected_browser_line,\
&gamma_off_flag\
);

if(a != 6)
	{
	fprintf(stderr, "col_pic: load_settings(): could only read %d of 5 arguments of file settings\n", a);

	return 0;
	}

fl_set_dial_value(fdui -> color_circle_dial, selected_color);

set_dial_color(selected_color, selected_saturation, selected_brightness);

sprintf(temp, "%.2f", selected_color);
fl_set_object_label(fdui -> color_degrees_output_field,  temp);

fl_set_slider_value(fdui -> saturation_slider, selected_saturation);

fl_set_slider_value(fdui -> brightness_slider, selected_saturation);

set_entry(selected_browser_line - 1);

fl_set_browser_topline(fdui -> color_browser, selected_browser_topline);
fl_select_browser_line(fdui -> color_browser, selected_browser_line);

fl_set_button(fdui -> gamma_off_button, gamma_off_flag);
if(gamma_off_flag)
	{
	fl_set_object_label(fdui -> gamma_off_button, "gamma off");
	}
else
	{
	fl_set_object_label(fdui -> gamma_off_button, "gamma on");	
	}

return 1;
} /* end function load_settings */



