
/*
col_pic copyright (c) 2005 Jan Panteltje

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "forms.h"
#include "col_pic.h"

FD_col_pic *fdui;


int set_port_parameters(int fd, int baudrate, char *device)
{
struct termios tty;
speed_t baud;

if(debug_flag)
	{
	fprintf(stdout, "set_port_parameters(): arg fd=%d baudrate=%d device=%s\n", fd, baudrate, device);
	}

/* convert real baudrates to 'B' baudrates */
switch(baudrate)
	{
	case 9600:
		baud = B9600;
		break;
	case 19200:
		baud = B19200;
		break;
	case 38400:
		baud = B38400;
		break;
	case 57600:
		baud = B57600;
		break;
	case 115200:
		baud = B115200;
		break;
	default:
		fprintf(stderr, "ptlrc: baudrate=%d unsupported, aborting.\n", baudrate);
		return 0;
		break;
	} /* end switch baudrate */

/* set comport parameters */
tcgetattr(fd, &tty);

tty.c_cflag = 0;
tty.c_cflag |= CLOCAL;			/* ignore modem control lines */
tty.c_cflag |= CREAD;			/* enable receiver */
tty.c_cflag |= CS8;				/* use 8 data bits */
//tty.c_cflag |= CSTOPB;		/* 2 stop bits */
//tty.c_cflag |= PARENB;		/* enable parity */
//tty.c_cflag |= PARODD;		/* use odd parity */
//tty.c_cflag &= ~CRTSCTS;		/* do not use RTS and CTS handshake */

tty.c_iflag = 0;
tty.c_iflag |= IGNBRK;
tty.c_iflag |= IGNPAR;
//tty.c_iflag |= PARMRK
//tty.c_iflag |= INPCK;
//tty.c_iflag |= INLCR;
//tty.c_iflag |= ISTRIP
//tty.c_iflag &= ~(IXON | IXOFF | IXANY);

tty.c_oflag = 0;

tty.c_lflag = 0;
//tty.c_lflag |= ICANON;
//tty.c_cc[VMIN] = 1;
//tty.c_cc[VTIME] = 5;
//tty.c_lflag &= ~(ECHO|ECHONL|ICANON|ISIG|IEXTEN);


cfsetospeed(&tty, (speed_t)baud);
cfsetispeed(&tty, (speed_t)baud);

tcsetattr(fd, TCSANOW, &tty);

return 1;
} /* end function set_port_parameters */


int send_command(char *command)
{
int a, len;
int fd;

if(debug_flag)
	{
	fprintf(stderr, "col_pic: send_command(): arg command=%s using serial_device_name=%s baudrate=%d\n", command, serial_device_name, baudrate);
	}

if(! command) return 0;

fd = open(serial_device_name, O_RDWR);
if(fd == -1)
	{
	fprintf(stderr, "col_pic: send_command(): could not open device %s for read-write.\n", serial_device_name);
	
	return 0;
	}

// int set_port_parameters(int fd, int baudrate, char *device)
if(! set_port_parameters(fd, baudrate, serial_device_name) )
	{
	fprintf(stderr, "col_pic: send_command(): could not set baudrate %d\n", baudrate); 
	
	return 0;
	}

//sprintf(temp, "sending red=%d green=%d blue=%d", reverse_gamma_red, reverse_gamma_green, reverse_gamma_blue);
//fl_set_object_label(fdui -> status_box, command);

len = strlen(command);

//ssize_t write(int fd, const void *buf, size_t count);
a = write(fd, command, len);
if(a != len)
	{
	fprintf(stderr, "col_pic: send_command(): could only write %d of %d bytes to serial port.\n", a, len);

	close(fd);

	return 0;
	}

close(fd);

return 1;
} /* end function send_command */


