
/*
col_pic copyright (c) 2009-always Jan Panteltje

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#include "forms.h"
#include "col_pic.h"

extern FD_col_pic *fdui;


void catch_alarm(int sig)
{
FILE *pptr;

/* this should force EOF in readline */
pptr = popen("killall rci_power", "w");
pclose(pptr); 

pptr = popen("killall rci_tx", "w");
pclose(pptr); 

signal (sig, catch_alarm);

} /* end function cacth _alarm */


int print_usage()
{
fprintf(stderr, "\n\
Panteltje (c) %s\n\
Usage:                   col_pic [-b baudrate] [-d serial_device_name] [-h] [-v]\n\
-b                       baudrate, allowed is 9600, 19200, 38400, 57600, 115200, default is %d.\n\
-d serial_device_name    serial device name, default %s.\n\
-h                       help (this help).\n\
-i 10.0.0.157            internet address in dotted quad form.\n\
-j port                  port number, 1-65535.\n\
-v                       debug (prints functions and arguments).\n\
example:\n\
col_pic -d /dev/ttyS1\n\
",\
PROG_VERSION, DEFAULT_BAUDRATE, DEFAULT_SERIAL_DEVICE_NAME);

return 1;
} /* end function print_usage */


int main(int argc, char *argv[])
{
FD_col_pic *fd_col_pic;
FL_IOPT fl_iopt;
char *ptr;
int a;
Pixmap p, mask;
char temp[1024];
unsigned w, h;
FILE *fptr;

/* get user info */
userinfo = getpwuid(getuid() );

/* get home directory */ 
home_dir = (char *)strsave(userinfo -> pw_dir);
if(! home_dir)
	{
	fprintf(stderr, "col_pic: main(): cannot allocate space for home_dir, aborting.\n");
	exit(1);
	}

user_name = (char *)strsave(userinfo -> pw_name);
if(! user_name)
	{
	fprintf(stderr, "col_pic: main(): cannot allocate space for user_name, aborting.\n");
	exit(1);
	}

/* against flashing */
/* set double buffering */
fl_iopt.doubleBuffer = 1;
fl_set_defaults(FL_PDDouble, &fl_iopt);
                   
fl_initialize(&argc, argv, "Color_pic", 0, 0);

fd_col_pic = create_form_col_pic();

/* set the icon */
sprintf(temp, "%s/.col_pic/col_pic.xpm", home_dir);
fptr = fopen(temp, "r");
if(fptr)
	{
	fclose(fptr);

	p = fl_read_pixmapfile(fl_root, temp, &w, &h, &mask, 0, 0, 0);

	fl_set_form_icon(fdui -> col_pic, p, mask);                 
	}
else
	{
	fprintf(stderr, "no icon %s found\n", temp);
	}

/* fill-in form initialization code */

/* defaults */
debug_flag = 0;

serial_device_name = strsave(DEFAULT_SERIAL_DEVICE_NAME);
if(! serial_device_name)
	{
	fprintf(stderr, "col_pic: could not allocate space for serial device name, aborting.\n");

	exit(1);
	}

baudrate = DEFAULT_BAUDRATE;

database_name = strsave(DEFAULT_DATABASE_NAME);
if(! database_name)
	{
	fprintf(stderr, "col_pic: main(): could not allocate space for database_name, aborting.\n");

	exit(1);
	}

gamma_correction = DEFAULT_GAMMA_CORRECTION;
selected_color = DEFAULT_SELECTED_COLOR_ANGLE;
selected_saturation = DEFAULT_SELECTED_SATURATION;
selected_brightness = DEFAULT_SELECTED_BRIGHTNESS;
/* end defaults */

/* get any previous settings */
ptr = load_setting("serial_device_name");
if(ptr)
	{
	free(serial_device_name);
	serial_device_name = strsave(ptr);

	if(! serial_device_name)
		{
		fprintf(stderr, "col_pic: main(): could not allocate space for serial_device_name, aborting.\n");
		exit(1);	
		}	
	}
	
while(1)
	{
	a = getopt(argc, argv, "ab:d:hi:j:v");
	if(a == -1) break;

	switch(a)
		{
		case 'b': // baudrate
			baudrate = atoi(optarg);
			break;
		case 'd': // serial device
			free(serial_device_name);
			serial_device_name = strsave(optarg);
			if(! serial_device_name)
				{
				fprintf(stderr, "col_pic: could not allocate space for serial device, aborting.\n");

				exit(1);
				}

			break;
		case 'h': // help
			print_usage();
			exit(1);
			break;
		case 'i':	// IP address
			ip_address = strsave(optarg);
			if(! ip_address)
				{
				fprintf(stderr, "col_pic: could not allocate space for ip_address, aborting.\n");

				exit(1);
				}		
		
			break;
		case 'j':	// port		, 'p' as option is intercepted by xforms
			port = atoi(optarg);

			if( (port < 1) || (port > 65535) )
				{
				fprintf(stderr, "col_pic: invalid port number, aborting.\n");
			
				exit(1);	
				}
			
			break;
		case 'v': // debug
			debug_flag = 1;
			break;
        case -1:
        	break;
		case '?':
			if (isprint(optopt) )
 				{
 				fprintf(stderr, "Unknown option `-%c'.\n", optopt);
 				}
			else
				{
				fprintf(stderr, "Unknown option character `\\x%x'.\n",\
				optopt);
				}
			print_usage();

			exit(1);
			break;			
		default:
			print_usage();

			exit(1);
			break;
		}/* end switch a */
	}/* end while getopt() */

if(debug_flag)
	{
	fprintf(stderr, "ip_address=%s port=%d\n", ip_address, port);
	}

if(port)
	{
	sprintf(temp, "netcat -u %s %d\n", ip_address, port);

	pnetcat = popen(temp, "w");
	}

ptr = load_setting("database_name");
if(ptr)
	{
	free(database_name);
	database_name = strsave(ptr);

	if(! database_name)
		{
		fprintf(stderr, "col_pic: main(): could not allocate space for database_name, aborting.\n");
		exit(1);	
		}	
	}

ptr = load_setting("gamma_correction");
if(ptr)
	{
	gamma_correction = atof(ptr);

	sprintf(temp, "gamma %.2f", gamma_correction);
	fl_set_object_label(fdui -> gamma_select_button, temp);
	}

if (load_browser(database_name))
	{
	fl_set_object_label(fdui -> database_button, database_name);
	}
else
	{
	fl_set_object_label(fdui -> database_button, "None");
	}


/* selected_color, selected_saturation, selected_brightness, selected_browser_topline, selected_browser_line */
load_settings();

fl_set_object_label(fdui -> serial_device_select_button, serial_device_name);

//int set_port_parameters(int fd, int baudrate, char *device);

//fl_set_form_minsize(cl, cl->w , cl->h);
//fl_set_form_maxsize(cl, 2*cl->w , 2*cl->h);
//fl_show_form(cl, FL_PLACE_FREE, FL_TRANSIENT, "RGB Browser");

/* show the first form */
fl_show_form(fd_col_pic -> col_pic, FL_PLACE_FREE, FL_FULLBORDER, PROG_VERSION);

fl_do_forms();

return 0;
} /* end function main */


