/*
col_pic copyright (c) 2009-always Jan Panteltje

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "forms.h"
#include "col_pic.h"

extern FD_col_pic *fdui;

typedef struct { int r, g, b; } RGBdb;
#define MAX_RGB 3000
static RGBdb rgbdb[MAX_RGB];


char *strsave(char *s) /* save char array s somewhere */
{
char *p;

p = malloc( strlen(s) +  1);
if(! p) return 0;

strcpy(p, s);
return p;
} /* end function strsave */


void save_settings_button_cb(FL_OBJECT *ob, long data)
{
char temp[10];

if(debug_flag)
	{	
	fprintf(stderr, "save_settings_button_cb(): arg none\n"); 
	}

sprintf(temp, "S%c", 10);
send_command(temp);

fl_set_object_label(fdui -> status_box, "sending 'save_status'");
}


void exit_button_cb(FL_OBJECT *ob, long data)
{
if(debug_flag)
	{
	fprintf(stderr, "exit_button_cb(): arg none\n");
	}
	
//save_settings();

fl_finish();

exit(0);
} /* end function exit_button_cb */


/* signal handler */
void one_second_tick(int sig)
{
time_t now;
struct tm *broken_time;

broken_time = localtime (&now);
//ogettime(weekday, month, &monthday, &hour, &minute, &second, &year);

fl_add_signal_callback(SIGALRM, (FL_SIGNAL_HANDLER)one_second_tick, NULL); //&mydata);

/* reenable the timer */
alarm(1);
} /* end function one_second_tick (signal handler) */



void set_entry(int i)
{
char temp[80];
int reverse_gamma_red, reverse_gamma_green, reverse_gamma_blue;

RGBdb *db = rgbdb + i;

fl_freeze_form(fdui -> col_pic);

fl_mapcolor(FL_FREE_COL4+i, db->r, db->g, db->b);
fl_mapcolor(FL_FREE_COL4, db->r, db->g, db->b);

fl_set_slider_value(fdui -> red_slider, db->r);
fl_set_slider_value(fdui -> green_slider, db->g);
fl_set_slider_value(fdui -> blue_slider, db->b);

fl_redraw_object(fdui -> color_box);

fl_unfreeze_form(fdui -> col_pic);

//int reverse_gamma(int value, int *result, double coefficient)
reverse_gamma(db -> r, &reverse_gamma_red, gamma_correction);
reverse_gamma(db -> g, &reverse_gamma_green, gamma_correction);
reverse_gamma(db -> b, &reverse_gamma_blue, gamma_correction);

if(port)	// send as UDP to internet address and port as specified on comand line.
	{
	fprintf(pnetcat, "R%d\nG%d\nB%d\n", reverse_gamma_red, reverse_gamma_green, reverse_gamma_blue);

	fflush(pnetcat);
	}	
else
	{
	sprintf(temp, "R%d%cG%d%cB%d%c", reverse_gamma_red, 10, reverse_gamma_green, 10, reverse_gamma_blue, 10);
	send_command(temp);
	}

	
sprintf(temp, "sending red=%d green=%d blue=%d", reverse_gamma_red, reverse_gamma_green, reverse_gamma_blue);
fl_set_object_label(fdui -> status_box, temp);

}


void color_browser_cb(FL_OBJECT * ob, long q)
{
int r = fl_get_browser(ob);

if (r <= 0) return;
set_entry(r - 1);

selected_browser_topline = fl_get_browser_topline(fdui -> color_browser);
selected_browser_line = r;
save_settings();

}


int read_entry(FILE * fp, int *r, int *g, int *b, char *name)
{
int  n;
char buf[512], *p;

if (!fgets(buf, sizeof(buf) - 1, fp)) return 0;

if(buf[0] == '!')
fgets(buf,sizeof(buf)-1,fp);

if(sscanf(buf, " %d %d %d %n", r, g, b, &n) < 3) return 0;

p = buf + n;

/* squeeze out all spaces */
while (*p)
	{
	if (*p != ' ' && *p != '\n') *name++ = *p;
	p++;
	}
*name = 0;

return (feof(fp) || ferror(fp)) ? 0 : 1;
}


int load_browser(char *fname)
{
FILE *fp;
RGBdb *db = rgbdb, *dbs = db + MAX_RGB;
int r, g, b,  lr  = -1 , lg = -1, lb = -1;
char name[256], buf[256];

if(debug_flag)
	{
	fprintf(stderr, "load_browser(): arg fname=%s\n", fname);
	}

if(!(fp = fopen(fname, "r")))
	{
	fl_show_alert("Load", fname, "Can't open", 0);
	return 0;
	}

if(debug_flag)
	{
	fprintf(stderr, "load_browser(): fileno(fp)=%d\n", fileno(fp) );
	}

/* read the items */
fl_freeze_form(fdui -> col_pic);

for(; db < dbs && read_entry(fp, &r, &g, &b, name);)
	{	
	db->r = r;
	db->g = g;
	db->b = b;

	/* unique the entries on the fly */
	if (lr != r || lg != g || lb != b)
		{
   		db++;
   		lr = r;
   		lg = g;
   		lb = b;

    	sprintf(buf, "(%3d %3d %3d) %s", r, g, b, name);
    	fl_addto_browser(fdui -> color_browser, buf);
		}
	}

fclose(fp);

if (db < dbs) db -> r = 1000;		/* sentinel */
else
	{
	db--;
	db -> r = 1000;
    }

fl_set_browser_topline(fdui -> color_browser, 1);

fl_select_browser_line(fdui -> color_browser, 1);

set_entry(0);

fl_unfreeze_form(fdui -> col_pic);

return 1;
}


int search_entry(int r, int g, int b)
{
register RGBdb *db = rgbdb;
int i, j, diffr, diffg, diffb;
unsigned int diff, mindiff;

mindiff = ~0;
for (i = j = 0; db->r < 256; db++, i++)
	{
	diffr = r - db->r;
	diffg = g - db->g;
	diffb = b - db->b;

#ifdef FL_LINEAR
	diff = (int)(3.0 * (FL_abs(r - db->r)) + (5.9 * FL_abs(g - db->g)) + (1.1 * (FL_abs(b - db->b))));
#else
	diff = (int)(3.0 * (diffr *diffr) + 5.9 * (diffg *diffg) +  1.1 *(diffb *diffb));
#endif

	if (mindiff > diff)
		{
    	mindiff = diff;
    	j = i;
		}
    }

return j;
}


void search_rgb(FL_OBJECT * ob, long q)
{
int r, g, b, i;
int top  = fl_get_browser_topline(fdui -> color_browser);

r = (int)fl_get_slider_value(fdui -> red_slider);
g = (int)fl_get_slider_value(fdui -> green_slider);
b = (int)fl_get_slider_value(fdui -> blue_slider);

fl_freeze_form(fdui -> col_pic);

fl_mapcolor(FL_FREE_COL4, r, g, b);

fl_redraw_object(fdui -> color_box);

i = search_entry(r, g, b);

/* change topline only if necessary */
if(i < top || i > (top+15)) fl_set_browser_topline(fdui -> color_browser, i-8);
fl_select_browser_line(fdui -> color_browser, i + 1);

fl_unfreeze_form(fdui -> col_pic);

set_entry(i);

}


/* change database */
void database_button_cb(FL_OBJECT * ob, long q)
{
const char *p = fl_show_input("Enter New Database Name", database_name);
char buf[512];

if (!p || strcmp(p, database_name) == 0) return;
strcpy(buf, p);
if(load_browser(buf))
	{
	if(database_name) free(database_name);
	database_name = strsave(buf);
	if(! database_name)
		{
		fprintf(stderr, "col_pic: database_button_cb(): could not allocate space for database_name, aborting.\n");
		
		exit(1);
		}
	}

if (load_browser(database_name))
	{
	fl_set_object_label(fdui -> database_button, database_name);
	}
else
	{
	fl_set_object_label(fdui -> database_button, "None");
	}

save_setting("database_name", database_name);
}


void serial_device_select_button_cb(FL_OBJECT *ob, long data)
{
char *p;

if(debug_flag)
	{
	fprintf(stderr, "serial_device_select_button_cb(): arg none\n");
	}

p = (char *)fl_show_input("Enter New serial device name", serial_device_name);
if(! p) return;

if(serial_device_name) free(serial_device_name);
serial_device_name = strsave(p);
if(! serial_device_name)
	{
	fprintf(stderr, "col_pic: serial_device_select_button_cb(): could not allocate space for serial_device_name\n");
	}

fl_set_object_label(ob, serial_device_name);

//fl_redraw_object(ob);

save_setting("serial_device_name", serial_device_name);

return;
} /* end function audio_input_device_select_button_cb */



void gamma_select_button_cb(FL_OBJECT *ob, long data)
{
char *p;
char temp[80];

if(debug_flag)
	{
	fprintf(stderr, "gamma_select_button_cb(): arg none\n");
	}

sprintf(temp, "%.2f", gamma_correction);
p = (char *)fl_show_input("Enter new gamma correction", temp);
if(! p) return;

gamma_correction = atof(p);

sprintf(temp, "%.2f", gamma_correction);
save_setting("gamma_correction", temp);

sprintf(temp, "gamma %.2f", gamma_correction);
fl_set_object_label(ob, temp);

} /* end function gamma_select_button_cb */


void gamma_off_button_cb(FL_OBJECT *ob, long data)
{
if(debug_flag)
	{
	fprintf(stderr, "gamma_select_button_cb(): arg none\n");
	}

gamma_off_flag = fl_get_button(ob);

if(gamma_off_flag)
	{
	fl_set_object_label(ob, "gamma off");
	}
else
	{
	fl_set_object_label(ob, "gamma on");	
	}

save_settings();

} /* end function gamma_off_button_cb */


void color_circle_dial_cb(FL_OBJECT *ob, long data)
{
char temp[80];
double dial_value;

if(debug_flag)
	{
	fprintf(stderr, "color_circle_dial_cb(): arg none\n");
	}

dial_value = fl_get_dial_value(ob);

selected_color = dial_value;

set_dial_color(selected_color, selected_saturation, selected_brightness);

sprintf(temp, "%.2f", dial_value);
fl_set_object_label(fdui -> color_degrees_output_field,  temp);

send_selected_color_saturation_brightness();

save_settings();
} /* end function color_circle_dial_cb */



void saturation_slider_cb(FL_OBJECT *ob, long data)
{
if(debug_flag)
	{
	fprintf(stderr, "saturation_slider_cb(): arg none\n");
	}

selected_saturation = fl_get_slider_value(ob);

set_dial_color(selected_color, selected_saturation, selected_brightness);

send_selected_color_saturation_brightness();

save_settings();

} /* end function saturation_slider_cb */


void brightness_slider_cb(FL_OBJECT *ob, long data)
{
if(debug_flag)
	{
	fprintf(stderr, "brightness_slider_cb(): arg none\n");
	}

selected_brightness= fl_get_slider_value(ob);

set_dial_color(selected_color, selected_saturation, selected_brightness);

send_selected_color_saturation_brightness();

save_settings();
} /* end function saturation_slider_cb */


