
/*
col_pic copyright (c) 2005-always Jan Panteltje

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _COL_PIC_H_
#define _COL_PIC_H_

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <pwd.h>
#include <string.h>
#include "getopt.h"
#include "strings.h"
#include <signal.h>
#include <pthread.h>
#include <fcntl.h>
#include <stdint.h>

#include <sys/ioctl.h>
#include <math.h>
#include <ctype.h>
#include <sys/wait.h>

#include <unistd.h> /* for libc5 */
#include <sys/io.h> /* for glibc */

#include <termcap.h>
#include <termios.h>

#include <forms.h>

#include "keys.h"

/**** Forms and Objects ****/
typedef struct
	{
	FL_FORM *col_pic;
	void *vdata;
	char *cdata;
	long  ldata;
	FL_OBJECT *main_form_text;
	FL_OBJECT *color_circle_dial;
	FL_OBJECT *color_degrees_output_field;
	FL_OBJECT *saturation_slider;
	FL_OBJECT *brightness_slider;
	FL_OBJECT *serial_device_select_button;
	FL_OBJECT *status_box;
	FL_OBJECT *database_button;
	FL_OBJECT *color_browser;
	FL_OBJECT *red_slider;
	FL_OBJECT *green_slider;
	FL_OBJECT *blue_slider;
	FL_OBJECT *color_box;
	FL_OBJECT *gamma_select_button;
	FL_OBJECT *gamma_off_button;
	FL_OBJECT *save_settings_button;
	FL_OBJECT *exit_button;

	} FD_col_pic;

extern FD_col_pic * create_form_col_pic(void);

#define READSIZE 4096

int debug_flag;
struct passwd *userinfo;
char *user_name;
char *home_dir;
char *serial_device_name;
int baudrate;
char *database_name;
int red;
int green;
int blue;
double gamma_correction;
double selected_color;
double selected_saturation;
double selected_brightness;
int selected_red;
int selected_green;
int selected_blue;
int selected_browser_line;
int selected_browser_topline;
int gamma_off_flag;
char *ip_address;
int port;
FILE *pnetcat;

#define LIMIT(x) ((((x)>0xffffff)?0xff0000:(((x)<=0xffff)?0:(x)&0xff0000))>>16)

#define DEFAULT_SERIAL_DEVICE_NAME			"/dev/ttyS0"
#define DEFAULT_BAUDRATE					19200
#define DEFAULT_DATABASE_NAME				"/usr/lib/X11/rgb.txt"
#define DEFAULT_GAMMA_CORRECTION			2.2
#define DEFAULT_SELECTED_BRIGHTNESS			100.0
#define DEFAULT_SELECTED_SATURATION			100.0
#define DEFAULT_SELECTED_COLOR_ANGLE		0.0


#define PROG_VERSION "col_pic-0.7.2"

#include "col_pic_proto.h"

#endif /* _COL_PIC_H_ */

