
/*
col_pic copyright (c) 2005 Jan Panteltje

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "forms.h"
#include <stdlib.h>
#include "col_pic.h"


//void one_second_tick(int sig);


FD_col_pic *fdui;
char *mydata;

FD_col_pic *create_form_col_pic(void)
{
FL_OBJECT *obj;
fdui = (FD_col_pic *) fl_calloc(1, sizeof(*fdui));

fl_set_idle_callback(idle_cb, 0);

fdui -> col_pic = fl_bgn_form(FL_NO_BOX, 500, 375);

obj = fl_add_box(FL_UP_BOX, 0, 0, 500, 375,"");

fdui -> main_form_text = obj =\
	fl_add_text(FL_NORMAL_TEXT, 100, 5, 200, 20, "Panteltje (c) col_pic");
	fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);

fdui -> color_browser = obj =\
	fl_add_browser(FL_HOLD_BROWSER, 10, 30, 205, 290, "");
	fl_set_browser_fontstyle(obj, FL_FIXED_STYLE); 
	fl_set_object_callback(obj, color_browser_cb, 0);
            
fdui -> red_slider = obj =\
	fl_add_valslider(FL_VERT_FILL_SLIDER, 225, 75, 30, 200, "");
//	fl_set_object_color(obj, FL_INDIANRED, FL_RED);
	fl_set_object_color(obj, FL_DARKER_COL1, FL_RED);
	fl_set_slider_bounds(obj, 0, 255);
	fl_set_slider_precision(obj, 0);
	fl_set_object_callback(obj, search_rgb, 0);
	fl_set_slider_return(obj, 0);

fdui -> green_slider = obj =\
	fl_add_valslider(FL_VERT_FILL_SLIDER, 255, 75, 30, 200, "");
//	fl_set_object_color(obj, FL_INDIANRED, FL_GREEN);
	fl_set_object_color(obj, FL_DARKER_COL1, FL_GREEN);
	fl_set_slider_bounds(obj, 0, 255);
	fl_set_slider_precision(obj, 0);
	fl_set_object_callback(obj, search_rgb, 1);
	fl_set_slider_return(obj, 0);

fdui -> blue_slider = obj =\
	fl_add_valslider(FL_VERT_FILL_SLIDER, 285, 75, 30, 200, "");
//	fl_set_object_color(obj, FL_INDIANRED, FL_BLUE);
	fl_set_object_color(obj, FL_DARKER_COL1, FL_BLUE);
	fl_set_slider_bounds(obj, 0, 255);
	fl_set_slider_precision(obj, 0);
	fl_set_object_callback(obj, search_rgb, 2);
	fl_set_slider_return(obj, 0);

fdui -> color_box = obj =\
	fl_add_box(FL_FLAT_BOX, 225, 30, 90, 35, "");
	fl_set_object_color(obj, FL_FREE_COL4, FL_FREE_COL4);
	fl_set_object_boxtype(obj, FL_BORDER_BOX);

fdui -> gamma_select_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 325, 30, 75, 30, "Gamma");
	fl_set_object_color(obj, FL_COL1, FL_COL1);
	fl_set_object_callback(obj, gamma_select_button_cb, 0);

fdui -> gamma_off_button = obj =\
	fl_add_button(FL_PUSH_BUTTON, 415, 30, 75, 30, "Gamma Off");
	fl_set_object_color(obj, FL_COL1, FL_YELLOW);
	fl_set_object_callback(obj, gamma_off_button_cb, 0);

fdui -> database_button = obj = \
	fl_add_button(FL_NORMAL_BUTTON, 10, 335, 210, 30, "");
	fl_set_object_color(obj, FL_COL1, FL_COL1);
	fl_set_object_callback(obj, database_button_cb, 0);

fdui -> color_circle_dial = obj =\
	fl_add_dial(FL_LINE_DIAL, 325, 75, 60, 60, "color");
	fl_set_object_callback(obj, color_circle_dial_cb, 0);
	fl_set_dial_return(obj, FL_RETURN_CHANGED);
	fl_set_dial_bounds(obj, 0, 360);
	fl_set_dial_cross(obj, 1);
	fl_set_dial_direction(obj, FL_DIAL_CCW);
	fl_set_object_color(obj, FL_COL1, FL_COL1);
//	fl_set_dial_step(obj, float step);
	
fdui -> color_degrees_output_field = obj =\
	fl_add_text(FL_NORMAL_TEXT, 335, 150, 40, 25, "");
//	fl_set_object_boxtype(obj,FL_DOWN_BOX);
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE);
	fl_set_object_lsize(obj, FL_SMALL_SIZE);
    fl_set_object_lcol(obj, FL_BLACK);
    fl_set_object_color(obj, FL_COL1, FL_COL1);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER);

fdui -> saturation_slider = obj =\
	fl_add_valslider(FL_VERT_NICE_SLIDER, 395, 75, 30, 110, "sat.");
	fl_set_slider_return(obj, FL_RETURN_CHANGED);
	fl_set_object_callback(obj, saturation_slider_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_COL1);
	fl_set_slider_bounds(obj, 100.0, 0.0);
	fl_set_slider_precision(obj, 0);
	fl_set_object_boxtype(obj, FL_FLAT_BOX);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER | FL_ALIGN_BOTTOM);

fdui -> brightness_slider = obj =\
	fl_add_valslider(FL_VERT_NICE_SLIDER, 435, 75, 30, 110, "bright.");
	fl_set_slider_return(obj, FL_RETURN_CHANGED);
	fl_set_object_callback(obj, brightness_slider_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_COL1);
	fl_set_slider_bounds(obj, 100.0, 0.0);
	fl_set_slider_precision(obj, 0);
	fl_set_object_boxtype(obj, FL_FLAT_BOX);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER | FL_ALIGN_BOTTOM);

fdui -> serial_device_select_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 225, 285, 90, 30, "");
	fl_set_object_color(obj, FL_COL1, FL_COL1);
	fl_set_object_callback(obj, serial_device_select_button_cb, 0);

fdui -> status_box = obj =\
	fl_add_box(FL_FLAT_BOX, 325, 285, 165, 30, "");
	fl_set_object_color(obj, FL_YELLOW, FL_YELLOW);
	fl_set_object_boxtype(obj, FL_BORDER_BOX);

fdui -> save_settings_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 235, 335, 80, 30, "Save Settings");
	fl_set_object_color(obj, FL_COL1, FL_DARKORANGE);
	fl_set_object_callback(obj, save_settings_button_cb, 0);

fdui -> exit_button =obj =\
	fl_add_button(FL_NORMAL_BUTTON, 410, 335, 80, 30, "EXIT");
	fl_set_object_callback(obj, exit_button_cb, 0);

fl_add_signal_callback(\
    SIGALRM, (FL_SIGNAL_HANDLER)one_second_tick, NULL); //&mydata);
alarm(1);

fl_end_form();

fl_scale_form(fdui -> col_pic, 1.1, 1.0);

fdui -> col_pic -> fdui = fdui;

return fdui;
} /* end function create_form_col_pic */



