

; This program is free software; you can redistribute it and/or modify
; it under the ; (at your option) any later version.
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


; Panteltje col LED RGB PWM driver with serial RS232 control.
; Copyright Jan Panteltje 2009-always
;
; CODE IS FOR gpasm-0.13.5 beta.


; Changes:
; 0.3:
; First public release.

; 0.4:
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.

; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


; Panteltje col LED RGB PWM driver with serial RS232 control.
; Copyright Jan Panteltje 2009-always
;
; CODE IS FOR gpasm-0.13.5 beta.


; Changes:
; 0.3:
; First public release.

; 0.4:
; No changes, just to stay compatible wioth col_pic version numbering.

; 0.5:
; No changes, just to stay compatible with col_pic version numbering.

; 0.6:
; Removed save flags from save_settings, and load flags from load_settings.
; Added 24 hour clock
; Added 5 programmable timers (0-4).
; timers in RAM 5 bytes hour, minute, r, g, b,
; timers saved in EEPROM.
; Put menu code in page 1 and put it in DT statemente.
; Added clock prescaler set and read commands.
; added fast mode

; 0.7:
; Disabled interrupt in help printing to prevent hanging if 'h' keeps being send.
; Added CdS LDR to ground on pin 2 and pin 6, using pullup in pin 6, using comparator1 with internal reference.
; Changed 'L' to set comparator reference level for light intensity compare, range 0-31, 0 causes light to be always on.
; This function can switch on the LEDs when it gets dark, for example also when the main lighting fails.
; Added 'l' to display comparator reference steps, 'on' of 'off' for the lights, and the actual light level measured in steps (0-31), where 0 is brightest and 31 is dark. 
; Updated help for the new functions.
; Clock out no longer to ouput pin.
; Moved red and green to other pins, as the old ones now in use by the comparators it seems.
; Removed pwm_init
; Changed the EEPROM programming routines for no W offset, and no calls but all jumps, removed EEPROM error flag.
; Fixed printing error caused by extra tx_w in EERPOM error report.


; 0.7.1:
; Added limited number of retries and timeouts in eeprom_write.
; Disabled interrupt disabling in eeprom_write.
; This all likely needed because of some error in the PIC itself, every now and then data errors programming the EEPROM
; Still seems to hang sometimes, but better now.

; 0.7.2:
; Moved all functions back to int routine, and removed associated flags in flasg3.
; Grounded RB4 pin to prevent going into low voltage programming mode.
; This also needs to be done during programming, added wire on top of PIC for that.
; Removed disable interrupst from functions, as already called from within interrupt with interrupts disabled.

; 0.7.3:
; set default clock speeds 65 237
; added nops so timing with lights off (in light sensor mode) is same as with lights on.

; 0.7.4:
; set default clock speeds 65 226
; better nops timing.



; 19200 Baud, 1 start bit, 8 data bits, 2 stop bits, NO PARITY! internal 4MHz oscillator, BRGH = 1.
#define BAUDRATE_RELOAD		D'12'		; for 19200 Bd and 4 MHz internal osc

;		Format commands:
; BnnnLF			set blue PWM, range 0-255.
; CnnnENTER			set clock calibration, range 0-255, saved in EEPROM
; c					prints clock speed.
; D                 set clock prescaler1 and clock speed defaults, deselect fast mode.
; FnnnENTER			set clock prescaler, range 0-255, default 255, saved in EEPROM.
; f                 print clock prescaler.
; GnnnLF			set green PWM, range 0-255.
; HnnENTER			set hour, range 0-23
; LnnENTER			set light sensitivity (0-31), default 0, saved in EEPROM.
; l				 	print light sensitivity, light comparator status (on or off), and actual measured light level (0-31) where 0 is brightest and 31 is dark.
; MnnENTER			set minute, range 0-59.
; PnENTER           program timer number n, n is range 0-4. will ask for hour, minute, red, green, blue, timers saved in EEPROM.
; p                 display timers, sorted, timer_nr, hour, minute, red, green, blue 
; RnnnLF			set red PWM, range 0-255.
; S					save settings in EEPROM.
; s					sends back R, G, B in the form of 3 integers.
; t					prints time
; X                 set fast mode, save in EEPROM.
; x                 reset fast mode, saved in EERPOM.

; Look at the defines below to see all commands.

; for second jump table, commands with numeric arguments.
#define COMMAND_OFF						D'0'
#define COMMAND_SET_RED					D'1'
#define COMMAND_SET_GREEN				D'2'
#define COMMAND_SET_BLUE				D'3'
#define COMMAND_SET_HOUR				D'4'
#define COMMAND_SET_MINUTE				D'5'
#define COMMAND_SET_CLOCK_SPEED			D'6'
#define COMMAND_PROGRAM_TIMERS_N		D'7'	
#define COMMAND_PROGRAM_TIMERS_H		D'8'
#define COMMAND_PROGRAM_TIMERS_M		D'9'
#define COMMAND_PROGRAM_TIMERS_R		D'10'
#define COMMAND_PROGRAM_TIMERS_G		D'11'
#define COMMAND_PROGRAM_TIMERS_B		D'12'
#define COMMAND_SET_CLOCK_PRESCALER		D'13'
#define COMMAND_SET_LIGHT_SENSITIVITY	D'14'

; The clock calibratuon
#define CLOCK_PRESCALER1_DEFAULT		D'226'
#define CLOCK_SPEED_DEFAULT				D'65'


; !!!!!!!!!!!!!! RB4 must be connected to ground to program _LVP_OFF to set low programming mode off!!!!
; define config fuses
; IF YOU WANT TO RUN VERIFY, BETTER HAVE COPY PROTECTION OFF ;-)
	__CONFIG _CP_OFF & _LVP_OFF & _WDT_OFF & _PWRTE_OFF & _INTOSC_OSC_NOCLKOUT & _BOREN_OFF & _DATA_CP_OFF &_MCLRE_OFF

; when !MRCLRE is asserted in INTOSC or RC mode, the internal clock oscillator is disabled.

; include PIC register definitions
	PROCESSOR	p16f648a
	include		<p16f648a.inc>


; define register file variables
red					equ	0x20		; saved in EEPROM
green				equ	0x21		; saved in EEPROM
blue				equ	0x22		; saved in EEPROM
digit_in			equ	0x23
command				equ	0x24
value				equ	0x25		
flags1				equ	0x26
delay_count			equ	0x27
light_sensitivity	equ	0x28		; saved in EEEPROM
temp_w				equ	0x29
temp_s				equ	0x2A
digit_cnt			equ	0x2B
temp1				equ	0x2C
temp2				equ	0x2D
temp3				equ	0x2E
count				equ	0x2F

red_sum				equ	0x30
green_sum			equ	0x31
blue_sum			equ	0x32
eeprom_address		equ	0x33
eeprom_data			equ	0x34
flags2				equ	0x35		; saved in EEPROM
flags3				equ	0x36		; volatile, cleared at start
tx_timeout			equ	0x37
temp				equ	0x38
temp_h				equ	0x39
temp_l				equ	0x3A
EEADRH				equ	0x3B
EEPGD				equ	0x3C
EEDAT				equ	0x3D
EEDATH				equ	0x3E
clock_1				equ 0x3F

clock_2				equ 0x40
seconds				equ 0x41
minutes				equ	0x42
hours				equ 0x43
clock_prescaler_1	equ	0x45		; saves in EEPROM
clock_speed			equ	0x44		; saved in EEPROM
selected_timer		equ	0x46
pri_cnt				equ	0x47
p_temp				equ	0x48
light_in			equ	0x49
eeprom_readback		equ	0x4A
ls_temp				equ	0x4B
li_count			equ	0x4C
eeprog_timeout		equ	0x4D
eeprog_retrys		equ	0x4E
;0x4F

hour0				equ	0x50		; all saved in EEPROM
minute0				equ	0x51
red0				equ	0x52
green0				equ	0x53
blue0				equ	0x54
hour1				equ	0x55
minute1				equ	0x56
red1				equ	0x57
green1				equ	0x58
blue1				equ	0x59
hour2				equ	0x5A
minute2				equ	0x5B
red2				equ	0x5C
green2				equ	0x5D
blue2				equ	0x5E
hour3				equ	0x5F

minute3				equ	0x60
red3				equ	0x61
green3				equ	0x62
blue3				equ	0x63
hour4				equ	0x64
minute4				equ	0x65
red4				equ	0x66
green4				equ	0x67
blue4				equ	0x68

; RAM:
;  0x20 -  0x7F in bank 0
;  0xA0 -  0xFF in bank 1
; 0x120 - 0x17F in bank 2
; 0x1F0 - 0x1FF in bank 3

; 0x70-0x7F the same in all banks (112-127)
s_pclath			equ	D'112'
s_fsr				equ	D'113'
int_fsr_save		equ	D'114'
offset_l			equ	D'115'
offset_h			equ	D'116'
temp4				equ	D'117'

; define flags1
FIRST_ZERO_SUPPRESSED_FLAG	equ	D'2'

; define flags2							
FAST_MODE_FLAG				equ	D'0'	; saved in EEPROM

; define flags3						; volatile flags
PROGAM_TIMERS_FLAG			equ	D'4'

; page macros
call_0 macro subroutine_name
	clrf	PCLATH					; Next call will go to page 0
	call	subroutine_name
	endm

call_1 macro subroutine_name
	bsf		PCLATH,	3				; Next call or jump will go to page 1	
	CALL    subroutine_name 	  	; Jump to function that starts in this page
	endm


; macros to save and restore W and status register in interrupt.
save_w_stat macro
	movwf   temp_w
	swapf   STATUS,W
	clrf	STATUS					; extra force bank 0 clears IRP, RP1, RP0
	movwf   temp_s
	movfw	PCLATH
	movwf	s_pclath
	movfw	FSR
	movwf	s_fsr
	endm

restore_w_stat macro
	movfw	s_fsr
	movwf	FSR
	movfw	s_pclath
	movwf	PCLATH
	swapf   temp_s,W
	movwf   STATUS
	swapf   temp_w,F
	swapf   temp_w,W
	endm

; code start
	org	0
	goto	reset_entry

	org	4
; interrupt entry point
; 6 MHz crystal --> 1.5 MHz instruction clock
; one instruction cycle = 1 / 1 500 000 = 0.666 uS
; OPTION_REG is 0xff at power up!

; do interrupt processing here
	save_w_stat					; save W and status

	banksel	0

; TEST
	bsf	PORTB,	3			

; test_serial_port_interrupt
	btfss	PIR1,	RCIF			; test if serial port interrupt
	goto	int_end

; read rx status	
; test framing error
	btfss	RCSTA,	FERR
	goto	test_overrun
; framing error
	goto	reset_rx_circuit

test_overrun:
	btfss	RCSTA,	OERR
	goto	get_rx_char
; overrun error

reset_rx_circuit:
; clear error flags
	bcf	RCSTA,	FERR
	bcf	RCSTA,	OERR
; restart rx
	bcf	RCSTA,	CREN
	bsf	RCSTA,	CREN
	goto	int_end					; discard character

get_rx_char:
; have serial char in RCREG

; jump table received characters, set your keys here!
	movfw	RCREG
	movwf	temp1

	movfw	temp1
	andlw	D'127'					; max 127 entries

	addwf	PCL,	1				; add to program counter

	goto	int_end					; 0		Null
	goto	int_end					; 1		ctrl A
	goto	int_end					; 2		ctrl B
	goto	int_end					; 3		ctrl C
	goto	int_end					; 4		ctrl D	
	goto	int_end					; 5		ctrl E
	goto	int_end					; 6		ctrl F
	goto	int_end					; 7		ctrl G
	goto	int_end					; 8		ctrl H
	goto	int_end					; 9		ctrl I

	goto	lf_command				; 10	ctrl J
	goto	int_end					; 11	ctrl K
	goto	int_end					; 12	ctrl L
	goto	cr_command				; 13	ctrl M
	goto	int_end					; 14	ctrl N
	goto	int_end					; 15	ctrl O
	goto	int_end					; 16	ctrl P
	goto	int_end					; 17	ctrl Q
	goto	int_end					; 18	ctrl R
	goto	int_end					; 19	ctrl S
	goto	int_end					; 20	ctrl T
	goto	int_end					; 21	ctrl U
	goto	int_end					; 22	ctrl V
	goto	int_end					; 23	ctrl W
	goto	int_end					; 24	ctrl X
	goto	int_end					; 25	ctrl Y
	goto	int_end					; 26	ctrl Z
	goto	int_end					; 27	ctrl [	escape
	goto	int_end					; 28	ctrl \
	goto	int_end					; 29	ctrl ]
	goto	int_end					; 30	ctrl `
	goto	int_end					; 31	ctrl -

	goto	int_end					; 32	' '
	goto	int_end					; 33	'!'
	goto	int_end					; 34	'"'
	goto	int_end					; 35	'#'
	goto	int_end					; 36	'$'
	goto	int_end					; 37	'%'
	goto	int_end					; 38	'&'
	goto	int_end					; 39	'''
	goto	int_end					; 40	'('
	goto	int_end					; 41	')'
	goto	int_end					; 42	'*'
	goto	int_end					; 43	'+'
	goto	int_end					; 44	','
	goto	int_end					; 45	'-'
	goto	int_end					; 46	'.'
	goto	int_end					; 47	'/'

	goto	process_digits_command	; 48	'0'
	goto	process_digits_command	; 49	'1'
	goto	process_digits_command	; 50	'2'
	goto	process_digits_command	; 51	'3'
	goto	process_digits_command	; 52	'4'
	goto	process_digits_command	; 53	'5'
	goto	process_digits_command	; 54	'6'
	goto	process_digits_command	; 55	'7'
	goto	process_digits_command	; 56	'8'
	goto	process_digits_command	; 57	'9'

	goto	int_end					; 58	':'
	goto	int_end					; 59	';'
	goto	int_end					; 60	'<'
	goto	int_end					; 61	'='
	goto	int_end					; 62	'>'
	goto	int_end					; 63	'?'
	goto	int_end					; 64	'@'

	goto	int_end					; 65	'A'
	goto	set_blue_command		; 66	'B'
	goto	set_clock_speed_command	; 67	'C'
	goto	set_clock_timer_defaults_command	; 68	'D'
	goto	int_end					; 69	'E'
	goto	set_clock_prescaler_command	; 70	'F'
	goto	set_green_command		; 71	'G'
	goto	set_hour_command		; 72	'H'
	goto	int_end					; 73	'I'
	goto	int_end					; 74	'J'
	goto	int_end					; 75	'K'
	goto	set_light_sensitivity_command	; 76	'L'
	goto	set_minute_command		; 77	'M'
	goto	int_end					; 78	'N'
	goto	int_end					; 79	'O'
	goto	program_timers_n_command	; 80	'P'
	goto	int_end					; 81	'Q'
	goto	set_red_command			; 82	'R'
	goto	save_settings_command	; 83	'S'
	goto	int_end					; 84	'T'
	goto	int_end					; 85	'U'
	goto	int_end					; 86	'V'
	goto	int_end					; 87	'W'
	goto	set_fast_mode_command	; 88	'X'
	goto	int_end					; 89	'Y'
	goto	int_end					; 90	'Z'

	goto	int_end					; 91	'['
	goto	int_end					; 92	'\'
	goto	int_end					; 93	']'
	goto	int_end					; 94	'^'
	goto	int_end 				; 95	'_'
	goto	int_end					; 96	'`'
	goto	int_end					; 97	'a'
	goto	int_end					; 98	'b'
	goto	print_clock_speed_command	; 99	'c'
	goto	int_end					; 100	'd'
	goto	int_end					; 101	'e'
	goto	print_clock_prescaler_command	; 102	'f'
	goto	int_end					; 103	'g'
	goto	print_help_command		; 104	'h'
	goto	int_end					; 105	'i'
	goto	int_end					; 106	'j'
	goto	int_end					; 107	'k'
	goto	print_light_sensitivity_command					; 108	'l'
	goto	int_end					; 109	'm'
	goto	int_end					; 110	'n'
	goto	int_end					; 111	'o'
	goto	print_timers_command	; 112	'p'
	goto	int_end					; 113	'q'
	goto	int_end					; 114	'r'
	goto	send_status_command		; 115	's'
	goto	print_time_command		; 116	't'
	goto	int_end					; 117	'u'
	goto	send_version_command	; 118	'v'	
	goto	int_end					; 119	'w'
	goto	reset_fast_mode_command	; 120	'x'
	goto	int_end					; 121	'y'
	goto	int_end					; 122	'z'

	goto	int_end					; 123	'{'
	goto	int_end					; 124	'|'
	goto	int_end					; 125	'}'
	goto	int_end					; 126	'"'
	goto	int_end					; 127	delete

; jump table LF processing numeric commands
lf_command:
cr_command:
; If zero digits were entered, do nothing
	movlw	D'0'
	subwf	digit_cnt,	W
	btfsc	STATUS,	Z							; if zero digits do nothing
	goto	int_end				

	movfw	command
	andlw	D'15'								; limit max index in table
	addwf	PCL,	1							; jump is one location, add offset

	goto	int_end								; 0 here if no numeric command was selected
	goto	end_set_red_command					; 1
	goto	end_set_green_command				; 2
	goto	end_set_blue_command				; 3
	goto	end_set_hour_command				; 4
	goto	end_set_minute_command				; 5
	goto	end_set_clock_speed_command			; 6
	goto	end_program_timers_n_command		; 7
	goto	end_program_timers_h_command		; 8
	goto	end_program_timers_m_command		; 9
	goto	end_program_timers_r_command		; 10
	goto	end_program_timers_g_command		; 11
	goto	end_program_timers_b_command		; 12
	goto	end_set_clock_prescaler_command		; 13
	goto	end_set_light_sensitivity_command	; 14
	goto	int_end								; 15

; these commands have no numeric argument
print_help_command:
; print help
	clrf	offset_h
	clrf	offset_l

pri_loop1:

	call_1	help_pri
	clrf 	PCLATH

	movwf	temp4

	movlw	D'0'
	subwf	temp4,	w
	btfsc	STATUS,	Z
	goto	pri_end

	movfw	temp4
	call	tx_w

	incf	offset_l
	skpnz
	incf	offset_h

	goto	pri_loop1

pri_end:
	clrf	PCLATH

	goto	int_end_clr

send_status_command:
	call	send_status
	goto	int_end_clr

send_version_command:
	call	print_id
	goto	int_end_clr

save_settings_command:
	call	save_settings
	goto	int_end_clr

print_time_command:
	movfw	hours
	call	print_w_ascii_dec

	movlw	':'
	call	tx_w

	movfw	minutes
	call	print_w_ascii_dec

	call	tx_crlf

	goto int_end_clr

print_timers_command:
	call	print_timers
	goto	int_end_clr

print_clock_speed_command:
	movfw	clock_speed
	call	print_w_ascii_dec
	call	tx_crlf
	goto	int_end_clr

print_clock_prescaler_command:
	movfw	clock_prescaler_1
	call	print_w_ascii_dec
	call	tx_crlf
	goto	int_end_clr

set_fast_mode_command:
	bsf		flags2, FAST_MODE_FLAG
	call	save_settings
	goto	int_end_clr

reset_fast_mode_command:
	bcf		flags2,	FAST_MODE_FLAG
	call	save_settings
	goto	int_end_clr

set_clock_timer_defaults_command:
	bcf		flags2,	FAST_MODE_FLAG

	movlw	CLOCK_PRESCALER1_DEFAULT
	movwf	clock_prescaler_1

	movlw	CLOCK_SPEED_DEFAULT
	movwf	clock_speed
	call	save_settings
	goto	int_end_clr

print_light_sensitivity_command:
	movfw	light_sensitivity
	call	print_w_ascii_dec
; print light comparator status
	movlw	' '
	call tx_w
	btfsc CMCON, C1OUT
	goto	ls_status_off
;ls_status_on:
	movlw	'o'
	call	tx_w
	movlw	'n'	
	call	tx_w
	goto	pri_lstat_light_in
ls_status_off:
	movlw	'o'
	call	tx_w
	movlw	'f'
	call	tx_w
	movlw	'f'
	call	tx_w

pri_lstat_light_in:
; find real light input and print it
; save light_sensitivity
	movfw	light_sensitivity
	movwf	ls_temp
; step down through all levels until comparator flips.
	movlw	D'32'
    movwf   light_sensitivity
try_more_light:
	decf	light_sensitivity	
	btfsc STATUS, Z
; if zero stop stepping down
	goto	restore_light_sensitivity

    call    set_light_sensitivity
	btfsc CMCON, C1OUT
	goto	try_more_light
; save value found 
	movfw	light_sensitivity
	movwf	light_in

restore_light_sensitivity:
	movfw	ls_temp
	movwf	light_sensitivity
	call	set_light_sensitivity

; print light_in
	movlw	' '
	call tx_w

	movfw	light_in	
	call	print_w_ascii_dec

	call	tx_crlf

	goto	int_end_clr

; these commands have a numeric argument
set_red_command:
	movlw	COMMAND_SET_RED
	movwf	command
	goto	command_end

set_green_command:
	movlw	COMMAND_SET_GREEN
	movwf	command
	goto	command_end
	
set_blue_command:
	movlw	COMMAND_SET_BLUE
	movwf	command
	goto	command_end

set_hour_command:
	movlw	COMMAND_SET_HOUR
	movwf	command
	goto	command_end

set_minute_command:
	movlw	COMMAND_SET_MINUTE
	movwf	command
	goto	command_end

set_clock_speed_command:
	movlw	COMMAND_SET_CLOCK_SPEED
	movwf	command
	goto	command_end

program_timers_n_command:
	movlw	'T'
	call	tx_w
	movlw	'i'
	call	tx_w
	movlw	'm'
	call	tx_w
	movlw	'e'
	call	tx_w
	movlw	'r'
	call	tx_w
	movlw	'('
	call	tx_w
	movlw	'0'
	call	tx_w
	movlw	'-'
	call	tx_w
	movlw	'4'
	call	tx_w
	movlw	')'
	call	tx_w
	movlw	'?'
	call	tx_w
	call	tx_crlf
	movlw	COMMAND_PROGRAM_TIMERS_N
	movwf	command
	goto	command_end

program_timers_h_command:
	movlw	COMMAND_PROGRAM_TIMERS_H
	movwf	command
	goto	command_end

program_timers_m_command:
	movlw	COMMAND_PROGRAM_TIMERS_M
	movwf	command
	goto	command_end

program_timers_r_command:
	movlw	COMMAND_PROGRAM_TIMERS_R
	movwf	command
	goto	command_end

program_timers_g_command:
	movlw	COMMAND_PROGRAM_TIMERS_G
	movwf	command
	goto	command_end

program_timers_b_command:
	movlw	COMMAND_PROGRAM_TIMERS_B
	movwf	command
	goto	command_end

set_clock_prescaler_command:
	movlw	COMMAND_SET_CLOCK_PRESCALER
	movwf	command
	goto	command_end

set_light_sensitivity_command:
	movlw	COMMAND_SET_LIGHT_SENSITIVITY
	movwf	command
	goto	command_end

; final processing of commands with numeric arguments, we have the number in 'value' now.
end_set_red_command:
	btfsc	flags3,	PROGAM_TIMERS_FLAG
	goto	end_program_timers_r_command
	movfw	value
	movwf	red
	goto	command_end

end_set_green_command:
	btfsc	flags3,	PROGAM_TIMERS_FLAG
	goto	end_program_timers_g_command
	movfw	value
	movwf	green
	goto	command_end

end_set_blue_command:
	btfsc	flags3,	PROGAM_TIMERS_FLAG
	goto	end_program_timers_b_command
	movfw	value
	movwf	blue
	goto	command_end

end_set_hour_command:
	btfsc	flags3,	PROGAM_TIMERS_FLAG
	goto	end_program_timers_h_command
	movfw	value
	movwf	hours
	goto	command_end

end_set_minute_command:
	btfsc	flags3,	PROGAM_TIMERS_FLAG
	goto	end_program_timers_m_command
	movfw	value
	movwf	minutes
; reset the seconds to zero
	clrf	seconds
	goto	command_end

end_set_clock_speed_command:
	movfw	value
	movwf	clock_speed
	call	save_settings
	goto	command_end

end_program_timers_n_command:
	movfw	value
	movwf	selected_timer

	bsf	flags3,	PROGAM_TIMERS_FLAG

; ask for hour
	movlw	'H'
	call	tx_w
	movlw	'?'
	call	tx_w
	call	tx_crlf

	movlw	COMMAND_SET_HOUR
	movwf	command

	goto	command_end

end_program_timers_h_command:
; if selected timer 0 to hour0, 1 to hour1 , 2 to hour2, 3 to hour3, 4 to hour4
; The offset is always 5 bytes between entries.
	movfw	selected_timer
	movwf	p_temp				; * 1
	addwf	p_temp,	1			; * 2
	addwf	p_temp,	1			; * 3
	addwf	p_temp,	1			; * 4
	addwf	p_temp,	1			; * 5

; get base in RAM where to store
	movlw	hour0
	movwf	FSR

; add p_temp = 5 x selected_timer
	movfw	p_temp
	addwf	FSR

; store value at  hour0 + (5 * seledted_timer)
	movfw	value
	movwf	INDF

; ask for minute
	movlw	'M'
	call	tx_w
	movlw	'?'
	call	tx_w
	call	tx_crlf

	movlw	COMMAND_SET_MINUTE
	movwf	command

	goto	command_end


end_program_timers_m_command:
	movfw	value
; if selected timer 0 to hour0, 1 to hour1 , 2 to hour2, 3 to hour3, 4 to hour4
; The offset is always 5 bytes between entries.
	movfw	selected_timer
	movwf	p_temp				; * 1
	addwf	p_temp,	1			; * 2
	addwf	p_temp,	1			; * 3
	addwf	p_temp,	1			; * 4
	addwf	p_temp,	1			; * 5

; get base in RAM where to store
	movlw	minute0
	movwf	FSR

; add p_temp = 5 x selected_timer
	movfw	p_temp
	addwf	FSR

; store value at  hour0 + (5 * seledted_timer)
	movfw	value
	movwf	INDF

; ask for red
	movlw	'R'
	call	tx_w
	movlw	'?'
	call	tx_w
	call	tx_crlf

	movlw	COMMAND_SET_RED
	movwf	command

	goto	command_end


end_program_timers_r_command:
	movfw	value
; if selected timer 0 to hour0, 1 to hour1 , 2 to hour2, 3 to hour3, 4 to hour4
; The offset is always 5 bytes between entries.
	movfw	selected_timer
	movwf	p_temp				; * 1
	addwf	p_temp,	1			; * 2
	addwf	p_temp,	1			; * 3
	addwf	p_temp,	1			; * 4
	addwf	p_temp,	1			; * 5

; get base in RAM where to store
	movlw	red0
	movwf	FSR

; add p_temp = 5 x selected_timer
	movfw	p_temp
	addwf	FSR

; store value at  hour0 + (5 * seledted_timer)
	movfw	value
	movwf	INDF

; ask for green
	movlw	'G'
	call	tx_w
	movlw	'?'
	call	tx_w
	call	tx_crlf

	movlw	COMMAND_SET_GREEN
	movwf	command

	goto	command_end


end_program_timers_g_command:
	movfw	value
; if selected timer 0 to hour0, 1 to hour1 , 2 to hour2, 3 to hour3, 4 to hour4
; The offset is always 5 bytes between entries.
	movfw	selected_timer
	movwf	p_temp				; * 1
	addwf	p_temp,	1			; * 2
	addwf	p_temp,	1			; * 3
	addwf	p_temp,	1			; * 4
	addwf	p_temp,	1			; * 5

; get base in RAM where to store
	movlw	green0
	movwf	FSR

; add p_temp = 5 x selected_timer
	movfw	p_temp
	addwf	FSR

; store value at  hour0 + (5 * seledted_timer)
	movfw	value
	movwf	INDF

; ask for blue
	movlw	'B'
	call	tx_w
	movlw	'?'
	call	tx_w
	call	tx_crlf

	movlw	COMMAND_SET_BLUE
	movwf	command

	goto	command_end


end_program_timers_b_command:
	movfw	value
; if selected timer 0 to hour0, 1 to hour1 , 2 to hour2, 3 to hour3, 4 to hour4
; The offset is always 5 bytes between entries.
	movfw	selected_timer
	movwf	p_temp				; * 1
	addwf	p_temp,	1			; * 2
	addwf	p_temp,	1			; * 3
	addwf	p_temp,	1			; * 4
	addwf	p_temp,	1			; * 5

; get base in RAM where to store
	movlw	blue0
	movwf	FSR

; add p_temp = 5 x selected_timer
	movfw	p_temp
	addwf	FSR

; store value at  hour0 + (5 * seledted_timer)
	movfw	value
	movwf	INDF

; report result of user input
	call	print_timers

	bcf	flags3,	PROGAM_TIMERS_FLAG

; save status in EEPROM
	call	save_settings
	goto	command_end

end_set_clock_prescaler_command:
	movfw	value
	movwf	clock_prescaler_1

; save in EEPROM
	call	save_settings
	goto	command_end

end_set_light_sensitivity_command:
	movfw	value
	andlw	D'31'
	movwf	light_sensitivity

	call	set_light_sensitivity
	
	call	save_settings
	goto	command_end

process_digits_command:
 	movlw	D'48'
	subwf	RCREG,	W			; digit now in W

	movwf	digit_in

; value = value * 10
; value += RCREG

	movfw	value				; W = original value
; look, I know about rlf, but we have 4096 words available.
	addwf	value				; value * 2
	addwf	value				; value * 3
	addwf	value				; value * 4
	addwf	value				; value * 5
	addwf	value				; value * 6
	addwf	value				; value * 7
	addwf	value				; value * 8
	addwf	value				; value * 9
	addwf	value				; value * 10

	movfw	digit_in			; input digit in W
	addwf	value				; add W to value

	incf	digit_cnt
	goto	int_end

; end of interrupt routines
command_end:
; reset the value, so we can continue for x, y, f, or z with 200ENTER
	clrf	value
	clrf	digit_cnt
	goto	int_end

int_end_clr:					; for non numeric commands, no digits expected.
	clrf	command

int_end:
	bcf	PORTB, 3

	movf	CMCON,	W			; read CMCON to end mismatch because of comparator output change

	bcf	INTCON,	T0IF			; timer 0 overflow interrupt flag
	bcf	INTCON,	RBIF			; PORTB change interrupt flag bit
	bcf	INTCON,	INTF			; RB0/INT
	bcf	PIR1,	EEIF			; EEPROM write complete interrupt flag
	bcf	PIR1,	CMIF			; peripheral interrupts: clear comparator interrupt
	bcf	PIR1,	TMR1IF			; timer1 overflow interrupt flag
	bcf	PIR1,	TMR2IF			; timer2 equals PR2 interrupt flag
	bcf	PIR1,	RCIF			; clear the serial interrupt flag

	restore_w_stat				; get back W and status

	retfie

reset_entry:
; initialize IO output latches

	banksel	0

; PORTA bank 0, address 0x05
	clrf	PORTA				; init PORTA all output latches to zero

; PORTB bank 0, address 0x06
	clrf	PORTB				; init PORTB all output latches to zero

; IO pin assignment PORTA
LDR_IN				equ	3		; RA3/AN3/CMP1		pin 2   light sensor in			this is used by comparator 1, other input comparator 1 on Vref.		CM2:CM0 = 010	CIS = 1 
GREEN_PWM			equ	6		; PORTA				pin 15	green	
                                ; RB0/INT           pin 6   is in parallel with LDR_IN, and global pullups are active, so pin 6 pulls up the LDR with about 200 uA.
BLUE_PWM			equ	7		; PORTA				pin 16	blue	

; IO pin assignment PORTB
RED_PWM				equ	5		; PORTB				pin 11	red


; RXD							RB1 pin 7		rx  data	
; TXD							RB2 pin 8		tx data
; Vss							pin 5
; Vdd							pin 14
; program data					pin 13
; progrem clock					pin 12
; Vpp							pin 4

; intialize IO direction
; TRISA bank 1, address 0x85
; _ _ TRISA5 TRISA4 TRISA3 TRISA2 TRISA1 TRISA0
; TRISA 3 read only and reads always 1, rest R/W
; 1 = input, 0 = output
	banksel TRISA
	bsf	TRISA,	0				; n.c.		comparator 1 for CIS=0 input
	bsf	TRISA,	1				; n.c.		comparator 2 for CIS=0 input
	bsf	TRISA,	2				; n.c.		comparator 2 for CIS=1 input
	bsf	TRISA,	3				; LDR in	comparator 1 for CIS=1 input
	bcf	TRISA,	4				; red PWM out
	bsf	TRISA,	5				; Vpp / !MCLR
	bcf	TRISA,	6				; green PWM out
	bcf	TRISA,	7				; blue PWM out


; TRISB, the UART pins are here, address 0x86, bank 1
; 1 = input, 0 = output
	banksel TRISB
	bsf	TRISB,	0				; rb0 INT, nc
	bsf	TRISB,	1				; rb1, UART in
	bcf	TRISB,	2				; rb2, UART output
	bcf	TRISB,	3				; rb3, PWM out
	bsf	TRISB,	4				; rb4, connected to ground ivm low voltage programming 
	bcf	TRISB,	5				; rb5, red PWM out
	bsf	TRISB,	6				; rb6, program clock input
	bsf	TRISB,	7				; rb7, program data, input


; OPTION_REG bank 1, address 0x81, bank 1
; !GPPU INTEDG T0CS T0SE PSA PS2 PS1 PS0
	banksel OPTION_REG
	movlw	B'00000001'			; prescaler 1
	movwf	OPTION_REG
	bcf	OPTION_REG,	NOT_RBPU	; yes pullups 

; init vreference
	banksel VRCON
	bsf	VRCON,	VREN 			; VREN reference enable	1
	bcf	VRCON,	VROE			; diable ouput to pin
	bcf	VRCON,	VRR				; 0 = high range
	bsf	VRCON,	VR3				; VR3:VR0 low range Vref = A / 24 * Vdd, high range Vref = (Vdd / 4) + A * (Vdd / 32), 
	bcf	VRCON,	VR2				; 5 1045 mV, 6 1250 mV, 7 1450 mV, 8 1660 mV
	bcf	VRCON,	VR1
	bcf	VRCON,	VR0

; init comparator 1 (light level), other input on Vref.	
	banksel	CMCON
	bcf CMCON,	C2INV			; invert comparator 2 output
	bcf CMCON,	C1INV			; invert comparator 1 output
	bsf	CMCON,	CIS				; comparator input switch
								; 	When CM2:CM0 = 001
								;		1 = C1 VIN- connects to RA3
								;		0 = C1 VIN- connects to RA0
								; 	When CM2:CM0 = 010
								; 		1 = C1 VIN- connects to RA3		C2 VIN- connects to RA2
								;		0 = C1 VIN- connects to RA0		C2 VIN- connects to RA1
	bcf	CMCON,	CM2				; CM2:CM0: Comparator Mode, use 010 
	bsf	CMCON,	CM1
	bcf	CMCON,	CM0
; 10s delay
	banksel	0
	movlw	D'10'
	movwf	delay_count
delay_loop:
	decf	delay_count,f
	btfss	STATUS,	Z		
	goto	delay_loop		

	banksel	CMCON
	MOVF   CMCON,	F			; Read CMCON to end change condition

	banksel	PIR1
	BCF    PIR1, CMIF			; Clear pending interrupts

; USART address 0x98, bank 1
	banksel	TXSTA
	clrf	TXSTA
	bsf	TXSTA,	CSRC			; async mode
	bsf	TXSTA,	TXEN			; transmit enable bit
	bsf	TXSTA,	BRGH			; high baudrate select bit

; SPBRG baudrate generator register, address 0x99, bank 1
	banksel	SPBRG
	movlw	BAUDRATE_RELOAD
	movwf	SPBRG
	
; peripheral interupt register PIE1, address 0x8c, bank 1
	banksel	PIE1
	clrf	PIE1
	bsf	PIE1,	RCIE			; USART receive interrupt enable
;	bsf	PIE1,	EEIE			; EEPROM write complete interrupt enable
;	bsf	PIE1,	ADIE			; AD converter interrupt enable (12F675 only)
;	bsf	PIE1,	TMR1IE			; timer 1 overflow interrupt enable
;	bsf	PIE1,	TMR2IE			; timer 2 equals PR2
;	bsf	PIE1,	CMIE			; comparator interrupt enable

; receive status and control register, address 0x18, bank 0
	banksel	RCSTA
	clrf	RCSTA
	bsf	RCSTA,	SPEN			; serial port enable	
	bsf	RCSTA,	CREN			; continuous receive enable bit

; init variables
	banksel 0
	clrf	command
	clrf	value
	clrf	digit_cnt

; flags to zero
	clrf	flags1
	clrf	flags2
	clrf	flags3

	banksel	INTCON
; enable gobal and peripheral interrupt
	clrf	INTCON
	bsf	INTCON,	PEIE			; peripheral interrupts enable
;	bsf	INTCON,	T0IE			; timer 0 overflow interrupt enable
;	bsf	INTCON,	INTE			; RB0/INT interrupt enable
;	bsf	INTCON,	GPIE			; port change interrupt enable
	bsf	INTCON,	GIE				; global interrupt enable

; load settings from eeprom
	call	load_settings		; this sets flags1

; change prescaler from watchdog timer to timer 0, see pdf datasheet page 49.
	clrwdt						; clear watch dog timer
	banksel TMR0
	clrf	TMR0				; clear timer 0 and prescaler

	banksel OPTION_REG
	movlw	b'00000000'
	movwf	OPTION_REG			;

	banksel	0

main_loop:

; increment clock_prescaler_1
	incf	clock_1

; test 255
	movfw	clock_prescaler_1
	subwf	clock_1, w
	btfss	STATUS, Z
	goto	test_timers

; test if fast mode, if so only look at hours.
	btfsc	flags2,	FAST_MODE_FLAG
	goto	fast_mode

; one tick
	clrf	clock_1
; increment clock_2
	incf	clock_2

; test clock_speed ticks
	movfw	clock_speed
	subwf	clock_2, w
	btfss	STATUS, Z
	goto	test_timers

; one second
	clrf	clock_2
	incf	seconds

; test 60 seconds	
	movlw	D'60'
	subwf	seconds, w
	btfss	STATUS, Z
	goto	test_timers

; one_minute
	clrf	seconds	
	incf	minutes

; test 60 minutes
	movlw	D'60'
	subwf	minutes,	w
	btfss	STATUS,	Z	
	goto	test_timers

fast_mode:
; one hour
	clrf	minutes
	incf	hours

; test 24 hours
	movlw	D'24'
	subwf	hours,	w
	btfss	STATUS, Z
	goto	test_timers	

; one day
	clrf	hours
;	goto	delay_1


test_timers:
; test timer0 hour
	movfw	hour0
	subwf	hours,	w
	btfss	STATUS, Z
	goto	test_timer_1

; test timer0 minute
	movfw	minute0
	subwf	minutes, w
	btfss	STATUS, Z
	goto	test_timer_1

; timer0 match
; set red
	movfw	red0
	movwf	red
; set green
	movfw	green0
	movwf	green
; set blue
	movfw	blue0
	movwf	blue		
	goto	delay_1

test_timer_1:
; test timer1 hour
	movfw	hour1
	subwf	hours,	w
	btfss	STATUS, Z
	goto	test_timer_2

; test timer1 minute
	movfw	minute1
	subwf	minutes, w
	btfss	STATUS, Z
	goto	test_timer_2

; timer1 match
; set red
	movfw	red1
	movwf	red
; set green
	movfw	green1
	movwf	green
; set blue
	movfw	blue1
	movwf	blue		
	goto	delay_1

test_timer_2:
; test timer2 hour
	movfw	hour2
	subwf	hours,	w
	btfss	STATUS, Z
	goto	test_timer_3

; test timer2 minute
	movfw	minute2
	subwf	minutes, w
	btfss	STATUS, Z
	goto	test_timer_3

; timer2 match
; set red
	movfw	red2
	movwf	red
; set green
	movfw	green2
	movwf	green
; set blue
	movfw	blue2
	movwf	blue		
	goto	delay_1

test_timer_3:
; test timer3 hour
	movfw	hour3
	subwf	hours,	w
	btfss	STATUS, Z
	goto	test_timer_4

; test timer3 minute
	movfw	minute3
	subwf	minutes, w
	btfss	STATUS, Z
	goto	test_timer_4

; timer3 match
; set red
	movfw	red3
	movwf	red
; set green
	movfw	green3
	movwf	green
; set blue
	movfw	blue3
	movwf	blue		
	goto	delay_1

test_timer_4:
; test timer4 hour
	movfw	hour4
	subwf	hours,	w
	btfss	STATUS, Z
	goto	delay_1

; test timer4 minute
	movfw	minute4
	subwf	minutes, w
	btfss	STATUS, Z
	goto	delay_1

; timer4 match
; set red
	movfw	red4
	movwf	red
; set green
	movfw	green4
	movwf	green
; set blue
	movfw	blue4
	movwf	blue		

delay_1:
	nop
	nop
	nop
	nop
	nop
delay_2:
	nop

; test for comparator 1 light on
test_light:
	btfss CMCON, C1OUT			; 1 !true	1		2 true		2
	goto	do_rgb				; 2	!true	3

; 2
; lights_off
	bcf PORTB,  RED_PWM			; 1	3
	bcf PORTA,  GREEN_PWM		; 1 4
	bcf PORTA,  BLUE_PWM		; 1 5
; 5

; 5 - 3 is 2 slower, so comment out 2 nops in the delay

; timing compensation to prevent the clock from running too fast if lights off.

; 8 nops to substitute for red routine, MINUS 
;	nop
;	nop
	nop
	nop
	nop
	nop
	nop
	nop

; 8 nops to substitue for green routine
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
; 8 nops to substitute for blue routine
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop

	goto	col_done
;	goto	main_loop

do_rgb:
do_red:
	bcf	STATUS, C					; 1
	movfw	red						; 1 2
	addwf	red_sum					; 1 3
	btfsc STATUS, C					; 1 4 	2 if true 5
	goto	red_on					; 2 6
; red off
	bcf	PORTB,	RED_PWM						; 1 6
	goto	do_green						; 2 8
red_on:
	bsf	PORTB, RED_PWM				; 1 8
	nop								; 1 to compensate for btfsc being 2  7
; 8
do_green:
	bcf	STATUS, C
	movfw	green
	addwf	green_sum
	btfsc STATUS, C
	goto	green_on
; green off
	bcf	PORTA,	GREEN_PWM
	goto	do_blue
green_on:			
	bsf	PORTA, GREEN_PWM
	nop

do_blue:
	bcf		STATUS, C
	movfw	blue
	addwf	blue_sum
	btfsc	STATUS, C
	goto	blue_on
; blue off
	bcf	PORTA,	BLUE_PWM
	goto	col_done
blue_on:			
	bsf	PORTA, BLUE_PWM
	nop

col_done:
	goto	main_loop
; end of main loop




; ***************** subroutines ********************

wait_tx_empty:
	banksel	TXSTA
; make sure we have a timeout
	movlw	D'255'	
	movwf	tx_timeout
test_tx_empty:
	decfsz	tx_timeout,	1
	goto	test_txsta
	goto	tx_has_timed_out
test_txsta:
	btfss	TXSTA,	TRMT	
	goto	test_tx_empty
tx_has_timed_out:
	banksel	0
	return

; send byte in W
tx_digit_in_w:
	addlw	'0'				; zero
tx_w:
	movwf	TXREG
	call	wait_tx_empty
	return


tx_crlf:
	movlw	D'13'
	call	tx_w
	movlw	D'10'
	call	tx_w
	return


print_id:
	movlw	'P'
	call	tx_w
	movlw	'a'
	call	tx_w
	movlw	'n'
	call	tx_w
	movlw	't'
	call	tx_w
	movlw	'e'
	call	tx_w
	movlw	'l'
	call	tx_w
	movlw	't'
	call	tx_w
	movlw	'j'
	call	tx_w
	movlw	'e'
	call	tx_w
	movlw	' '
	call	tx_w
	movlw	'c'
	call	tx_w
	movlw	'o'
	call	tx_w
	movlw	'l'
	call	tx_w
	movlw	'_'
	call	tx_w
	movlw	'p'
	call	tx_w
	movlw	'i'
	call	tx_w
	movlw	'c'
	call	tx_w
	movlw	'-'
	call	tx_w
	movlw	'0'
	call	tx_w
	movlw	'.'
	call	tx_w
	movlw	'7'
	call	tx_w
	movlw	'.'
	call	tx_w
	movlw	'4'
	call	tx_w
	call tx_crlf
	return


print_w_ascii_dec:				; prints register W in ASCII decimal
	bsf	flags1,	FIRST_ZERO_SUPPRESSED_FLAG
	movwf	temp1
	clrf	count				; number of hundreds found
loop_hundreds:
	movlw	D'100'
	subwf	temp1
	btfss	STATUS,	C			; if no carry flag, no more hundreds, go count tenth		
	goto	count10				; substraction failed
	incf	count	
	goto	loop_hundreds
count10:
	movlw	D'0'
	subwf	count,	W
	btfsc	STATUS,	Z
	goto	suppress_first_zero

	bcf	flags1,	FIRST_ZERO_SUPPRESSED_FLAG

	movfw	count
	call	tx_digit_in_w			; print hundreds

suppress_first_zero:
	movlw	D'100'				; restore temp1 from one substract to many
	addwf	temp1	

	clrf	count				; number of tenth found
loop_tenth:
	movlw	D'10'
	subwf	temp1
	btfss	STATUS,	C			; if no carry flag no more tenth, only units left	
	goto	count1		
	incf	count
	goto	loop_tenth
count1:
	movlw	D'0'
	subwf	count,	W
	btfss	STATUS,	Z
	goto	print_tenth			; tenth not zero

; tenth zero
; test if zero supression was active in hundreds (first digit)
	btfsc	flags1,	FIRST_ZERO_SUPPRESSED_FLAG
	goto	print_units			; if first digit was not zero, print this zero	

print_tenth:
	movfw	count
	call	tx_digit_in_w			; print tenth

print_units:
	movlw	D'10'				; restore temp1 from 1 substract to many
	addwf	temp1

; units
	movfw	temp1
	call	tx_digit_in_w			; print units
	return

print_timers:
; print the timers
timer_pri:
	movlw	'0'
	call	tx_w

	movlw	' '
	call	tx_w

	movfw	hour0
	call	print_w_ascii_dec

	movlw	':'
	call	tx_w

	movfw	minute0
	call	print_w_ascii_dec

	movlw	' '
	call	tx_w

	movfw	red0
	call	print_w_ascii_dec

	movlw	' '
	call	tx_w

	movfw	green0
	call	print_w_ascii_dec

	movlw	' '
	call	tx_w

	movfw	blue0
	call	print_w_ascii_dec

	movlw	' '
	call	tx_w

	movlw	' '
	call	tx_w

	movlw	'1'
	call	tx_w

	movlw	' '
	call	tx_w

	movfw	hour1
	call	print_w_ascii_dec

	movlw	':'
	call	tx_w

	movfw	minute1
	call	print_w_ascii_dec

	movlw	' '
	call	tx_w

	movfw	red1
	call	print_w_ascii_dec

	movlw	' '
	call	tx_w

	movfw	green1
	call	print_w_ascii_dec

	movlw	' '
	call	tx_w

	movfw	blue1
	call	print_w_ascii_dec

	movlw	' '
	call	tx_w

	movlw	' '
	call	tx_w

	movlw	'2'
	call	tx_w

	movlw	' '
	call	tx_w

	movfw	hour2
	call	print_w_ascii_dec

	movlw	':'
	call	tx_w

	movfw	minute2
	call	print_w_ascii_dec

	movlw	' '
	call	tx_w

	movfw	red2
	call	print_w_ascii_dec

	movlw	' '
	call	tx_w

	movfw	green2
	call	print_w_ascii_dec

	movlw	' '
	call	tx_w

	movfw	blue2
	call	print_w_ascii_dec

	movlw	' '
	call	tx_w

	movlw	' '
	call	tx_w

	movlw	'3'
	call	tx_w

	movlw	' '
	call	tx_w

	movfw	hour3
	call	print_w_ascii_dec

	movlw	':'
	call	tx_w

	movfw	minute3
	call	print_w_ascii_dec

	movlw	' '
	call	tx_w

	movfw	red3
	call	print_w_ascii_dec

	movlw	' '
	call	tx_w

	movfw	green3
	call	print_w_ascii_dec

	movlw	' '
	call	tx_w

	movfw	blue3
	call	print_w_ascii_dec

	movlw	' '
	call	tx_w

	movlw	' '
	call	tx_w

	movlw	'4'
	call	tx_w

	movlw	' '
	call	tx_w

	movfw	hour4
	call	print_w_ascii_dec

	movlw	':'
	call	tx_w

	movfw	minute4
	call	print_w_ascii_dec

	movlw	' '
	call	tx_w

	movfw	red4
	call	print_w_ascii_dec

	movlw	' '
	call	tx_w

	movfw	green4
	call	print_w_ascii_dec

	movlw	' '
	call	tx_w

	movfw	blue4
	call	print_w_ascii_dec

	call	tx_crlf

	return



send_status:					; sends status report
; red=nnn
	banksel	0
	movlw	'r'
	call	tx_w
	movlw	'e'
	call	tx_w
	movlw	'd'
	call	tx_w
	movlw	'='
	call	tx_w
	movfw	red
	call	print_w_ascii_dec

; green=nnn
	movlw	' '
	call	tx_w
	movlw	'g'
	call	tx_w
	movlw	'r'
	call	tx_w
	movlw	'e'
	call	tx_w
	movlw	'e'
	call	tx_w
	movlw	'n'
	call	tx_w
	movlw	'='
	call	tx_w
	movfw	green
	call	print_w_ascii_dec

; blue=nnn
	movlw	' '
	call	tx_w
	movlw	'b'
	call	tx_w
	movlw	'l'
	call	tx_w
	movlw	'u'
	call	tx_w
	movlw	'e'
	call	tx_w
	movlw	'='
	call	tx_w
	movfw	blue
	call	print_w_ascii_dec

status_end:
	call	tx_crlf
	banksel	0
	return


eeprom_write:
	banksel	0
	movlw D'10'						; retries
	movwf	eeprog_retrys
eeprog_retry:
	decfsz	eeprog_retrys, 1
	goto	eeprog_it
; say Failed
	movlw ' '
	call	tx_w
	movlw	'F'
	call	tx_w
	movlw	'F'
	call	tx_w
	movlw	'a'
	call	tx_w
	movlw	'i'
	call	tx_w
	movlw	'l'
	call	tx_w
	movlw	'e'
	call	tx_w
	movlw	'd'
	call	tx_w
	call	tx_crlf
; cancel command
	return

eeprog_it:
	movfw	eeprom_address			; get address

	banksel	EEADR
	movwf	EEADR					; set EEPROM address

	banksel	0
	movfw	eeprom_data				; get data
; EEDATA, EECON1, EECON2 in bank 1

	banksel	EEDATA
	movwf	EEDATA					; set EEPROM data

	bsf	EECON1,	WREN				; enable write to eeprom

; unlock write
	movlw	0x55					; unlock write
	movwf	EECON2				

	movlw	0xAA
	movwf	EECON2

	bsf	EECON1,	WR					; begin write

; poll for write complete
; make sure we have a timeout
	banksel 0
	movlw D'255'
	movwf	eeprog_timeout
poll_eeprom_write_complete:
	banksel	0
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	decfsz	eeprog_timeout,	1
	goto	test_eeprom_write_complete
; timeout, programming failed
	banksel	0
	movlw 'w'
	call tx_w
	movlw 'r'
	call tx_w
	movlw 'i'
	call tx_w
	movlw 't'
	call tx_w
	movlw 'e'
	call tx_w
	movlw ' '
	call tx_w
	movlw 't'
	call tx_w
	movlw 'i'
	call tx_w
	movlw 'm'
	call tx_w
	movlw 'o'
	call tx_w
	movlw 'u'
	call tx_w
	movlw 't'
	call tx_w
	movlw ' '
	call tx_w
; address=nnn	
	movlw	'a'
	call	tx_w
	movlw	'd'
	call	tx_w
	movlw	'd'
	call	tx_w
	movlw	'r'
	call	tx_w
	movlw	'e'
	call	tx_w
	movlw	's'
	call	tx_w
	movlw	's'
	call	tx_w
	movlw	'='
	call	tx_w
	movfw	eeprom_address
	call	print_w_ascii_dec
	call	tx_crlf
	goto	eeprog_error

test_eeprom_write_complete:
	banksel	EECON1
	btfsc	EECON1,	WR
	goto	poll_eeprom_write_complete

	bcf	EECON1,	WREN				; disable writes to eeprom

; read back data written
	bsf	EECON1, RD					; read byte written into EEDATA
	movfw	EEDATA

	banksel	0
	movwf	eeprom_readback

	movfw	eeprom_data				; requested data to W
	subwf	eeprom_readback,	W	; compare to requested
; STATUS is in all banks
	btfsc	STATUS,	Z				; skip if  error
	return							; return OK bank 0

; eeprom_write_error
; eeprom write result
	banksel	0
	movlw	'e'
	call	tx_w
	movlw	'e'
	call	tx_w
	movlw	'p'
	call	tx_w
	movlw	'r'
	call	tx_w
	movlw	'o'
	call	tx_w
	movlw	'm'
	call	tx_w
	movlw	' '
	call	tx_w
	movlw	'w'
	call	tx_w
	movlw	'r'
	call	tx_w
	movlw	'i'
	call	tx_w
	movlw	't'
	call	tx_w
	movlw	'e'
	call	tx_w
	movlw	' '
	call	tx_w
	movlw	'r'
	call	tx_w
	movlw	'e'
	call	tx_w
	movlw	's'
	call	tx_w
	movlw	'u'
	call	tx_w
	movlw	'l'
	call	tx_w
	movlw	't'
	call	tx_w
	movlw	' '
; address=nnn	
	call	tx_w
	movlw	'a'
	call	tx_w
	movlw	'd'
	call	tx_w
	movlw	'd'
	call	tx_w
	movlw	'r'
	call	tx_w
	movlw	'e'
	call	tx_w
	movlw	's'
	call	tx_w
	movlw	's'
	call	tx_w
	movlw	'='
	call	tx_w
	movfw	eeprom_address
	call	print_w_ascii_dec
	movlw	' '
	call	tx_w
; original=nnn
	movlw	'w'
	call	tx_w
	movlw	'r'
	call	tx_w
	movlw	'i'
	call	tx_w
	movlw	't'
	call	tx_w
	movlw	't'
	call	tx_w
	movlw	'e'
	call	tx_w
	movlw	'n'
	call	tx_w
	movlw	'='
	call	tx_w
	movfw	eeprom_data
	call	print_w_ascii_dec
	movlw	' '
; read=nnn
	call	tx_w
	movlw	'r'
	call	tx_w
	movlw	'e'
	call	tx_w
	movlw	'a'
	call	tx_w
	movlw	'd'
	call	tx_w
	movlw	' '
	call	tx_w
	movlw	'b'
	call	tx_w
	movlw	'a'
	call	tx_w
	movlw	'c'
	call	tx_w
	movlw	'k'
	call	tx_w
	movlw	'='
	call	tx_w
	movfw	eeprom_readback
	call	print_w_ascii_dec	
	call	tx_crlf

eeprog_error:
; retry for this EEPROM location here.
	banksel	EECON1
	bcf	EECON1,	WREN				; disable writes to eeprom

; say retry
	banksel	0
	movlw 'r'
	call tx_w
	movlw 'e'
	call tx_w
	movlw 't'
	call tx_w
	movlw 'r'
	call tx_w
	movlw 'y'
	call tx_w
	call	tx_crlf

	goto	eeprog_retry			; try to program this EEPROM location again
	banksel	0
	return


eeprom_read:						; address in eeprom_address, returns data in W
	banksel	0
	movfw	eeprom_address

	banksel	EEADR
	movwf	EEADR	

	bsf	EECON1,	RD
	movfw	EEDATA

	banksel	0
	return


save_settings:
	banksel	0
	movlw	D'0'
; write red
	movwf	eeprom_address			; 0
	movfw	red
	movwf	eeprom_data
	call	eeprom_write
; write green
	incf	eeprom_address			; 1
	movfw	green
	movwf	eeprom_data
	call	eeprom_write
; write blue
	incf	eeprom_address			; 2
	movfw	blue
	movwf	eeprom_data
	call	eeprom_write
; write clock_prescaler_1
	incf	eeprom_address			; 6
	movfw	clock_prescaler_1
	movwf	eeprom_data
	call	eeprom_write
; write clock_speed
	incf	eeprom_address			; 7
	movfw	clock_speed
	movwf	eeprom_data
	call	eeprom_write
; timer 0
	incf	eeprom_address
	movfw	hour0
	movwf	eeprom_data
	call	eeprom_write

	incf	eeprom_address
	movfw	minute0
	movwf	eeprom_data
	call	eeprom_write

	incf	eeprom_address
	movfw	red0
	movwf	eeprom_data
	call	eeprom_write

	incf	eeprom_address
	movfw	green0
	movwf	eeprom_data
	call	eeprom_write

	incf	eeprom_address
	movfw	blue0
	movwf	eeprom_data
	call	eeprom_write
; timer 1
	incf	eeprom_address
	movfw	hour1
	movwf	eeprom_data
	call	eeprom_write

	incf	eeprom_address
	movfw	minute1
	movwf	eeprom_data
	call	eeprom_write

	incf	eeprom_address
	movfw	red1
	movwf	eeprom_data
	call	eeprom_write

	incf	eeprom_address
	movfw	green1
	movwf	eeprom_data
	call	eeprom_write

	incf	eeprom_address
	movfw	blue1
	movwf	eeprom_data
	call	eeprom_write
; timer 2
	incf	eeprom_address
	movfw	hour2
	movwf	eeprom_data
	call	eeprom_write

	incf	eeprom_address
	movfw	minute2
	movwf	eeprom_data
	call	eeprom_write

	incf	eeprom_address
	movfw	red2
	movwf	eeprom_data
	call	eeprom_write

	incf	eeprom_address
	movfw	green2
	movwf	eeprom_data
	call	eeprom_write

	incf	eeprom_address
	movfw	blue2
	movwf	eeprom_data
	call	eeprom_write
; timer 3
	incf	eeprom_address
	movfw	hour3
	movwf	eeprom_data
	call	eeprom_write

	incf	eeprom_address
	movfw	minute3
	movwf	eeprom_data
	call	eeprom_write

	incf	eeprom_address
	movfw	red3
	movwf	eeprom_data
	call	eeprom_write

	incf	eeprom_address
	movfw	green3
	movwf	eeprom_data
	call	eeprom_write

	incf	eeprom_address
	movfw	blue3
	movwf	eeprom_data
	call	eeprom_write
; timer 4
	incf	eeprom_address
	movfw	hour4
	movwf	eeprom_data
	call	eeprom_write

	incf	eeprom_address
	movfw	minute4
	movwf	eeprom_data
	call	eeprom_write

	incf	eeprom_address
	movfw	red4
	movwf	eeprom_data
	call	eeprom_write

	incf	eeprom_address
	movfw	green4
	movwf	eeprom_data
	call	eeprom_write

	incf	eeprom_address
	movfw	blue4
	movwf	eeprom_data
	call	eeprom_write

; flags 2
	incf	eeprom_address
	movfw	flags2
	movwf	eeprom_data
	call	eeprom_write
	
; light sensitivity
	incf	eeprom_address
	movfw	light_sensitivity
	movwf	eeprom_data
	call	eeprom_write

	banksel	0
	return


load_settings:
	banksel	0
; load red
	movlw	D'0'
	movwf	eeprom_address			; 0
	call	eeprom_read
	movwf	red
; load green
	incf	eeprom_address			; 1
	call	eeprom_read
	movwf	green
; load blue
	incf	eeprom_address			; 2
	call	eeprom_read
	movwf	blue

; load clock_prescaler_1
	incf	eeprom_address
	call	eeprom_read
	movwf	clock_prescaler_1

; load clock_speed
	incf	eeprom_address
	call	eeprom_read
	movwf	clock_speed

; timer 0
	incf	eeprom_address
	call	eeprom_read
	movwf	hour0	

	incf	eeprom_address
	call	eeprom_read
	movwf	minute0

	incf	eeprom_address
	call	eeprom_read
	movwf	red0

	incf	eeprom_address
	call	eeprom_read
	movwf	green0

	incf	eeprom_address
	call	eeprom_read
	movwf	blue0

; timer 1
	incf	eeprom_address
	call	eeprom_read
	movwf	hour1

	incf	eeprom_address
	call	eeprom_read
	movwf	minute1

	incf	eeprom_address
	call	eeprom_read
	movwf	red1

	incf	eeprom_address
	call	eeprom_read
	movwf	green1

	incf	eeprom_address
	call	eeprom_read
	movwf	blue1

; timer 2
	incf	eeprom_address
	call	eeprom_read
	movwf	hour2

	incf	eeprom_address
	call	eeprom_read
	movwf	minute2

	incf	eeprom_address
	call	eeprom_read
	movwf	red2

	incf	eeprom_address
	call	eeprom_read
	movwf	green2

	incf	eeprom_address
	call	eeprom_read
	movwf	blue2

; timer 3
	incf	eeprom_address
	call	eeprom_read
	movwf	hour3

	incf	eeprom_address
	call	eeprom_read
	movwf	minute3

	incf	eeprom_address
	call	eeprom_read
	movwf	red3

	incf	eeprom_address
	call	eeprom_read
	movwf	green3

	incf	eeprom_address
	call	eeprom_read
	movwf	blue3

; timer 4
	incf	eeprom_address
	call	eeprom_read
	movwf	hour4

	incf	eeprom_address
	call	eeprom_read
	movwf	minute4

	incf	eeprom_address
	call	eeprom_read
	movwf	red4

	incf	eeprom_address
	call	eeprom_read
	movwf	green4

	incf	eeprom_address
	call	eeprom_read
	movwf	blue4

; flags 2
	incf	eeprom_address
	call	eeprom_read
	movwf	flags2

; light sensitivity
	incf	eeprom_address
	call	eeprom_read
	andlw	D'31'
	movwf	light_sensitivity
	call	set_light_sensitivity
	
	banksel	0
	return






set_light_sensitivity:
	banksel VRCON
	bsf	VRCON,	VRR			; low range se;ect
	bcf	VRCON,	VR3			; reference select
	bcf	VRCON,	VR2			; reference select
	bcf	VRCON,	VR1			; reference select
	bcf	VRCON,	VR0			; reference select

	banksel	0
	btfss	light_sensitivity,  4	; 16 ?
	goto test_ct_3
	
	banksel VRCON
	bcf	VRCON,	VRR			; high range se;ect

test_ct_3:
	banksel	0
	btfss	light_sensitivity,  3	; 8 ?
	goto test_ct_2

	banksel VRCON
	bsf	VRCON,	VR3

test_ct_2:
	banksel	0
	btfss	light_sensitivity,  2	; 4 ?
	goto test_ct_1

	banksel VRCON
	bsf	VRCON,	VR2

test_ct_1:
	banksel	0
	btfss	light_sensitivity,  1	; 2 ?
	goto test_ct_0

	banksel VRCON
	bsf	VRCON,	VR1

test_ct_0:
	banksel	0
	btfss	light_sensitivity,  0	; 1?
	goto	light_sensitivity_set

	banksel VRCON
	bsf	VRCON,	VR0

light_sensitivity_set:
	banksel	0
	return



; PAGE 1

	org	D'2048'

help_pri:
	movlw	HIGH(tstart)
	addwf	offset_h, w

	movwf	PCLATH

	movlw	LOW(tstart)
	addwf	offset_l, w

	skpnc
	incf	PCLATH,	f
	
	movwf	PCL

tstart:
	retlw	D'13'
	retlw	D'10'

	DT	"Help menu"
	retlw	D'13'
	retlw	D'10'

	DT	"BnnnENTER set blue LED (0-255)."
	retlw	D'13'
	retlw	D'10'

	DT	"CnnnENTER set clock speed (0-255), default ~80."
	retlw	D'13'
	retlw	D'10'

	DT	"c print clock speed."
	retlw	D'13'
	retlw	D'10'

	DT	"D set clock timer default speed, F=226, C=65"
	retlw	D'13'
	retlw	D'10'

	DT	"FnnnENTER set clock prescaler (0-255), default 255."
	retlw	D'13'
	retlw	D'10'

	DT	"f print clock prescaler."
	retlw	D'13'
	retlw	D'10'

	DT	"GnnnENTER set green LED (0-255)."
	retlw	D'13'
	retlw	D'10'

	DT	"HnnENTER set hour (0-23)."
	retlw	D'13'
	retlw	D'10'

	DT	"L set light sensitivity (0-31), default 0, saved in  EEPROM."
	retlw	D'13'
	retlw	D'10'

	DT	"l print light sensitivity. on or off status, and actual light measured (0-31) where 0 is brigthest and 31 is dark."
	retlw	D'13'
	retlw	D'10'

	DT	"MnnENTER set minute (0-59)."
	retlw	D'13'
	retlw	D'10'

	DT	"Pn ENTER set timer number (0-4), use 255 for hours or minutes to disable a timer."
	retlw	D'13'
	retlw	D'10'

	DT	"p show timers."
	retlw	D'13'
	retlw	D'10'

	DT	"RnnnENTER set red LED (0-255)."
	retlw	D'13'
	retlw	D'10'

	DT	"S save settings in EEPROM."
	retlw	D'13'
	retlw	D'10'

	DT	"s print RGB."
	retlw	D'13'
	retlw	D'10'

	DT	"t print time."
	retlw	D'13'
	retlw	D'10'

	DT	"v print version."
	retlw	D'13'
	retlw	D'10'

	DT	"X set fast mode, only look at hours, minutes must be zero, 'F' and 'f' still work (saved in EEPROM)."
	retlw	D'13'
	retlw	D'10'

	DT	"x leave fast mode."
	retlw	D'13'
	retlw	D'10'

; table end
	retlw	D'0'


; eeprom

; end listing
	end

