/************************************************/
/*						*/
/*	validate.c				*/
/*					        */
/*	The functions in this module are uses to*/
/*	validate the user's input		*/
/*						*/
/***********************************************/
#include "addrbk.h"

static void format_phone_number(char *input);

/*function to strip the trailing blanks from a string */    

char *strip(char *input,int len)
{
	char wkbuff[200];
	int i=0;

	strncpy(wkbuff,input,len);

	i = len;

	while (isspace(wkbuff[i-1]))
	{
		wkbuff[i-1] = '\0';
		i--;
	}
	
	sprintf(input,"%s",wkbuff);

	return(input);
}

/*function to parse the name*/
/* these are the possible formats: */
/* First MI Last */
/* Last, First MI */
int is_valid_name(char *input,IO_ADDR *output)
{
	return(SUCCESS);
}

/*function to validate and format zip code*/
/*zip can be either ZZZZZ or ZZZZZ-ZZZZ   */

int is_valid_zip(char *input)
{
	char wkbuff[6];
	char zip[L_ZIP];
	char zip_p[L_ZIP];

	memset(wkbuff,'\0',sizeof(wkbuff));
	memset(zip,'\0',sizeof(zip));
	memset(zip_p,'\0',sizeof(zip_p));

	sprintf(zip,"%.*s",L_ZIP,input);

	if (strlen(zip) == 5)
	{
	   /*normal zip, so just validate that all are digits*/
	 
	   if (is_valid_number(&zip[0],strlen(zip)) == FAIL)
	   {
		return(FAIL);
	   }
	   else
	   {
		input = &zip[0];
		return(SUCCESS);
	   }
	} 
	else if (strlen(input) == 9)
	{
	   memset(zip,'\0',sizeof(zip));
	   sprintf(zip,"%.9s",input);
	   if (is_valid_number(input,strlen(input)) == FAIL)
		return(FAIL);
	   else
	   {
		sprintf(input,"%.5s-%.4s",&zip[0],&zip[5]);
		return(SUCCESS);
	   }
	}
	else if (strtok(input,"-") != NULL)
	{
	  sprintf(wkbuff,"%.5s",input);
	  if (is_valid_number(&wkbuff[0],strlen(wkbuff)) == FAIL)
	  {
		return(FAIL);
	  }
	  else if(is_valid_number(input+6,4) == FAIL)
	  {
		return(FAIL);
	  }
	  else
	  {
		input = 0;
		input = &zip[0];
		return(SUCCESS);
	  }
	}
	else
	  return(FAIL);
}
	
	
/*function to validate and format phone number*/
/*if the phone number is invalid, returns fail*/
/*allows three different formats :	      */
/*(AAA)XXX-LLLL, or AAA-XXX-LLLL, or AAAXXXLLLL*/

int is_valid_phone(char *input)
{
	char wkbuff[L_PHONE];
	char tmp_phone[11];
	char *phone;
	memset(wkbuff,'\0',sizeof(wkbuff));
	memset(tmp_phone,'\0',sizeof(tmp_phone));

	/*assume the phone number is in this format AAAXXXLLLL*/
	/*if it is in one of the other formats, the check if needed*/

	if ((is_valid_number(input,strlen(input)) == SUCCESS) &&
	    (strlen(input) == 10))
	{
            /*all of the characters in the string are digits and*/
	    /*the length is correct (10 numbers) */

	    sprintf(tmp_phone,"%.10s",input);	

	    phone = &tmp_phone[0];
	    format_phone_number(phone);

	    memcpy(input,phone,L_PHONE);
	    return(SUCCESS);
	}
	else if (!strncmp(input,"(",1))
	{
	   /*if the first character is a '(' then parse for this *
	   /*format (AAA)XXX-LLLL*/
    
	   sprintf(tmp_phone,"%.3s",&input[1]);
	   if (!strncmp(&input[4],")",1))
		strncat(tmp_phone,&input[5],3);
	   else
		return(FAIL);
	   
	   if (!strncmp(&input[8],"-",1))
		strncat(tmp_phone,&input[9],4);
	   else
	      return(FAIL);

	   if(is_valid_number(&tmp_phone[0],strlen(tmp_phone)) == SUCCESS)
	   {	
		phone = &tmp_phone[0];
		format_phone_number(phone);
		memcpy(input,phone,L_PHONE);
		return(SUCCESS);
	   }
	   else
	 	return(FAIL);
	}
	else if (!strncmp(input+3,"-",1))
	{
	   /*found a hypen, so parse for this format: AAA-XXX-LLLL*/
	   /*this is the format that the program uses to display  */
	   /*and save both phone and fax numbers*/
			
	   memset(wkbuff,'\0',sizeof(wkbuff));
	   sprintf(wkbuff,"%.3s",&input[0]);
	   if (is_valid_number(&wkbuff[0],strlen(wkbuff)) == FAIL)
		return(FAIL);
		
	   sprintf(wkbuff,"%.3s",&input[4]);
	   if ((strncmp(&input[3],"-",1)) && 
	      (is_valid_number(&wkbuff[0],strlen(wkbuff)) == FAIL))
		return(FAIL);

	   sprintf(wkbuff,"%.4s",&input[8]);
	   if((strncmp(&input[7],"-",1)) &&
	     (is_valid_number(&wkbuff[0],sizeof(wkbuff)) == FAIL))
		return(FAIL);
		
	   /*if this point has been reached, the number is valid*/
	
	   return(SUCCESS);

	}
	else
	   return(FAIL);
}

/*function to validate a string*/
/*cannot contain any spaces, must be all alpha*/

int is_valid_string(char *input,int len)
{
	int i;
	char wkbuff[1];	
		
	strncpy(wkbuff,input,1);
	for(i = 0; i < (len) ; i++)
	{
		if (isalpha(wkbuff[0]) == 0)
		{
			return(FAIL);
		}
		
		input++;
		memset(wkbuff,'\0',sizeof(wkbuff));
		strncpy(wkbuff,input,1);

	}

	return (SUCCESS);
}

/*function to validate a string of numbers*/
/*if any place in the string is not 0-9, return FAIL*/

int is_valid_number(char *input,int len)
{
	int i;
	char wkbuff[1];

	strncpy(wkbuff,input,1);

	for( i = 0; i < len; i++)
	{

	   if (!isdigit(wkbuff[0]))
	   {
		return(FAIL);
	   }
	   
	   input++;
	   memset(wkbuff,'\0',sizeof(wkbuff));
	   strncpy(wkbuff,input,1);
	}
	
	return(SUCCESS);
}

/*format the phone number from AAAXXXLLLL to */
/*AAA-XXX-LLLL*/
static void format_phone_number(char *input)
{
	char tmp[13];

	sprintf(tmp,"%.3s-%.3s-%.4s",input,
		input+3,input+6);

	memcpy(input,tmp,sizeof(tmp));

	/*input = &tmp[0];*/
}
