/*
	This module contains the function that strips the
	trailing blanks from the input struct

*/

#include "addrbk.h"

void strip_blanks(ADDR_LIST *input)
{
	char buffer[201];

	memset(buffer,'\0',sizeof(L_COMMENT));

	/*strip blanks from first name*/
	sprintf(buffer,"%.*s,",L_FNAME,&input->f_name[0]);
	memset(input->f_name,'\0',sizeof(input->f_name));
	strcpy(input->f_name,strip(&buffer[0],L_FNAME));
	
	/*middle initial*/

	memset(buffer,'\0',L_COMMENT);
	sprintf(buffer,"%.*s",L_MNAME,&input->m_name[0]);
	memset(input->m_name,'\0',sizeof(input->m_name));
	strcpy(input->m_name,strip(&buffer[0],L_MNAME));

	/*last name*/

	memset(buffer,'\0',sizeof(buffer));
	sprintf(buffer,"%.*s",L_LNAME,&input->l_name[0]);
	memset(input->l_name,'\0',L_LNAME);
	strcpy(input->l_name,strip(&buffer[0],L_LNAME));

	/*title*/

	memset(buffer,'\0',L_COMMENT);
	sprintf(buffer,"%.*s",L_TITLE,&input->title[0]);
	memset(input->title,'\0',L_TITLE);
	strcpy(input->title,strip(&buffer[0],L_TITLE));

	/*company*/

	memset(buffer,'\0',L_COMMENT);
	sprintf(buffer,"%.*s",L_COMPANY,&input->company[0]);
	memset(input->company,'\0',L_COMPANY);
	strcpy(input->company,strip(&buffer[0],L_COMPANY));

	/*address*/

	memset(buffer,'\0',L_COMMENT);
	sprintf(buffer,"%.*s",L_ADDR,&input->address[0]);
	memset(input->address,'\0',L_ADDR);
	strcpy(input->address,strip(buffer,L_ADDR));

	/*city*/

	memset(buffer,'\0',L_COMMENT);
	sprintf(buffer,"%.*s",L_CITY,&input->city[0]);
	memset(input->city,'\0',L_CITY);
	strcpy(input->city,strip(buffer,L_CITY));
	
	/*state*/

	memset(buffer,'\0',L_COMMENT);
	sprintf(buffer,"%.*s",L_STATE,&input->state[0]);
	memset(input->state,'\0',L_STATE);
	strcpy(input->state,strip(buffer,L_STATE));

	/*zip*/

	memset(buffer,'\0',L_COMMENT);
	sprintf(buffer,"%.*s",L_ZIP,&input->zip[0]);
	memset(input->zip,'\0',L_ZIP);
	strcpy(input->zip,strip(buffer,L_ZIP));
	
	/*phone*/

	memset(buffer,'\0',L_COMMENT);
	sprintf(buffer,"%.*s",L_PHONE,&input->phone[0]);
	memset(input->phone,'\0',L_PHONE);
	strcpy(input->phone,strip(buffer,L_PHONE));

	/*fax*/

	memset(buffer,'\0',L_COMMENT);
	sprintf(buffer,"%.*s",L_FAX,&input->fax[0]);
	memset(input->fax,'\0',L_PHONE);
	strcpy(input->fax,strip(buffer,L_PHONE));

	/*email*/

	memset(buffer,'\0',L_COMMENT);
	sprintf(buffer,"%.*s",L_EMAIL,&input->email[0]);
	memset(input->email,'\0',L_EMAIL);
	strcpy(input->email,strip(buffer,L_EMAIL));

	/*comment*/

	memset(buffer,'\0',L_COMMENT+1);
	sprintf(buffer,"%.*s",L_COMMENT,&input->comment[0]);
	memset(input->comment,'\0',L_COMMENT);
	strcpy(input->comment,strip(buffer,L_COMMENT));

	
}

