/************************************************/
/*						*/
/*	addrproc.c				*/
/*						*/
/*	This module contains all callback 	*/
/*	functions				*/
/*						*/
/*	Luther Maloney		Oct 1 1997	*/
/*						*/
/************************************************/
#include <xview/generic.h>
#include <xview/xview.h>
#include <xview/frame.h>
#include <xview/panel.h>
#include <xview/notice.h>
#include "addrgui.h"

static void clear(ADDR_DATA *list);
static void change_button_state(ADDR_DATA *addr,int state);

void save_file(Panel_item item)
{
	ADDR_DATA *addr;

	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,SAVE_KEY);

	if(addr->save_flg == NOT_SAVED)
	{
	   xv_set(addr->save_notice,XV_SHOW,TRUE,NULL);

	   if((int)xv_get(addr->save_notice,NOTICE_STATUS) == NOTICE_YES)
	   {
	      /*the user has chosen to save the file*/

	      (void)write_addr_list(addr->head_ptr,addr->addr_file_ptr);

	      addr->save_flg = SAVED;

	      /*reset the display to beginging of list*/

	      addr->current_node = addr->head_ptr;
	   
	      display(addr,addr->head_ptr);
	
	   }
	   else
	   {
	     addr->save_flg = NOT_SAVED;
	   }
	}
}

void insert_address(Panel_item item)
{
	ADDR_DATA *addr;

	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,INSERT_KEY);

	/*disable normal command buttons and enable insert buttons*/

	clear(addr);

	change_button_state(addr,TRUE);

	xv_set(addr->addr_itm.insert,PANEL_INACTIVE,FALSE,NULL);
	xv_set(addr->addr_itm.cancel,PANEL_INACTIVE,FALSE,NULL);

}
void search_list(Panel_item item)
{
	ADDR_DATA *addr;

	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,SEARCH_KEY);

	/*popup an input frame to get the name to be searched */

	create_search_frame(addr);
}

void search(Panel_item item)
{
	ADDR_DATA *addr;
	ADDR_LIST *current_node;
	char *buffer;

	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,SEARCH_KEY_2);

	/*get the name to search for*/

	buffer = (char *)xv_get(addr->search_name,PANEL_VALUE);
	current_node = addr->head_ptr;

	if(strlen(buffer) == 0)
	{
	   /*empty feild, destroy frame*/

	   xv_destroy_safe(addr->search_frame);

	}
	else
	{
	   /*perform the search*/

	   while(current_node != NULL)
	   {
		if(strcmp(current_node->l_name,buffer) == 0)
		{
		   /*move the display to the name that was found*/

		   display(addr,current_node);

		   if(current_node->next_item == NULL)
			xv_set(addr->addr_itm.next,PANEL_INACTIVE,TRUE,NULL);

		   addr->current_node = current_node;
		   xv_set(addr->addr_itm.prev,PANEL_INACTIVE,FALSE,NULL);

		   xv_destroy_safe(addr->search_frame);
		   break;

		}
		else if(current_node->next_item == NULL)
		{
		   /*if the name was not found and */ 
		   /*the end of list was reached, display notice*/

		   xv_set(addr->name_not_found,NOTICE_MESSAGE_STRINGS,
			buffer,"Was Not found",NULL);
		   xv_set(addr->name_not_found,XV_SHOW,TRUE,NULL);
		   
		   /*now destroy the search frame*/
		
		   xv_destroy_safe(addr->search_frame);
	   	}

		current_node = current_node->next_item;
	   }

	}
}

void delete_address(Panel_item item)
{
	ADDR_DATA *addr;
	ADDR_LIST *delete;
	ADDR_LIST *prev;
	ADDR_LIST *start;
	ADDR_LIST *next;
	char message[100];

	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,DELETE_KEY);
	delete = addr->current_node;

	sprintf(message,"Delete : %.*s %.*s ?",L_FNAME,delete->f_name,
			L_LNAME,delete->l_name);

	xv_set(addr->delete_notice,NOTICE_MESSAGE_STRING,message,NULL);
	xv_set(addr->delete_notice,XV_SHOW,TRUE,NULL);

	if((int)xv_get(addr->delete_notice,NOTICE_STATUS)==NOTICE_YES)
	{
	   /*delete the node*/

	   if(delete->prev_item == NULL)
	   {
	      /*delete first item in list*/
	      next = delete->next_item;
	      next->prev_item = NULL;
	      addr->head_ptr = next;
	   }
	   else if(delete->next_item == NULL)
	   {
	      /*delete last item*/
	      prev = delete->prev_item;
	      prev->next_item = NULL;
	   }
	   else
	   {
	       /*delete in middle of list*/
	       
	       prev = delete->prev_item;
	       next = delete->next_item;
	       next->prev_item = prev;
	       prev->next_item = next;
	   }

	   free(delete);

	   /*reset the pointers to start of list*/

	   addr->current_node = addr->head_ptr;
	
	   /*display the start of list*/

	   display(addr,addr->head_ptr);

	   /*change button states*/

	   start = addr->head_ptr;

	   if(start->next_item == NULL)
	      xv_set(addr->addr_itm.next,PANEL_INACTIVE,TRUE,NULL);
	   else
	     xv_set(addr->addr_itm.next,PANEL_INACTIVE,FALSE,NULL);

	   xv_set(addr->addr_itm.prev,PANEL_INACTIVE,TRUE,NULL);	

	   /*reset the file saved flag*/
 
	   addr->save_flg = NOT_SAVED;
	}
	
}

void display_next(Panel_item item)
{
	ADDR_DATA *addr;
	ADDR_LIST *display_next = NULL;

	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,NEXT_KEY);

	display_next = addr->current_node;
	display_next = display_next->next_item; /*move pointer to next node*/
	addr->current_node = display_next;  /*move current node to next node*/	

	display(addr,display_next);	      /*display the next item*/

	if(display_next->next_item == NULL)
	   xv_set(addr->addr_itm.next,PANEL_INACTIVE,TRUE,NULL);

	/*enable delete button */

	xv_set(addr->addr_itm.delete,PANEL_INACTIVE,FALSE,NULL);
	xv_set(addr->addr_itm.prev,PANEL_INACTIVE,FALSE,NULL);
	
}

void display_prev(Panel_item item)
{
	ADDR_DATA *addr;
	ADDR_LIST *current_node;
	
	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,PREV_KEY);
	
	current_node = addr->current_node;

	current_node = current_node->prev_item;

	addr->current_node = current_node;

	display(addr,addr->current_node);

	if(current_node->prev_item == NULL)
	   xv_set(addr->addr_itm.prev,PANEL_INACTIVE,TRUE,NULL);

	xv_set(addr->addr_itm.next,PANEL_INACTIVE,FALSE,NULL);

} 

void insert(Panel_item item)
{
	ADDR_DATA *addr; /*pointer to hold addr_data struct*/
	char *buffer;

	char *name;
	char message[100];
	ADDR_LIST *start = NULL;        

	/*get the data from the button */
	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,INSERT_KEY_2);

	sprintf(message,"Insert : %s %s %s ?",addr->input_addr.f_name,
		addr->input_addr.m_name,addr->input_addr.l_name);

	xv_set(addr->insert_notice,NOTICE_MESSAGE_STRING,message,NULL);
	xv_set(addr->insert_notice,XV_SHOW,TRUE,NULL);

	if((int)xv_get(addr->insert_notice,NOTICE_STATUS) == NOTICE_YES)
	{
	   if(strlen(addr->input_addr.l_name) == 0 || 
		strlen(addr->input_addr.f_name) == 0 || 
		strlen(addr->input_addr.phone) == 0)
	   {
	      /*required information is not present -- error */

	      xv_set(addr->invalid_insert,XV_SHOW,TRUE,NULL);

	      clear(addr);

	      xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.fname,NULL);
	   }
	   else
	   {
	      if(addr->empty_flg == FILE_EMPTY)
	      {
	         sprintf(addr->head_ptr->f_name,"EMPTY");
	         addr->empty_flg = FILE_NOT_EMPTY;
	      }

	      start = insert_node_addr_list(addr->head_ptr,&addr->input_addr);

	      /*refresh the display frame*/  

	      display(addr,start);

	      /*enable normal command buttons, disable insert buttons*/

	      change_button_state(addr,FALSE);

	      xv_set(addr->addr_itm.insert,PANEL_INACTIVE,TRUE,NULL);
	      xv_set(addr->addr_itm.cancel,PANEL_INACTIVE,TRUE,NULL);

	      addr->save_flg = NOT_SAVED;
	      addr->head_ptr = start;
	      addr->current_node = start;
	  
	      if(start->next_item == NULL)
	         xv_set(addr->addr_itm.next,PANEL_INACTIVE,TRUE,NULL);
	
	      /*first item in list, cannot delete it yet*/

	      xv_set(addr->addr_itm.prev,PANEL_INACTIVE,TRUE,NULL);
	   }
	}
	else
	{
	   /*the user has chosen not to insert the node */
	
	   memset(&addr->input_addr,'\0',sizeof(IO_ADDR));

	   start = addr->head_ptr;

	   display(addr,start);

	}
}

void insert_cancel(Panel_item item)
{
	ADDR_DATA *addr;
	ADDR_LIST *start;

	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,CANCEL_KEY);
	
	memset(&addr->input_addr,'\0',sizeof(ADDR_LIST));

	change_button_state(addr,FALSE);

	xv_set(addr->addr_itm.insert,PANEL_INACTIVE,TRUE,NULL);
	xv_set(addr->addr_itm.cancel,PANEL_INACTIVE,TRUE,NULL);

	start = addr->head_ptr;

	display(addr,start);

	xv_set(addr->addr_itm.delete,PANEL_INACTIVE,TRUE,NULL);
	xv_set(addr->addr_itm.prev,PANEL_INACTIVE,TRUE,NULL);

}	

void quit(Panel_item item)
{
	ADDR_DATA *addr;
	int status;

	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,QUIT_KEY);

	xv_set(addr->quit_notice,XV_SHOW,TRUE,NULL);

	status = (int)xv_get(addr->quit_notice,NOTICE_STATUS);

	switch (status)
	{
	   case NOTICE_YES :
		if(addr->save_flg == NOT_SAVED)
		{
		   xv_set(addr->save_notice,XV_SHOW,TRUE,NULL);
		   if((int)xv_get(addr->save_notice,NOTICE_STATUS) == NOTICE_YES)
		   {
			(void)write_addr_list(addr->head_ptr,addr->addr_file_ptr);
			xv_destroy_safe(addr->addr_frame);
			fclose(addr->addr_file_ptr);
			exit(0);
		   }
		}
		xv_destroy_safe(addr->addr_frame);
		fclose(addr->addr_file_ptr);
		exit(0);
		break;
	   case NOTICE_NO :
		break;
	}
	xv_set(addr->quit_notice,XV_SHOW,FALSE,NULL);
}

void input_fname(Panel_item item)
{
	ADDR_DATA *addr;
	char *fname;
	
	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,FNAME_KEY);

	fname = (char *)xv_get(addr->addr_itm.fname,PANEL_VALUE);

	if(is_valid_string(fname,strlen(fname)) == FAIL)
	{
	   xv_set(addr->name_notice,NOTICE_MESSAGE_STRING,
		"The name is incorrect.\nThe name must be all characters.",NULL);
	   xv_set(addr->name_notice,XV_SHOW,TRUE,NULL);
	   xv_set(addr->addr_itm.fname,PANEL_VALUE,"",NULL);
	   xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.fname,NULL);
	}
	else
	{
	  /*the first name is correct (all char)*/
	  sprintf(addr->input_addr.f_name,"%.*s",L_FNAME,fname);
	  xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.mname,NULL);
	}
}

void input_mname(Panel_item item)
{
	ADDR_DATA *addr;
	char *mname;
	char buff[2];

	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,MNAME_KEY);
	mname = (char *)xv_get(addr->addr_itm.mname,PANEL_VALUE);
	sprintf(buff,"%.1s",mname);

	if(strlen(buff) != 0)
	{
	   if(is_valid_string(&buff[0],strlen(buff)) == FAIL)
	   {
	      xv_set(addr->name_notice,NOTICE_MESSAGE_STRING,
		"The middle initial is incorrect.\nThe MI must be a character.",NULL);
	      xv_set(addr->name_notice,XV_SHOW,TRUE,NULL);
	      xv_set(addr->addr_itm.mname,PANEL_VALUE,"",NULL);
	      xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.mname,NULL);
	   }
	   else
	   {
	      sprintf(addr->input_addr.m_name,"%.1s",mname);
	      strcat(addr->input_addr.m_name,".");
	      xv_set(addr->addr_itm.mname,PANEL_VALUE,addr->input_addr.m_name,NULL);
	      xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.lname,NULL);
	   }
	}
	else
	{
	    /*no middile initial was entered*/
	    sprintf(addr->input_addr.m_name,"\0");
	    xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.lname,NULL);
	}
}

void input_lname(Panel_item item)
{
	ADDR_DATA *addr;
	char *lname;

	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,LNAME_KEY);
	lname = (char *)xv_get(addr->addr_itm.lname,PANEL_VALUE);

	if(is_valid_string(lname,strlen(lname)) == FAIL)
	{
	   xv_set(addr->name_notice,NOTICE_MESSAGE_STRING,
		"The name is incorrect.\nThe name must be all characters",NULL);
	   xv_set(addr->name_notice,XV_SHOW,TRUE,NULL);
	   xv_set(addr->addr_itm.lname,PANEL_VALUE,"",NULL);
	   xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.lname,NULL);
	}
	else
	{
	   sprintf(addr->input_addr.l_name,"%.*s",L_LNAME,lname);
	   xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.title,NULL);
	}
}

void input_title(Panel_item item)
{
	ADDR_DATA *addr;
	char *title;

	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,TITLE_KEY);
	title = (char *)xv_get(addr->addr_itm.title,PANEL_VALUE);

	if(strlen(title) == 0)
	   sprintf(addr->input_addr.title,"none");
	else
	   sprintf(addr->input_addr.title,"%.*s",L_TITLE,title);
	xv_set(addr->addr_itm.title,PANEL_VALUE,"none",NULL);
	xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.company,NULL);
}

void input_company(Panel_item item)
{
	ADDR_DATA *addr;
	char *buffer;

	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,COMPANY_KEY);
	buffer = (char *)xv_get(addr->addr_itm.company,PANEL_VALUE);

	if(strlen(buffer) == 0)
	   sprintf(addr->input_addr.company,"none");
	else
	   sprintf(addr->input_addr.company,"%.*s",L_COMPANY,buffer);
	xv_set(addr->addr_itm.company,PANEL_VALUE,addr->input_addr.company,NULL);
	xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.address,NULL);
}

void input_address(Panel_item item)
{
	ADDR_DATA *addr;
	char *buffer;

	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,ADDR_KEY);
	buffer = (char *)xv_get(addr->addr_itm.address,PANEL_VALUE);
	
	if(strlen(buffer) == 0)
	{
	   sprintf(addr->input_addr.address,"none");
	   sprintf(addr->input_addr.city,"none");
	   sprintf(addr->input_addr.state,"NN");
	   sprintf(addr->input_addr.zip,"00000");

	   xv_set(addr->addr_itm.address,PANEL_VALUE,addr->input_addr.address,NULL);
	   xv_set(addr->addr_itm.city,PANEL_VALUE,addr->input_addr.city,NULL);
	   xv_set(addr->addr_itm.state,PANEL_VALUE,addr->input_addr.state,NULL);
	   xv_set(addr->addr_itm.zip,PANEL_VALUE,addr->input_addr.zip,NULL);
	   xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.phone,NULL);
	}
	else
	{
	   sprintf(addr->input_addr.address,"%.*s",L_ADDR,buffer);
	   xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.city,NULL);
	}
}

void input_city(Panel_item item)
{
	ADDR_DATA *addr;
	char *buffer;

	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,CITY_KEY);
	buffer = (char *)xv_get(addr->addr_itm.city,PANEL_VALUE);

	if(is_valid_string(buffer,strlen(buffer)) == FAIL)
	{
	   xv_set(addr->name_notice,NOTICE_MESSAGE_STRING,
		"The city is incorrect.\nThe city must be all characters",NULL);
	   xv_set(addr->name_notice,XV_SHOW,TRUE,NULL);
	   xv_set(addr->addr_itm.city,PANEL_VALUE,"",NULL);
	   xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.city,NULL);
	}
	else
	{
	   sprintf(addr->input_addr.city,"%.*s",L_CITY,buffer);
	   xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.state,NULL);
	}
}

void input_state(Panel_item item)
{
	ADDR_DATA *addr;
	char *buffer;

	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,STATE_KEY);
	buffer = (char *)xv_get(addr->addr_itm.state,PANEL_VALUE);

	if(is_valid_string(buffer,strlen(buffer)) == FAIL)
	{
	   xv_set(addr->name_notice,NOTICE_MESSAGE_STRING,
		"The state is incorrect.\nThe state must be all characters",NULL);
	   xv_set(addr->name_notice,XV_SHOW,TRUE,NULL);
	   xv_set(addr->addr_itm.state,PANEL_VALUE,"",NULL);
	   xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.state,NULL);
	}
	else
	{
	   sprintf(addr->input_addr.state,"%.*s",L_STATE,buffer);
	   xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.zip,NULL);
	}
}

void input_zip(Panel_item item)
{
	ADDR_DATA *addr;
	char *buffer;

	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,ZIP_KEY);
	buffer = (char *)xv_get(addr->addr_itm.zip,PANEL_VALUE);

	if(is_valid_zip(buffer) == FAIL)
	{
	   xv_set(addr->zip_notice,XV_SHOW,TRUE,NULL);
	   xv_set(addr->addr_itm.zip,PANEL_VALUE,"",NULL);
	   xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.zip,NULL);
	}
	else
	{
	   sprintf(addr->input_addr.zip,"%.*s",L_ZIP,buffer);
	   xv_set(addr->addr_itm.zip,PANEL_VALUE,addr->input_addr.zip,NULL);
	   xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.phone,NULL);
	}
}

void input_phone(Panel_item item)
{
	ADDR_DATA *addr;
	char *buffer;

	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,PHONE_KEY);
	buffer = (char *)xv_get(addr->addr_itm.phone,PANEL_VALUE);

	if(is_valid_phone(buffer) == FAIL)
	{
	   xv_set(addr->phone_notice,XV_SHOW,TRUE,NULL);
	   xv_set(addr->addr_itm.phone,PANEL_VALUE,"",NULL);
	   xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.phone,NULL);
	} 
	else
	{
	   sprintf(addr->input_addr.phone,"%.*s",L_PHONE,buffer);
	   xv_set(addr->addr_itm.phone,PANEL_VALUE,addr->input_addr.phone,NULL);
	   xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.fax,NULL);
	}
}

void input_fax(Panel_item item)
{
	ADDR_DATA *addr;
	char *buffer;

	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,FAX_KEY);
	buffer = (char *)xv_get(addr->addr_itm.fax,PANEL_VALUE);

	if(strlen(buffer) != 0)
	{
	   if(is_valid_phone(buffer) == FAIL)
	   {
	      xv_set(addr->phone_notice,XV_SHOW,TRUE,NULL);
	      xv_set(addr->addr_itm.fax,PANEL_VALUE,"",NULL);
	      xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.fax,NULL);
	   }
	   else
	   {
	      sprintf(addr->input_addr.fax,"%.*.s",L_PHONE,buffer);
	      xv_set(addr->addr_itm.fax,PANEL_VALUE,addr->input_addr.fax,NULL);
	      xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.email,NULL);
	   }
	}
	else
	{
	   sprintf(addr->input_addr.fax,"%.*s",L_PHONE,"none");
	   xv_set(addr->addr_itm.fax,PANEL_VALUE,addr->input_addr.fax,NULL);
	   xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.email,NULL);
	}
}

void input_email(Panel_item item)
{
	ADDR_DATA *addr;
	char *buffer;

	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,EMAIL_KEY);
	buffer = (char *)xv_get(addr->addr_itm.email,PANEL_VALUE);

	if(strlen(buffer) == 0)
	   sprintf(addr->input_addr.email,"none");
	else
	   sprintf(addr->input_addr.email,"%.*s",L_EMAIL,buffer);
	xv_set(addr->addr_itm.email,PANEL_VALUE,addr->input_addr.email,NULL);
	xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.comment,NULL);
}

void input_comment(Panel_item item)
{
	ADDR_DATA *addr;
	char *buffer;

	addr = (ADDR_DATA *)xv_get(item,XV_KEY_DATA,COMMENT_KEY);
	buffer = (char *)xv_get(addr->addr_itm.comment,PANEL_VALUE);

	if(strlen(buffer)==0)
	   sprintf(addr->input_addr.comment,"none");
	else
	   sprintf(addr->input_addr.comment,"%.*s",L_COMMENT,buffer);
	xv_set(addr->addr_panel,PANEL_CARET_ITEM,addr->addr_itm.fname,NULL);
}

static void clear(ADDR_DATA *list)
{
	xv_set(list->addr_itm.fname,PANEL_VALUE,"",NULL);
	xv_set(list->addr_itm.mname,PANEL_VALUE,"",NULL);
	xv_set(list->addr_itm.lname,PANEL_VALUE,"",NULL);
	xv_set(list->addr_itm.title,PANEL_VALUE,"",NULL);
	xv_set(list->addr_itm.company,PANEL_VALUE,"",NULL);
	xv_set(list->addr_itm.address,PANEL_VALUE,"",NULL);
	xv_set(list->addr_itm.city,PANEL_VALUE,"",NULL);
	xv_set(list->addr_itm.state,PANEL_VALUE,"",NULL);
	xv_set(list->addr_itm.zip,PANEL_VALUE,"",NULL);
	xv_set(list->addr_itm.phone,PANEL_VALUE,"",NULL);
	xv_set(list->addr_itm.fax,PANEL_VALUE,"",NULL);
	xv_set(list->addr_itm.email,PANEL_VALUE,"",NULL);
	xv_set(list->addr_itm.comment,PANEL_VALUE,"",NULL);
	xv_set(list->addr_panel,PANEL_CARET_ITEM,list->addr_itm.fname);
}

void display(ADDR_DATA *display,ADDR_LIST *item) 
{
	IO_ADDR addr;

	memset((char *)&addr,'\0',sizeof(IO_ADDR));

	sprintf(addr.f_name,"%.*s",L_FNAME,item->f_name);
	sprintf(addr.m_name,"%.*s",L_MNAME,item->m_name);
	sprintf(addr.l_name,"%.*s",L_LNAME,item->l_name);
	sprintf(addr.title,"%.*s",L_TITLE,item->title);
	sprintf(addr.company,"%.*s",L_COMPANY,item->company);
	sprintf(addr.address,"%.*s",L_ADDR,item->address);
	sprintf(addr.city,"%.*s",L_CITY,item->city);
	sprintf(addr.state,"%.*s",L_STATE,item->state);
	sprintf(addr.zip,"%.*s",L_ZIP,item->zip);
	sprintf(addr.phone,"%.*s",L_PHONE,item->phone);
	sprintf(addr.fax,"%.*s",L_FAX,item->fax);
	sprintf(addr.email,"%.*s",L_EMAIL,item->email);
	sprintf(addr.comment,"%.*s",L_COMMENT,item->comment);


	clear(display);

	xv_set(display->addr_itm.fname,PANEL_VALUE,addr.f_name,NULL);
	xv_set(display->addr_itm.mname,PANEL_VALUE,addr.m_name,NULL);
	xv_set(display->addr_itm.lname,PANEL_VALUE,addr.l_name,NULL);
	xv_set(display->addr_itm.title,PANEL_VALUE,addr.title,NULL);
	xv_set(display->addr_itm.company,PANEL_VALUE,addr.company,NULL);
	xv_set(display->addr_itm.address,PANEL_VALUE,addr.address,NULL);
	xv_set(display->addr_itm.city,PANEL_VALUE,addr.city,NULL);
	xv_set(display->addr_itm.state,PANEL_VALUE,addr.state,NULL);
	xv_set(display->addr_itm.zip,PANEL_VALUE,addr.zip,NULL);
	xv_set(display->addr_itm.phone,PANEL_VALUE,addr.phone,NULL);
	xv_set(display->addr_itm.fax,PANEL_VALUE,addr.fax,NULL);
	xv_set(display->addr_itm.email,PANEL_VALUE,addr.email,NULL);
	xv_set(display->addr_itm.comment,PANEL_VALUE,addr.comment,NULL);
}

static void change_button_state(ADDR_DATA *addr,int state)		
{
	xv_set(addr->addr_itm.save,PANEL_INACTIVE,state,NULL);
	xv_set(addr->addr_itm.in_name,PANEL_INACTIVE,state,NULL);
	xv_set(addr->addr_itm.search,PANEL_INACTIVE,state,NULL);
	xv_set(addr->addr_itm.delete,PANEL_INACTIVE,state,NULL);
	xv_set(addr->addr_itm.prev,PANEL_INACTIVE,state,NULL);
	xv_set(addr->addr_itm.next,PANEL_INACTIVE,state,NULL);
	xv_set(addr->addr_itm.quit_itm,PANEL_INACTIVE,state,NULL);
	
}
