#include "addrbk.h"

/*defines*/

#define NAME 		201
#define PHONE	 	301
#define ZIP  		401
#define INVALID_INSERT  501
#define NOT_FOUND	601
#define FILE_EMPTY	20
#define FILE_NOT_EMPTY  30
#define QUIT_KEY 	65572
#define CANCEL_KEY	65573
#define INSERT_KEY	65590 
#define INSERT_KEY_2	65591 
#define DELETE_KEY 	65592
#define SAVE_KEY 	65593
#define SEARCH_KEY 	65594
#define PREV_KEY 	65595
#define NEXT_KEY 	65598
#define FNAME_KEY	65599	
#define MNAME_KEY	65580
#define LNAME_KEY	65581
#define TITLE_KEY	65582
#define COMPANY_KEY	65583
#define ADDR_KEY	65584
#define CITY_KEY	65585
#define STATE_KEY	65586
#define ZIP_KEY		65587
#define PHONE_KEY	65588
#define FAX_KEY		65589	
#define EMAIL_KEY	65570
#define COMMENT_KEY	65571
#define SEARCH_KEY_2    65569

typedef struct p_addr_items{
	Panel_item	fname;
	Panel_item	mname;
	Panel_item	lname;
	Panel_item	title;
	Panel_item	company;
	Panel_item	address;
	Panel_item	city;
	Panel_item	state;
	Panel_item	zip;
	Panel_item	phone;
	Panel_item 	fax;
	Panel_item	email;
	Panel_item	comment;
	Panel_item	save;
	Panel_item	in_name;
	Panel_item	search;
	Panel_item	delete;
	Panel_item	prev;
	Panel_item	next;
	Panel_item	insert;
	Panel_item	cancel;
	Panel_item	quit_itm;
	}P_ADDR_ITEMS;

typedef struct addr_data{
	IO_ADDR input_addr;
	ADDR_LIST *prev_node;
	ADDR_LIST *current_node;
	ADDR_LIST *head_ptr;
	FILE	*addr_file_ptr;
	int 	save_flg;
	int	empty_flg;
	Frame	addr_frame;
	Frame   search_frame;
	Panel	addr_panel;
	Panel 	input_panel;
	Panel   search_panel;
	Panel_item search_button;
	Panel_item search_name;
	P_ADDR_ITEMS addr_itm;
	Xv_Notice name_notice;
	Xv_Notice phone_notice;
	Xv_Notice zip_notice;
	Xv_Notice save_notice;
	Xv_Notice new_file_notice;
	Xv_Notice delete_notice;
	Xv_Notice insert_notice;
	Xv_Notice invalid_insert;
	Xv_Notice name_not_found;
	Xv_Notice quit_notice;
	} ADDR_DATA;

/*function prototypes*/

/*callback functions for panel buttons*/
void quit(Panel_item item);
void save_file(Panel_item item);
void insert_address(Panel_item item);
void search_list(Panel_item item);
void delete_address(Panel_item item);
void display_next(Panel_item item);
void display_prev(Panel_item item);
void insert(Panel_item item);
void insert_cancel(Panel_item item);
void search(Panel_item item);

/*functions to validate entered data, also */
/*moves data over to input structure */
void input_fname(Panel_item item);
void input_mname(Panel_item item);
void input_lname(Panel_item item);
void input_title(Panel_item item);
void input_company(Panel_item item);
void input_address(Panel_item item);
void input_city(Panel_item item);
void input_state(Panel_item item);
void input_zip(Panel_item item);
void input_phone(Panel_item item);
void input_fax(Panel_item item);
void input_email(Panel_item item);
void input_comment(Panel_item item);

/*functions to create gui interface */
void create_base_frame(ADDR_DATA *create);
void create_search_frame(ADDR_DATA *create);
void create_notices(ADDR_DATA *create);

/*miscellaneous functions*/
void display(ADDR_DATA *display,ADDR_LIST *item);
