/************************************************/
/*						*/
/*	addrgui.c				*/
/*						*/
/*	This module contains a function that 	*/
/*	sets up the notices this program uses	*/
/*						*/
/*	Luther Maloney		Oct 1 1997	*/
/************************************************/
#include <xview/generic.h>
#include <xview/xview.h>
#include <xview/notice.h>
#include <xview/frame.h>
#include <xview/panel.h>
#include "addrgui.h"

/*function that creates frames for this program*/
/*XV_SHOW is set to FALSE */

void create_base_frame(ADDR_DATA *create)
{
	create->addr_frame = (Frame)xv_create((int)NULL,FRAME,
				FRAME_LABEL,"Personal Address Book V 1.0",
				XV_HEIGHT,350,
				XV_WIDTH,600,
				NULL);

	create->addr_panel = (Panel)xv_create(create->addr_frame,PANEL,NULL);
	
	create->addr_itm.save =	(Panel_item)xv_create(create->addr_panel,PANEL_BUTTON,
				PANEL_LABEL_STRING,	"Save",
				XV_KEY_DATA,SAVE_KEY,create,
				PANEL_NOTIFY_PROC,save_file,
				NULL);
		
	create->addr_itm.in_name = (Panel_item)xv_create(create->addr_panel,PANEL_BUTTON,
				PANEL_LABEL_STRING,	"Insert Name",
				XV_KEY_DATA,INSERT_KEY,create,
				PANEL_NOTIFY_PROC,insert_address,
				NULL);

	create->addr_itm.search = (Panel_item)xv_create(create->addr_panel,PANEL_BUTTON,
				PANEL_LABEL_STRING,	"Search for ..",
				XV_KEY_DATA,SEARCH_KEY,create,
				PANEL_NOTIFY_PROC,search_list,
				NULL);

	create->addr_itm.delete = (Panel_item)xv_create(create->addr_panel,PANEL_BUTTON,
				PANEL_LABEL_STRING,	"Delete ...",
				XV_KEY_DATA,DELETE_KEY,create,
				PANEL_NOTIFY_PROC,delete_address,
				NULL);	
		
	create->addr_itm.prev = (Panel_item)xv_create(create->addr_panel,PANEL_BUTTON,
				PANEL_LABEL_STRING,	"Prev Name",
				XV_KEY_DATA,PREV_KEY,create,
				PANEL_NOTIFY_PROC,display_prev,
				NULL);

	create->addr_itm.next = (Panel_item)xv_create(create->addr_panel,PANEL_BUTTON,
				PANEL_LABEL_STRING,	"Next Name",
				XV_KEY_DATA,NEXT_KEY,create,
				PANEL_NOTIFY_PROC,display_next,
				NULL);

	create->addr_itm.quit_itm = (Panel_item)xv_create(create->addr_panel,PANEL_BUTTON,
				PANEL_LABEL_STRING,"Quit",
				XV_KEY_DATA,QUIT_KEY,create,
				PANEL_NOTIFY_PROC,quit,
				NULL);

	create->addr_itm.fname = (Panel_item)xv_create(create->addr_panel,
				PANEL_TEXT,
				PANEL_LABEL_STRING,"First Name:",
				PANEL_VALUE_DISPLAY_LENGTH,L_FNAME,
				PANEL_NOTIFY_PROC,input_fname,
				XV_KEY_DATA,FNAME_KEY,create,
				NULL);
	
	create->addr_itm.mname = (Panel_item)xv_create(create->addr_panel,
				PANEL_TEXT,
				PANEL_LABEL_STRING,"Middle Initial:",
				PANEL_VALUE_DISPLAY_LENGTH,L_MNAME,
				PANEL_NOTIFY_PROC,input_mname,
				XV_KEY_DATA,MNAME_KEY,create,
				NULL);

	create->addr_itm.lname = (Panel_item)xv_create(create->addr_panel,
				PANEL_TEXT,
				PANEL_LABEL_STRING,"Last Name:",
				PANEL_VALUE_DISPLAY_LENGTH,L_LNAME,
				PANEL_NOTIFY_PROC,input_lname,
				XV_KEY_DATA,LNAME_KEY,create,
				NULL);

	create->addr_itm.title = (Panel_item)xv_create(create->addr_panel,
				PANEL_TEXT,
				PANEL_LABEL_STRING,"Title:",
				PANEL_VALUE_DISPLAY_LENGTH,L_TITLE,
				PANEL_NOTIFY_PROC,input_title,
				XV_KEY_DATA,TITLE_KEY,create,
				NULL);

	create->addr_itm.company = (Panel_item)xv_create(create->addr_panel,
				PANEL_TEXT,
				PANEL_LABEL_STRING,"Company:",
				PANEL_VALUE_DISPLAY_LENGTH,L_COMPANY,
				PANEL_NOTIFY_PROC,input_company,
				XV_KEY_DATA,COMPANY_KEY,create,
				NULL);

	create->addr_itm.address = (Panel_item)xv_create(create->addr_panel,
				PANEL_TEXT,
				PANEL_LABEL_STRING,"Address:",
				PANEL_VALUE_DISPLAY_LENGTH,L_ADDR,
				PANEL_NOTIFY_PROC,input_address,
				XV_KEY_DATA,ADDR_KEY,create,
				NULL);

	create->addr_itm.city = (Panel_item)xv_create(create->addr_panel,
				PANEL_TEXT,
				PANEL_LABEL_STRING,"City:",
				PANEL_VALUE_DISPLAY_LENGTH,L_CITY,
				PANEL_NOTIFY_PROC,input_city,
				XV_KEY_DATA,CITY_KEY,create,
				NULL);

	create->addr_itm.state = (Panel_item)xv_create(create->addr_panel,
				PANEL_TEXT,
				PANEL_LABEL_STRING,"State:",
				PANEL_VALUE_DISPLAY_LENGTH,L_STATE,
				PANEL_NOTIFY_PROC,input_state,
				XV_KEY_DATA,STATE_KEY,create,
				NULL);

	create->addr_itm.zip = (Panel_item)xv_create(create->addr_panel,
				PANEL_TEXT,
				PANEL_LABEL_STRING,"Zip:",
				PANEL_VALUE_DISPLAY_LENGTH,L_ZIP,
				PANEL_NOTIFY_PROC,input_zip,
				XV_KEY_DATA,ZIP_KEY,create,
				NULL);

	create->addr_itm.phone = (Panel_item)xv_create(create->addr_panel,
				PANEL_TEXT,
				PANEL_LABEL_STRING,"Phone:",
				PANEL_VALUE_DISPLAY_LENGTH,L_PHONE,
				PANEL_NOTIFY_PROC,input_phone,
				XV_KEY_DATA,PHONE_KEY,create,
				NULL);

	create->addr_itm.fax = (Panel_item)xv_create(create->addr_panel,
				PANEL_TEXT,
				PANEL_LABEL_STRING,"Fax:",
				PANEL_VALUE_DISPLAY_LENGTH,L_FAX,
				PANEL_NOTIFY_PROC,input_fax,
				XV_KEY_DATA,FAX_KEY,create,
				NULL);
	
	create->addr_itm.email = (Panel_item)xv_create(create->addr_panel,
				PANEL_TEXT,
				PANEL_LABEL_STRING,"Email Address:",
				PANEL_VALUE_DISPLAY_LENGTH,L_EMAIL-15,
				PANEL_NOTIFY_PROC,input_email,
				XV_KEY_DATA,EMAIL_KEY,create,
				NULL);

	create->addr_itm.comment = (Panel_item)xv_create(create->addr_panel,
				PANEL_MULTILINE_TEXT,
				PANEL_LABEL_STRING,"Comment:",
				PANEL_DISPLAY_ROWS,4,
				PANEL_VALUE_DISPLAY_LENGTH,60,
				PANEL_VALUE_STORED_LENGTH,200,
				PANEL_LINE_BREAK_ACTION,PANEL_WRAP_AT_WORD,
				PANEL_NOTIFY_PROC,input_comment,
				XV_KEY_DATA,COMMENT_KEY,create,
				NULL);

	create->addr_itm.insert = (Panel_item)xv_create(create->addr_panel,PANEL_BUTTON,
				PANEL_LABEL_STRING,"      Insert Address",
				PANEL_LABEL_WIDTH,150,
				PANEL_INACTIVE,TRUE,
				XV_KEY_DATA,INSERT_KEY_2,create,
				PANEL_NOTIFY_PROC,insert,
				NULL);
		
	create->addr_itm.cancel = (Panel_item)xv_create(create->addr_panel,PANEL_BUTTON,
				PANEL_LABEL_STRING,"        Cancel Insert",
				PANEL_LABEL_WIDTH,150,
				PANEL_INACTIVE,TRUE,
				XV_KEY_DATA,CANCEL_KEY,create,
				PANEL_NOTIFY_PROC,insert_cancel,
				NULL);

}

void create_search_frame(ADDR_DATA *create)
{
	create->search_frame = (Frame)xv_create(create->addr_frame,FRAME,
				FRAME_LABEL,"Search for ....",
				XV_HEIGHT,	100,
				XV_WIDTH,	300,
				XV_SHOW,	TRUE,
				NULL);

	create->search_panel = (Panel)xv_create(create->search_frame,PANEL,NULL);

	create->search_name = (Panel_item)xv_create(create->search_panel,
				PANEL_TEXT,
				PANEL_LABEL_STRING,"Last Name:",
				PANEL_VALUE_DISPLAY_LENGTH,80,
				NULL);

	create->search_button = (Panel_item)xv_create(create->search_panel,
				PANEL_BUTTON,
				PANEL_LABEL_STRING, "Search for ...",
				PANEL_NOTIFY_PROC,search,
				XV_KEY_DATA,SEARCH_KEY_2,create,
				NULL);
}

void create_notices(ADDR_DATA *create)
{
	/*Notice if the addr_file does not exist*/
	create->new_file_notice = (Xv_Notice)xv_create(create->addr_frame,NOTICE,
				NOTICE_BUTTON_YES, "Create",
				NOTICE_BUTTON_NO,  "Cancel",
				XV_SHOW,FALSE,
				NOTICE_MESSAGE_STRINGS,
				"Your address file does not exist."
				"Create it?",
				NULL,NULL);

	/*Notice to save file*/
	create->save_notice = (Xv_Notice)xv_create(create->addr_frame,NOTICE,
				NOTICE_BUTTON_YES,"Save",
				NOTICE_BUTTON_NO,"Cancel",
				XV_SHOW,FALSE,
				NOTICE_MESSAGE_STRING,"Save address file?",
				NULL);

	create->delete_notice = (Xv_notice)xv_create(create->addr_frame,NOTICE,
				NOTICE_BUTTON_YES,"Delete",
				NOTICE_BUTTON_NO,"Cancel",
				XV_SHOW,FALSE,
				NULL);

	

	create->quit_notice = (Xv_Notice)xv_create(create->addr_frame,NOTICE,
				NOTICE_BUTTON_YES,"Yes, Really Quit",
				NOTICE_BUTTON_NO,"Cancel",
				NOTICE_MESSAGE_STRING,"Do you really want to quit?",
				XV_SHOW,FALSE,
				NULL);

	/*Notice for an incorrect name*/
	create->name_notice = (Xv_Notice)xv_create(create->addr_frame,NOTICE,
				NOTICE_BUTTON,"OK",NAME,
				XV_SHOW, FALSE,
				NOTICE_MESSAGE_STRING, 
				"The name is incorrect.\nThe name must be all characters.",
				NULL);
	
	/*Notice for an incorrect phone or fax number*/
	create->phone_notice = (Xv_Notice)xv_create(create->addr_frame,NOTICE,
				NOTICE_BUTTON,"OK",PHONE,
				XV_SHOW,FALSE,
				NOTICE_MESSAGE_STRINGS,
				"The phone number you entered is incorrect.",
				"The number must be in one of the formats :",
				"(AAA)XXX-LLLL, AAA-XXX-LLLL, or AAAXXXLLLL",
				"Where A = Area Code, X = Exchance, and L = Line",
				NULL,NULL);

	/*Notice for an incorrect zip code */
	create->zip_notice = (Xv_Notice)xv_create(create->addr_frame,NOTICE,
				NOTICE_BUTTON,"OK",ZIP,
				XV_SHOW,FALSE,
				NOTICE_MESSAGE_STRINGS,
				"The zip code you entered is incorrect.",
				"The zip must be in one of these formats:",
				"XXXXX-XXXX, XXXXX1234, or XXXXX",
				NULL,NULL);

	create->insert_notice = (Xv_Notice)xv_create(create->addr_frame,NOTICE,
				NOTICE_BUTTON_YES,"Insert",
				NOTICE_BUTTON_NO,"Cancel",
				XV_SHOW,FALSE,
				NULL);

	create->name_not_found = (Xv_Notice)xv_create(create->addr_frame,NOTICE,
				NOTICE_BUTTON,"OK",NOT_FOUND,
				XV_SHOW,FALSE,
				NULL);

	create->invalid_insert = (Xv_Notice)xv_create(create->addr_frame,NOTICE,
				NOTICE_BUTTON,"OK",INVALID_INSERT,
				XV_SHOW,FALSE,
				NOTICE_MESSAGE_STRINGS, "Attempt to insert an",
				"empty address. The address must contain",
				"a name and a phone number.",NULL,
				NULL);
				
}
