/********************************************************/
/*							*/
/*	addrbk.h					*/
/*							*/
/*	Contains defines and function prototypes. 	*/
/*	Also contains defines and includes for header	*/
/*	files.						*/
/*							*/
/*	Luther J Maloney		Oct 1 1997	*/
/*							*/
/********************************************************/
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <stdio.h>

/*define constants*/
 
#define SUCCESS 	1
#define FAIL		-1 
#define SAVED		10
#define NOT_SAVED 	-10
#define L_FNAME		30
#define L_LNAME		50
#define L_MNAME  	3
#define L_TITLE		30
#define L_COMPANY 	30
#define L_ADDR		60
#define L_CITY		20
#define L_STATE		3
#define L_ZIP		11
#define	L_IO_PHONE	10
#define L_PHONE		13
#define L_IO_FAX	10
#define L_FAX		13
#define L_EMAIL		50
#define L_COMMENT	200

/*define structure to hold addresses*/

typedef struct address {
	char f_name[L_FNAME];
	char l_name[L_LNAME];
	char m_name[L_MNAME];
	char title[L_TITLE];
	char company[L_COMPANY];
	char address[L_ADDR];
	char city[L_CITY];
	char state[L_STATE];
	char zip[L_ZIP];
	char phone[L_PHONE];
	char fax[L_FAX];
	char email[L_EMAIL];
	char comment[L_COMMENT];
	} IO_ADDR;  

typedef struct addr_list{ 
	char f_name[L_FNAME];
	char l_name[L_LNAME];
	char m_name[L_MNAME];
	char title[L_TITLE];
	char company[L_COMPANY];
	char address[L_ADDR];
	char city[L_CITY];
	char state[L_STATE];
	char zip[L_ZIP];
	char phone[L_PHONE];
	char fax[L_FAX];
	char email[L_EMAIL];
	char comment[L_COMMENT];
	struct addr_list *prev_item;
	struct addr_list *next_item;
	} ADDR_LIST;

/*function prototypes*/

int build_addr_list(ADDR_LIST *address,FILE *addr_file);
ADDR_LIST *insert_node_addr_list(ADDR_LIST *head_ptr,IO_ADDR *new_address);
int delete_item_addr_list(ADDR_LIST *delete_ptr,ADDR_LIST *prev_node);
int write_addr_list(ADDR_LIST *head_ptr,FILE *addr_file);

/*these functions are used to validate data */

int is_valid_string (char *input,int len);
int is_valid_number(char *input,int len);
int is_valid_phone(char *input);
int is_valid_zip(char *input);
int is_valid_name(char *input,IO_ADDR *output);
void strip_blanks(ADDR_LIST *input);
char *strip(char *input,int len);


