/********************************************************/
/*							*/
/*	addrbk.c					*/
/*							*/
/*	This program allows the user to enter a list of */
/*	personal or business addresses and stores these */
/*	in a file. This is written using the XView 	*/
/*	toolkit to handle the user interface. This      */
/*	program also requires these enviroment varabiles*/
/*	to be set : USER = user HOME = home directory	*/
/*							*/
/*	Luther J. Maloney		October 1, 1997	*/
/*							*/
/********************************************************/
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <xview/generic.h>
#include <xview/xview.h>
#include <xview/frame.h>
#include <xview/panel.h>
#include <xview/notice.h>
#include "addrgui.h"

static void open_file(ADDR_DATA *input);

main(int argc,char *argv[])
{
	ADDR_DATA addr;
	ADDR_LIST *start;

	/*set the default save flag*/

	addr.head_ptr = NULL;
	addr.save_flg = SAVED;

	xv_init(XV_INIT_ARGC_PTR_ARGV,&argc,argv,NULL);

	create_base_frame(&addr);

	create_notices(&addr);

	/*get the file name and open the file */

	open_file(&addr);

	/*read the address file in */  
	
	addr.head_ptr = (ADDR_LIST *)malloc(sizeof(ADDR_LIST));

	if (addr.head_ptr == NULL)
	{
		fprintf(stderr,"\nERROR ALLOCATING MEMORY : ABORT!!!");
		exit(255);
	}

	memset(addr.head_ptr,'\0',sizeof(ADDR_LIST));

	if(addr.empty_flg == FILE_NOT_EMPTY)
	{
	   if(build_addr_list(addr.head_ptr,addr.addr_file_ptr) == FAIL)
		exit(FAIL);
	
	   start = addr.head_ptr;

	   display(&addr,start);

	   if(start->next_item == NULL)
	      xv_set(addr.addr_itm.next,PANEL_INACTIVE,TRUE,NULL);

	   addr.prev_node = NULL;
	   addr.current_node = addr.head_ptr;
	
	}

	if(addr.empty_flg == FILE_EMPTY)
	   xv_set(addr.addr_itm.next,PANEL_INACTIVE,TRUE,NULL);

	xv_set(addr.addr_itm.delete,PANEL_INACTIVE,TRUE,NULL);

	xv_main_loop(addr.addr_frame);
	
	exit(0);
}
 

static void open_file(ADDR_DATA *input)
{	
	int status;

	/*this function opens the address file */

	char path[50];
	char *ptr;
	memset((char *)&path[0],'\0',sizeof(path));

	/*get the user's home directory */
	
	ptr = getenv("HOME");
	if(ptr == NULL)
	{
	   fprintf(stderr,"\nERROR -- ENVIROMENT VARIBLE 'HOME' NOT SET : ABORT");
	   exit(245);
	}
	strcpy(path,ptr);
	strcat(path,"/address.book");

	input->addr_file_ptr = fopen(path,"r+");
	if(input->addr_file_ptr == NULL)
	{
	   /*the file does not exist*/
	   xv_set(input->new_file_notice,XV_SHOW,TRUE,NULL);
	   status = (int)xv_get(input->new_file_notice,NOTICE_STATUS);
	   switch (status)
	   {
		case NOTICE_YES:
		   input->addr_file_ptr = fopen(path,"w");
		   if(input->addr_file_ptr == NULL)
		   {
			fprintf(stderr,"\nERROR CREATING FILE %s : ABORT!!",path);
			exit(-255);
		   }
		   input->empty_flg = FILE_EMPTY;
		   break;
		case NOTICE_NO:
		   exit(0);
	  }
	}
	else
	   input->empty_flg = FILE_NOT_EMPTY;
}
