/* Zgv v4.2 - GIF, JPEG and PBM/PGM/PPM viewer, for VGA PCs running Linux.
 * Copyright (C) 1993-1995 Russell Marks. See README for license details.
 *
 * Changes by Matan Ziv-Av
 *
 * rc_config.h - Defined! the zgv_config structure.
 *                       photographic evidence on page 2. :-)
 */

#include "mouse.h"

struct cfgrgb_tag { int r,g,b; };

struct zgv_config {
  int videomode,vismode,zoom,vkludge,jpeg24bit,jpegspeed;
  int jpegindexstyle;  /* 0=v. fast, 1=fast, 2=normal, 3=slow (as in <=v2.7) */
  int centreflag,blockcursor,thicktext;
  int betterpgm;  /* grinds PGM to 24-bit internally allowing 256 shades */
  int hicolmodes;	/* force zgv to think card has high-colour modes */
  int nodelprompt,perfectindex;
  int xvpic_index;
  int onefile_progress,cleartext;
  int force16fs;
  int repeat_timer,tag_timer;
  int revert,gamma,selecting;
  int fs16col;
  int viewer16col;
  int fullsel;
  int echotagged;
  int forgetoldpos;
  int linetext;
  int smallfiletext;
  
  int brightness;
  double contrast;
  
  struct cfgrgb_tag black,dark,medium,light,marked;
  int mode_allowed[256];
  int showxvpicdir;

  int loop;		/* loop forever in slideshow */
  mouse_type mtype;	/* mouse type to use */
  
  char cmd[1024];	/* alternative command to run instead of viewing */
  char convert_path[256];
  char image_exts[1024];
  int errignore;
  int sort_key, promptmulti, usefitmode, wide, allfiles, useconvert;
  
  int hicontrol;
  int pcdres;		/* resolution to use in PhotoCD files */
  int fast;
  };
