/* Zgv v4.2 - GIF, JPEG and PBM/PGM/PPM viewer, for VGA PCs running Linux.
 * Copyright (C) 1993-1996 Russell Marks. See README for license details.
 *
 *  Changes by Matan Ziv-Av (zivav@cs.bgu.ac.il)
 *
 * magic.c - Determines type of image file, and image dimensions.
 */

#include <stdio.h>
#include <string.h>
#include "magic.h"


int magic_ident(char *filename)
{
FILE *in;
unsigned char buf[3];

if((in=fopen(filename,"rb"))==NULL)
  return(_IS_BAD);

buf[0]=buf[1]=buf[2]=0;
fread(buf,1,3,in);
fclose(in);

/* We use the following rules:
 * P?M files must have 'P', then a digit; '1'<=digit<='6'.
 * GIF files must have "GIF"
 * JPEG files must have first byte=0xff, second byte=0xd8 (M_SOI)
 * BMP files must start with "BM"
 * PCX files have 0x0A, version byte, then 0x01.
 * mrf files must have "MRF"
 * TGA files suck rocks ;-) (heuristics in this case)
 */

/* no magic for technical reasons - test for '.ngm' extension */
if(strlen(filename)>=4 && !strcasecmp(filename+strlen(filename)-4,".ngm"))
  return(_IS_NGM);

/* xvpics look a bit like P?M files */
if(!strncmp(buf,"P7 ",3))
  return(_IS_XVPIC);

/* PBM/PGM/PPM */
if(buf[0]=='P' && buf[1]>='1' && buf[1]<='6')
  return(_IS_PNM);

/* GIF */
if(strncmp(buf,"GIF",3)==0)
  return(_IS_GIF);

/* JPEG */
if(buf[0]==0xff && buf[1]==0xd8)
  return(_IS_JPEG);

/* BMP */
if(buf[0]=='B' && buf[1]=='M')
  return(_IS_BMP);

/* PNG */
if(buf[0]==0x89 && buf[1]=='P' && buf[2]=='N')
  return(_IS_PNG);		/* XXX should test the rest I s'pose */

/* PCX */
if(buf[0]==10 && buf[2]==1)
  return(_IS_PCX);

/* mrf */
if(strncmp(buf,"MRF",3)==0)
  return(_IS_MRF);

/* TGA */
/* this is hairy, since TGA files don't have a magic number.
 * we make a guess based on some of the image info.
 * (whether it has a colourmap or not, and the type)
 */
if((buf[1]==1 && (buf[2]==1 || buf[2]==9)) ||
   (buf[1]<=1 && (buf[2]==2 || buf[2]==10)))
  return(_IS_TGA);


/* if we got here, it might be PCD, so read the 3 bytes after skipping 2048
  */

  in=fopen(filename,"rb"); /* it can be opened */

  buf[0]=buf[1]=buf[2]=0;
  fseek(in,2048,SEEK_SET);
  fread(buf,1,3,in);
  fclose(in);

  if(!strncmp(buf,"PCD",3))
    return(_IS_PCD);

/* if no valid header */
return(_IS_BAD);
}

int magic_ident_size(char *filename, int *width, int *height)
{
FILE *in;
unsigned char buf[1024]; /* should be enogh to find the size of every type */
long *lbuf;
short int *wbuf;

if((in=fopen(filename,"rb"))==NULL)
  return(_IS_BAD);

fread(buf,1,1024,in);
lbuf=(long *)buf;
wbuf=(short int *)buf;
fclose(in);

/* We use the following rules:
 * P?M files must have 'P', then a digit; '1'<=digit<='6'.

 * GIF files must have "GIF"

 * JPEG files must have first byte=0xff, second byte=0xd8 (M_SOI)
   find 0xffc0 marker at x, then there width is the word at x+7, height at x+9

 * BMP files must start with "BM"

 * PCX files have 0x0A, version byte, then 0x01.
    width=wbuf[4]-wbuf[2] height=wbuf[5]-wbuf[3]
    
 * mrf files must have "MRF"

 * TGA files suck rocks ;-) (heuristics in this case)

 */

/* no magic for technical reasons - test for '.ngm' extension */
if(strlen(filename)>=4 && !strcasecmp(filename+strlen(filename)-4,".ngm")){
  *width=192;
  *height=64; 
  return(_IS_NGM);
};

/* xvpics look a bit like P?M files */
if(!strncmp(buf,"P7 ",3)){
  sscanf(buf+3,"%i %i",width,height);  
  return(_IS_XVPIC);
};

/* PBM/PGM/PPM */
if(buf[0]=='P' && buf[1]>='1' && buf[1]<='6'){
  sscanf(buf+3,"%i %i",width,height);
  return(_IS_PNM);
};

/* GIF */
if(strncmp(buf,"GIF",3)==0){
   int i;
   i=-11;
   if(buf[11]&0x80)i=3*(2<<(buf[11]&0x07));
   *width=(buf[i+18]<<8)+buf[i+17];
   *height=(buf[i+20]<<8)+buf[i+19];
  return(_IS_GIF);
};

/* JPEG */
if((buf[0]==0xff)&&(buf[1]==0xd8)){
  int i,j;
  for(i=0;i<6;i++){
     for(j=0;j<1023;j++)
        if((buf[j]==0xff)&&((buf[j+1]&0xfd)==0xc0)){
           *width=buf[j+8]+(buf[j+7]<<8);
           *height=buf[j+6]+(buf[j+5]<<8);
           return(_IS_JPEG);
        };
     j=buf[1023];
     fread(buf,1,1024,in);
     if((j==0xff)&&((buf[0]&0xfd)==0xc0)){ *height=buf[5]+(buf[4]<<8); 
                                    *width=buf[7]+(buf[6]<<8);
                                    return(_IS_JPEG);
                                  };
  };
  *width=-1;
  *height=-1;
  return(_IS_JPEG);
};

/* BMP */
if(buf[0]=='B' && buf[1]=='M'){
  *width=(buf[21]<<24)|(buf[20]<<16)|(buf[19]<<8)|buf[18];
  *height=(buf[25]<<24)|(buf[24]<<16)|(buf[23]<<8)|buf[22];
  return(_IS_BMP);
};

/* PNG */
if(buf[0]==0x89 && buf[1]=='P' && buf[2]=='N'){
  *width=(buf[16]<<24)|(buf[17]<<16)|(buf[18]<<8)|buf[19];
  *height=(buf[20]<<24)|(buf[21]<<16)|(buf[22]<<8)|buf[23];
  return(_IS_PNG);		
};

/* PCX */
if(buf[0]==10 && buf[2]==1){
  *width=wbuf[4]-wbuf[2];
  *height=wbuf[5]-wbuf[3];
printf("%i %i %i %i %i %i\n",wbuf[0],wbuf[1],wbuf[2],wbuf[3],wbuf[4],wbuf[5]);
  return(_IS_PCX);
};

/* mrf */
if(strncmp(buf,"MRF",3)==0){
  *width=lbuf[1];
  *height=lbuf[2];
  return(_IS_MRF);
};

/* TGA */
/* this is hairy, since TGA files don't have a magic number.
 * we make a guess based on some of the image info.
 * (whether it has a colourmap or not, and the type)
 */
if((buf[1]==1 && (buf[2]==1 || buf[2]==9)) ||
   (buf[1]<=1 && (buf[2]==2 || buf[2]==10))){
   *width=wbuf[6];
   *height=wbuf[7];
  return(_IS_TGA);
};

/* if no valid header */
*width=-1;
*height=-1;
return(_IS_BAD);
};

