/* Zgv v4.0 - GIF, JPEG and PBM/PGM/PPM viewer, for VGA PCs running Linux.
 * Copyright (C) 1993-1995 Russell Marks. See README for license details.
 *
 * Changes by Matan Ziv-Av (zivav@cs.bgu.ac.il)
 *
 * helppage.c - for the online help page displays.
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <vga.h>
#include "3deffects.h"
#include "font.h"
#include "readnbkey.h"
#include "rc_config.h"
#include "rcfile.h"



void helpscreenon()
{
vga_setmode((vga_hasmode(G640x480x256) && cfg.force16fs==0)?
              G640x480x256:G640x480x16);
vga_setcolor(15);

vga_setpalette(0,cfg.medium.r,cfg.medium.g,cfg.medium.b);
vga_setpalette(1,cfg.dark.r,cfg.dark.g,cfg.dark.b);
vga_setpalette(2,cfg.light.r,cfg.light.g,cfg.light.b);
vga_setpalette(15,cfg.black.r,cfg.black.g,cfg.black.b);

draw3dbox(0,0,639,479,2,1, 2,1);
draw3dbox(10,10,629,469,1,0, 2,1);
}


/* the caller is expected to reset the mode and redraw the screen afterwards,
 * if necessary. help is the array pointer (see vgadisp.c and zgv.c).
 * in each string, the left side (key(s)) is separated from the right
 * (description) by a backslash. the routine must be able to (temporarily)
 * modify the data in the array, so don't use e.g. a `char *foo[]' with it.
 */
void showhelp(int ttyfd,char *title,char help[][80], int density)
{
int f,quit,gotkey,key;
char *ptr;

quit=0;

while(!quit)
  {
  gotkey=0;
  helpscreenon();
  drawtext3d(90,40,5,title,1, 2,1,15);
  drawtext3d(210,76,3,"- press a key to return -",1, 2,1,15);
  f=-1;
  while(strlen(help[++f]))
    {
    ptr=strchr(help[f],'\\');
    if(ptr) *ptr=0;
    drawtext3d(90,110+f*(20-density),3,help[f],0, 2,1,15);
    if(ptr)
      {
      drawtext3d(90+3*64,110+f*(20-density),3,ptr+1,0, 2,1,15);
      *ptr='\\';
      }
    }

  while(!gotkey)
    {
    key=readnbkey(ttyfd);
    if(key!=0)
      {
      gotkey=1;
      quit=1;
      }
      
    usleep(40000);
    }
  }
}
