/* Zgv v4.1 - GIF, JPEG and PBM/PGM/PPM viewer, for VGA PCs running Linux.
 * Copyright (C) 1993-1998 Russell Marks. See README for license details.
 *
 * Changes by Matan Ziv-Av (zivav@cs.bgu.ac.il)
 *
 * 3deffects.c - provides the '3d' style boxes, text etc.
 *                used by zgv.c (for file selector) and vgadisp.c
 *                (for help screen)
 */


#include <unistd.h>
#include <vga.h>
#include <stdlib.h>
#include "3deffects.h"
#include "font.h"
#include "readnbkey.h"
#include "zgv.h"
#include "rc_config.h"
#include "rcfile.h"


int msgbox_draw_ok=0;	/* 1 if ok to draw msgbox in current mode */


/* produce tacky 3d text */
void drawtext3d(int x,int y,int s,char *str,
                int isout,int lite,int dark,int txt)
{
vga_setcolor(isout?lite:dark);
vgadrawtext(x-1,y-1,s,str);
vga_setcolor(isout?dark:lite);
vgadrawtext(x+1,y+1,s,str);
vga_setcolor(txt);
vgadrawtext(x,y,s,str);
}


/* restore sanity */
void undrawtext3d(int x,int y,int s,char *str)
{
vga_setcolor(idx_medium);
vgadrawtext(x-1,y-1,s,str);
vgadrawtext(x+1,y+1,s,str);
vgadrawtext(x,y,s,str);
}


/* render each bock in 3d */
void draw3dbox(int x1,int y1,int x2,int y2,int depth,
               int isout,int lite,int dark)
{
int f;

for(f=0;f<depth;f++)
  {
  vga_setcolor(isout?lite:dark);
  vga_drawline(x1+f,y2-f,x1+f,y1+f);
  vga_drawline(x1+f,y1+f,x2-f,y1+f);
  vga_setcolor(isout?dark:lite);
  vga_drawline(x2-f,y1+f,x2-f,y2-f);
  vga_drawline(x2-f,y2-f,x1+f,y2-f);
  }
}


/* Undraw each relevant bock */
void undraw3dbox(int x1,int y1,int x2,int y2,int depth)
{
int f;

vga_setcolor(idx_medium);
for(f=0;f<depth;f++)
  {
  vga_drawline(x1+f,y2-f,x1+f,y1+f);
  vga_drawline(x1+f,y1+f,x2-f,y1+f);
  vga_drawline(x2-f,y1+f,x2-f,y2-f);
  vga_drawline(x2-f,y2-f,x1+f,y2-f);
  }
}


/* this blasts whatever is 'under' it - you have to save or redraw it.
 * also, if msgbox_draw_ok is zero, it changes to 640x480x16 mode before
 * drawing the box, and obviously this blasts the lot. :-)
 */
int msgbox(int ttyfd,char *message,int replytype,int lite,int dark,int txt)
{
int f,x1,y1,x2,y2,wide,high,key;
void *buf;

if(!msgbox_draw_ok)
  {
  /* fairly nasty, but it'll be followed by a mode change so it
   * doesn't matter.
   */
  vga_setmode((vga_hasmode(G640x480x256) && cfg.force16fs==0)?
                G640x480x256:G640x480x16);
  vga_setpalette(idx_medium=1,cfg.medium.r,cfg.medium.g,cfg.medium.b);
  vga_setpalette(dark=2,cfg.dark.r,cfg.dark.g,cfg.dark.b);
  vga_setpalette(lite=3,cfg.light.r,cfg.light.g,cfg.light.b);
  vga_setpalette(txt =4,cfg.black.r,cfg.black.g,cfg.black.b);
  }

set_max_text_width(vga_getxdim()-70);

high=90;
wide=vgatextsize(3,message)+60;
x1=((vga_getxdim()-wide)>>1);
y1=((vga_getydim()-high)>>1);
x2=((vga_getxdim()+wide)>>1);
y2=((vga_getydim()+high)>>1);

buf=malloc((high+1)*(wide+1));
for(f=y1;f<=y2;f++)
  vga_getscansegment(buf+(f-y1)*(wide+1),x1,f,wide+1);

vga_setcolor(idx_medium);
for(f=y1;f<y2;f++)
  vga_drawline(x1,f,x2,f);

/* draw outer box */
draw3dbox(x1 ,y1  ,x2  ,y2  ,2,1, lite,dark);
draw3dbox(x1+9,y1+9,x2-9,y2-9,1,0, lite,dark);

/* finally, I've got around to doing different types of msgbox! */
switch(replytype)
  {
  /* a box with a single 'OK' button, for warnings, errors, etc. */
  case MSGBOXTYPE_OK:
    /* draw 'button' */
    draw3dbox((vga_getxdim()-40)>>1,y2-45,
              (vga_getxdim()+40)>>1,y2-20, 1,1, lite,dark);

    vga_setcolor(txt);
    vgadrawtext(x1+30,y1+20,3,message);
    drawtext3d(((vga_getxdim()-15)>>1)-3*(cfg.linetext==0),y2-39,3,
    	"OK",0,lite,dark,txt);
    set_max_text_width(NO_CLIP_FONT);

    do
      {
      usleep(40000);
      key=readnbkey(ttyfd);
      }
    while((key!=RK_ESC)&&(key!=RK_ENTER));
    for(f=y1;f<=y2;f++)
      vga_drawscansegment(buf+(f-y1)*(wide+1),x1,f,wide+1);
    free(buf);
    return(1);

  /* a box with two buttons, 'Yes' and 'No'. Enter or 'y' selects yes,
   * Esc or 'n' selects no.
   */    
  case MSGBOXTYPE_YESNO:
    /* draw 'yes' button */
    draw3dbox((vga_getxdim()>>1)-50,y2-45,
              (vga_getxdim()>>1)-10,y2-20, 1,1, lite,dark);
    vga_setcolor(txt);
    vgadrawtext(x1+30,y1+20,3,message);		/* draw message */
    drawtext3d((vga_getxdim()>>1)-43-1*(cfg.linetext==0),y2-39,3,
    	"Yes",0,lite,dark,txt);

    /* draw 'no' button */
    draw3dbox((vga_getxdim()>>1)+10,y2-45,
              (vga_getxdim()>>1)+50,y2-20, 1,1, lite,dark);
    vga_setcolor(txt);
    drawtext3d((vga_getxdim()>>1)+23-2*(cfg.linetext==0),y2-39,3,
    	"No",0,lite,dark,txt);

    set_max_text_width(NO_CLIP_FONT);
    
    do
      {
      usleep(40000);
      key=readnbkey(ttyfd);
      }
    while(key!=RK_ESC && key!=RK_ENTER && key!='y' && key!='n');

    for(f=y1;f<=y2;f++)
      vga_drawscansegment(buf+(f-y1)*(wide+1),x1,f,wide+1);
    free(buf);
    return(key==RK_ENTER || key=='y');
  }
    for(f=y1;f<=y2;f++)
      vga_drawscansegment(buf+(f-y1)*(wide+1),x1,f,wide+1);
    free(buf);
return(0);
}

int inputbox(int ttyfd,char *message,int replytype,int lite,int dark,int txt, int maxlength,char *input)
{
int i,f,x1,y1,x2,y2,wide,high,key;
void *buf;
char *tmp;

if(!msgbox_draw_ok)
  {
  /* fairly nasty, but it'll be followed by a mode change so it
   * doesn't matter.
   */
  vga_setmode((vga_hasmode(G640x480x256) && cfg.force16fs==0)?
                G640x480x256:G640x480x16);
  vga_setpalette(idx_medium=1,cfg.medium.r,cfg.medium.g,cfg.medium.b);
  vga_setpalette(dark=2,cfg.dark.r,cfg.dark.g,cfg.dark.b);
  vga_setpalette(lite=3,cfg.light.r,cfg.light.g,cfg.light.b);
  vga_setpalette(txt =4,cfg.black.r,cfg.black.g,cfg.black.b);
  }

set_max_text_width(vga_getxdim()-70);

high=90;
wide=vgatextsize(3,message)+200;
if(wide>vga_getxdim()-50)wide=vga_getxdim()-50;
x1=((vga_getxdim()-wide)>>1);
y1=((vga_getydim()-high)>>1);
x2=((vga_getxdim()+wide)>>1);
y2=((vga_getydim()+high)>>1);

buf=malloc((high+1)*(wide+1));
for(f=y1;f<=y2;f++)
  vga_getscansegment(buf+(f-y1)*(wide+1),x1,f,wide+1);

vga_setcolor(idx_medium);
for(f=y1;f<y2;f++)
  vga_drawline(x1,f,x2,f);

/* draw outer box */
draw3dbox(x1 ,y1  ,x2  ,y2  ,2,1, lite,dark);
draw3dbox(x1+9,y1+9,x2-9,y2-9,1,0, lite,dark);

set_max_text_width(wide-60);
vga_setcolor(txt);
vgadrawtext(x1+30,y1+20,3,message);

tmp=malloc(maxlength);
i=0;
tmp[i]='\0';

do    {
      usleep(40000);
      key=readnbkey(ttyfd);
      if(((key==RK_BACKSPACE)||(key==RK_DELETE))&&(i>0)){
         tmp[--i]='\0';
         vga_setcolor(idx_medium);
         for(f=y2-30;f<y2-10;f++)vga_drawline(x1+30,f,x2-30,f);
         vga_setcolor(txt);
         vgadrawtext(x1+30,y2-30,3,tmp);
      };
      if((key!=RK_BACKSPACE)&&(key!=RK_ESC)&&(key!=RK_ENTER)&&(key!=RK_DELETE)&&(key>=32)&&(key<=255)&&(i<maxlength)){
         tmp[i++]=(char)key;
         tmp[i]='\0';
         vgadrawtext(x1+30,y2-30,3,tmp);
         };
      }
    while((key!=RK_ESC)&&(key!=RK_ENTER));
    for(f=y1;f<=y2;f++)
      vga_drawscansegment(buf+(f-y1)*(wide+1),x1,f,wide+1);
    free(buf);
    strcpy(input,tmp);
    return(key==RK_ENTER);

return(0);
}
