/*
 * XCallerID.C - XCallerID client source file
 * Copyright (c) 1998 Joe Yandle <yandle@cs.unc.edu>
 *
 * The XCallerID client is a Gtk+ style front end to the database
 * created and used by the the xcid daemon.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Version 1.2: Jun 1998
 * 
 * Changes in v1.2:
 *	switch to Gtk widget set ***DONE***
 *	automatic update of call list ***DONE***
 *
 * Changes in v1.1:
 * 	integrate xcid daemon with client ***DONE***
 * 	have call list update automatically ***DONE***
 *     	completed 29Jun98
 *
 */

#include <gtk/gtk.h>
#include <time.h>
#include <msql.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>

char* 		dbase = "CallerID";
char  		command[256];
m_result* 	query_ret;
int 		sock;
int 		fd;
pid_t 		serverid = 0;
struct stat	mystat;
int 		ncalls = 0;
bool 		autostart = true;
int 		row_select;
GtkWidget* 	call_list;

gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data);

void killwidget(GtkWidget* widget, gpointer data);

void destroy(GtkWidget* widget, gpointer data);

void showdialog(GtkWidget* widget, gpointer data);

void ssdaemon(GtkWidget* widget, gpointer data);

void setlist(GtkWidget* widget, gpointer data);

void search_callback(GtkWidget* widget, gpointer data);

void search_date_update(GtkWidget* widget, gpointer data);

void search_name_update(GtkWidget* widget, gpointer data);

void search_numb_update(GtkWidget* widget, gpointer data);

void resetlist();

void edit_name_callback(GtkWidget* widget, gpointer data);

void edit_greet_callback(GtkWidget* widget, gpointer data);

void selection_made(GtkWidget *clist, gint row, gint column, 
		    GdkEventButton *event, gpointer data);

void update_name(GtkWidget* widget, gpointer data);

void update_greet(GtkWidget* widget, gpointer data);

int timeout_callback( gpointer data );

int main( int argc, char** argv ) {

  GtkWidget* window;
  GtkWidget* menubar;

  GtkWidget* file_menu;
  GtkWidget* edit_menu;
  GtkWidget* search_menu;
  GtkWidget* daemon_menu;
  GtkWidget* help_menu;

  GtkWidget* file_item;
  GtkWidget* edit_item;
  GtkWidget* search_item;
  GtkWidget* daemon_item;
  GtkWidget* help_item;

  GtkWidget* file_exit_item;
  GtkWidget* edit_name_item;
  GtkWidget* edit_greet_item;
  GtkWidget* search_date_item;
  GtkWidget* search_numb_item;
  GtkWidget* search_name_item;
  GtkWidget* daemon_start_item;
  GtkWidget* daemon_stop_item;
  GtkWidget* help_about_item;

  GtkWidget* vbox;

  if( (sock=msqlConnect(NULL)) == -1 ) {
    printf( "Error connecting to server\n" );
    exit(1);
  }

  if( msqlSelectDB(sock,dbase) == -1 ) {
    printf( "Error opening database %s\n", dbase );
    exit(1);
  }

  gtk_init(&argc,&argv);
  
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize(GTK_WIDGET(window), 444, 300);
  gtk_window_set_title(GTK_WINDOW (window), "XCallerID");

  file_menu = gtk_menu_new();
  edit_menu = gtk_menu_new();
  search_menu = gtk_menu_new();
  daemon_menu = gtk_menu_new();
  help_menu = gtk_menu_new();

  menubar = gtk_menu_bar_new();

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(window), vbox);
  gtk_widget_show(vbox);

  file_item = gtk_menu_item_new_with_label("File");
  edit_item = gtk_menu_item_new_with_label("Edit");
  search_item = gtk_menu_item_new_with_label("Search");
  daemon_item = gtk_menu_item_new_with_label("Daemon");
  help_item = gtk_menu_item_new_with_label("Help");

  file_exit_item = gtk_menu_item_new_with_label("Exit");
  edit_name_item = gtk_menu_item_new_with_label("Edit name");
  edit_greet_item = gtk_menu_item_new_with_label("Edit greeting");
  search_date_item = gtk_menu_item_new_with_label("Search by date");
  search_name_item = gtk_menu_item_new_with_label("Search by name");
  search_numb_item = gtk_menu_item_new_with_label("Search by number");
  daemon_start_item = gtk_menu_item_new_with_label("Start daemon");
  daemon_stop_item = gtk_menu_item_new_with_label("Stop daemon");
  help_about_item = gtk_menu_item_new_with_label("About");
  
  gtk_menu_append(GTK_MENU(file_menu),file_exit_item);
  gtk_menu_append(GTK_MENU(edit_menu),edit_name_item);
  gtk_menu_append(GTK_MENU(edit_menu),edit_greet_item);
  gtk_menu_append(GTK_MENU(search_menu),search_date_item);
  gtk_menu_append(GTK_MENU(search_menu),search_name_item);
  gtk_menu_append(GTK_MENU(search_menu),search_numb_item);
  gtk_menu_append(GTK_MENU(daemon_menu),daemon_start_item);
  gtk_menu_append(GTK_MENU(daemon_menu),daemon_stop_item);
  gtk_menu_append(GTK_MENU(help_menu),help_about_item);

  gtk_widget_show(file_exit_item);
  gtk_widget_show(edit_name_item);
  gtk_widget_show(edit_greet_item);
  gtk_widget_show(search_date_item);
  gtk_widget_show(search_numb_item);
  gtk_widget_show(search_name_item);
  gtk_widget_show(daemon_start_item);
  gtk_widget_show(daemon_stop_item);
  gtk_widget_show(help_about_item);

  gtk_widget_show(file_item);
  gtk_widget_show(edit_item);
  gtk_widget_show(search_item);
  gtk_widget_show(daemon_item);
  gtk_widget_show(help_item);
  
  gtk_box_pack_start(GTK_BOX(vbox), menubar, FALSE, TRUE, 0);
  gtk_widget_show(menubar);

  gtk_menu_item_set_submenu(GTK_MENU_ITEM(file_item),file_menu);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(edit_item),edit_menu);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(search_item),search_menu);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(daemon_item),daemon_menu);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(help_item),help_menu);

  gtk_menu_bar_append(GTK_MENU_BAR(menubar),file_item);
  gtk_menu_bar_append(GTK_MENU_BAR(menubar),edit_item);
  gtk_menu_bar_append(GTK_MENU_BAR(menubar),search_item);
  gtk_menu_bar_append(GTK_MENU_BAR(menubar),daemon_item);
  gtk_menu_bar_append(GTK_MENU_BAR(menubar),help_item);

  gtk_menu_item_right_justify(GTK_MENU_ITEM(help_item));

  char* titles[] = {"Number","Name","Date","Time"};
  call_list = gtk_clist_new_with_titles(4,titles);
  gtk_clist_set_policy(GTK_CLIST(call_list),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
  for(int i=0;i<4;i++) {
    gtk_clist_set_column_justification(GTK_CLIST(call_list),i,GTK_JUSTIFY_CENTER);
  }
  gtk_clist_set_column_width(GTK_CLIST(call_list),0,100);
  gtk_clist_set_column_width(GTK_CLIST(call_list),1,150);
  gtk_clist_set_column_width(GTK_CLIST(call_list),2,80);
  gtk_clist_set_column_width(GTK_CLIST(call_list),3,60);
  gtk_clist_set_selection_mode( GTK_CLIST(call_list), GTK_SELECTION_SINGLE );
  gtk_widget_show(call_list);
  
  gtk_box_pack_start(GTK_BOX(vbox), call_list, TRUE, TRUE, 0);

  setlist(call_list,NULL);

  gtk_timeout_add( 1000, timeout_callback, call_list );

  gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(destroy), NULL );
  gtk_signal_connect(GTK_OBJECT(window), "delete_event", 
		     GTK_SIGNAL_FUNC(delete_event), NULL );
  gtk_signal_connect(GTK_OBJECT(file_exit_item), "activate", GTK_SIGNAL_FUNC(destroy), NULL);
  gtk_signal_connect(GTK_OBJECT(help_about_item), "activate", GTK_SIGNAL_FUNC(showdialog), NULL);

  gtk_signal_connect(GTK_OBJECT(edit_name_item), "activate", GTK_SIGNAL_FUNC(edit_name_callback), call_list);
  gtk_signal_connect(GTK_OBJECT(edit_greet_item), "activate", GTK_SIGNAL_FUNC(edit_greet_callback), call_list);
  gtk_signal_connect(GTK_OBJECT(daemon_start_item), "activate", GTK_SIGNAL_FUNC(ssdaemon), (gpointer)"start");
  gtk_signal_connect(GTK_OBJECT(daemon_stop_item), "activate", GTK_SIGNAL_FUNC(ssdaemon), (gpointer)"stop");
  gtk_signal_connect(GTK_OBJECT(search_date_item), "activate", GTK_SIGNAL_FUNC(search_callback), (gpointer)"call_date");
  gtk_signal_connect(GTK_OBJECT(search_name_item), "activate", GTK_SIGNAL_FUNC(search_callback), (gpointer)"name");
  gtk_signal_connect(GTK_OBJECT(search_numb_item), "activate", GTK_SIGNAL_FUNC(search_callback), (gpointer)"number");

  gtk_signal_connect(GTK_OBJECT(call_list), "select_row",
		     GTK_SIGNAL_FUNC(selection_made),
		     NULL);

  gtk_widget_show(window);

  if( autostart ) {
    if( !(serverid=fork()) ) {
      char pathname[256];
      sprintf( pathname, "%s/xcid", XCID_HOME );
      execl( pathname, "xcid", NULL );
      exit(1);
    }
  }
  gtk_main();

  return 0;

}

gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data) {
  return FALSE; 
}

void destroy(GtkWidget* widget, gpointer data) {
  if( serverid )
    kill(serverid,SIGTERM);
  gtk_main_quit();
}

void killwidget(GtkWidget* widget, gpointer data) {
  gtk_widget_destroy((GtkWidget*)data);
}

void showdialog(GtkWidget* widget, gpointer data) {
 
  GtkWidget* aboutd;
  GtkWidget* labeld;
  GtkWidget* aboutt;
  GtkWidget* okbutton;
  GtkWidget* cabutton;

  okbutton = gtk_button_new_with_label("Ok");
  cabutton = gtk_button_new_with_label("Cancel");
  aboutd = gtk_dialog_new();
  gtk_window_set_title(GTK_WINDOW(aboutd), "About XCallerID");
  labeld = gtk_label_new("     XCallerID-1.2 (c) 1998 Joe Yandle     ");

  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (aboutd)->vbox), labeld, TRUE,
		      TRUE, 10);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (aboutd)->action_area), okbutton,
		      TRUE, TRUE, 25);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (aboutd)->action_area), cabutton,
		      TRUE, TRUE, 25);
  gtk_widget_show(okbutton);
  gtk_widget_show(cabutton);
  gtk_widget_show(labeld);
  gtk_widget_show(aboutd);
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (killwidget), aboutd);
  gtk_signal_connect (GTK_OBJECT (cabutton), "clicked",
		      GTK_SIGNAL_FUNC (killwidget), aboutd);

}

void setlist(GtkWidget* widget, gpointer data) {

  time_t time_now = time(NULL);
  sprintf(command, 
	  "SELECT number, name, call_date, call_time FROM calls WHERE call_date = '%s'",
	  msqlUnixTimeToDate(time_now));
  int n = msqlQuery(sock, command );
  query_ret = msqlStoreResult();
  gtk_clist_clear(GTK_CLIST(widget));

  for( int i = 0; i < n; i++ ) {
    m_row row = msqlFetchRow(query_ret);
    char* cdata[] = { row[0], row[1], row[2], row[3] };
    gtk_clist_append(GTK_CLIST(widget),cdata);
  }
  ncalls = n;

}

int timeout_callback( gpointer data ) {

  time_t time_now = time(NULL);
  char ucommand[256];
  sprintf(ucommand, 
	  "SELECT number, name, call_date, call_time FROM calls WHERE call_date = '%s'",
	  msqlUnixTimeToDate(time_now));
  int n = msqlQuery(sock, ucommand );

  if( n != ncalls ) {
    setlist( (GtkWidget*)data, NULL );
    //ncalls = n;
  }
  return TRUE;
}

void ssdaemon(GtkWidget* widget, gpointer data) {
  if(strstr((char*)data,"start") && !serverid) {
    if( !(serverid=fork()) ) {
      char pathname[256];
      sprintf( pathname, "%s/xcid", XCID_HOME );
      execl( pathname, "xcid", NULL );
      exit(1);
    }
  }
  else if(strstr((char*)data,"stop") && serverid) {
    kill(serverid,SIGTERM);
    serverid=0;
  }
}

void edit_name_callback(GtkWidget* widget, gpointer data) {

  if(GTK_CLIST(data)->selection == NULL)
    return;
 
  GtkWidget* aboutd;
  GtkWidget* labeld;
  GtkWidget* aboutt;
  GtkWidget* okbutton;
  GtkWidget* cabutton;
  GtkWidget* name_entry;
  GtkWidget* hbox;

  hbox = gtk_hbox_new(TRUE,0);

  okbutton = gtk_button_new_with_label("Ok");
  cabutton = gtk_button_new_with_label("Cancel");
  aboutd = gtk_dialog_new();

  char* num;
  gtk_clist_get_text( GTK_CLIST(call_list),row_select,0,&num);
  char dtitle[256];
  sprintf(dtitle, "Edit name for %s", num);
  gtk_window_set_title(GTK_WINDOW(aboutd), dtitle);

  char* name;
  gtk_clist_get_text( GTK_CLIST(data),row_select,1,&name);

  name_entry = gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY(name_entry),name);

  gtk_box_pack_start(GTK_BOX(hbox), name_entry, FALSE, TRUE, 20);
  
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (aboutd)->vbox), hbox, TRUE,
		      TRUE, 10);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (aboutd)->action_area), okbutton,
		      TRUE, TRUE, 25);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (aboutd)->action_area), cabutton,
		      TRUE, TRUE, 25);
  gtk_widget_show(okbutton);
  gtk_widget_show(cabutton);
  gtk_widget_show(name_entry);
  gtk_widget_show(hbox);
  gtk_widget_show(aboutd);
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (update_name), name_entry);
  gtk_signal_connect (GTK_OBJECT (name_entry), "activate",
		      GTK_SIGNAL_FUNC (update_name), name_entry);
  gtk_signal_connect (GTK_OBJECT (cabutton), "clicked",
		      GTK_SIGNAL_FUNC (killwidget), aboutd);

}

void edit_greet_callback(GtkWidget* widget, gpointer data) {
  if(!GTK_CLIST(data)->selection)
    return;

  GtkWidget* fdialog;

  char* num;
  gtk_clist_get_text( GTK_CLIST(data),row_select,0,&num);
  char dtitle[256];
  sprintf(dtitle, "Edit greeting for %s", num);
  fdialog = gtk_file_selection_new(dtitle);


  gtk_widget_show(fdialog);
  gtk_signal_connect (GTK_OBJECT ( GTK_FILE_SELECTION(fdialog)->ok_button), "clicked",
		      GTK_SIGNAL_FUNC (update_greet), fdialog);
  gtk_signal_connect (GTK_OBJECT ( GTK_FILE_SELECTION(fdialog)->cancel_button), "clicked",
		      GTK_SIGNAL_FUNC (killwidget), fdialog);
  
}

void selection_made(GtkWidget *clist, gint row, gint column, 
		    GdkEventButton *event, gpointer data) {
  row_select = row;
}

void update_name(GtkWidget* widget, gpointer data) {
  char ucommand[256];
  char* name;
  gtk_clist_get_text( GTK_CLIST(call_list),row_select,0,&name);
  sprintf( ucommand, "UPDATE calls SET name = '%s' WHERE number = '%s'",
	   gtk_entry_get_text(GTK_ENTRY(data)), name );
  msqlQuery(sock,ucommand);
  resetlist();
  gtk_widget_destroy( ((GtkWidget*)data)->parent->parent->parent  );
}

void update_greet(GtkWidget* widget, gpointer data) {

  char ucommand[256];
  char* name;
  gtk_clist_get_text( GTK_CLIST(call_list),row_select,0,&name);
  sprintf( ucommand, "UPDATE calls SET incoming = '%s' WHERE number = '%s'",
	   gtk_file_selection_get_filename(GTK_FILE_SELECTION(data)), name );
  msqlQuery(sock,ucommand);
  
  gtk_widget_destroy((GtkWidget*)data);
}

void resetlist() {

  int n = msqlQuery(sock, command );
  query_ret = msqlStoreResult();
  gtk_clist_clear(GTK_CLIST(call_list));

  for( int i = 0; i < n; i++ ) {
    m_row row = msqlFetchRow(query_ret);
    char* cdata[] = { row[0], row[1], row[2], row[3] };
    gtk_clist_append(GTK_CLIST(call_list),cdata);
  }

}

void search_callback(GtkWidget* widget, gpointer data) {
  
  GtkWidget* aboutd;
  GtkWidget* labeld;
  GtkWidget* aboutt;
  GtkWidget* okbutton;
  GtkWidget* cabutton;
  GtkWidget* name_entry;
  GtkWidget* hbox;

  hbox = gtk_hbox_new(TRUE,0);
  //gtk_container_border_width(GTK_CONTAINER(hbox), 5);
  okbutton = gtk_button_new_with_label("Ok");
  cabutton = gtk_button_new_with_label("Cancel");
  aboutd = gtk_dialog_new();

  char dtitle[256];
  sprintf(dtitle, "Search by %s", data);
  gtk_window_set_title(GTK_WINDOW(aboutd), dtitle);

  name_entry = gtk_entry_new();
  gtk_box_pack_start(GTK_BOX(hbox), name_entry, FALSE, TRUE, 20);
  

  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (aboutd)->vbox), hbox, TRUE,
		      TRUE, 10);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (aboutd)->action_area), okbutton,
		      TRUE, TRUE, 25);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (aboutd)->action_area), cabutton,
		      TRUE, TRUE, 25);
  gtk_widget_show(okbutton);
  gtk_widget_show(cabutton);
  gtk_widget_show(name_entry);
  gtk_widget_show(hbox);
  gtk_widget_show(aboutd);


  if( strstr((char*)data,"call_date") ) {
    gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
			GTK_SIGNAL_FUNC (search_date_update), name_entry);
    gtk_signal_connect (GTK_OBJECT (name_entry), "activate",
			GTK_SIGNAL_FUNC (search_date_update), name_entry);
  }
  else if( strstr((char*)data,"name") ) {
    gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
			GTK_SIGNAL_FUNC (search_name_update), name_entry);
    gtk_signal_connect (GTK_OBJECT (name_entry), "activate",
			GTK_SIGNAL_FUNC (search_name_update), name_entry);
  }
  else if( strstr((char*)data,"number") ) {
    gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
			GTK_SIGNAL_FUNC (search_numb_update), name_entry);
    gtk_signal_connect (GTK_OBJECT (name_entry), "activate",
			GTK_SIGNAL_FUNC (search_numb_update), name_entry);
  }

  gtk_signal_connect (GTK_OBJECT (cabutton), "clicked",
		      GTK_SIGNAL_FUNC (killwidget), aboutd);

}

void search_date_update(GtkWidget* widget, gpointer data) {
  sprintf(command, 
	  "SELECT number, name, call_date, call_time FROM calls WHERE call_date = '%s'",
	  gtk_entry_get_text(GTK_ENTRY(data)));
  resetlist();
  gtk_widget_destroy(GTK_WIDGET(data)->parent->parent->parent);
}

void search_name_update(GtkWidget* widget, gpointer data) {
  sprintf(command, 
	  "SELECT number, name, call_date, call_time FROM calls WHERE name = '%s'",
	  gtk_entry_get_text(GTK_ENTRY(data)));
  resetlist();
  gtk_widget_destroy(GTK_WIDGET(data)->parent->parent->parent);
}

void search_numb_update(GtkWidget* widget, gpointer data) {
  sprintf(command, 
	  "SELECT number, name, call_date, call_time FROM calls WHERE number = '%s'",
	  gtk_entry_get_text(GTK_ENTRY(data)));
  resetlist();
  gtk_widget_destroy(GTK_WIDGET(data)->parent->parent->parent);
}

