//////////////////////////////////////////////////////////////////////
//
// Class:	  SnmpGet
//
// Description:	  Defines a class which performs SNMP get requests
//		  using the UCD Snmp Mini Client Library
// History:
// 11/13/1998 sean
// Initial Version
//
//////////////////////////////////////////////////////////////////////

#ifndef _SnmpGet_h
#define _SnmpGet_h

extern "C" {
#include <snmp/snmp.h>
}


class BN5399SnmpCollector;

class SnmpGet

{
  friend BN5399SnmpCollector;
  
  private:
    char *_community, *_host;
    void *_clientPtr;

    unsigned char *_result;
    int _resultLength;

  public:

    SnmpGet(char *host, char *community = "public");
    ~SnmpGet();

    int connect();
    void disconnect();

    int poll (oid*, int len);
    

};

#endif
