///////////////////////////////////////////////////////////////////////
//
// Class:	  
// 
// Description:	  
//
// History:
// 11/10/1998 sean
//
///////////////////////////////////////////////////////////////////////

#include "SnmpGet.h"

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <assert.h>
#include <string.h>

SnmpGet::SnmpGet(char *host, char *community)
{
  _host = strdup(host);
  _community = strdup(community);

  assert (_host != NULL);
  assert (_community != NULL);

  _result = NULL;
  _resultLength = -1;
  
}

SnmpGet::~SnmpGet()
{
  if (_community) {
    delete _community;
  }

  if (_result) {
    delete _result;
  }
  
}

int SnmpGet::connect()
{
  int RC = 0;
  
  // Initialize SNMP Library
  init_mini_snmp_client(10);

  // Connect to Host 
  _clientPtr = snmp_mini_open (_host, 161, _community);

  if (_clientPtr != NULL)
    RC = 1;

  return RC;
}

void SnmpGet::disconnect()
{
  close_mini_snmp_client();
  snmp_mini_close(_clientPtr);
}

int SnmpGet::poll (oid *request, int len)
{
  void **data;
  int resultLength;
  unsigned char *result;
  int RC = 0;
  oid **d;
  int *l;

  d = new oid* [1];
  l = new int;
  
  *l = len;
  *d = request;
  
  data = snmp_mini_get (NULL, NULL, 1, d, l, _clientPtr);
  if (data != NULL) {

    // Obtain pointer to result; allocate storage
    resultLength = snmp_mini_response_len(0);
    if (resultLength != _resultLength) {
      delete _result;
      _result = new unsigned char [resultLength];
      assert (_result);
      _resultLength = resultLength;
 
    }
  
    result = (unsigned char*)*data;

    // Copy result 
    memcpy (_result, result, _resultLength);

    RC = 1;
  }

  return RC;

}


  






  
