//////////////////////////////////////////////////////////////////////
//
// Class:	  Poller
//
// Description:	  Object which facilities runs 
//		  BN5399SnmpCollector.poll() function every few seconds
// History:
// 11/13/1998 sean
// Initial Version
//
//////////////////////////////////////////////////////////////////////

#include "Poller.h"
#include "BN5399List.h"
#include <stdlib.h>
#include <stdio.h>
#include <X11/X.h>
#include <assert.h>

void Poller::timeoutCallback ( XtPointer clientData, XtIntervalId * )
{
  Poller *obj = (Poller *) clientData;
  obj->timeout();
}

Poller::Poller()
{
  _list = NULL;
}

void Poller::attachList (BN5399List *l, Widget w)
{
  _list = l;
  _baseWidget = w;  
}

void Poller::timeout()
{
  tick();

  // Install Xt Time out function to call callout
  XtAppAddTimeOut (XtWidgetToApplicationContext (_baseWidget),
		  TIMEOUT,
		  &Poller::timeoutCallback,
		  (XtPointer) this);
}

void Poller::tick()
{
  _list->update();
}

  
