//////////////////////////////////////////////////////////////////////
//
// Class:	  BN5399SnmpCollector
//
// Description:	  Hosts an Array of SnmpGet objects which represent
//		  5399 Blades. Performs getting of led MIB, and 
//		  decodes OID returned.
//
//		  Color Keys:
//		    1000 = 100%	    (Orange)
//		     100 = 75%-100% (Green - 100%)
//		      75 = 50-75%   (Green - 75%)
//		      ....
//
// History:
// 11/14/1998 sean
// Initial Version
//
//////////////////////////////////////////////////////////////////////

#ifndef _BN5399SnmpCollector_h
#define _BN5399SnmpCollector_h

#include "SnmpGet.h"

#define STRSIZE (64)
#define MAXHOSTS (6)

typedef struct {
  char hostname[STRSIZE];
  char community[STRSIZE];
  int active;
  int wan1Usage;
  int wan2Usage;
} BN5399;

class BN5399SnmpCollector {

  private:
    int		      _noBlades;
    BN5399	      _blades[MAXHOSTS];
    SnmpGet	      **_snmpCollectors;

    void decodeBladeLeds(int index);
    void loadBlades();    

  public:

    BN5399SnmpCollector();
    ~BN5399SnmpCollector();

    void poll();

    void  getWanLeds (const int bladeNo, int &wan1, int &wan2);
    int	  getNoBlades () { return _noBlades; }
    char* getBladeName (const int bladeNo);
    int	  getActive(int bladeNo) { return _blades[bladeNo].active; }

};


#endif
  
