//////////////////////////////////////////////////////////////////////
//
// Class:	  BN5399List
//
// Description:	  Displays a bunch of 5399 Led Panels in a Vertical Stack
//
// History:
// 11/13/1998 sean
// Initial Version
//
//////////////////////////////////////////////////////////////////////

#include "BN5399List.h"
#include "BN5399LedPanel.h"
#include "BN5399SnmpCollector.h"

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>

#include <Xm/RowColumn.h>

BN5399List::BN5399List (const char *name, Widget parent)
  : VkComponent(name)
{
  // Initalize Variables
  _noPanels = 0;

  // Create a XmRowColumn widget as the components base widget
  _baseWidget = XmCreateRowColumn (parent, _name, NULL, 0);

  XtVaSetValues(_baseWidget, XmNorientation, XmVERTICAL, NULL);  

  // Install Destroy handler
  installDestroyHandler();

  // Create Collection Object
  _collector = new BN5399SnmpCollector;

  // Now, Create N number of 5399LedPanels for N hosts
  _panels = new BN5399LedPanel* [_collector->getNoBlades()];

  for (int i = 0; i < _collector->getNoBlades(); i++) {
    _panels[i] = new BN5399LedPanel (_collector->getBladeName(i),
				    _baseWidget);

    // If connection to blade was successfull, show the panel, and
    // update hostname
    if (_collector->getActive(i)) {
      _panels[i]->show();
      _panels[i]->setName (_collector->getBladeName(i));
    }
  }

  _noPanels = _collector->getNoBlades();

  _poller.attachList (this, baseWidget());
  _poller.timeout();

}

BN5399List::~BN5399List()
{
  delete _panels;
  delete _collector;
}

const char *BN5399List::className()
{
  return "BN5399List";
}


void BN5399List::update()
{
  int wan1, wan2;
  
  // Poll Device
  _collector->poll();
  
  for (int i = 0; i < _collector->getNoBlades(); i++) {
    // Fetch state of leds for specific panel
    _collector->getWanLeds (i, wan1, wan2);

    // Update LEDS based on panels
    if (_collector->getActive (i)) {
      _panels[i]->setUtilization (1, wan1);
      _panels[i]->setUtilization (2, wan2);
    }
  }

}
      
