//////////////////////////////////////////////////////////////////////
//
// Class:	  BN5399LedPanel
//
// Description:	  Defines a Component which looks like a Bay 5399 Wan 1+2
//		  Led Display
// History:
// 11/13/1998 sean
// Initial Version
//
//////////////////////////////////////////////////////////////////////

#ifndef _BN5399LedPanel_h
#define _BN5399LedPanel_h

#include <Vk/VkComponent.h>

class BN5399LedPanel: public VkComponent {

  protected:
    static String _defaultResources[];
    
    Widget _container,
           _nameLabel,
	   _wan1RowManager,
	     _wan1Label, _wan1Form,
	       _wan1p25, _wan1p50, _wan1p75, _wan1p100,
	   _wan2RowManager,
	    _wan2Label, _wan2Form,
	       _wan2p25, _wan2p50, _wan2p75, _wan2p100;

  private:
    void buildWan1();
    void buildWan2();

    void setWidgetColor (Widget w, char *);
    
  public:
    BN5399LedPanel (const char *, Widget);
    ~BN5399LedPanel();

    virtual const char *className();

    void setName (char *);
    void setUtilization (int port, int utilization);
    
};

#endif
