//////////////////////////////////////////////////////////////////////
//
// Class:	  BN5399LedPanel
//
// Description:	  Defines a Component which looks like a Bay 5399 Wan 1+2
//		  Led Display
// History:
// 11/13/1998 sean
// Initial Version
//
//////////////////////////////////////////////////////////////////////

#include "BN5399LedPanel.h"

#include <stdlib.h>
#include <stdio.h>

#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>

String BN5399LedPanel::_defaultResources[] = {
 "*wan1Label.labelString:   Wan1",
 "*wan2Label.labelString:   Wan2",
 "*wan1Label.fontList:	    -*-helvetica-bold-r-*-*-*-120-75-*-*-*-*-*",
 "*wan2Label.fontList:	    -*-helvetica-bold-r-*-*-*-120-75-*-*-*-*-*",
 "*p25.labelString:	    25%",
 "*p25.fontList:	    -*-helvetica-medium-r-*-*-*-120-75-*-*-*-*-*",
 "*p25.background:	    black",
 "*p25.foreground:	    gray",
 "*p50.labelString:	    50%",
 "*p50.fontList:	    -*-helvetica-medium-r-*-*-*-120-75-*-*-*-*-*",
 "*p50.background:	    black",
 "*p50.foreground:	    gray",
 "*p75.labelString:	    75%",
 "*p75.fontList:	    -*-helvetica-medium-r-*-*-*-120-75-*-*-*-*-*",
 "*p75.background:	    black",
 "*p75.foreground:	    gray",
 "*p100.labelString:		    100%",
 "*p100.fontList:	    -*-helvetica-medium-r-*-*-*-120-75-*-*-*-*-*",
 "*p100.background:	    black",
 "*p100.foreground:	    gray",
 "*nameLabel.labelString:   Hostname: Unknown",
 "*nameLabel.alignment:	    XmALIGNMENT_CENTER",
 "*nameLabel.fontList:	    -*-helvetica-bold-r-*-*-*-120-75-*-*-*-*-*",
 NULL
};

//////////////////////////////////////////////////////////////////////
// BN5399LedPanel Constructor
// 
// Builds Interface
//
//////////////////////////////////////////////////////////////////////
BN5399LedPanel::BN5399LedPanel(const char *name, Widget parent)
      : VkComponent (name)
{

  // Load class-default rsources for this object for creating
  setDefaultResources (parent, _defaultResources);
  
  // Create a XmRowColumn widget as the components base widget
  _baseWidget = XmCreateRowColumn (parent, _name, NULL, 0);

  // Install Destroy handler
  installDestroyHandler();  

  // Give Widget Vertical Orientation.
  // So label is on top, followed by WAN lines
  XtVaSetValues (_baseWidget, XmNorientation, XmVERTICAL, NULL);

  // Create Label Widget to place name in
  _nameLabel = XmCreateLabel (_baseWidget, "nameLabel", NULL, 0);  

  // Create 2 XmRowColumn Widgets to hold the name of the wan on the left, and
  // then the form on thr right
  _wan1RowManager = XmCreateRowColumn (_baseWidget, "wan1RowManager", NULL, 0);
  _wan2RowManager = XmCreateRowColumn (_baseWidget, "wan2RowManager", NULL, 0);  

  // Align Row Manager widgets horizontally
  XtVaSetValues (_wan1RowManager, XmNorientation, XmHORIZONTAL, NULL);
  XtVaSetValues (_wan2RowManager, XmNorientation, XmHORIZONTAL, NULL);    
  
  // Create Wan1, Wan2 Labels
  _wan1Label = XmCreateLabel (_wan1RowManager, "wan1Label", NULL, 0);
  _wan2Label = XmCreateLabel (_wan2RowManager, "wan2Label", NULL, 0);
  
  // Create 2 Form Widgets to manage Wan % Labels
  _wan1Form = XtCreateManagedWidget ("Wan1Form",
	    xmFormWidgetClass,
	    _wan1RowManager,
	    NULL, 0);

  _wan2Form = XtCreateManagedWidget ("Wan2Form",
	    xmFormWidgetClass,
	    _wan2RowManager,
	    NULL, 0);	    

  // Build Widget Trees for Each Widget
  buildWan1();
  buildWan2();

  // Manage Children
  XtManageChild (_nameLabel);
  
  XtManageChild (_wan1Label);
  XtManageChild (_wan1RowManager);

  XtManageChild (_wan2Label);
  XtManageChild (_wan2RowManager);
}  

//////////////////////////////////////////////////////////////////////
//
//
//
//
//////////////////////////////////////////////////////////////////////
void BN5399LedPanel::buildWan1()
{
  // Create Wan1 Dusplay
  // Create 25, 50, 75, and 100 Percent Widgets
  _wan1p25 = XtCreateManagedWidget ("p25",
	  xmLabelWidgetClass,
	  _wan1Form,
	  NULL, 0);

  _wan1p50 = XtCreateManagedWidget ("p50",
	  xmLabelWidgetClass,
	  _wan1Form,
	  NULL, 0);

  _wan1p75 = XtCreateManagedWidget ("p75",
	  xmLabelWidgetClass,
	  _wan1Form,
	  NULL, 0);

  _wan1p100 = XtCreateManagedWidget ("p100",
	  xmLabelWidgetClass,
	  _wan1Form,
	  NULL, 0);	  

  // Specify default resources for Form
  XtVaSetValues (_wan1Form,
	  XmNresizable,		False,
	  XmNhorizontalSpacing,	0,
	  NULL);

  // Attach 25 to left, top of form
  XtVaSetValues (_wan1p25,
	XmNleftAttachment,	XmATTACH_FORM,
	XmNtopAttachment,	XmATTACH_FORM,
	NULL);

  // Attach 50 to right side of 25, top
  XtVaSetValues (_wan1p50,
	XmNleftAttachment,	XmATTACH_WIDGET,
	XmNleftWidget,		_wan1p25,
	XmNtopAttachment,	XmATTACH_FORM,
	NULL);

  // Attach 75 to right side of 50, top
  XtVaSetValues (_wan1p75,
	XmNleftAttachment,	XmATTACH_WIDGET,
	XmNleftWidget,		_wan1p50,
	XmNtopAttachment,	XmATTACH_FORM,
	NULL);

  // Attach 100 to right side of 75, top
  XtVaSetValues (_wan1p100,
	XmNleftAttachment,	XmATTACH_WIDGET,
	XmNleftWidget,		_wan1p75,
	XmNtopAttachment,	XmATTACH_FORM,
	NULL);
}

//////////////////////////////////////////////////////////////////////
//
//
//
//
//////////////////////////////////////////////////////////////////////
void BN5399LedPanel::buildWan2()
{
  // Create Wan1 Display
  // Create 25, 50, 75, and 100 Percent Widgets
  _wan2p25 = XtCreateManagedWidget ("p25",
	  xmLabelWidgetClass,
	  _wan2Form,
	  NULL, 0);


  _wan2p50 = XtCreateManagedWidget ("p50",
	  xmLabelWidgetClass,
	  _wan2Form,
	  NULL, 0);

  _wan2p75 = XtCreateManagedWidget ("p75",
	  xmLabelWidgetClass,
	  _wan2Form,
	  NULL, 0);

  _wan2p100 = XtCreateManagedWidget ("p100",
	  xmLabelWidgetClass,
	  _wan2Form,
	  NULL, 0);	  

  // Specify default resources for Form
  XtVaSetValues (_wan2Form,
	  XmNresizable,		False,
	  XmNhorizontalSpacing,	0,
	  NULL);

  // Attach 25 to left, top of form
  XtVaSetValues (_wan2p25,
	XmNleftAttachment,	XmATTACH_FORM,
	XmNtopAttachment,	XmATTACH_FORM,
	NULL);

  // Attach 50 to right side of 25, top
  XtVaSetValues (_wan2p50,
	XmNleftAttachment,	XmATTACH_WIDGET,
	XmNleftWidget,		_wan2p25,
	XmNtopAttachment,	XmATTACH_FORM,
	NULL);

  // Attach 75 to right side of 50, top
  XtVaSetValues (_wan2p75,
	XmNleftAttachment,	XmATTACH_WIDGET,
	XmNleftWidget,		_wan2p50,
	XmNtopAttachment,	XmATTACH_FORM,
	NULL);

  // Attach 100 to right side of 75, top
  XtVaSetValues (_wan2p100,
	XmNleftAttachment,	XmATTACH_WIDGET,
	XmNleftWidget,		_wan2p75,
	XmNtopAttachment,	XmATTACH_FORM,
	NULL);
}

//////////////////////////////////////////////////////////////////////
//
//
//
//
//////////////////////////////////////////////////////////////////////
BN5399LedPanel::~BN5399LedPanel()
{

}



//////////////////////////////////////////////////////////////////////
//
//
//
//
//////////////////////////////////////////////////////////////////////
const char *BN5399LedPanel::className()
{
  return "BN5399LedPanel";
}

//////////////////////////////////////////////////////////////////////
// 
// Member:	  setName
//
// Description:	  Sets the Blades Name
//
// History:
// 11/13/1998 sean
// Initial Version
//
//////////////////////////////////////////////////////////////////////
void BN5399LedPanel::setName(char *name)
{
  XmString    xmstr;
  char	      buffer[1024];

  // Create Formatted string to display
  sprintf (buffer, "Hostname: %s\n", name);

  xmstr = XmStringCreateSimple (buffer);
  
  // Set nameLabel to string we formatted
  XtVaSetValues ( _nameLabel,
      XmNlabelString,	  xmstr,
      XmNalignment,	  XmALIGNMENT_CENTER,
      NULL);

  XmStringFree (xmstr);
}

void BN5399LedPanel::setUtilization (int port, int utilization)
{
  switch (utilization) {
    case 0:
      if (port == 1) {
	setWidgetColor (_wan1p25, "black");
	setWidgetColor (_wan1p50, "black");
	setWidgetColor (_wan1p75, "black");
	setWidgetColor (_wan1p100, "black");	
      } else if (port == 2) {
	setWidgetColor (_wan2p25, "black");
	setWidgetColor (_wan2p50, "black");
	setWidgetColor (_wan2p75, "black");
	setWidgetColor (_wan2p100, "black");
      }
      break;
    case 25:
      if (port == 1) {
	setWidgetColor (_wan1p25, "green");
	setWidgetColor (_wan1p50, "black");
	setWidgetColor (_wan1p75, "black");
	setWidgetColor (_wan1p100, "black");	
      } else if (port == 2) {
	setWidgetColor (_wan2p25, "green");
	setWidgetColor (_wan2p50, "black");
	setWidgetColor (_wan2p75, "black");
	setWidgetColor (_wan2p100, "black");
      }
      break;
    case 50:
      if (port == 1) {
	setWidgetColor (_wan1p25, "green");
	setWidgetColor (_wan1p50, "green");
	setWidgetColor (_wan1p75, "black");
	setWidgetColor (_wan1p100, "black");	
      } else if (port == 2) {
	setWidgetColor (_wan2p25, "green");
	setWidgetColor (_wan2p50, "green");
	setWidgetColor (_wan2p75, "black");
	setWidgetColor (_wan2p100, "black");
      }
      break;
    case 75:
      if (port == 1) {
	setWidgetColor (_wan1p25, "green");
	setWidgetColor (_wan1p50, "green");
	setWidgetColor (_wan1p75, "green");
	setWidgetColor (_wan1p100, "black");	
      } else if (port == 2) {
	setWidgetColor (_wan2p25, "green");
	setWidgetColor (_wan2p50, "green");
	setWidgetColor (_wan2p75, "green");
	setWidgetColor (_wan2p100, "black");
      }
      break;
    case 100:
      if (port == 1) {
	setWidgetColor (_wan1p25, "green");
	setWidgetColor (_wan1p50, "green");
	setWidgetColor (_wan1p75, "green");
	setWidgetColor (_wan1p100, "green");	
      } else if (port == 2) {
	setWidgetColor (_wan2p25, "green");
	setWidgetColor (_wan2p50, "green");
	setWidgetColor (_wan2p75, "green");
	setWidgetColor (_wan2p100, "green");
      }
      break;
    case 1000:
      if (port == 1) {
	setWidgetColor (_wan1p25, "yellow");
	setWidgetColor (_wan1p50, "yellow");
	setWidgetColor (_wan1p75, "yellow");
	setWidgetColor (_wan1p100, "yellow");	
      } else if (port == 2) {
	setWidgetColor (_wan2p25, "yellow");
	setWidgetColor (_wan2p50, "yellow");
	setWidgetColor (_wan2p75, "yellow");
	setWidgetColor (_wan2p100, "yellow");
      }
      break;                  
  }

}

void BN5399LedPanel::setWidgetColor (Widget w, char *color)
{
  XtVaSetValues (w,
    XtVaTypedArg, XmNbackground,
    XtRString, color,
    strlen(color)+1, NULL);
}
