# Make Matrix from List
proc creatematrix {win list typ} {
    if { $list=="" } { 
	global lan
	label $win -text $lan(emptymatrix)
	return
    }
    frame $win
    set y 0
#   puts "matrix $list"
    foreach row $list {
#	puts "mrow $y $row"
	set x 0
	foreach col $row {
#	   puts "mcol $x $col"
	   create${typ}w "${win}.num${y}_${x}" $col no yes
	   grid "${win}.num${y}_${x}" -row $y -column $x -sticky we 
	   incr x
	}
	incr y
    } 
}
proc createstring {win list typ} {
    label $win -text $list
}
proc onecolumnmatrix matrix {
    set ret ""
    foreach onecell $matrix {
	lappend ret [list $onecell]
    }
    return $ret
}
proc createsolution {win list typ} {
    frame $win
    label $win.sol -text X=
#   puts "sol $list"
    creatematrix $win.mat0 [onecolumnmatrix [lindex $list 0]] $typ
    set i 1
    pack $win.sol $win.mat0 -side left
    foreach morematrix [lrange $list 1 end] {
	label $win.index${i} -text +x${i}
	creatematrix $win.mat${i} [onecolumnmatrix $morematrix] $typ
	pack $win.index${i} $win.mat${i} -side left
    }
}
proc createeqnarray {win list typ} {
    set z 0
    frame $win
#    puts "eqnarray $list"
    foreach zeile $list {
	set i 0
	frame $win.left${z}
	frame $win.right${z}
	foreach elem [lrange $zeile 0 [expr [llength $zeile]-2]] {
	    if {[llength $elem]==1} {
		create${typ}w "${win}.left${z}.num${i}" [lindex $elem 0] no
		pack ${win}.left${z}.num${i} -side left
	    } else {
		label ${win}.left${z}.label${i} -text "x[lindex $elem 1]"
		if {[lindex $elem 0]==""} {
		    pack ${win}.left${z}.label${i} -side left
		} else {
		    create${typ}w "${win}.left${z}.num${i}" [lindex $elem 0] no
		    pack ${win}.left${z}.num${i} ${win}.left${z}.label${i} -side left
		}
	    }
	    incr i
	}
	set elem [lindex $zeile [expr [llength $zeile]-1]]
	label ${win}.right${z}.label -text =
	create${typ}w "${win}.right${z}.num${i}" $elem no
	pack ${win}.right${z}.label ${win}.right${z}.num${i} -side left
	
	grid $win.left${z} -column 0 -row $z -sticky e
	grid $win.right${z} -column 1 -row $z -sticky w
	incr z
    }
}
proc createpolynom {win list typ} {
    frame $win
    set i 0
#    puts "polynom $list"
    foreach item $list {
        if {[llength $item]==2} {
            create${typ}w "${win}.num${i}" [lindex $item 0] no
            label ${win}.label${i} -text "x^[lindex $item 1]"
            pack ${win}.num${i} ${win}.label${i} -side left
        } else {
            create${typ}w "${win}.num${i}" $item no
            pack ${win}.num${i} -side left
        }
        incr i
    }
}
proc createsimplex {win list typ} {
#    puts "simplex $list"
    frame $win
    creatematrix $win.mat [lrange $list 0 [expr [llength $list]-2]] $typ
    frame $win.func
    set func [lindex $list [expr [llength $list]-1]]
    set const [lindex $func 0]
    
    label ${win}.func.lab -text G(x)=
    pack ${win}.func.lab -side left
    if {[llength $const]!=2} {
        create${typ}w "${win}.func.const" $const no
        pack ${win}.func.const -side left
        set func [lrange $func 1 end]
    }
    set i 0
    foreach elem $func {
	label ${win}.func.label${i} -text "x[lindex $elem 1]"
	create${typ}w "${win}.func.num${i}" [lindex $elem 0] no
	pack ${win}.func.num${i} ${win}.func.label${i} -side left
	incr i
    }
    pack $win.mat -side top -anchor w
    pack $win.func -side top -anchor w
}
proc createdeterminante {win list typ} {
    create${typ}w "${win}" [lindex $list 0] no
}
proc createscalar {win list typ} {
    create${typ}w "${win}" [lindex $list 0] no
}
proc createform {win list typ} {
    frame $win
    set f 0
#    puts "form $list koniec"
    foreach form $list {
#	puts "$form -[lindex $form 0]-"
	set ctyp [lindex $form 0]
	if {$ctyp!="" && $ctyp!="\}"} {
	    create$ctyp ${win}.form${f} [lrange $form 1 end] $typ
	    pack ${win}.form${f} -side top -anchor w
	    incr f
	}
    }
}
# Bildet oder Aktualiesiert Windows mit Ergebnis und Protokoll
proc createvieww {w matrix was} {
    global lan
    toplevel $w
    frame $w.mb -relief raised -bd 2
    menubutton $w.mb.button1 -text $lan(viewmenu) -relief raised -menu $w.mb.button1.m
    menu $w.mb.button1.m
    $w.mb.button1.m add command -label $lan(print) \
	    -command "printmatrix $matrix $was"
    $w.mb.button1.m add command -label $lan(printpreview) \
	    -command "printpreviewmatrix $matrix $was"
    if {$was=="solution"} {
        global whandle
        # is th matrix name the window name too
        if {[info exist whandle(.$matrix)] & $whandle(.$matrix)=="$matrix"} {
            $w.mb.button1.m add command -label $lan(editsolution) \
                    -command "solution2first_handler .$matrix"
        }
    }
    $w.mb.button1.m add command -label $lan(closeview) \
	    -command "destroy $w"
    pack $w.mb.button1 -side left

    frame $w.mframe
    canvas $w.can \
	    -relief ridge \
	    -xscrollcommand "$w.hscroll set" \
	    -yscrollcommand "$w.vscroll set" \
	    -xscrollincrement 10 \
	    -yscrollincrement 10
    scrollbar $w.vscroll -command "$w.can yview"
    scrollbar $w.hscroll -orient horiz -command "$w.can xview"
    
    grid $w.can -in $w.mframe \
	    -row 0 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid $w.vscroll -in $w.mframe \
	    -row 0 -column 1 -rowspan 1 -columnspan 1 -sticky news
    grid $w.hscroll -in $w.mframe \
	    -row 1 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid rowconfig    $w.mframe 0 -weight 1 -minsize 0
    grid columnconfig $w.mframe 0 -weight 1 -minsize 0
    pack $w.mb -fill x -side top
    pack $w.mframe -fill both -expand yes -side top
    global $matrix
    if {[info exists ${matrix}(filename)]} {
	set title [file tail [set ${matrix}(filename)]]
    } else {
	set title $matrix
    }
    wm title $w "$title $was"
}
proc actualise_output {matrix was {check no}} {
    set w .${matrix}_${was}
    set stuff [matrixtcl $matrix getform tcl -$was]
    if {[winfo exists $w]} {
	$w.can delete form
	destroy $w.can.form
    } else {
	global option
	if {!$option(open${was}) && $check=="yes"} {
	    return
	} else {
	    createvieww $w $matrix $was
	}
    }
    createform $w.can.form $stuff [matrixtcl $matrix info type]
    $w.can create window 0 0 -window $w.can.form -anchor nw -tag form
    #	$w.can config -scrollregion [$w.can bbox form] -width 15c -height 10c
    bind $w.can <Configure> "$w.can config -scrollregion \[$w.can bbox form\]"
    # nchste Zeile bringt nichts vielleicht erst abwarten
    tkwait visibility $w.can.form
    $w.can config -scrollregion [$w.can bbox form]
}
proc view_output {root {check no}} {
    set matrix [getmatrix $root]
    set wname [getroot $root]
    # Zuerst Ergebniss
    if {[matrixtcl $matrix info issolution]} {
        actualise_output $matrix solution $check
    } elseif  {[winfo exists .${matrix}_solution]} {
        destroy .${matrix}_solution
     }
    # Protokol 
    if {[matrixtcl $matrix info isprotokol]} {
        actualise_output $matrix protokol $check
    } elseif {[winfo exists .${matrix}_protokol]} {
            destroy .${matrix}_protokol
     }
}







