# Dieses Teil inistialiesiert und benutzt Toolbar
proc inittoolbarimages {} {
    global progdir
    if {[llength [image names]]<5} {
	foreach im [glob -nocomplain [file join $progdir images *.gif]] {
	    image create photo [file tail $im] -file $im
	}    
    }
}
proc maketoolbar win {
    global lan
    inittoolbarimages
    set w $win.toolbar
    frame $w -bd 1 -relief ridge
    set bars {
	{new nullmatrix mb.button1.newmatrix} {open open mb.button1}
	{save save mb.button1} {print print mb.button1}
	{cut copy mb.button2} {paste paste mb.button2}
	{viewerg vsolution mb.button4} {viewprot vprotokol mb.button4}
	{info info mb.help}
    }
    set colnum 0
    foreach bar $bars {
	set name [lindex $bar 0]
	set mname [lindex $bar 1]
	set menu [lindex $bar 2]
	set command [$win.$menu entrycget $lan($mname) -command]
	button $win.toolbar.$name -image ${name}.gif -command $command \
	    -takefocus 0 -bg #c0c0c0 -highlightbackground #c0c0c0
	pack $win.toolbar.$name -side left
	incr colnum
    }
}
# this is called by variable trace command option(toolbar)
proc changetoolbar {name1 name2 op} {
    global option whandle
    if {[info exists whandle]!=1} {
	if {$option(toolbar)} {
	    maketoolbar ""
	    pack .toolbar -side top -anchor e -fill x -after .mb
	} else {
	    destroy .toolbar
	}
    } else {
	set indicator [array startsearch whandle]
	while {[array anymore whandle $indicator]} {
	    set elem [array nextelement whandle $indicator]
	    if {$elem=="."} { set elem ""}
	    if {$option(toolbar)} {
		maketoolbar $elem
		pack $elem.toolbar -side top -anchor e -fill x -after $elem.mb
	    } else {
		destroy ${elem}.toolbar
	    }
	}
    }
}









