#!/usr/bin/wish -f
# to proper work of this programm
# set this varibale "progdir" to path of the dir whith this programm 
# !! whithout ending / and not including ~
# and variable "helpdir" to the dir with html help files
# set progdir dummy
if {![info exist DynLinked]} {
    set DynLinked 1
}
if {$DynLinked} {
#    set progdir /usr/lib/tkmatrix
    set sname [info script]
    if {$sname==""} {
	# Run interactive for develop purposes
	set progdir /home/artur/tkmatrix
    } else {
	file lstat $sname stats
	# follow sym links
	if {$stats(type)=="link"} {
	    set sname [file readlink $sname]
	}
	set progdir [file dirname $sname]
    }
} else {
    set progdir [file dirname [info nameofexecutable]]
}
#set progdir /home/artur/tkmatrix
# Set dir with html help files
set helpdir  /usr/doc/tkmatrix-0.6.2
#set helpdir /home/artur/tkmatrix/docus
#use octave interface
if {$tcl_platform(platform)=="windows"} {
	# Only for cygnus tcl version
	load cygtclreg80.dll registry
	set octave 0
} else {
	set octave 1
}
#set dir to octave-tkmatrix scripts .tkm
set octave_scriptdir $progdir
#use own float widget
if {![info exist floatwidget]} {
    set floatwidget 1
}
#use TkTable widget
set tktable 1

#checking progdir if dummy than show message and exit
proc checkprogdir {} {
    global progdir helpdir
    if {$progdir == "dummy" || $helpdir == "dummy" || ![file exists [file join $progdir tkmatrix.tcl]]} {
	tk_messageBox -title {installation not proper} -message {for successfull installation you need to edit the "tkmatrix.tcl" file and change variable progdir and helpdir to the dictionary where this program is and where the html help files are. It is necessary for finding program modules.} \
	-icon error -type ok
	exit
    }
}
#check progdir if setting oder dummy
checkprogdir

# Language Setting
set option(language) dummy

#Funktion Definition
# Load all Dialogs
source [file join $progdir dialogs.tcl]
# Load Menu Handler (Callbacks)
source [file join $progdir hmenu.tcl]
# Load Sources fr elementare Unformungen und Behandlung von Editierzustnden
source [file join $progdir editmode.tcl]
# Load Ergebnis und Protokol Viewer
source [file join $progdir viewprot.tcl]
# Print und  Printpreview mit Benutzung von Latex, dvips, xdvi oder 
# ghostview gv
source [file join $progdir print.tcl]
# Hilfe und About (Info) Dialogs
source [file join $progdir about.tcl]
# Preferences and Language
source [file join $progdir preferences.tcl]
# Toolbar
source [file join $progdir toolbar.tcl]
# octave interface
source [file join $progdir octave.tcl]
# load float widget library
# Prozeduren fr behandlung von Editfenster

if {$floatwidget} {
    global DynLinked
    if {$DynLinked} {
	load [file join $progdir float.so]
    }
    proc unmarkregion_rational {win ypos1 xpos1 ypos2 xpos2} {
	global background
	if {$ypos1>$ypos2} { set y $ypos1; set ypos1 $ypos2; set ypos2 $y }
	if {$xpos1>$xpos2} { set x $xpos1; set xpos1 $xpos2; set xpos2 $x }
	for {set y $ypos1} {$y<=$ypos2} {incr y} {
	    for {set x $xpos1} {$x<=$xpos2} {incr x} {
		set thiswin "$win.num${y}_${x}"
		$thiswin configure -bg $background
	    }
	}
    }
    proc markregion_rational {win ypos1 xpos1 ypos2 xpos2} {
	if {$ypos1>$ypos2} { set y $ypos1; set ypos1 $ypos2; set ypos2 $y }
	if {$xpos1>$xpos2} { set x $xpos1; set xpos1 $xpos2; set xpos2 $x }
	#    puts "$ypos1 $xpos1 $ypos2 $xpos2"
	for {set y $ypos1} {$y<=$ypos2} {incr y} {
	    for {set x $xpos1} {$x<=$xpos2} {incr x} {
		set thiswin "$win.num${y}_${x}"
		$thiswin configure -bg blue
	    }
	}
    }
    proc markregion_one_rational {win ypos xpos} {
	$win configure -bg blue
    }
    proc createrationalw { name {rational 0} {bind no} {border no}} {
	if {$border=="yes"} {
	    float $name -text $rational
	} else {
	    float $name -text $rational -relief flat
	}
	if {[string compare $bind no]!=0} {
	    bind $name <Button-1> "handlebuttondown %W rational"
	    bind $name <Shift-Button-1> "handlemark %W rational"
	}
    }
    proc setrationalw { name {rational 0}} {
	$name configure -text $rational
    }
} else {
    proc unmarkregion_rational {win ypos1 xpos1 ypos2 xpos2} {
	global background
	if {$ypos1>$ypos2} { set y $ypos1; set ypos1 $ypos2; set ypos2 $y }
	if {$xpos1>$xpos2} { set x $xpos1; set xpos1 $xpos2; set xpos2 $x }
	for {set y $ypos1} {$y<=$ypos2} {incr y} {
	    for {set x $xpos1} {$x<=$xpos2} {incr x} {
		set thiswin "$win.num${y}_${x}"
		$thiswin config -bg $background
		$thiswin.ganzzahl config -bg $background
		$thiswin.zaehler config -bg $background
		$thiswin.nenner config -bg $background
	    }
	}
    }
    proc markregion_rational {win ypos1 xpos1 ypos2 xpos2} {
	if {$ypos1>$ypos2} { set y $ypos1; set ypos1 $ypos2; set ypos2 $y }
	if {$xpos1>$xpos2} { set x $xpos1; set xpos1 $xpos2; set xpos2 $x }
	#    puts "$ypos1 $xpos1 $ypos2 $xpos2"
	for {set y $ypos1} {$y<=$ypos2} {incr y} {
	    for {set x $xpos1} {$x<=$xpos2} {incr x} {
		set thiswin "$win.num${y}_${x}"
		$thiswin config -bg blue
		$thiswin.ganzzahl config -bg blue
		$thiswin.zaehler config -bg blue
		$thiswin.nenner config -bg blue
	    }
	}
    }
    proc markregion_one_rational {win ypos xpos} {
	$win config -bg blue
	$win.ganzzahl config -bg blue
	$win.zaehler config -bg blue
	$win.nenner config -bg blue
    }
    proc createrationalw { name {rational 0} {bind no} {border no}} {
	if {[llength $rational]==2} {
	    set rational [linsert $rational 0 {}]
	}
	if {$border=="yes"} {
	    frame $name -borderwidth 1 -relief groove
	} else {
	    frame $name -borderwidth 0
	}
	label $name.ganzzahl -text [lindex $rational 0] -font {-Adobe-Helvetica-Bold-R-Normal--*-180-*-*-*-*-*-*}
	label $name.zaehler -text [lindex $rational 1] -pady 0
	label $name.nenner -text [lindex $rational 2] -pady 0
	if {[llength $rational]==1} {
	    frame $name.strich
	} else {
	    frame $name.strich -bg black
	}
	grid $name.ganzzahl -row 0 -column 0 -rowspan 3
	grid $name.zaehler -row 0 -column 1
	grid $name.strich -row 1 -column 1 -sticky we
	grid $name.nenner -row 2 -column 1
	if {[string compare $bind no]!=0} {
	    bind $name <Button-1> "handlebuttondown %W rational"
	    bind $name.ganzzahl <Button-1> "handlebuttondown %W rational"
	    bind $name.zaehler <Button-1> "handlebuttondown %W rational"
	    bind $name.nenner <Button-1> "handlebuttondown %W rational"
	    bind $name <Shift-Button-1> "handlemark %W rational"
	    bind $name.ganzzahl <Shift-Button-1> "handlemark %W rational"
	    bind $name.zaehler <Shift-Button-1> "handlemark %W rational"
	    bind $name.nenner <Shift-Button-1> "handlemark %W rational"
	}
    }
    proc setrationalw { name {rational 0}} {
	if {[llength $rational]==2} {
	    set rational [linsert $rational 0 {}]
	}
	$name.ganzzahl configure -text [lindex $rational 0]
	$name.zaehler configure -text [lindex $rational 1]
	$name.nenner configure -text [lindex $rational 2]
	if {[llength $rational]==1} {
	    $name.strich configure -bg [lindex [$name.strich configure -bg] 3]
	} else {
	    $name.strich configure -bg black
	}
    }
}
proc markregion_one_float {win ypos xpos} {
    $win config -bg blue
}
proc markregion_one_widefloat {win ypos xpos} {
    markregion_one_float $win $ypos $xpos
}
proc unmarkregion_float {win ypos1 xpos1 ypos2 xpos2} {
    global background
    if {$ypos1>$ypos2} { set y $ypos1; set ypos1 $ypos2; set ypos2 $y }
    if {$xpos1>$xpos2} { set x $xpos1; set xpos1 $xpos2; set xpos2 $x }
    for {set y $ypos1} {$y<=$ypos2} {incr y} {
	for {set x $xpos1} {$x<=$xpos2} {incr x} {
	    $win.num${y}_${x} config -bg $background
	}
    }
}
proc unmarkregion_widefloat {win ypos1 xpos1 ypos2 xpos2} {
    unmarkregion_float $win $ypos1 $xpos1 $ypos2 $xpos2
}
proc markregion_float {win ypos1 xpos1 ypos2 xpos2} {
    if {$ypos1>$ypos2} { set y $ypos1; set ypos1 $ypos2; set ypos2 $y }
    if {$xpos1>$xpos2} { set x $xpos1; set xpos1 $xpos2; set xpos2 $x }
#    puts "$ypos1 $xpos1 $ypos2 $xpos2"
    for {set y $ypos1} {$y<=$ypos2} {incr y} {
	for {set x $xpos1} {$x<=$xpos2} {incr x} {
	    $win.num${y}_${x} config -bg blue
	}
    }
}
proc markregion_widefloat {win ypos1 xpos1 ypos2 xpos2} {
    markregion_float $win $ypos1 $xpos1 $ypos2 $xpos2
}
# Sucht den Eindeutigen Namen fr Root
proc getroot root {
    if {[string length $root]==0} {
	return .
    } else {
	return $root
    }
}
# Handler fr Button Down
# Kann auch benutzt werden um neue Position anzusteuern
proc handlebuttondown {win typ} {
    global whandle option
    regexp {(.*)\.can\.matrix\.num([0-9]+)_([0-9]+)} $win dummy root lrow lcol
    global xpos$root ypos$root edit$root emode$root
    set matrix $whandle([getroot $root])
    global ${matrix}
    
    if {[set ${matrix}(yaltpos)]!=-1} {
	unmarkregion_${typ} "$root.can.matrix" \
	    [set ${matrix}(yaltpos)] [set ${matrix}(xaltpos)] \
	    [set ${matrix}(yactpos)] [set  ${matrix}(xactpos)]
    }
    markregion_one_${typ} "$root.can.matrix.num${lrow}_${lcol}" $lrow $lcol
    set ${matrix}(yaltpos) $lrow
    set ${matrix}(xaltpos) $lcol
    set ${matrix}(yactpos) $lrow
    set ${matrix}(xactpos) $lcol

    if {$typ=="rational" && $option(editonlyfraction)==1} {
	set rational [matrixtcl ${matrix} getelem $lrow $lcol -onlyfraction]
    } else {
	set rational [matrixtcl ${matrix} getelem $lrow $lcol]
    }
    if {$typ=="rational"} {
	regsub -all " " $rational , rational
	regsub -- "-," $rational - rational
    } 
    set edit$root $rational
    if {[set emode$root]} {
	$root.workarea.edit selection range 0 end
    }
    
    set xpos$root "x=$lcol"
    set ypos$root "y=$lrow"
    # Wenn angeschaltete elem. Unformungen dann probiere sinnvoll die
    # Koordinaten aus aktuell Markirten Position in die Editierfelder zu bertragen
    if {[winfo exists $root.elemunf]} {
	global ${root}_editmode
	if {[set ${root}_editmode]=="elemunf"} {
	    buttondown_elemunf $root $matrix $lrow $lcol
	}
    }
}
# Shiht + Button1
# Markierung
proc handlemark {win typ} {
    global whandle
    regexp {(.*)\.can\.matrix\.num([0-9]+)_([0-9]+)} $win dummy root lrow lcol
    if {[string length $root]==0} { 
	set matrix $whandle(.)
    } else {
	set matrix $whandle($root)
    }
    global ${matrix}
    set laltrow [set ${matrix}(yaltpos)]
    set laltcol [set ${matrix}(xaltpos)]
    set lactrow [set ${matrix}(yactpos)]
    set lactcol [set ${matrix}(xactpos)]
    if {$lactrow != $lrow || $lactcol != $lcol} {
	unmarkregion_${typ} "$root.can.matrix" $laltrow $laltcol $lactrow $lactcol
	set ${matrix}(yactpos) $lrow
	set ${matrix}(xactpos) $lcol
	markregion_${typ} "$root.can.matrix" $laltrow $laltcol $lrow $lcol
    }
}
# Return in Editiefeld
proc handlereturn win {
    global whandle option
    regexp {(.*)\.workarea} $win dummy root
    if {[string length $root]==0} { 
	set matrix $whandle(.)
    } else {
	set matrix $whandle($root)
    }
    global ${matrix} edit$root
    set rational [set edit$root]
    if {[string length $rational]!=0} {
	set typ [matrixtcl $matrix info type]
	set ypos1 [set ${matrix}(yactpos)]
	set xpos1 [set ${matrix}(xactpos)]
	set ypos2 [set ${matrix}(yaltpos)]
	set xpos2 [set ${matrix}(xaltpos)]
	if {$typ == "rational"} {
	    regsub -all " " $rational "" rational
	    regsub -all "," $rational " " rational
	    regsub -all "/" $rational " " rational
	}
	if {$typ=="rational" && [regexp {(^-?[0-9]+)( [0-9]+)*$} $rational]==0} {
	    global lan
	    tk_messageBox -type ok -title $lan(errormsg) \
                -message $lan(errornofraction) -icon error
	    return
	    
	} 
        if {$typ=="rational" && $option(editonlyfraction)==1} {
            set nrational [matrixtcl $matrix setelem $ypos1 $xpos1 $rational \
                    -onlyfraction]
        } else {
            set nrational [matrixtcl $matrix setelem $ypos1 $xpos1 $rational]
        }
	if {$xpos1!=$xpos2 && $ypos1!=$ypos2} {
	    if {$ypos1>$ypos2} { set y $ypos1; set ypos1 $ypos2; set ypos2 $y }
	    if {$xpos1>$xpos2} { set x $xpos1; set xpos1 $xpos2; set xpos2 $x }
	    for {set y $ypos1} {$y<=$ypos2} {incr y} {
		for {set x $xpos1} {$x<=$xpos2} {incr x} {
		    set${typ}w $root.can.matrix.num${y}_${x} $nrational
		    matrixtcl $matrix setelem $y $x $rational
		}
	    }
	} else {
	    set${typ}w $root.can.matrix.num${ypos1}_${xpos1} $nrational
	}
    }
    cursormove $root 1 0
}
# Allgemeine Prozedur fr Bewegung des Kursor
proc cursormove {root dx dy} {
    global whandle
    set matrix $whandle([getroot $root])
    global ${matrix}
    set clickedy [set ${matrix}(yactpos)]
    set clickedx [set ${matrix}(xactpos)]
    set mhoehe  [lindex [matrixtcl $matrix info size] 0]
    set nbreite [lindex [matrixtcl $matrix info size] 1]
    
    set x [expr ($clickedx+$dx) % $nbreite]
    if {$x<0} {   // y verkleinern
	set ty [expr ($clickedy-(-$x+$nbreite-1)/$nbreite)%$mhoehe]
        incr x $nbreite
    } else {
	set ty [expr ($clickedy+($clickedx+$dx)/$nbreite)%$mhoehe]
    }
    set y [expr ($ty+$dy)%$mhoehe]
    if {$y<0} {
	set x [expr ($x-(-$clickedy-$dy+$mhoehe())/$mhoehe)%$nbreite]
	if {$x<0} { incr x $nbreite }
	incr y $mhoehe
    } else { 
	set x [expr ($x+($clickedy+$dy)/$mhoehe)%$nbreite]
    }
    handlebuttondown $root.can.matrix.num${y}_${x} [matrixtcl $matrix info type]
}

proc createfloatw { name {num 0} {bind no} {border no} {type float}} {
    if {$border=="yes"} {
	label $name -borderwidth 1 -relief groove -text $num
    } else  {
	label $name -borderwidth 1 -relief flat -text $num
    }
    if {[string compare $bind no]!=0} {
	bind $name <Button-1> "handlebuttondown %W $type"
	bind $name <Shift-Button-1> "handlemark %W $type"
    }
}
proc createwidefloatw { name {num 0} {bind no} {border no}} {
    createfloatw $name $num $bind $border widefloat
}
proc setfloatw { name {rational 0}} {
    $name configure -text $rational
}
# 
# unformating widewidget. Get Elem lifiert strings in format 
# [-]1223e[-]22
# z.B. -234e2 bedeutet -23.4
# Diese Prozedur macht eine Unformaung nach der Options Parameter
#
# proc widefloat_unformat {rational} {
#     if {$rational=="0"} { return 0 }
#     regexp {(-?)([0-9]+)e([-0-9]+)} $rational - sign base exp
#     global option
#     if {$exp==0} {
# 	return "${sign}0.${base}"
#     } elseif {$option(widefloat_reformat) && $option(widefloat_width)>abs($exp)} { 
# 	if {$exp>0} {
# 	    if {$exp>=[string length $base]} {
# 		for {set x [string length $base]} {$x<$exp} {incr x} {set base "${base}0"}
# 		return $base
# 	    } else {
# 		return "[string range $base 0 [expr $exp-1]].[string range $base $exp end]"
# 	    }
# 	} else {
# 	    for {set x 1} {$x<=(-$exp)} {incr x} {set base "0${base}"}
# 	    return "0.$base"	    
# 	}
#     } else {
# 	return "${sign}0.${base}e${exp}"
#     }
# }
proc setwidefloatw {name {rational 0}} {
    setfloatw $name $rational
}
proc creatematrixw {name matrix {bind no}} {
    global option
    set size [matrixtcl ${matrix} info size]
    set typ  [matrixtcl ${matrix} info type]
    set lrows [lindex $size 0]
    set lcols [lindex $size 1]
#    puts "$lrows $lcols"
    for {set y 0} {$y<$lrows} {incr y} {
	for {set x 0} {$x<$lcols} {incr x} {
            if {$typ=="rational" && $option(editonlyfraction)==1} {
                set elem [matrixtcl ${matrix} getelem $y $x -onlyfraction]
            } else {
                set elem [matrixtcl ${matrix} getelem $y $x]
            }
	    create${typ}w "${name}.num${y}_${x}" $elem $bind yes
	    grid "${name}.num${y}_${x}" -row [expr 1+$y] -column [expr 1+$x] -sticky we
	}
    }
    for {set y 0} {$y<$lrows} {incr y} {
	label ${name}.yl$y -text $y -bg red -bd 1 -relief groove
	grid "${name}.yl${y}" -column 0 -row [expr 1+$y] -sticky nwse
    }    
    for {set x 0} {$x<$lcols} {incr x} {
	label ${name}.xl$x -text $x -bg red -bd 1 -relief groove 
	grid "${name}.xl${x}" -row 0 -column [expr 1+$x] -sticky we
    }    
}
proc scroll_set {win min max} {
 $win set $min $max
    return
    if {$min == 0 && $max == 1} {
        grid forget $win
    } else {
        grid $win
        $win set $min $max
    }    
}
proc can_view {list how args} {
    foreach canvas $list {
        eval "$canvas ${how}view $args"
    }
}
# Bedeutung von whandle
# ein Array das den Windowsnamen die Matrixbezeichnung
# Handler
# (aus matrixtcl) zuordnet
# Sie enthlt alle Matrixfenster
# Windowsname korespondieren aber mit der Bezeichnung so
# haber die Toplevelfenster oft den Namen
# .matrix2
proc putmatrixw {root matrix} {
    if {[winfo exists $root.can.matrix]} {
	$root.can delete matrix
	destroy $root.can.matrix
    }
    if {[matrixtcl $matrix info size] == "0 0"} {
#	puts "Zero Matrix!"
	return
    }
    frame $root.can.matrix
    $root.can create window 0 0 -window $root.can.matrix -anchor nw -tag matrix
    creatematrixw $root.can.matrix ${matrix} yes
    global whandle
    set wname [getroot $root]
    set whandle($wname) $matrix
    global $matrix
    set ${matrix}(yaltpos) -1
    set ${matrix}(xaltpos) -1
    set ${matrix}(yactpos) -1
    set ${matrix}(xactpos) -1
    set ${matrix}(editmode) edit
    handlebuttondown $root.can.matrix.num0_0 [matrixtcl $matrix info type]
    if {[info exists ${matrix}(filename)]} {
	wm title $wname "matrix- [file tail [set ${matrix}(filename)]] [matrixtcl $matrix info size]"
    } else {
	wm title $wname "matrix- $matrix [matrixtcl $matrix info size]"
    }
}
proc del_matrixwin {root win} {
   #puts "del_amtrxi $root $win"
    if {$root == ""} { return }
#    if {[string match *.toolbar* $win]} { return }
#   When destroyed child widget than ignore
    if {[string match *.*.* $win]} { return }
    global whandle
    set wname [getroot $root]
    if {[info exists whandle($wname)]} {
	set matrix $whandle($wname)
	global $matrix ${wname}_editmode
	matrixtcl destroy $matrix
        ctrdelmatrix $matrix
	if {[winfo exists .${matrix}_solution]} {
	    destroy .${matrix}_solution
	}
	if {[winfo exists .${matrix}_protokol]} {
	    destroy .${matrix}_protokol
	}
	global edit$wname emode$wname xpos$wname ypos$wname
	unset whandle($wname)
        bind $wname <Destroy>
        destroy $wname 
	# Hier ist nich doe einzige Stelle wo die Variblaen
	# gelscht werden sollen. Siehe mcolse und hdeactivate in hmode.tcl
	unset $matrix ${wname}_editmode \
	    edit${wname} emode$wname xpos${wname} ypos${wname}
	if {[info globals ${wname}_modi]=="${wname}_modi"} {
	    global ${wname}_modi ${wname}_rowcol  
	    trace vdelete ${wname}_modi w newmodi_handler
	    unset ${wname}_modi ${wname}_rowcol
	} 
    }
}                                                     
#Init menu Buttons
proc createmainw root {
    global lan option xpos$root ypos$root emode$root octave
    menu $root.mb -tearoff 0
	 menu $root.mb.button1 -tearoff 0
	 menu $root.mb.button2 -tearoff 0
	 menu $root.mb.button3 -tearoff 0
	 menu $root.mb.button4 -tearoff 0
	 menu $root.mb.help -tearoff 0

 	 $root.mb add cascade -label $lan(file) -menu $root.mb.button1 -underline 0
 	 $root.mb add cascade -label $lan(edit) -menu $root.mb.button2 -underline 0
 	 $root.mb add cascade -label $lan(algorithmus) -menu $root.mb.button3 -underline 0
 	 $root.mb add cascade -label $lan(view) -menu $root.mb.button4 -underline 0
 	 $root.mb add cascade -label $lan(help) -menu $root.mb.help -underline 0

    $root.mb.button1 add cascade -label $lan(new) \
	-menu $root.mb.button1.newmatrix
   $root.mb.button1 add command -label $lan(open) \
	-command "open_matrix {$root}"
    $root.mb.button1 add command -label $lan(save) \
	-command "save_handler {$root}"
   $root.mb.button1 add command -label $lan(save_as)  \
	-command "saveas_handler {$root}"
   $root.mb.button1 add cascade -label $lan(import) \
	-menu $root.mb.button1.import
    $root.mb.button1 add cascade -label $lan(extra_save) \
	-menu $root.mb.button1.extrasave
   $root.mb.button1 add separator
    $root.mb.button1 add command -label $lan(print) \
	-command "print_handler {$root}"
   $root.mb.button1 add command -label $lan(printpreview)  \
	-command "ppreview_handler {$root}"
   $root.mb.button1 add separator
   $root.mb.button1 add cascade -label $lan(save_solution) \
	-menu $root.mb.button1.ssolution -state disabled
   $root.mb.button1 add cascade -label $lan(save_protokol) \
	-menu $root.mb.button1.sprotokol -state disabled
   $root.mb.button1 add separator
   if {$root!=""} {
       $root.mb.button1 add command -label $lan(close)  \
	-command "del_matrixwin {$root} $root"
   }
   $root.mb.button1 add command -label $lan(deactivate)  \
           -command "hdeactivate {$root}"
   $root.mb.button1 add command -label $lan(end)  \
	-command "end_handle {$root}"

   menu $root.mb.button1.newmatrix -tearoff 0
   $root.mb.button1.newmatrix add  command -label $lan(nullmatrix) \
	-command "new_matrix {$root} nullmatrix"
   $root.mb.button1.newmatrix add  command -label $lan(einheitsmatrix) \
	-command "new_matrix {$root} einheitsmatrix"
   $root.mb.button1.newmatrix add  command -label $lan(randommatrix) \
	-command "new_matrix {$root} randommatrix"

   menu $root.mb.button1.import -tearoff 0
   $root.mb.button1.import add  command -label octave-text \
	-command "import_handler {$root} octave_text"
   $root.mb.button1.import add  command -label octave-binary \
	-command "import_handler {$root} octave_binary"
   $root.mb.button1.import add  command -label MathLab \
	-command "import_handler {$root} mathlab"
   $root.mb.button1.import add  command -label WiMat \
	-command "import_handler {$root} wimat"

   menu $root.mb.button1.extrasave -tearoff 0
   $root.mb.button1.extrasave add  command -label octave-text \
	-command "export_handler {$root} octave_text"
   $root.mb.button1.extrasave add  command -label octave-binary \
	-command "export_handler {$root} octave_binary"
   $root.mb.button1.extrasave add  command -label MathLab \
	-command "export_handler {$root} mathlab"
   $root.mb.button1.extrasave add  command -label WiMat \
	-command "export_handler {$root} wimat"
   $root.mb.button1.extrasave add  command -label ascII \
	-command "smore_handler {$root} input ascii"
   $root.mb.button1.extrasave add  command -label Html \
	-command "smore_handler {$root} input html"
   $root.mb.button1.extrasave add  command -label Latex \
	-command "smore_handler {$root} input latex"

   menu $root.mb.button1.ssolution -tearoff 0
   $root.mb.button1.ssolution add  command -label ascII \
	-command "smore_handler {$root} solution ascii"
   $root.mb.button1.ssolution add  command -label Html \
	-command "smore_handler {$root} solution html"
   $root.mb.button1.ssolution add  command -label Latex \
	-command "smore_handler {$root} solution latex"

   menu $root.mb.button1.sprotokol -tearoff 0
   $root.mb.button1.sprotokol add  command -label ascII \
	-command "smore_handler {$root} protokol ascii"
   $root.mb.button1.sprotokol add  command -label Html \
	-command "smore_handler {$root} protokol html"
   $root.mb.button1.sprotokol add  command -label Latex \
	-command "smore_handler {$root} protokol latex"

   global ${root}_editmode
   set ${root}_editmode edit
   $root.mb.button2 add radiobutton -label $lan(edit_m)  \
	-variable ${root}_editmode -value edit \
	-command "editmode_handler {$root}"
   $root.mb.button2 add radiobutton -label $lan(edit_eunf)  \
	-variable ${root}_editmode -value elemunf \
	-command "editmode_handler {$root}"
   $root.mb.button2 add separator
   $root.mb.button2 add command -label $lan(copy)  \
	-command "copy_handler {$root}"
   $root.mb.button2 add command -label $lan(paste)  \
	-command "paste_handler {$root}"
   $root.mb.button2 add command -label $lan(resize) \
	-command "resize_handler {$root}"
   $root.mb.button2 add separator
   $root.mb.button2 add cascade -label $lan(mark) \
	-menu $root.mb.button2.mark 
   $root.mb.button2 add command -label $lan(duplicate) \
	-command "duplicate_handler {$root}"
   $root.mb.button2 add command -label $lan(solution2first) \
	-command "solution2first_handler {$root}" -state disabled
   $root.mb.button2 add command -label $lan(open_as_float) \
	-command "open_as_float_handler {$root}"
   $root.mb.button2 add command -label $lan(open_as_widefloat) \
	-command "open_as_float_handler {$root} -widefloat"
   $root.mb.button2 add command -label $lan(open_puffer) \
	-command "open_puffer_handler {$root}"
   $root.mb.button2 add separator
   $root.mb.button2 add command -label $lan(preferences) \
	-command "pref_dialog"

   menu $root.mb.button2.mark -tearoff 0
   $root.mb.button2.mark add  command -label $lan(col)  -command "mark_handler {$root} col"
   $root.mb.button2.mark add  command -label $lan(row)  -command "mark_handler {$root} row"
   $root.mb.button2.mark add  command -label $lan(all)  -command "mark_handler {$root} all"

   $root.mb.button3 add command -label $lan(gauss) \
	-command "alg_handler {$root} gauss"
   $root.mb.button3 add command -label $lan(gaussjordan) \
	-command "alg_handler {$root} jordan"
   $root.mb.button3 add command -label $lan(solution) \
	-command "alg_handler {$root} loesung"
   $root.mb.button3 add command -label $lan(determinante) \
	-command "alg_handler {$root} determinante"
   $root.mb.button3 add command -label $lan(bild) \
	-command "alg_handler {$root} bild"
   $root.mb.button3 add command -label $lan(kern) \
	-command "alg_handler {$root} kern"
   $root.mb.button3 add command -label $lan(inverse) \
	-command "alg_handler {$root} inverse"
   $root.mb.button3 add command -label $lan(naehrung) \
	-command "alg_handler {$root} naehrung"
   $root.mb.button3 add command -label $lan(pivotiere) \
	-command "pivot_handler {$root}"
   $root.mb.button3 add command -label $lan(simplex) \
	-command "alg_handler {$root} simplex"
   $root.mb.button3 add command -label $lan(eckenfindung) \
	-command "alg_handler {$root} eckenfindung"
   $root.mb.button3 add command -label $lan(transponieren) \
	-command "alg_handler {$root} transponiere"
   $root.mb.button3 add command -label $lan(chpolynom) \
	-command "alg_handler {$root} chpolynom"
   $root.mb.button3 add command -label $lan(matrixspiel) \
	-command "alg_handler {$root} matrixspiel"
   $root.mb.button3 add separator
   $root.mb.button3 add command -label $lan(mmul) \
	-command "op_handler {$root} mul"
   $root.mb.button3 add command -label $lan(madd) \
	-command "op_handler {$root} add"
   $root.mb.button3 add command -label $lan(msub) \
	-command "op_handler {$root} sub"

   $root.mb.button4 add command -label $lan(vsolution) \
	-command "view_handler {$root} solution" -state disabled
   $root.mb.button4 add command -label $lan(vprotokol) \
	-command "view_handler {$root} protokol" -state disabled
   $root.mb.button4 add separator
   $root.mb.button4 add command -label $lan(print_solution) \
	-command "printview_handler {$root} solution" -state disabled
   $root.mb.button4 add command -label $lan(pview_solution) \
	-command "vprintview_handler {$root} solution" -state disabled
   $root.mb.button4 add command -label $lan(print_protokol) \
	-command "printview_handler {$root} protokol" -state disabled
   $root.mb.button4 add command -label $lan(pview_protokol) \
	-command "vprintview_handler {$root} protokol" -state disabled

   $root.mb.help add command -label $lan(help) \
	   -command "matrixhelp"
   $root.mb.help add command -label $lan(info) \
	   -command "about"
   $root.mb.help add command -label $lan(wwwlink_autor) \
	   -command wwwlink_autor

    if {$octave} {
   menu $root.mb.button6 -tearoff 0
   $root.mb add cascade -label $lan(octave) -menu $root.mb.button6
	makeoctavemenu $root $root.mb.button6

    }
	$root configure -menu $root.mb
# Edit Leiste
    frame $root.workarea -relief raised -bd 2
    label $root.workarea.yposlabel -textvariable ypos$root
    label $root.workarea.xposlabel -textvariable xpos$root
    entry $root.workarea.edit -textvariable edit$root
    checkbutton $root.workarea.emode -text $lan(overwrite) -variable emode$root -anchor w
    pack $root.workarea.yposlabel $root.workarea.xposlabel $root.workarea.edit \
	$root.workarea.emode -side left


    frame $root.mframe
    # -width auf 320 damit alle Menus in einer Reihe erscheinnen 
    canvas $root.can \
        -width 360 \
        -height 0 \
	-relief ridge \
        -highlightthickness 0 \
	-xscrollcommand "scroll_set $root.hscroll" \
	-yscrollcommand "scroll_set $root.vscroll" \
        -xscrollincrement 10 \
        -yscrollincrement 10
    scrollbar $root.vscroll -command "can_view $root.can y"
    scrollbar $root.hscroll -orient horiz -command "can_view $root.can x"

    grid $root.vscroll -in $root.mframe -row 0 -column 1 -sticky sn
    grid $root.hscroll -in $root.mframe -row 1 -column 0 -sticky we
    grid $root.can -in $root.mframe -row 0 -column 0 -sticky nesw
    grid rowconfigure $root.mframe 0 -weight 1 -minsize 10c
    grid columnconfigure $root.mframe 0 -weight 1 -minsize 10c

    set ypos x=1
    set xpos y=2

    if {$option(toolbar)} {
	maketoolbar $root
	pack $root.toolbar -side top -anchor e -fill x
    }
    pack $root.workarea -side top -fill x
    pack $root.mframe -side top -expand yes -fill both
    bind $root.can <Configure> "$root.can config -scrollregion \[$root.can bbox matrix\]"
    bind $root.workarea.edit <Key-Return> {handlereturn %W}
    bind $root <Key-f> "cursormove {$root} 1 0"
    bind $root <Key-b> "cursormove {$root} -1 0"
    bind $root <Key-n> "cursormove {$root} 0 1"
    bind $root <Key-p> "cursormove {$root} 0 -1"
    bind $root <Key-Insert> "$root.workarea.emode flash; $root.workarea.emode invoke"
    if {$root!=""} {
	bind $root <Destroy> "hdeactivate {$root} %W"
    }
#   bind $root.can <B2-Motion> "$root.can scan dragto %x %y"
}
# This procedure create main control window
proc controlwindow {} {
    global lan
    #wm title . $lan(mwtitle)
    frame .listf -bd 2
    frame .mbuttonf -relief raised -bd 2
    frame .marea -relief raised -bd 2

    menu .menu -tearoff 0
    menu .menu.file -tearoff 0
    .menu add cascade -label $lan(file) -menu .menu.file  -underline 0
    .menu.file  add command  -label $lan(openmatrix) -command {open_matrix .}
    .menu.file add command -label $lan(preferences) \
	-command "pref_dialog"    
    menu .menu.newmatrix -tearoff 0
    .menu add cascade -label $lan(newmatrix) -menu .menu.newmatrix  -underline 0
    .menu.newmatrix add  command -label $lan(nullmatrix) \
	-command "new_matrix . nullmatrix"
    .menu.newmatrix add  command -label $lan(einheitsmatrix) \
	-command "new_matrix . einheitsmatrix"
    .menu.newmatrix add  command -label $lan(randommatrix) \
	-command "new_matrix . randommatrix"

    menu .menu.importm -tearoff 0
    .menu add cascade -label $lan(import) -menu .menu.importm  -underline 0
    .menu.importm add command -label octave-text \
            -command "import_handler . octave_text"
    .menu.importm add command -label octave-binary \
            -command "import_handler . octave_binary"
    .menu.importm add command -label MathLab \
            -command "import_handler . mathlab"
    .menu.importm add command -label WiMat \
	    -command "import_handler . wimat"

    menu .menu.help -tearoff 0
    .menu add cascade -label $lan(help) -menu .menu.help -underline 0
    .menu.help add command -label $lan(help) \
	   -command matrixhelp
    .menu.help add command -label $lan(info) \
	   -command about
    .menu.help add command -label $lan(wwwlink_autor) \
	   -command wwwlink_autor

    button .mclose -text $lan(close) -command mclose
#-state disabled
    button .mdeactivate -text $lan(deactivate) \
            -command mdeactivate
#-state disabled
    button .mshow -text $lan(show) -command mshow
#-state disabled
    button .endprog -text $lan(end) -command {end_handle .}
     listbox .mlist -yscroll ".scroll set" -setgrid 1 -height 12 -width 45 \
 	-exportselection no
    scrollbar .scroll -command ".mlist yview"

    pack .mlist -side left -fill both -expand yes -in .listf
    pack .scroll -side right -fill y -in .listf

    pack .mshow -side top -in .mbuttonf -fill x -anchor n
    pack .mdeactivate -side top -in .mbuttonf -fill x -anchor n
    pack .mclose -side top -in .mbuttonf -fill x -anchor n

    pack .listf -side left -fill both -expand yes -in .marea
    pack .mbuttonf -side right -in .marea -anchor n

    pack .marea -side top -fill both -expand yes
    pack .endprog -side top -anchor w
    . configure -menu .menu
    bind .mlist <Double-1> mshow
}

#matrixtcl Biblothek laden
if {$DynLinked} {
    load [file join $progdir matrixtcl.so]
}
# dir Path der biblothk ermitteln laden
# gebraucht um *.mform Dateien finden zu knnen
matrixtcl configure -dir $progdir


# Set prefs from prefsfile ".tkmatrix" in home directory or load
# defaults values
loadpref
# Sprach array "lan" setzten
# und Sprachdatei Laden
checklanguage
setprefbinds

#createmainw {}
controlwindow

#set matrix [matrixtcl load gauss.mat]
#putmatrixw {} $matrix
set puffer_rational ""
set puffer_float ""
set puffer_widefloat ""

set background [option get . background Label]
if {$background==""} {
    set background #d9d9d9
} 
if {$progdir=="/home/artur/tkmatrix" && "[pwd]"!=$progdir} {
    puts "set progdir for endversion"
    exit
}
# Lade Argumente als Matrizen
foreach file $argv {
    set ret [catch {set newmatrix [matrixtcl load $file]}]
    if {$ret==0} {
	global $newmatrix
	set ${newmatrix}(filename) $file
	ctraddmatrix $newmatrix
    } else {
	tk_messageBox -title $lan(errormsg) -message  \
	    "$lan(cannot_openfile) \"$file\"" \
	    -icon error -type ok
    }
}
#bind .can <Configure> "%W itemconfigure all -width %w; .can config -scrollregion \[.can bbox 1\]"
#pack .workarea








