# This two procedures handle printig and print preview of matrices and protokols
# You have to have properly latex dvips (ghostscript) for printig and gv (gostview) for
# previewing print
proc printmatrix {matrix {was ""}} {
    if {$was == ""} {
	set stuff [matrixtcl $matrix getform latex]
    } else {
	set stuff [matrixtcl $matrix getform latex -$was]
    }
    set fileh [open /tmp/${matrix}.tex w]
    puts -nonewline $fileh $stuff
    close $fileh
    cd /tmp
    if {[catch {exec latex ${matrix}.tex}]} {
        global lan
        tk_messageBox -type ok -title $lan(errormsg) \
                -message $lan(errornolatex) -icon error
        return
        
    }
    catch {exec dvips ${matrix}.dvi -o ${matrix}.ps}
    exec lpr ${matrix}.ps
    eval exec rm [glob -nocomplain ${matrix}.*]

}
proc printpreviewmatrix {matrix {was ""}} {
    if {$was == ""} {
	set stuff [matrixtcl $matrix getform latex]
    } else {
	set stuff [matrixtcl $matrix getform latex -$was]
    }
    set fileh [open /tmp/${matrix}.tex w]
    puts -nonewline $fileh $stuff
    close $fileh
    cd /tmp
    if {[catch {exec latex ${matrix}.tex}]} {
        global lan
        tk_messageBox -type ok -title $lan(errormsg) \
             -message $lan(errornolatex) -icon error
        return
    }
    catch {exec dvips ${matrix}.dvi -o ${matrix}.ps}
    # you can use xdvi, then you don't need to run dvips in previous line
    exec gv ${matrix}.ps
    # start ghostview as gv (RedHat comform)
    eval exec rm [glob -nocomplain ${matrix}.*]
}


