# Loading language
# this proc reading a *.lan file and fill the lan globol array
proc setlanguage language {
    global lan progdir
    set lanfile [open [file join $progdir ${language}.lan] r]
    while {[gets $lanfile Zeile] >= 0} {
	set lan([lindex $Zeile 0]) [lindex $Zeile 1]
    }
    if {$language=="polish" && [string match *-iso8859-2 [option get . font Font]]==0} {
	if {[info exists lan(polfont)]} {
	    option add *font $lan(polfont)
	} else {
# Convert polish option if no polish font are aviable
	    set indicator [array startsearch lan]
	    while {[array anymore lan $indicator]} {
		set key [array nextelement lan $indicator]
		set word $lan($key)
# make somthing as perl tr///;
		foreach item {{A } {a } {E } {S } {s } {C } {c } {O } {o } {L } {l } {Z } {z } {Z } {z } {N } {n }} {
		    regsub -all [lindex $item 1] $word [lindex $item 0] word
		}
		set lan($key) $word
	    }
	}
    } 
#elseif ("[option get . font Font]"!="") {
#	option clear
#    }
}
proc checklanguage {} {
    global option
    if {$option(language)=="dummy"} {
	wm withdraw .
	set ret  [language_dialog]
	wm deiconify .
	set option(language) [lindex $ret 0]
	setlanguage $option(language)
	if {[lindex $ret 1] == "ok2"} {
	    savepref
	}
    } else {
	setlanguage $option(language)
    }
}
proc defaultpref {{var option}} {
    global $var
    array set $var {
	language dummy
	toolbar 1
	htmlhelpviewer {netscape %s}
	opensolution 1
	openprotokol 1
        noprot 0
        onlyfraction 1
        editonlyfraction 1
	netscape_remote 1
	widefloat_prec 64
	widefloat_reformat 1
	widefloat_maxnum 6
	widefloat_maxzeros 6
	widefloat_showprec 0
    }
}
proc loadpref {} {
    global option tcl_platform
    defaultpref
    if {$tcl_platform(platform)=="windows"} {
    	if {![catch {package require registry}]} {
      	set reg_path {HKEY_CURRENT_USER\Software\tkmatrix}
      	if {![catch {set values [registry values $reg_path]}]} {
         	foreach val $values {
            	set option($val) [registry get $reg_path $val]
            }
         }
      }
    } else {
    	if {[file exists [file join ~  .tkmatrix]]} {
  			set preffile [open [file join ~ .tkmatrix] r]
	  		while {[gets $preffile Zeile] >= 0} {
	    		set option([lindex $Zeile 0]) [lindex $Zeile 1]
			}
      }
	 }
    matrixtcl configure -noprot $option(noprot)
    matrixtcl configure -onlyfraction $option(onlyfraction)
    matrixtcl configure -widefloat_prec $option(widefloat_prec)
    matrixtcl configure -widefloat_reformat $option(widefloat_reformat)
    matrixtcl configure -widefloat_maxnum $option(widefloat_maxnum)
    matrixtcl configure -widefloat_maxzeros $option(widefloat_maxzeros)
    matrixtcl configure -widefloat_showprec $option(widefloat_showprec)
}
proc savepref {} {
    global option lan errorInfo tcl_platform
    if {$tcl_platform(platform)=="windows"} {
    	if {![catch {package require registry}]} {
      	set reg_path {HKEY_CURRENT_USER\Software\tkmatrix}
	      set indicator [array startsearch option]
    		while {[array anymore option $indicator]} {
				set elem [array nextelement option $indicator]
  				registry set $reg_path $elem $option($elem)
    		}
      }
    } else {
     set ret [catch { set preffile [open [file join ~ .tkmatrix ] w] }]
    if {$ret != 0} {
	tk_messageBox -title $lan(cspreftitle) -message "$lan(csprefmessage) $errorInfo"  -icon error -type ok
	return
    }
    set indicator [array startsearch option]
    while {[array anymore option $indicator]} {
	set elem [array nextelement option $indicator]
	puts $preffile "$elem [list $option($elem)]"
    }
    close $preffile
    }
}
# Setting pref binds (trace) for reaktion by changing pref
proc setprefbinds {} {
    global option
    trace variable option(language) w changelanguage
    trace variable option(toolbar) w changetoolbar
}
proc changelanguage {name1 name2 op} {
    global option lan
    setlanguage $option(language)
    tk_messageBox -title info -message $lan(newlanguage) -icon info -type ok
}
#
# Preferences Dialog
#
proc pref_dialog {} {
    global mywait lan isfloatstate option prefopt progdir
    set w .prefdialog
    catch {destroy $w}
    toplevel $w -class Dialog
    wm title $w $lan(prefdialogtitle)
    wm iconname $w Dialog
    wm protocol $w WM_DELETE_WINDOW { }
    
    
    frame $w.bot
    frame $w.top -relief raised -bd 1
    
    # copy array option to prefopt
    array set prefopt [array get option]
    
    button $w.use -text $lan(use) -command "set mywait use"
    button $w.usesave  -text $lan(usesave) -command "set mywait usesave"
    button $w.cancel  -text $lan(dialogcancel) -command "set mywait cancel"
    button $w.default  -text $lan(default) -command "defaultpref prefopt; set prefopt(language) german"
    # Frames fr Rahmen fr Netscape, widefloat , Sprachen  
    frame $w.border_netscape -relief raised -bd 2
    frame $w.border_widefloat -relief raised -bd 2
    frame $w.border_lan -relief raised -bd 2

    label $w.l1 -text $lan(afteralgorithm)
    checkbutton $w.opensolution -text $lan(opensolution) -variable prefopt(opensolution)
    checkbutton $w.openprotocol -text $lan(openprotocol) -variable prefopt(openprotokol)
    checkbutton $w.noprot -text $lan(noprot) -variable prefopt(noprot)
    checkbutton $w.onlyfraction -text $lan(onlyfraction) \
            -variable prefopt(onlyfraction)
    checkbutton $w.editonlyfraction -text $lan(editonlyfraction) \
            -variable prefopt(editonlyfraction)
    label $w.browser -text $lan(helpbrowser)
    entry $w.ebrowser -width 25 -textvariable prefopt(htmlhelpviewer)
    label $w.text_prec -text $lan(widefloat_prec)
    entry $w.e_prec -width 10 -textvariable prefopt(widefloat_prec)
    checkbutton $w.toolbar -text $lan(toolbar) -variable prefopt(toolbar)
    label $w.lan -text $lan(language)
    checkbutton $w.netscape_remote -text $lan(netscape_remote) -variable prefopt(netscape_remote)
    checkbutton $w.wf_reformat -text $lan(widefloat_reformat) -variable prefopt(widefloat_reformat)
    label $w.label_wfw -text $lan(widefloat_width) 
    entry $w.wf_formatwidth -width 10 -textvariable prefopt(widefloat_maxnum)
    label $w.label_wfmz -text $lan(widefloat_maxzeros) 
    entry $w.wf_maxzeros -width 10 -textvariable prefopt(widefloat_maxzeros)
    label $w.label_wfsp -text $lan(widefloat_showprec) 
    entry $w.wf_showprec -width 10 -textvariable prefopt(widefloat_showprec)

    # Pakcen in Rahmen-Frames
    pack $w.browser $w.ebrowser $w.netscape_remote -in $w.border_netscape \
	-anchor w
    pack $w.text_prec $w.e_prec $w.wf_reformat $w.label_wfw $w.wf_formatwidth \
	$w.label_wfmz $w.wf_maxzeros $w.label_wfsp $w.wf_showprec \
	-in $w.border_widefloat -anchor w
    pack $w.lan -in $w.border_lan -anchor w

    pack $w.l1 $w.opensolution $w.openprotocol $w.noprot $w.onlyfraction \
	$w.editonlyfraction $w.toolbar $w.border_netscape  \
	$w.border_widefloat $w.border_lan \
	-in $w.top -anchor w -padx 1.5c
    foreach onelan [glob [file join $progdir *.lan]] {
	set lname [file tail [file rootname $onelan]]
	radiobutton $w.rb$lname -text $lname -variable prefopt(language) -value $lname
	pack $w.rb$lname -side top -in $w.top -anchor w -padx 2c -in $w.border_lan
    }
    
    grid  $w.use -in $w.bot -column 0 -row 0 -sticky ew
    grid  $w.usesave -in $w.bot -column 1 -row 0 -sticky ew
    grid  $w.cancel -in $w.bot -column 2 -row 0 -sticky ew
    grid  $w.default -in $w.bot -column 3 -row 0 -sticky ew
    
    pack $w.top -side top -fill both -expand 1
    pack $w.bot -side bottom -fill both
    
    # 5. Create a <Destroy> binding for the window that sets the
    # button variable to -1;  this is needed in case something happens
    # that destroys the window, such as its parent window being destroyed.
    
    bind $w <Destroy> {puts "gowno"; set mywait cancel}
    
    # 6. Withdraw the window, then update all the geometry information
    # so we know how big it wants to be, then center the window in the
    # display and de-iconify it.
    
    wm withdraw $w
    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
	    - [winfo vrootx [winfo parent $w]]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
	    - [winfo vrooty [winfo parent $w]]]
    wm geom $w +$x+$y
    wm deiconify $w
    
    # 7. Set a grab and claim the focus too.
    
    set oldFocus [focus]
    set oldGrab [grab current $w]
    if {$oldGrab != ""} {
	set grabStatus [grab status $oldGrab]
    }
    grab $w
    focus $w
    
    
    # 8. Wait for the user to respond, then restore the focus and
    # return the index of the selected button.  Restore the focus
    # before deleting the window, since otherwise the window manager
    # may take the focus away so we can't redirect it.  Finally,
    # restore any grab that was in effect.

    tkwait variable mywait
    catch {focus $oldFocus}
    catch {
	# It's possible that the window has already been destroyed,
	# hence this "catch".  Delete the Destroy handler so that
	# tkPriv(button) doesn't get reset by it.

	bind $w <Destroy> {}
	destroy $w
    }
    if {$oldGrab != ""} {
	if {$grabStatus == "global"} {
	    grab -global $oldGrab
	} else {
	    grab $oldGrab
	}
    }
    switch $mywait {
	use {
	    mycopyarray prefopt option
            matrixtcl configure -noprot $option(noprot)
            matrixtcl configure -onlyfraction $option(onlyfraction)
	    matrixtcl configure -widefloat_prec $option(widefloat_prec)
	    matrixtcl configure -widefloat_reformat $option(widefloat_reformat)
	    matrixtcl configure -widefloat_maxnum $option(widefloat_maxnum)
	    matrixtcl configure -widefloat_maxzeros $option(widefloat_maxzeros)
	    matrixtcl configure -widefloat_showprec $option(widefloat_showprec)
	}
	usesave {
	    mycopyarray prefopt option
            matrixtcl configure -noprot $option(noprot)
            matrixtcl configure -onlyfraction $option(onlyfraction)
	    matrixtcl configure -widefloat_prec $option(widefloat_prec)
	    matrixtcl configure -widefloat_reformat $option(widefloat_reformat)
	    matrixtcl configure -widefloat_maxnum $option(widefloat_maxnum)
	    matrixtcl configure -widefloat_maxzeros $option(widefloat_maxzeros)
	    matrixtcl configure -widefloat_showprec $option(widefloat_showprec)
	    savepref
	}
    }

}
proc mycopyarray {from to} {
    global $from $to
    set indicator [array startsearch $to]
    while {[array anymore $to $indicator]} {
	set elem [array nextelement $to $indicator]
	if {[set ${to}($elem)]!=[set ${from}($elem)]} {
	    set ${to}($elem) [set ${from}($elem)]
	}
    }
    
}


