# octave.tcl
#
# This file handle importing and exporting to
# octave file type and MathLab
# also octave interface
#
proc export_handler {root type} {
    set matrix [getmatrix $root]
    set ext "ext"
    switch $type {
        octave_text {set ext octt}
        octave_binary {set ext octb}
        mathlab {set ext mlab}
	wimat {set ext wim}
    }
    lappend types [list "$type files" .$ext] {"All files"		*}
    set file [tk_getSaveFile -filetypes $types -parent . \
	    -initialfile Untitled.$ext -defaultextension .$ext]
    if {$file != ""} {
	if {$type=="octave_text" || $type=="wimat"} {
	    set fileh [open $file w]
	    if {[matrixtcl $matrix info type]=="rational" && $type=="octave_text"} {
		set matrix [matrixtcl $matrix tofloat]
		save_$type $fileh $matrix
		matrixtcl destroy $matrix 
	    } else {
		save_$type $fileh $matrix
	    }
	    close $fileh
	} else {
	    save_$type $file $matrix
	}
    }
}
proc save_octave_text {fileh matrix} {
    set row [lindex [matrixtcl $matrix info size] 0]
    set column [lindex [matrixtcl $matrix info size] 1]
    puts $fileh "# name: tkmatrix"
    puts $fileh "# type: matrix"
    puts $fileh "# rows: $row"
    puts $fileh "# columns: $column"
    for {set y 0} {$y<$row} {incr y} {
        for {set x 0} {$x<$column} {incr x} {
            puts -nonewline $fileh " [matrixtcl $matrix getelem $y $x]"
        }    
        puts -nonewline $fileh "\n"
    }
}
proc save_wimat {fileh matrix} {
    set row [lindex [matrixtcl $matrix info size] 0]
    set column [lindex [matrixtcl $matrix info size] 1]
    # set DOS lineend
    fconfigure $fileh -translation crlf
    puts $fileh ""
    puts $fileh "m"
    puts $fileh "$row"
    puts $fileh "$column"
    for {set y 0} {$y<$row} {incr y} {
	puts -nonewline $fileh "  "
        for {set x 0} {$x<$column} {incr x} {
            puts -nonewline $fileh " [matrixtcl $matrix getelem $y $x]"
        }    
        puts $fileh ""
    }
}
proc save_octave_binary {file matrix} {
    matrixtcl $matrix save $file -octavebin
}
proc save_mathlab {file matrix} {
    matrixtcl $matrix save $file -mathlabbin
}
proc import_handler {win type} {
    set ext "ext"
    switch $type {
        octave_text {set ext octt}
        octave_binary {set ext octb}
        mathlab {set ext mlab}
	wimat {set ext wim}
    }
    lappend types [list "$type files" .$ext] {"All files"		*}
    set file [tk_getOpenFile -filetypes $types -parent .]
    if {$file != ""} {
	if {$type=="octave_text" || $type=="wimat"}  {
	    set fileh [open $file r]
	    set newmatrix [open_$type $fileh]
	    close $fileh
#	    puts "matrix $newmatrix"
	} else {
	    set newmatrix [open_$type $file]
	}
        if {$newmatrix != ""} {
            global $newmatrix
            set ${newmatrix}(filename) $file
            toplevel .${newmatrix}
            createmainw .${newmatrix}
            putmatrixw .${newmatrix} $newmatrix
            ctraddmatrix $newmatrix .${newmatrix} 
	    activatemenus .${newmatrix} $newmatrix
        }
    }
}
proc open_octave_text fileh {
    set row {}
    set column {}
    set type {}
    set name {}
    set value {}
    while 1 {
        set line [gets $fileh]
#        puts "line $line"
        if {$line == ""} break
        if {![regexp {^# ([a-z]+): (.+)$} $line - name value]} break
#        puts "regexp $name $value"
        switch $name {
            type {set type $value}
            rows {set row $value}
            columns {set column $value}
        }
    }
#    puts "$type $row $column"
    if {$type!="matrix" || $row=="" || $column==""} return
    set matrix [matrixtcl create $row $column -float]
    set elements "$line [read $fileh]"
#    puts $elements
    for {set y 0} {$y<$row} {incr y} {
        for {set x 0} {$x<$column} {incr x} {
            matrixtcl $matrix setelem $y $x [lindex $elements [expr $x+$y*$column]]
        }    
    }
    return $matrix
}
proc open_wimat fileh {
    set row {}
    set column {}
    set type {}
    set name {}
    set value {}
    # ignore blank line
    gets $fileh
    set line [gets $fileh]
    # 2nd line must be "m"
    if {$line!="m"} return
    set column [gets $fileh]
    set row [gets $fileh]
    set elements [read $fileh]
    if {[regexp {[0-9]+\.[0-9]+} $elements]} {
	set matrix [matrixtcl create $row $column -float]
	set type float
    } else {
	set matrix [matrixtcl create $row $column]
	set type rational
    }
    for {set y 0} {$y<$row} {incr y} {
        for {set x 0} {$x<$column} {incr x} {
	    set elem [lindex $elements [expr $x+$y*$column]]
	    if {$type=="rational"} {
		regsub -all "/" $elem " " elem
	    }
            matrixtcl $matrix setelem $y $x $elem
        }    
    }
    return $matrix
}
proc open_octave_binary file {
    return [matrixtcl load $file -octavebin]
}
proc open_mathlab file {
    return [matrixtcl load $file -mathlabbin]
}
#
# Octave interface (back-end)
#
set octave_proc ""
set octave_buf ""
set octave_debug 1
set octave_script 0
proc get_octave_proc {} {
    global octave_proc
    if {$octave_proc==""} {
        if {[catch { set octave_proc [open "|octave -i 2>@stdout" r+] }]} {
	    global lan
	    global octave
	    set octave 0
	    tk_messageBox -type ok -title $lan(errormsg) \
                -message $lan(errornooctave) -icon error
 	    return
	}
	# tell octave do not to use pager 
	# and do not spit matrices in columns
	puts $octave_proc "page_screen_output = 0;"
	puts $octave_proc "split_long_rows = 0;"
	flush $octave_proc
	set line [gets $octave_proc]
	while {$line!=""} {
#	    puts $line
	    set line [gets $octave_proc]
	}
	fconfigure $octave_proc -blocking 0
    }
    return $octave_proc
}
proc do_octavefunc {root func} {
    set matrix [getmatrix $root]
    set oproc [get_octave_proc]
    if {$oproc==""} { return }
    set omatrix [matrix2octave $matrix]
    set dummy [read $oproc]
    puts $oproc "${func}(${omatrix})"
    flush $oproc
    global octave_buf octave_end octave_script
    set octave_script 0
    set octave_buf ""
    fileevent $oproc readable "octave_input \[read $oproc\]"
#     set line [gets $oproc]
#     while {[fblocked $oproc]} {
#         if {$line!=""} {
# 	    puts $line
# 	}
#         set line [gets $oproc]
#     }
    octave_window
    if {$octave_end=="cancel"} return
#   puts $octave_buf
    matrixtcl $matrix deleteprot
    matrixtcl $matrix addprot string "Octave interface function $func"
    set buf [split $octave_buf "\n"]
    set ansid [lsearch -glob $buf {*ans*}]
    # ignore all lines to "ans" line
    if {$ansid==-1} return
    if {$ansid!=0} {
	set buf [lreplace $buf 0 [expr $ansid-1]]
    }
    if {[string match {* ans =} [lindex $buf 0] ]} {
	set buf [lrange $buf 2 [expr [llength $buf]-3]]
#	puts $buf
	matrixtcl $matrix addprot matrix $buf
	matrixtcl $matrix setsolution $buf
#	puts mark
	global $matrix
	set ${matrix}(lastalgorithmus) "octave $func"
	view_output $root yes
	ctrupdateitem $matrix
	activatemenus $root $matrix
    } elseif {[regexp {.+ans = ([0-9.eE\-]+)} [lindex $buf 0] - buf]} {
	matrixtcl $matrix addprot matrix  $buf
	matrixtcl $matrix setsolution  $buf
	global $matrix
	set ${matrix}(lastalgorithmus) "octave $func"
	view_output $root yes
	ctrupdateitem $matrix
	activatemenus $root $matrix
    } else {

    }
}
proc octave_input input {
    global octave_buf octave_debug octave_script
    set octave_buf "${octave_buf}${input}"
    #    puts -nonewline $input
    if {$octave_debug && [winfo exists .octavedialog.imsg.debug]} {
	.octavedialog.imsg.debug insert end $input
    }
    if {$octave_script} {
	if { [string match "*:error*" $octave_buf] || 
	     [string match "*:end*" $octave_buf] } {
	    global octave_end octave_proc
	    set octave_end ok
	    fileevent $octave_proc readable ""
	}
    } elseif {([string match "*\n\noctave:*" $octave_buf] || 
	       [string match "*ans = *\noctave:*" $octave_buf])} {
	global octave_end octave_proc
	set octave_end ok
	fileevent $octave_proc readable ""
    }
}
proc matrix2octave matrix {
    set ret "\["
    set destroy 0
    set row [lindex [matrixtcl $matrix info size] 0]
    set column [lindex [matrixtcl $matrix info size] 1]
    if {[matrixtcl $matrix info type]=="rational"} {
        set matrix [matrixtcl $matrix tofloat]
        set destroy 1
    } 
    for {set y 0} {$y<$row} {incr y} {
        for {set x 0} {$x<$column} {incr x} {
            set ret  "${ret}[matrixtcl $matrix getelem $y $x]"
            if {$x!=[expr $column-1]} {
                set ret "${ret},"
            }
        }    
        if {$y!=[expr $row-1]} {
            set ret "${ret};\n"
        } else {
            set ret "${ret}\]"
        }
    }
    if {$destroy} {
        matrixtcl destroy $matrix 
    }
    return $ret
}
proc endoctaveproc {} {
    global octave_proc
    if {$octave_proc!=""} {
	close $octave_proc
	set octave_proc ""
    }
}
proc octave_window {} {
    global lan octave_end octave_debug octave_proc
    set w .octavedialog
    catch {destroy $w}
    toplevel $w -class Dialog
    wm title $w $lan(octavedialogtitle)
    wm iconname $w Dialog
    wm protocol $w WM_DELETE_WINDOW { }

    frame $w.bot
    frame $w.top

    label $w.lstatus -text Status
    label $w.status -width 20 -text "Retrieving Data" -relief solid

    button $w.cancel  -text $lan(dialogcancel) -command "set octave_end cancel"

    pack $w.lstatus $w.status -in $w.top -side left
    pack $w.cancel -in $w.bot
    pack $w.top -side top -anchor w
    if {$octave_debug} {
        frame $w.imsg -relief sunken
        scrollbar $w.imsg.scroll -orient vertical \
	    -command "$w.imsg.debug yview"
        text $w.imsg.debug -yscrollcommand "$w.imsg.scroll set" \
	    -width 50 -height 12 -wrap word
        pack $w.imsg.debug -side left -expand yes -fill both
        pack $w.imsg.scroll -side left -fill y
	pack $w.imsg -side top -fill both -expand yes
    }
    pack $w.bot -side top
    
    bind $w <Destroy> { set octave_end cancel}

    # 6. Withdraw the window, then update all the geometry information
    # so we know how big it wants to be, then center the window in the
    # display and de-iconify it.

    wm withdraw $w
    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
	    - [winfo vrootx [winfo parent $w]]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
	    - [winfo vrooty [winfo parent $w]]]
    wm geom $w +$x+$y
    wm deiconify $w

    # 7. Set a grab and claim the focus too.

    set oldFocus [focus]
    set oldGrab [grab current $w]
    if {$oldGrab != ""} {
	set grabStatus [grab status $oldGrab]
    }
    grab $w
    focus $w
    

    # 8. Wait for the user to respond, then restore the focus and
    # return the index of the selected button.  Restore the focus
    # before deleting the window, since otherwise the window manager
    # may take the focus away so we can't redirect it.  Finally,
    # restore any grab that was in effect.

    tkwait variable octave_end
    if {$octave_end=="cancel"} {
	set dummy [read $octave_proc]
	fileevent $octave_proc readable {}
	#puts "end of warten"
    }
    catch {focus $oldFocus}
    catch {
	# It's possible that the window has already been destroyed,
	# hence this "catch".  Delete the Destroy handler so that
	# tkPriv(button) doesn't get reset by it.

	bind $w <Destroy> {}
	destroy $w
    }
    if {$oldGrab != ""} {
	if {$grabStatus == "global"} {
	    grab -global $oldGrab
	} else {
	    grab $oldGrab
	}
    }
    #puts "end of ew"
}
#
# tkmatrix octave scripts
#
proc do_octavescript {root oscript} {
    global octave_script
    set matrix [getmatrix $root]
    set octave_script 1
    set fileh [open $oscript r]
    if {$fileh==""} return
    set oproc [get_octave_proc]
#    set oproc stdout
    if {$oproc==""} { return }
    set line [gets $fileh]
    if {$line=="#tkmatrix-begin"} {
	set line [gets $fileh]
	while {$line!="#tkmatrix-end" && ![eof $fileh]} {
	    lappend script [string range $line 1 end]
	    set line [gets $fileh]
	}
	eval [join $script "\n"]
	global lan octaves_ok
	set w .octavescript
	catch {destroy $w}
	toplevel $w -class Dialog
	wm title $w $lan(octavedialogtitle)
	wm iconname $w Dialog
	wm protocol $w WM_DELETE_WINDOW { }

	if {[info exist message]} {
	    message $w.msg -relief raised -bd 1 -text $message -width 1000
	    pack $w.msg -expand yes -fill both -side top
	} else {
	    message $w.msg -relief raised -bd 1 -text "tkmatrix octave script $oscript"
	    pack $w.msg -expand yes -fill both -side top
	}
	# make list of all loaded matrix 
	global matrixlist
	foreach melem $matrixlist {
	    set melem [lindex $melem 0]
	    global $melem
	    if {[info exists ${melem}(filename)]} {
		lappend mlist [list $melem [file tail [set ${melem}(filename)]]]
	    } else {
		lappend mlist [list $melem $melem]
	    }
	}
    	if {[info exist variables]} {
	    frame $w.bot	    
	    foreach vlist $variables {
		set name [lindex $vlist 0]
		set type [lindex $vlist 1]
		set description [lindex $vlist 2]
		set defaultv [lindex $vlist 3]
		label $w.bot.$name -text $description
		switch $type {
		    integer {
			global $name
			set $name $defaultv
			entry $w.bot.v_$name -textvariable $name
		    }
		    string {
			global $name
			set $name $defaultv
			entry $w.bot.v_$name -textvariable $name
		    }
		    enum {
			global $name
			eval tk_optionMenu $w.bot.v_$name $name $defaultv
		    }
		    matrix {
			frame $w.bot.v_$name
			listbox $w.bot.v_$name.lb -relief raised -borderwidth 2 \
			    -yscrollcommand "$w.bot.v_$name.scroll set" \
			    -exportselection no -height 5
			scrollbar $w.bot.v_$name.scroll \
			    -command "$w.bot.v_$name.lb yview"
			foreach a $mlist {
			    $w.bot.v_$name.lb insert end [lindex $a 1]
			}
			$w.bot.v_$name.lb selection set 0
			pack $w.bot.v_$name.lb -side left \
			    -expand yes -fill both
			pack $w.bot.v_$name.scroll \
			    -side right -fill y
		    }
		}
		grid $w.bot.$name $w.bot.v_$name -sticky we
		
	    }
	    pack $w.bot -expand yes -fill x -side top
	} 

	button $w.ok  -text OK -command "set octaves_ok ok"

	pack $w.ok -side left

	bind $w <Destroy> { set octaves_ok cancel}

	# 6. Withdraw the window, then update all the geometry information
	# so we know how big it wants to be, then center the window in the
	# display and de-iconify it.

	wm withdraw $w
	update idletasks
	set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
		   - [winfo vrootx [winfo parent $w]]]
	set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
		   - [winfo vrooty [winfo parent $w]]]
	wm geom $w +$x+$y
	wm deiconify $w

	# 7. Set a grab and claim the focus too.

	set oldFocus [focus]
	set oldGrab [grab current $w]
	if {$oldGrab != ""} {
	    set grabStatus [grab status $oldGrab]
	}
	grab $w
	focus $w
	

	# 8. Wait for the user to respond, then restore the focus and
	# return the index of the selected button.  Restore the focus
	# before deleting the window, since otherwise the window manager
	# may take the focus away so we can't redirect it.  Finally,
	# restore any grab that was in effect.

	tkwait variable octaves_ok
	if {$octaves_ok=="cancel"} {
	    return
	}
	# set input matrix
	puts $oproc "in = [matrix2octave $matrix];"
	# set parameter varaibles to octave proces
	if {[info exist variables]} {
	    foreach vlist $variables {
		set name [lindex $vlist 0]
		set type [lindex $vlist 1]
		set desciption [lindex $vlist 2]
		set defaultv [lindex $vlist 3]
		switch $type {
		    integer {
			puts $oproc "$name = [set $name];"
			unset $name
		    }
		    string {
			puts $oproc "$name = \"[set $name]\";"
			unset $name
		    }
		    enum {
			puts $oproc "$name = [set $name];"
			unset $name
		    }
		    matrix {
			set ret [$w.bot.v_$name.lb curselection]
			set ret [lindex [lindex $mlist $ret] 0]
			puts $oproc "$name = [matrix2octave $ret];"
		    }
		}
	    }
	} 
    }
    catch {focus $oldFocus}
    catch {
	# It's possible that the window has already been destroyed,
	# hence this "catch".  Delete the Destroy handler so that
	# tkPriv(button) doesn't get reset by it.
	
	bind $w <Destroy> {}
	destroy $w
    }
    if {$oldGrab != ""} {
	if {$grabStatus == "global"} {
	    grab -global $oldGrab
	} else {
	    grab $oldGrab
	}
    }
    puts $oproc "source (\"$oscript\");"
    flush $oproc
    global octave_buf octave_end lan
    set octave_buf ""
    fileevent $oproc readable "octave_input \[read $oproc\]"
    matrixtcl $matrix deleteprot
    octave_window
    if {$octave_end=="cancel"} return
    set buf [split $octave_buf "\n"]
    #
    # Parse script output
    #
    #puts $octave_buf
    set type ""
    if {[set index [lsearch -glob $buf "*:error*"]]!=-1} {
	regexp {.*:error (.*)} [lindex $buf $index] - type
	tk_messageBox -type ok -title $lan(errormsg) \
	    -message $type -icon error
	return
    }
    while {[set index [lsearch -regexp $buf {:(begin|addprot|setsolution|end).*}]]!=-1} {
	set hline [lindex $buf $index]
	set buf [lreplace $buf 0 $index]
	if {[regexp {:([a-z]+).*} $hline - head]} {
	    switch $head {
		addprot {
		    regexp {.*:addprot ([a-z]+)} $hline - type
#		    puts "type $type $hline"
		    if {$type=="string"} {
#			puts "adding string"
			regexp {.*:addprot string (.*)} $hline - type
			matrixtcl $matrix addprot string $type
		    } else {
#			puts $buf
			set index [lsearch -regexp $buf {:.*}]
			set mat [lrange $buf 0 [expr $index-1]]
#			puts "adding prot matrix $index $mat"
			matrixtcl $matrix addprot matrix $mat
			set buf [lreplace $buf 0 [expr $index-1]]
		    }
		}
		setsolution {
		    set index [lsearch -regexp $buf {:.*}]
		    set mat [lrange $buf 0 [expr $index-1]]
#		    puts "seting solution $mat"
		    matrixtcl $matrix setsolution $mat
		    set buf [lreplace $buf 0 [expr $index-1]]
		}
	    }
	}
    }
    global $matrix
    set ${matrix}(lastalgorithmus) "octavescript [file tail $oscript]"
    view_output $root yes
    ctrupdateitem $matrix
    activatemenus $root $matrix
}
proc run_oscript root {
    set file [tk_getOpenFile -filetypes {{{tk Octave script} {.tkm}}} -parent $root]
    if {$file == ""} { return }
    do_octavescript $root $file
}
#
# bild octave menu
#
set octavefunc {
    {chol {Cholesky fac.}}
    {det determinant}
    {eig eigevalues}
    {expm expotential}
    {hess {Hessenberg dec.}}
    {inv inverse} 
    {lu {LU decomposition}}
    {norm p-norm}
    {pinv pseudoinverse}
    {qr {QR factorization}}
    {rank rank}
    {schur {Schur dec.}}
    {svd {singular value dec.}}
    {trace trace}
}
proc makeoctavemenu {root win} {
    global octavefunc lan octave_tkmscripts octave_scriptdir
    foreach a $octavefunc {
	set func [lindex $a 0]
	set name [lindex $a 1]
	$win add command -label "$func $name" \
	    -command "do_octavefunc {$root} $func"
    }
    $win add separator
    if {![info exists octave_tkmscripts]} {
	set octave_tkmscripts  [glob -nocomplain [file join $octave_scriptdir *.tkm]]
    }
    if {[llength $octave_tkmscripts]>0} {
	foreach script $octave_tkmscripts {
	    $win add command -label [file tail $script] -command \
		"do_octavescript $root $script"
	}
	$win add separator
    }
    $win add command -label $lan(octave_script) -command "run_oscript {$root}"
    $win add separator
    $win add command -label $lan(endoctaveproc) \
	-command "endoctaveproc"
}
proc activateoctavemenus {win matrix} {
    global octavefunc lan octave_tkmscripts 
    if {[matrixtcl $matrix info type]=="float"} {
        set state active
    } else {
        set state disabled
    }
    foreach item $octavefunc {
        set mname "[lindex $item 0] [lindex $item 1]"
        ${win} entryconfigure $mname -state $state
    }
    foreach item {octave_script} {
	set name $lan($item)
        ${win} entryconfigure $name -state $state
    }
    foreach script $octave_tkmscripts {
	$win entryconfigure [file tail $script] -state $state
    }
    
}
