# Handeler vor Menu
# Versucht eine Matrix zu den Window zu finden wenn es solche
# nicht existiert fhrt ein uplevel return
# andersfalls lifert den Handler fr Matrix
proc getmatrix root {
    global whandle 
    set wname [getroot $root]
    if {[info exists whandle($wname)]} {
	return $whandle($wname)
    } else {
	# puts "no matrix"
	return
    }
}
proc new_matrix {root type} {
    set erg [new_dialog $type]
    if {$erg == ""} { return }
    global whandle
    set wname [getroot $root]
    set newmatrix [matrixtcl create [lindex $erg 0] [lindex $erg 1] [lindex $erg 2]]

#    if {[info exists whandle($wname)]} {
#	toplevel .${newmatrix}
#	createmainw .${newmatrix}
#	putmatrixw .${newmatrix} $newmatrix
#    } else {
#	putmatrixw {} $newmatrix
#    }
    switch $type {
	einheitsmatrix {
	    set column [lindex $erg 1]
	    for {set x 0} {$x<$column} {incr x} {
		matrixtcl $newmatrix setelem $x $x 1
	    }    
	}
	randommatrix {
	    set row [lindex $erg 0]
	    set column [lindex $erg 1]
	    set maxnum [lindex $erg 3]
	    set maxden [lindex $erg 4]
	    set mtyp [lindex $erg 2]
	    for {set y 0} {$y<$row} {incr y} {
		for {set x 0} {$x<$column} {incr x} {
		    if {$mtyp=="-float"} {
			matrixtcl $newmatrix setelem $y $x [expr rand()]
		    } else {
			matrixtcl $newmatrix setelem $y $x \
			    "[expr round(rand()*2*$maxnum)-$maxnum] [expr round(rand()*$maxden+1)]" 
		    }
		}    
	    }
	}
    }
    toplevel .${newmatrix}
    createmainw .${newmatrix}
    putmatrixw .${newmatrix} $newmatrix
    ctraddmatrix $newmatrix .${newmatrix} 
}
proc open_matrix root {
    set wname [getroot $root]
    set types {
	{"Matrix files"		{.mat}	}
	{"All files"		*}
    }
    set file [tk_getOpenFile -filetypes $types -parent $wname]
    if {$file == ""} { return }
    global whandle
    set newmatrix [matrixtcl load $file]
    global $newmatrix
    set ${newmatrix}(filename) $file
#    if {[info exists whandle($wname)]} {
#	toplevel .${newmatrix}
#	createmainw .${newmatrix}
#	putmatrixw .${newmatrix} $newmatrix
#    } else {
#	putmatrixw {} $newmatrix
#    }
    toplevel .${newmatrix}
    createmainw .${newmatrix}
    putmatrixw .${newmatrix} $newmatrix
    ctraddmatrix $newmatrix .${newmatrix} 
    activatemenus .${newmatrix} $newmatrix
}
proc save_handler root {
    set matrix [getmatrix $root]
    global $matrix
    if {[info exists ${matrix}(filename)]} {
	matrixtcl $matrix save [set ${matrix}(filename)]
    } else {
	saveas_handler $root
    }
}
proc saveas_handler root {
    set matrix [getmatrix $root]
    set wname [getroot $root]
    set types {
	{"Matrix files"		{.mat}	}
	{"All files"		*}
    }
    set file [tk_getSaveFile -filetypes $types -parent $wname \
	    -initialfile Untitled.mat -defaultextension .mat]
    if {$file != ""} {
	matrixtcl $matrix save $file
	global $matrix
	set ${matrix}(filename) $file
        ctrupdateitem $matrix
    }
}
proc print_handler root {
    set matrix [getmatrix $root]
    printmatrix $matrix
}
proc ppreview_handler root {
    set matrix [getmatrix $root]
    printpreviewmatrix $matrix    
}
proc smore_handler {root was typ} {
    set matrix [getmatrix $root]
    set wname [getroot $root]
    set ext $typ
    if {$ext == "latex"} { set ext tex }
    if {$ext == "ascii"} { set ext txt }
    lappend types [list "$typ files" $ext] {"All files"		*}
    set file [tk_getSaveFile -filetypes $types -parent $wname \
	    -initialfile Untitled.$ext -defaultextension .$ext]
    if {$file != ""} {
	if {$was == "input"} {
	    set stuff [matrixtcl $matrix getform $typ]
	} else {
	    set stuff [matrixtcl $matrix getform $typ -$was]
	}
	set fileh [open $file w]
	puts -nonewline $fileh $stuff
	close $fileh
    }
}
proc end_handle root {
    global lan
    if {[tk_messageBox -title $lan(enddialogtitle) -message $lan(enddialogmes) -icon question -type okcancel]=="ok"} { exit }

}
proc copy_handler root {
    set matrix [getmatrix $root]
    set typ [matrixtcl $matrix info type]
    global puffer_$typ
    set pmatrix [set puffer_$typ]
    if {$pmatrix != ""} {
	matrixtcl destroy $pmatrix	
    }
    global $matrix
    #puts "y1=[set ${matrix}(yactpos)] x1=[set ${matrix}(xactpos)] y2=[set ${matrix}(yaltpos)] x2=[set ${matrix}(xaltpos)]"
    set puffer_$typ [matrixtcl $matrix copy [set ${matrix}(yactpos)] \
			 [set ${matrix}(xactpos)] \
			 [set ${matrix}(yaltpos)] \
			 [set ${matrix}(xaltpos)]
		    ]
}
proc mymin {a1 a2} {
    if {$a1<$a2} {
	return $a1
    } else {
	return $a2
    }
}
proc mymax {a1 a2} {
    if {$a1>$a2} {
	return $a1
    } else {
	return $a2
    }
}
proc paste_handler root {
    set matrix [getmatrix $root]
    set wname [getroot $root]
    set typ [matrixtcl $matrix info type]
    global puffer_$typ
    set pmatrix [set puffer_$typ]
    if {$pmatrix != ""} {
	set edge [paste_dialog]
	if {$edge != ""} {
	    global $matrix
	    set hoehe [lindex [matrixtcl $matrix info size] 0]
	    set breite [lindex [matrixtcl $matrix info size] 1]
	    set phoehe [lindex [matrixtcl $pmatrix info size] 0]
	    set pbreite [lindex [matrixtcl $pmatrix info size] 1]
	    set x [set ${matrix}(xactpos)]
	    set y [set ${matrix}(yactpos)]
	    switch $edge {    
		TopLeft {
		    set xa 0; set ya 0;
		    set b [mymin [expr $breite-$x] $pbreite]
		    set h [mymin [expr $hoehe-$y] $phoehe]
		}
		TopRight {
		    set h [mymin [expr $hoehe-$y] $phoehe]
		    set b [mymin [expr $x+1] $pbreite]
		    set xa [mymax [expr $pbreite-$x-1] 0]
		    set ya 0
		    incr x [expr -($b-1)]
		}
		BottomLeft {
		    set h [mymin [expr $y+1] $phoehe]
		    set b [mymin [expr $breite-$x] $pbreite]
		    set xa 0
		    set ya [mymax [expr $phoehe-$y-1] 0]
		    incr y [expr -($h-1)]
		}
		BottomRight {
		    set h [mymin [expr $y+1] $phoehe]
		    set b [mymin [expr $x+1] $pbreite]
		    set xa [mymax [expr $pbreite-$x-1] 0]
		    set ya [mymax [expr $phoehe-$y-1] 0]
		    incr x [expr -($b-1)]
		    incr y [expr -($h-1)]
		}
	    }
#	    puts "x=$x y=$y b=$b h=$h breite=$breite pbreite=$pbreite hoehe=$hoehe phoehe=$phoehe"
	    for {set tx 0} {$tx<$b} {incr tx} {
		for {set ty 0} {$ty<$h} {incr ty} {
#		    puts "y=[expr $ya+$ty] x= [expr $tx+$xa]"
		    set rational [matrixtcl $pmatrix getelem [expr $ya+$ty] [expr $tx+$xa]]
		    set my [expr $ty+$y]
		    set mx [expr $tx+$x]
#		    puts "$rational y=$my x=$mx"
		    matrixtcl $matrix setelem $my $mx $rational
		    set${typ}w $root.can.matrix.num${my}_${mx} $rational
		}
	    }
	}
    }
}
proc mark_handler {root mtyp} {
    set matrix [getmatrix $root]
    set wname [getroot $root]
    set typ [matrixtcl $matrix info type]
    global $matrix
    set yaltpos [set ${matrix}(yaltpos)]
    set xaltpos [set ${matrix}(xaltpos)]
    set yactpos [set ${matrix}(yactpos)]
    set xactpos [set ${matrix}(xactpos)]
    switch $mtyp {
	row {
	    set xactpos 0
	    set xaltpos [expr [lindex [matrixtcl $matrix info size] 1]-1]
	}
	col {
	    set yactpos 0
	    set yaltpos [expr [lindex [matrixtcl $matrix info size] 0]-1]
	}
	all {
	    set xactpos 0
	    set xaltpos [expr [lindex [matrixtcl $matrix info size] 1]-1]
	    set yactpos 0
	    set yaltpos [expr [lindex [matrixtcl $matrix info size] 0]-1]
	}
    }
#    set ${matrix}(yactpos) $lactrow
#    set ${matrix}(xactpos) $lactcol
    handlebuttondown $root.can.matrix.num${yactpos}_${xactpos} $typ 
    set ${matrix}(yaltpos) $yaltpos
    set ${matrix}(xaltpos) $xaltpos
     markregion_${typ} "$root.can.matrix" $yaltpos $xaltpos $yactpos $xactpos
}
proc resize_handler root {
    set matrix [getmatrix $root]
    set ret [resize_dialog $matrix]
#    puts $ret
    if {$ret != ""} {
	matrixtcl $matrix resize [lindex $ret 0] [lindex $ret 1] [lindex $ret 2] [lindex $ret 3] 
	putmatrixw $root $matrix
    }
    ctrupdateitem $matrix
}
proc addmatrixw matrix {
    toplevel .${matrix}
    createmainw .${matrix}
    putmatrixw .${matrix} $matrix
    ctraddmatrix $matrix .${matrix} 
    activatemenus .${matrix} $matrix
}
proc duplicate_handler root {
    set matrix [getmatrix $root]
    set dmatrix [matrixtcl $matrix duplicate]
    addmatrixw $dmatrix
}
proc solution2first_handler root {
    set matrix [getmatrix $root]
    set dmatrix [matrixtcl $matrix duplicate -solution]
    addmatrixw $dmatrix
}
proc open_as_float_handler {root {floattyp {}}} {
    set matrix [getmatrix $root]
    if {$floattyp==""} {
	set dmatrix [matrixtcl $matrix tofloat]
    } else {
	set dmatrix [matrixtcl $matrix tofloat $floattyp]
    }
    addmatrixw $dmatrix
}
proc open_puffer_handler root {
    set matrix [getmatrix $root]
    set typ [matrixtcl $matrix info type]
    global puffer_$typ
    set pmatrix [set puffer_$typ]
    if {$pmatrix != ""} {
	set dmatrix [matrixtcl $pmatrix duplicate]
	addmatrixw $dmatrix
    }
}
proc alg_handler {root alg} {
    set matrix [getmatrix $root]
    global $matrix lan
    set ${matrix}(lastalgorithmus) $alg
    catch { matrixtcl $matrix algorithmus $alg } alg_error
    view_output $root yes
    ctrupdateitem $matrix
    activatemenus $root $matrix
    if {[matrixtcl $matrix info issolution]=="no"} {
	if {$alg_error!=""} {
	    tk_messageBox -title $lan(errormsg) -message $lan($alg_error) -icon error -type ok
	} else {
	    tk_messageBox -title $lan(errormsg) -message $lan(erroralg) -icon error -type ok
	}
    }
}
proc pivot_handler root {
    set matrix [getmatrix $root]
    global $matrix
    set ret [pivot_dialog [set ${matrix}(yactpos)] \
            [set ${matrix}(xactpos)]] 
    if {$ret != ""} {
	catch { 
	    matrixtcl $matrix algorithmus pivotiere \
		[lindex $ret 0] [lindex $ret 1]
	} alg_error
	view_output $root yes
        set ${matrix}(lastalgorithmus) "pivot $ret"
        ctrupdateitem $matrix
        activatemenus $root $matrix
	if {[matrixtcl $matrix info issolution]=="no"} {
	    global lan
	    if {$alg_error=="outof_range"} {
		tk_messageBox -title $lan(errormsg) -message $lan($alg_error) -icon error -type ok
	    } else {
		tk_messageBox -title $lan(errormsg) -message $alg_error -icon error -type ok
	    }
	}
    }
}
proc op_handler {root op} {
    set matrix [getmatrix $root]
    set type [matrixtcl $matrix info type]
    set hoehe [lindex [matrixtcl $matrix info size] 0]
    set breite [lindex [matrixtcl $matrix info size] 1]
    if {$op == "mul"} {
	set hoehe $breite
	set breite -1
    }
    set matrix_op [op_dialog $type $hoehe $breite]
    if {$matrix_op != ""} {
	matrixtcl $matrix operation $matrix_op $op
	view_output $root yes
        global $matrix
        set ${matrix}(lastalgorithmus) "$op $matrix_op"
        ctrupdateitem $matrix
        activatemenus $root $matrix
    }
}
proc view_handler {root was} {
    global lan
    set matrix [getmatrix $root]
    if {[matrixtcl $matrix info issolution]=="no" && $was=="solution"} {
	tk_messageBox -title $lan(errormsg) -message "$lan(nosolution)" \
		-icon error -type ok
	return
    }
    if {[matrixtcl $matrix info isprotokol]=="no" && $was=="protokol"} {
	tk_messageBox -title $lan(errormsg) -message "$lan(noprotocol)" \
		    -icon error -type ok
	return
    } 
    if {[winfo exists .${matrix}_$was]} {
	focus .${matrix}_$was
    } else {
	actualise_output $matrix $was
    }
}
proc printview_handler {root was} {
    set matrix [getmatrix $root]
    printmatrix $matrix $was
}
proc vprintview_handler {root was} {
    set matrix [getmatrix $root]
    printpreviewmatrix $matrix $was
}
# Die nchsten Commands
# Sind handler fr Steuerungszentrum dessen
# Hilfsprozeduren
#
# matrixlist hat den Aufbau
# {matrixhandle winname}*
# oder {matrixhandle}*  wenn deaktiv
proc ctraddmatrix {handle {window none}} {
    global matrixlist
    if {$window!="none"} {
	lappend matrixlist [list $handle $window]
    } else {
	lappend matrixlist [list $handle]
    }
    .mlist insert end "dummy"
    ctrupdateitem $handle
}
proc ctrupdateitem handle {
    global matrixlist
    global $handle
    set index [lsearch -glob $matrixlist "$handle*"]
    set wname [lindex [lindex $matrixlist $index] 1]
    # aktiv oder nicht aktiv
#    puts "ctr update $handle $index matrixlist $matrixlist"
    if {$wname==""} {
        set wname D
    } else {
        set wname A
    }
    if {[info exists ${handle}(filename)]} {
        set showname  "\"[file tail [set ${handle}(filename)]]\""
    } else {
        set showname $handle
    }
    set stat ""
    set alg ""
    if {[info exists ${handle}(lastalgorithmus)]} {
        set alg "- [set ${handle}(lastalgorithmus)]"
        if {[matrixtcl $handle info issolution]} {
            set stat S
        }
        if {[matrixtcl $handle info isprotokol]} {
            set stat "${stat}P"
        } 
        set alg "$alg (${stat})"
    } else {
        set alg ""
    }
    set listitem "$wname - $showname ([matrixtcl $handle info type])- [matrixtcl $handle info size] $alg"
    .mlist delete $index
    .mlist insert $index $listitem
}
proc ctrdelmatrix handle {
    global matrixlist
    set index [lsearch -glob $matrixlist "$handle*"]
    set matrixlist [lreplace $matrixlist $index $index]
#    if {[.mlist curselection]==$index} {
#        .mclose configure -state disabled
#        .mshow configure -state disabled
#        .mdeactivate configure -state disabled
#    }
    .mlist delete $index
#    puts "ctrdelete $handle $index matrixlist $matrixlist"
}
proc mclose {} {
    set index [.mlist curselection]  
    if {$index==""} return
    global matrixlist
    set win [lindex [lindex $matrixlist $index] 1]
    global whandle
    if {[info exists whandle($win)]} {
        del_matrixwin $win $win
    } else {
        set matrix [lindex [lindex $matrixlist $index] 0]
        matrixtcl destroy $matrix
        ctrdelmatrix $matrix
	global $matrix
	unset $matrix
    }
}
proc mshow {} {
    set index [.mlist curselection]  
    if {$index==""} return
    global matrixlist
    if {[llength [lindex $matrixlist $index]]==1} {
        set newmatrix  [lindex $matrixlist $index]
        toplevel .${newmatrix}
        createmainw .${newmatrix}
        putmatrixw .${newmatrix} $newmatrix
        set matrixlist [lreplace $matrixlist $index $index [list $newmatrix .${newmatrix}]]
        ctrupdateitem $newmatrix
        activatemenus .${newmatrix} $newmatrix
    } 
}
proc mdeactivate {} {
    set index [.mlist curselection]
    global matrixlist
    if {$index==""} return
    if {[llength [lindex $matrixlist $index]]==2} {
        hdeactivate [lindex [lindex $matrixlist $index] 1]
    }
}
# Diese Prozedur wird immer angeruffen wenn ein Matrix-Editier-Fester
# Deaktiwiert wird. Auch mit WindowManager Close-Button
proc hdeactivate {win {wname dummy}} {
    global whandle
    # Nur beim Schlieen des Fenster durch Closebutton
    # wird Destroy handler ausgefhrt
    if {$wname!="dummy" && ![regexp {^.[a-zA-Z0-9]+$} $wname]} {
	return
    }
    if {![info exists whandle($win)]} {
        return
    }
    set matrix $whandle($win)
    if {[winfo exists .${matrix}_solution]} {
        destroy .${matrix}_solution
    }
    if {[winfo exists .${matrix}_protokol]} {
        destroy .${matrix}_protokol
    }
    unset whandle($win)
    catch { 
        bind $win <Destroy>
        destroy $win 
    }
    # Lschen von globalen Variablen
    if {[info globals ${win}_modi]=="${win}_modi"} {
	global ${win}_modi ${win}_rowcol  
	trace vdelete ${win}_modi w newmodi_handler
	unset ${win}_modi ${win}_rowcol
    } 
    global edit$win emode$win xpos$win ypos$win ${win}_editmode
    unset ${win}_editmode edit${win} emode$win xpos${win} ypos${win}
    # Nur handle ohne Windowsname
    global matrixlist
    set index [lsearch -glob $matrixlist "$matrix*"]
    set matrixlist [lreplace $matrixlist $index $index $matrix]
    ctrupdateitem $matrix
}
# Wird von alg_handler Aufgerufen nach jedem Algorithmus
proc activatemenus {win matrix} {
    global lan octave
    if {$octave} {
	activateoctavemenus $win.mb.button6 $matrix
    }
    set solution_menus {
        {mb.button1 save_solution}
        {mb.button2 solution2first}
        {mb.button4 vsolution}
        {mb.button4 print_solution}
        {mb.button4 pview_solution}
    }
    set protokol_menus {
        {mb.button1 save_protokol}
        {mb.button4 vprotokol}
        {mb.button4 print_protokol}
        {mb.button4 pview_protokol}
    }
    if {[matrixtcl $matrix info issolution]} {
        set state active
    } else {
        set state disabled
    }
    foreach item $solution_menus {
        set mpath [lindex $item 0]
        set mname $lan([lindex $item 1])
#        puts "${win}.${mpath} entryconfigure $mname -state $state"
        ${win}.${mpath} entryconfigure $mname -state $state
    }
    if {[matrixtcl $matrix info isprotokol]} {
        set state active
    } else {
        set state disabled
    }
    foreach item $protokol_menus {
        set mpath [lindex $item 0]
        set mname $lan([lindex $item 1])
        $win.$mpath entryconfigure $mname -state $state
    }
}
